/*
 * Decompiled with CFR 0.152.
 */
package br.com.maximasolutions.estoque.relatorio.controller;

import br.com.maximasolutions.administrativo.modelo.Configuracao;
import br.com.maximasolutions.administrativo.service.ConfiguracaoService;
import br.com.maximasolutions.config.StageManager;
import br.com.maximasolutions.core.MaximaAlert;
import br.com.maximasolutions.core.MaximaController;
import br.com.maximasolutions.core.MaximaIcone;
import br.com.maximasolutions.core.MaximaRelatorio;
import br.com.maximasolutions.core.PrintReport;
import br.com.maximasolutions.estoque.modelo.VendaProduto;
import br.com.maximasolutions.estoque.service.VendaProdutoService;
import br.com.maximasolutions.geral.form.ClientePesquisaForm;
import br.com.maximasolutions.geral.modelo.Cliente;
import br.com.maximasolutions.geral.modelo.Vendedor;
import br.com.maximasolutions.geral.service.ClienteService;
import br.com.maximasolutions.geral.service.VendedorService;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.SQLException;
import java.time.LocalDate;
import java.time.chrono.ChronoLocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.collections.FXCollections;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.DatePicker;
import javafx.scene.control.TextField;
import javafx.scene.input.KeyCode;
import javafx.scene.layout.VBox;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.data.JRBeanCollectionDataSource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Controller;

@Controller
public class RelatorioVendaController
extends MaximaController
implements Initializable {
    @Lazy
    @Autowired
    private StageManager stageManager;
    @Autowired
    private ConfiguracaoService configuracaoService;
    @Autowired
    private VendaProdutoService vendaProdutoService;
    @Autowired
    private ClienteService clienteService;
    @Autowired
    private VendedorService vendedorService;
    @FXML
    private Button btnGeraRelatorio;
    @FXML
    private Button btnClientePesquisa;
    @FXML
    private DatePicker tfDataInicial;
    @FXML
    private DatePicker tfDataFinal;
    @FXML
    private TextField tfClientePesquisa;
    @FXML
    private TextField tfClienteNome;
    @FXML
    private CheckBox ccbFaturadas;
    @FXML
    private VBox vBoxRelatorioVendas;
    @FXML
    private ComboBox<Vendedor> cbbVendedor;
    private BigDecimal subTotal;
    private BigDecimal total;
    private BigDecimal totalLiquido;
    private BigDecimal produtos;
    private BigDecimal produtosCusto;
    private BigDecimal servicos;
    private BigDecimal servicosCusto;
    private BigDecimal totalCusto;
    private BigDecimal desconto;
    private BigDecimal lucro;
    private Cliente cliente;
    private Boolean reduzirValores;

    public void initialize(URL url, ResourceBundle rb) {
        this.carregaIcones();
        this.registraAcoes();
        this.loadCombos();
        this.loadMascaras();
        this.inicializa();
    }

    public void inicializa() {
        this.cliente = null;
        this.reduzirValores = false;
    }

    private void geraRelatorio() {
        if (!this.validaForm()) {
            return;
        }
        List vendas = this.vendaProdutoService.relatorio((LocalDate)this.tfDataInicial.getValue(), (LocalDate)this.tfDataFinal.getValue(), Boolean.valueOf(this.ccbFaturadas.isSelected()), this.cliente, (Vendedor)this.cbbVendedor.getSelectionModel().getSelectedItem());
        if (vendas == null || vendas.isEmpty()) {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"Nenhum registro encontrado para o filtro informado.");
            return;
        }
        this.calculaTotal(vendas);
        Configuracao conf = this.configuracaoService.load();
        try {
            Map params = new MaximaRelatorio().getParametros(conf, Boolean.valueOf(false));
            params.put("TELEFONE", conf.getTelefoneEmpresa());
            params.put("CNPJ", conf.getEmpresaNFe().getCpf());
            params.put("ENDERECO", conf.getEmpresaNFe().getEnderecoCompleto());
            params.put("Logo", "logo.png");
            params.put("FILTRO", "PER\u00cdODO DE: " + ((LocalDate)this.tfDataInicial.getValue()).format(DateTimeFormatter.ofPattern("dd/MM/yyyy")) + " \u00e0 " + ((LocalDate)this.tfDataFinal.getValue()).format(DateTimeFormatter.ofPattern("dd/MM/yyyy")));
            params.put("PRODUTOS", this.produtos);
            params.put("PRODUTOS_CUSTO", this.produtosCusto);
            params.put("SERVICOS", this.servicos);
            params.put("SERVICOS_CUSTO", this.servicosCusto);
            params.put("DESCONTO", this.desconto);
            params.put("SUBTOTAL", this.subTotal);
            params.put("TOTAL", this.total);
            params.put("TOTAL_CUSTO", this.totalCusto);
            params.put("VENDAS", vendas.size());
            params.put("LIQUIDO", this.totalLiquido);
            params.put("LUCRO", this.lucro);
            JRBeanCollectionDataSource jrds = new JRBeanCollectionDataSource((Collection)vendas);
            new PrintReport().showReport("/jasper/estoque/vendaProduto/vendas_custo.jasper", (JRDataSource)jrds, params);
        }
        catch (JRException ex) {
            Logger.getLogger("").log(Level.SEVERE, null, ex);
            MaximaAlert.aviso((StageManager)this.stageManager, (String)("Ocorreu um erro ao gerar relat\u00f3rio.\n" + ex.getMessage()));
        }
        catch (ClassNotFoundException | SQLException ex) {
            Logger.getLogger(RelatorioVendaController.class.getName()).log(Level.SEVERE, null, ex);
            MaximaAlert.aviso((StageManager)this.stageManager, (String)("Ocorreu um erro ao gerar relat\u00f3rio.\n" + ex.getMessage()));
        }
    }

    private void calculaTotal(List<VendaProduto> vendas) {
        this.produtos = BigDecimal.ZERO;
        this.produtosCusto = BigDecimal.ZERO;
        this.servicos = BigDecimal.ZERO;
        this.servicosCusto = BigDecimal.ZERO;
        this.desconto = BigDecimal.ZERO;
        this.total = BigDecimal.ZERO;
        this.totalLiquido = BigDecimal.ZERO;
        this.totalCusto = BigDecimal.ZERO;
        this.lucro = BigDecimal.ZERO;
        this.subTotal = BigDecimal.ZERO;
        vendas.stream().forEachOrdered(venda -> {
            this.produtos = this.produtos.add(venda.getValorPecas());
            this.produtosCusto = this.produtosCusto.add(venda.getCustoProdutos());
            this.servicos = this.servicos.add(venda.getValorServico());
            this.servicosCusto = this.servicosCusto.add(venda.getCustoServicos());
            this.desconto = this.desconto.add(venda.getDesconto());
            this.subTotal = this.subTotal.add(venda.getValorProdutos());
            this.total = this.total.add(venda.getTotal());
            this.totalLiquido = this.totalLiquido.add(venda.getTotalLiquido());
            this.totalCusto = this.totalCusto.add(venda.getCustoTotal());
            this.lucro = this.lucro.add(venda.getLucro());
        });
    }

    private boolean validaForm() {
        boolean valido = true;
        if (this.tfDataInicial.getValue() == null) {
            this.tfDataInicial.getStyleClass().add((Object)"error");
            valido = false;
        } else {
            this.tfDataInicial.getStyleClass().remove((Object)"error");
        }
        if (this.tfDataFinal.getValue() == null) {
            this.tfDataFinal.getStyleClass().add((Object)"error");
            valido = false;
        } else {
            this.tfDataFinal.getStyleClass().remove((Object)"error");
        }
        if (valido) {
            if (((LocalDate)this.tfDataInicial.getValue()).isAfter((ChronoLocalDate)this.tfDataFinal.getValue())) {
                this.tfDataFinal.getStyleClass().add((Object)"error");
                valido = false;
            } else {
                this.tfDataFinal.getStyleClass().remove((Object)"error");
            }
        }
        return valido;
    }

    private void carregaIcones() {
        MaximaIcone maximaIcone = new MaximaIcone();
        this.btnGeraRelatorio.setGraphic((Node)maximaIcone.getIconeConfirma());
        this.btnClientePesquisa.setGraphic((Node)maximaIcone.getPesquisa());
    }

    private void loadMascaras() {
    }

    private void registraAcoes() {
        this.btnGeraRelatorio.setOnAction(t -> this.geraRelatorio());
        this.tfClientePesquisa.setOnKeyPressed(event -> {
            if (event.getCode() == KeyCode.ENTER) {
                this.pesquisaCliente();
            }
        });
        this.btnClientePesquisa.setOnAction(event -> this.pesquisaClienteForm());
    }

    private void loadCombos() {
        ArrayList vendedores = new ArrayList();
        vendedores.add(null);
        vendedores.addAll(this.vendedorService.list());
        this.cbbVendedor.setItems(FXCollections.observableList(vendedores));
    }

    private void pesquisaCliente() {
        String clienteCodigo = this.tfClientePesquisa.getText().trim();
        if (clienteCodigo.isEmpty()) {
            return;
        }
        try {
            Long clienteCodigoNumero = Long.valueOf(clienteCodigo);
            Cliente clientePesquisa = this.clienteService.getById(clienteCodigoNumero);
            if (clientePesquisa != null) {
                this.cliente = clientePesquisa;
            } else {
                this.cliente = null;
                MaximaAlert.aviso((StageManager)this.stageManager, (String)"C\u00f3digo de cliente n\u00e3o encontrado.");
                this.tfClientePesquisa.requestFocus();
                this.tfClientePesquisa.selectAll();
            }
            this.loadDadosCliente();
            return;
        }
        catch (NumberFormatException numberFormatException) {
            this.pesquisaClienteForm();
            return;
        }
    }

    private void pesquisaClienteForm() {
        this.cliente = new ClientePesquisaForm().getCliente(this.stageManager, this.btnClientePesquisa.getScene(), this.tfClientePesquisa.getText().trim());
        this.loadDadosCliente();
    }

    private void loadDadosCliente() {
        if (this.cliente != null) {
            this.tfClientePesquisa.setText(this.cliente.getId().toString());
            this.tfClienteNome.setText(this.cliente.getNome().toUpperCase());
        } else {
            this.tfClienteNome.setText("");
            this.tfClientePesquisa.setText("");
            this.tfClientePesquisa.requestFocus();
        }
    }

    private List<VendaProduto> esquemaJulio(List<VendaProduto> vendas) {
        BigDecimal valorDiario = BigDecimal.ZERO;
        ArrayList<VendaProduto> auxiliar = new ArrayList<VendaProduto>();
        int dia = vendas.get(vendas.size() - 1).getDataEmissao().getDayOfMonth();
        System.out.println("== Dia inicial: " + dia);
        for (VendaProduto venda : vendas) {
            if (venda.getDataEmissao().getDayOfMonth() == dia) {
                if (valorDiario.compareTo(new BigDecimal(2500)) >= 0) continue;
                valorDiario = valorDiario.add(venda.getTotal());
                auxiliar.add(venda);
                continue;
            }
            dia = venda.getDataEmissao().getDayOfMonth();
            valorDiario = BigDecimal.ZERO;
        }
        return auxiliar;
    }
}

