/*
 * Decompiled with CFR 0.152.
 */
package br.com.maximasolutions.estoque.relatorio.controller;

import br.com.maximasolutions.administrativo.modelo.Configuracao;
import br.com.maximasolutions.administrativo.service.ConfiguracaoService;
import br.com.maximasolutions.config.StageManager;
import br.com.maximasolutions.core.MaximaAlert;
import br.com.maximasolutions.core.MaximaController;
import br.com.maximasolutions.core.MaximaIcone;
import br.com.maximasolutions.core.MaximaRelatorio;
import br.com.maximasolutions.core.PrintReport;
import br.com.maximasolutions.estoque.bean.VendaProdutoItemBean;
import br.com.maximasolutions.estoque.bean.VendaProdutoItemOrderBy;
import br.com.maximasolutions.estoque.modelo.CategoriaProduto;
import br.com.maximasolutions.estoque.relatorio.controller.Sortby;
import br.com.maximasolutions.estoque.relatorio.controller.SortbyPercentual;
import br.com.maximasolutions.estoque.service.CategoriaProdutoService;
import br.com.maximasolutions.estoque.service.VendaProdutoService;
import br.com.maximasolutions.geral.modelo.Vendedor;
import br.com.maximasolutions.geral.service.VendedorService;
import br.com.maximasolutions.utils.MaximaNumber;
import java.awt.Desktop;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.net.URL;
import java.sql.SQLException;
import java.time.LocalDate;
import java.time.chrono.ChronoLocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.collections.FXCollections;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.DatePicker;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.data.JRBeanCollectionDataSource;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFFont;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Controller;

@Controller
public class RelatorioVendaProdutoController
extends MaximaController
implements Initializable {
    @Lazy
    @Autowired
    private StageManager stageManager;
    @Autowired
    private ConfiguracaoService configuracaoService;
    @Autowired
    private VendaProdutoService vendaProdutoService;
    @Autowired
    private VendedorService vendedorService;
    @Autowired
    private CategoriaProdutoService categoriaProdutoService;
    @FXML
    private Button btnGeraRelatorio;
    @FXML
    private DatePicker tfDataInicial;
    @FXML
    private DatePicker tfDataFinal;
    @FXML
    private CheckBox ccbFaturadas;
    @FXML
    private CheckBox ccbAgruparProdutos;
    @FXML
    private ComboBox<Vendedor> cbbVendedor;
    @FXML
    private ComboBox<CategoriaProduto> cbbCategoria;
    @FXML
    private ComboBox<VendaProdutoItemOrderBy> cbbOrderBy;
    private BigDecimal quantidade;
    private BigDecimal total;
    private BigDecimal custoMedio;
    private BigDecimal precoMedio;
    private BigDecimal custoTotal;
    private Integer produtos;

    public void initialize(URL url, ResourceBundle rb) {
        this.carregaIcones();
        this.registraAcoes();
        this.loadCombos();
        this.loadMascaras();
        this.inicializa();
    }

    private void habilitaForm() {
        if (this.ccbAgruparProdutos.isSelected()) {
            this.cbbOrderBy.getSelectionModel().select((Object)VendaProdutoItemOrderBy.MAIS_VENDIDOS);
        } else {
            this.cbbOrderBy.getSelectionModel().select((Object)VendaProdutoItemOrderBy.DATA);
        }
    }

    public void inicializa() {
        this.habilitaForm();
    }

    private void exportToExcel() {
        if (!this.validaForm()) {
            return;
        }
        Boolean agruparProdutos = this.ccbAgruparProdutos.isSelected();
        Vendedor vendedor = (Vendedor)this.cbbVendedor.getSelectionModel().getSelectedItem();
        List itens = this.vendaProdutoService.relatorioProdutos((LocalDate)this.tfDataInicial.getValue(), (LocalDate)this.tfDataFinal.getValue(), Boolean.valueOf(this.ccbFaturadas.isSelected()), null, vendedor, (CategoriaProduto)this.cbbCategoria.getSelectionModel().getSelectedItem(), agruparProdutos, (VendaProdutoItemOrderBy)this.cbbOrderBy.getSelectionModel().getSelectedItem());
        if (itens == null || itens.isEmpty()) {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"Nenhum registro encontrado para o filtro informado.");
            return;
        }
        this.calculaTotal(itens);
        String jasper = "vendas-produtos.jasper";
        if (((VendaProdutoItemOrderBy)this.cbbOrderBy.getSelectionModel().getSelectedItem()).equals((Object)VendaProdutoItemOrderBy.MAIS_VENDIDOS)) {
            Collections.sort(itens, new Sortby());
            jasper = "vendas-produtos-abc.jasper";
            System.out.println("== ORDER BY MAIS VENDIDOS");
        }
        if (((VendaProdutoItemOrderBy)this.cbbOrderBy.getSelectionModel().getSelectedItem()).equals((Object)VendaProdutoItemOrderBy.PERCENTUAL_VENDA)) {
            Collections.sort(itens, new SortbyPercentual());
            jasper = "vendas-produtos-abc.jasper";
            System.out.println("== ORDER BY MAIS VENDIDOS");
        }
        XSSFWorkbook wb = new XSSFWorkbook();
        String PathTillProject = System.getProperty("user.dir");
        try {
            String arquivoPath = PathTillProject + "/" + UUID.randomUUID().toString() + ".xlsx";
            FileOutputStream fileOut = new FileOutputStream(arquivoPath);
            XSSFSheet abaPrimaria = wb.createSheet("Relat\u00f3rio");
            int index = 1;
            XSSFRow primeiraLinha = abaPrimaria.createRow(0);
            XSSFCellStyle style = wb.createCellStyle();
            XSSFFont font = wb.createFont();
            font.setFontName("Arial");
            font.setFontHeightInPoints((short)10);
            font.setBold(true);
            style.setFont((Font)font);
            XSSFCell primeiraCelulaColuna = primeiraLinha.createCell(0);
            primeiraCelulaColuna.setCellStyle((CellStyle)style);
            XSSFCell segundaCelulaColuna = primeiraLinha.createCell(1);
            segundaCelulaColuna.setCellStyle((CellStyle)style);
            XSSFCell terceiraCelulaColuna = primeiraLinha.createCell(2);
            terceiraCelulaColuna.setCellStyle((CellStyle)style);
            XSSFCell quartaCelulaColuna = primeiraLinha.createCell(3);
            quartaCelulaColuna.setCellStyle((CellStyle)style);
            XSSFCell quintaCelulaColuna = primeiraLinha.createCell(4);
            quintaCelulaColuna.setCellStyle((CellStyle)style);
            XSSFCell sextaCelulaColuna = primeiraLinha.createCell(5);
            sextaCelulaColuna.setCellStyle((CellStyle)style);
            XSSFCell setimaCelulaColuna = primeiraLinha.createCell(6);
            setimaCelulaColuna.setCellStyle((CellStyle)style);
            XSSFCell oitavaCelulaColuna = primeiraLinha.createCell(7);
            oitavaCelulaColuna.setCellStyle((CellStyle)style);
            primeiraCelulaColuna.setCellValue("C\u00d3DIGO");
            segundaCelulaColuna.setCellValue("PRODUTO");
            terceiraCelulaColuna.setCellValue("ESTOQUE");
            quartaCelulaColuna.setCellValue("QUANTIDADE VENDIDA");
            quintaCelulaColuna.setCellValue("CUSTO UNIT\u00c1RIO");
            sextaCelulaColuna.setCellValue("CUSTO TOTAL");
            setimaCelulaColuna.setCellValue("VALOR UNIT\u00c1RIO");
            oitavaCelulaColuna.setCellValue("VALOR TOTAL");
            for (VendaProdutoItemBean bean : itens) {
                XSSFRow linha = abaPrimaria.createRow(index);
                XSSFCell colCodigo = linha.createCell(0);
                XSSFCell colDescricao = linha.createCell(1);
                XSSFCell colEstoque = linha.createCell(2);
                XSSFCell colQuantidade = linha.createCell(3);
                XSSFCell colCustoUnitario = linha.createCell(4);
                XSSFCell colCustoTotal = linha.createCell(5);
                XSSFCell colValorMedio = linha.createCell(6);
                XSSFCell colTotal = linha.createCell(7);
                colCodigo.setCellValue(bean.getCodigo());
                colDescricao.setCellValue(bean.getProduto());
                colEstoque.setCellValue(MaximaNumber.quantidadeToString((BigDecimal)bean.getEstoqueAtual()));
                colQuantidade.setCellValue(MaximaNumber.quantidadeToString((BigDecimal)bean.getQuantidade()));
                colCustoUnitario.setCellValue(MaximaNumber.formataNumero((BigDecimal)bean.getCustoUnitario()));
                colCustoTotal.setCellValue(MaximaNumber.formataNumero((BigDecimal)bean.getCustoTotal()));
                colValorMedio.setCellValue(MaximaNumber.formataNumero((BigDecimal)bean.getValorMedio()));
                colTotal.setCellValue(MaximaNumber.formataNumero((BigDecimal)bean.getTotal()));
                ++index;
            }
            abaPrimaria.autoSizeColumn(0);
            abaPrimaria.autoSizeColumn(1);
            abaPrimaria.autoSizeColumn(2);
            abaPrimaria.autoSizeColumn(3);
            abaPrimaria.autoSizeColumn(4);
            abaPrimaria.autoSizeColumn(5);
            abaPrimaria.autoSizeColumn(6);
            wb.write((OutputStream)fileOut);
            wb.close();
            fileOut.close();
            Desktop.getDesktop().open(new File(arquivoPath));
        }
        catch (FileNotFoundException ex) {
            Logger.getLogger(RelatorioVendaProdutoController.class.getName()).log(Level.SEVERE, null, ex);
            MaximaAlert.aviso((StageManager)this.stageManager, (String)("Ocorreu um erro ao gerar relat\u00f3rio.\n" + ex.getMessage()));
        }
        catch (IOException ex) {
            Logger.getLogger(RelatorioVendaProdutoController.class.getName()).log(Level.SEVERE, null, ex);
            MaximaAlert.aviso((StageManager)this.stageManager, (String)("Ocorreu um erro ao gerar relat\u00f3rio.\n" + ex.getMessage()));
        }
    }

    private void geraRelatorio() {
        if (!this.validaForm()) {
            return;
        }
        Boolean agruparProdutos = this.ccbAgruparProdutos.isSelected();
        Vendedor vendedor = (Vendedor)this.cbbVendedor.getSelectionModel().getSelectedItem();
        List itens = this.vendaProdutoService.relatorioProdutos((LocalDate)this.tfDataInicial.getValue(), (LocalDate)this.tfDataFinal.getValue(), Boolean.valueOf(this.ccbFaturadas.isSelected()), null, vendedor, (CategoriaProduto)this.cbbCategoria.getSelectionModel().getSelectedItem(), agruparProdutos, (VendaProdutoItemOrderBy)this.cbbOrderBy.getSelectionModel().getSelectedItem());
        if (itens == null || itens.isEmpty()) {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"Nenhum registro encontrado para o filtro informado.");
            return;
        }
        this.calculaTotal(itens);
        String jasper = "vendas-produtos.jasper";
        if (((VendaProdutoItemOrderBy)this.cbbOrderBy.getSelectionModel().getSelectedItem()).equals((Object)VendaProdutoItemOrderBy.MAIS_VENDIDOS)) {
            Collections.sort(itens, new Sortby());
            jasper = "vendas-produtos-abc.jasper";
            System.out.println("== ORDER BY MAIS VENDIDOS");
        }
        if (((VendaProdutoItemOrderBy)this.cbbOrderBy.getSelectionModel().getSelectedItem()).equals((Object)VendaProdutoItemOrderBy.PERCENTUAL_VENDA)) {
            Collections.sort(itens, new SortbyPercentual());
            jasper = "vendas-produtos-abc.jasper";
            System.out.println("== ORDER BY MAIS VENDIDOS");
        }
        Configuracao conf = this.configuracaoService.load();
        try {
            Map params = new MaximaRelatorio().getParametros(conf, Boolean.valueOf(false));
            String filtro = "PER\u00cdODO DE: " + ((LocalDate)this.tfDataInicial.getValue()).format(DateTimeFormatter.ofPattern("dd/MM/yyyy")) + " \u00e0 " + ((LocalDate)this.tfDataFinal.getValue()).format(DateTimeFormatter.ofPattern("dd/MM/yyyy"));
            if (vendedor != null) {
                filtro = filtro + " | FUNCION\u00c1RIO: " + vendedor.getNome().toUpperCase();
            }
            params.put("FILTRO", filtro);
            params.put("QUANTIDADE", this.quantidade);
            params.put("PRODUTOS", this.produtos);
            params.put("TOTAL", this.total);
            params.put("TOTAL_CUSTO", this.custoTotal);
            params.put("LIQUIDO", this.total.subtract(this.custoTotal));
            params.put("CUSTO_MEDIO", this.custoMedio);
            params.put("PRECO_MEDIO", this.precoMedio);
            JRBeanCollectionDataSource jrds = new JRBeanCollectionDataSource((Collection)itens);
            new PrintReport().showReport("/jasper/estoque/vendaProduto/" + jasper, (JRDataSource)jrds, params);
        }
        catch (JRException ex) {
            Logger.getLogger("").log(Level.SEVERE, null, ex);
            MaximaAlert.aviso((StageManager)this.stageManager, (String)("Ocorreu um erro ao gerar relat\u00f3rio.\n" + ex.getMessage()));
        }
        catch (ClassNotFoundException | SQLException ex) {
            Logger.getLogger(RelatorioVendaProdutoController.class.getName()).log(Level.SEVERE, null, ex);
            MaximaAlert.aviso((StageManager)this.stageManager, (String)("Ocorreu um erro ao gerar relat\u00f3rio.\n" + ex.getMessage()));
        }
    }

    private void calculaTotal(List<VendaProdutoItemBean> itens) {
        this.total = BigDecimal.ZERO;
        this.quantidade = BigDecimal.ZERO;
        this.custoTotal = BigDecimal.ZERO;
        this.custoMedio = BigDecimal.ZERO;
        this.precoMedio = BigDecimal.ZERO;
        this.produtos = 0;
        ArrayList<VendaProdutoItemBean> produtosAdicionados = new ArrayList<VendaProdutoItemBean>();
        for (VendaProdutoItemBean bean : itens) {
            this.quantidade = this.quantidade.add(bean.getQuantidade());
            this.total = this.total.add(bean.getTotal());
            this.custoTotal = this.custoTotal.add(bean.getCustoTotal());
            this.custoMedio = this.custoMedio.add(bean.getCustoUnitario());
            this.precoMedio = this.precoMedio.add(bean.getValorMedio());
            boolean existe = false;
            for (VendaProdutoItemBean b : produtosAdicionados) {
                if (!bean.getProdutoId().equals(b.getProdutoId())) continue;
                existe = true;
                break;
            }
            if (existe) continue;
            produtosAdicionados.add(bean);
        }
        this.produtos = produtosAdicionados.size();
        this.custoMedio = this.custoMedio.divide(new BigDecimal(itens.size()), 2, RoundingMode.HALF_EVEN);
        this.precoMedio = this.precoMedio.divide(new BigDecimal(itens.size()), 2, RoundingMode.HALF_EVEN);
        for (VendaProdutoItemBean bean : produtosAdicionados) {
            BigDecimal percentual = bean.getTotal().multiply(new BigDecimal(100)).divide(this.total, 2, RoundingMode.HALF_EVEN);
            bean.setPercentual(percentual);
        }
    }

    private boolean validaForm() {
        boolean valido = true;
        if (this.tfDataInicial.getValue() == null) {
            this.tfDataInicial.getStyleClass().add((Object)"error");
            valido = false;
        } else {
            this.tfDataInicial.getStyleClass().remove((Object)"error");
        }
        if (this.tfDataFinal.getValue() == null) {
            this.tfDataFinal.getStyleClass().add((Object)"error");
            valido = false;
        } else {
            this.tfDataFinal.getStyleClass().remove((Object)"error");
        }
        if (valido) {
            if (((LocalDate)this.tfDataInicial.getValue()).isAfter((ChronoLocalDate)this.tfDataFinal.getValue())) {
                this.tfDataFinal.getStyleClass().add((Object)"error");
                valido = false;
            } else {
                this.tfDataFinal.getStyleClass().remove((Object)"error");
            }
        }
        return valido;
    }

    private void carregaIcones() {
        MaximaIcone maximaIcone = new MaximaIcone();
        this.btnGeraRelatorio.setGraphic((Node)maximaIcone.getIconeConfirma());
    }

    private void loadMascaras() {
    }

    private void registraAcoes() {
        this.btnGeraRelatorio.setOnAction(t -> this.geraRelatorio());
        this.ccbAgruparProdutos.setOnAction(evt -> this.habilitaForm());
    }

    private void loadCombos() {
        ArrayList vendedores = new ArrayList();
        vendedores.add(null);
        vendedores.addAll(this.vendedorService.list());
        this.cbbVendedor.setItems(FXCollections.observableList(vendedores));
        this.cbbCategoria.setItems(FXCollections.observableList((List)this.categoriaProdutoService.combo()));
        this.loadComboOrderBy();
    }

    private void loadComboOrderBy() {
        ArrayList<VendaProdutoItemOrderBy> lista = new ArrayList<VendaProdutoItemOrderBy>();
        if (this.ccbAgruparProdutos.isSelected()) {
            lista.add(VendaProdutoItemOrderBy.DESCRICAO);
            lista.add(VendaProdutoItemOrderBy.MAIS_VENDIDOS);
            lista.add(VendaProdutoItemOrderBy.PERCENTUAL_VENDA);
        } else {
            lista.add(VendaProdutoItemOrderBy.DESCRICAO);
            lista.add(VendaProdutoItemOrderBy.DATA);
        }
        this.cbbOrderBy.setItems(FXCollections.observableArrayList(lista));
    }
}

