/*
 * Decompiled with CFR 0.152.
 */
package br.com.maximasolutions.estoque.relatorio.controller;

import br.com.maximasolutions.administrativo.modelo.Configuracao;
import br.com.maximasolutions.administrativo.service.ConfiguracaoService;
import br.com.maximasolutions.config.StageManager;
import br.com.maximasolutions.core.MaximaAlert;
import br.com.maximasolutions.core.MaximaController;
import br.com.maximasolutions.core.MaximaIcone;
import br.com.maximasolutions.core.MaximaRelatorio;
import br.com.maximasolutions.core.PrintReport;
import br.com.maximasolutions.estoque.bean.VendasCategoriasBean;
import br.com.maximasolutions.estoque.relatorio.controller.RelatorioVendaProdutoController;
import br.com.maximasolutions.estoque.service.VendaProdutoService;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.net.URL;
import java.sql.SQLException;
import java.time.LocalDate;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.DatePicker;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.data.JRBeanCollectionDataSource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Controller;

@Controller
public class RelatorioVendasCategoriasController
extends MaximaController
implements Initializable {
    @FXML
    private Button btnGeraRelatorio;
    @FXML
    private DatePicker tfDataInicio;
    @FXML
    private DatePicker tfDataFinal;
    @Lazy
    @Autowired
    private StageManager stageManager;
    @Autowired
    private VendaProdutoService vendaProdutoService;
    @Autowired
    private ConfiguracaoService configuracaoService;

    public void initialize(URL url, ResourceBundle rb) {
        this.carregaIcones();
        this.registraAcoes();
        this.loadCombos();
        this.loadMascaras();
    }

    private void carregaIcones() {
        this.btnGeraRelatorio.setGraphic((Node)new MaximaIcone().getIconeConfirma());
    }

    private void loadMascaras() {
    }

    private void registraAcoes() {
        this.btnGeraRelatorio.setOnAction(t -> this.geraRelatorio());
    }

    private void loadCombos() {
    }

    private void geraRelatorio() {
        LocalDate dataFim;
        if (this.tfDataInicio.getValue() == null || this.tfDataFinal.getValue() == null) {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"Informe a data inicial e final para gerar o relat\u00f3rio.");
            return;
        }
        LocalDate dataInicio = (LocalDate)this.tfDataInicio.getValue();
        if (dataInicio.isAfter(dataFim = (LocalDate)this.tfDataFinal.getValue())) {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"A data de in\u00edcio deve ser anterior ou igual a data final.");
            return;
        }
        List list = this.vendaProdutoService.vendasCategorias(dataInicio, dataFim);
        BigDecimal totalVendido = BigDecimal.ZERO;
        for (VendasCategoriasBean obj : list) {
            totalVendido = totalVendido.add(obj.getPrecoTotal());
        }
        for (VendasCategoriasBean obj : list) {
            obj.setPercentual(new BigDecimal("100").multiply(obj.getPrecoTotal()).divide(totalVendido, 2, RoundingMode.HALF_EVEN).setScale(2, RoundingMode.HALF_EVEN));
        }
        Configuracao conf = this.configuracaoService.load();
        try {
            Map params = new MaximaRelatorio().getParametros(conf, Boolean.valueOf(false));
            params.put("TOTAL", totalVendido);
            JRBeanCollectionDataSource jrds = new JRBeanCollectionDataSource((Collection)list);
            new PrintReport().showReport("/jasper/estoque/vendaProduto/vendas-categorias.jasper", (JRDataSource)jrds, params);
        }
        catch (JRException ex) {
            Logger.getLogger("").log(Level.SEVERE, null, ex);
            MaximaAlert.aviso((StageManager)this.stageManager, (String)("Ocorreu um erro ao gerar relat\u00f3rio.\n" + ex.getMessage()));
        }
        catch (ClassNotFoundException | SQLException ex) {
            Logger.getLogger(RelatorioVendaProdutoController.class.getName()).log(Level.SEVERE, null, ex);
            MaximaAlert.aviso((StageManager)this.stageManager, (String)("Ocorreu um erro ao gerar relat\u00f3rio.\n" + ex.getMessage()));
        }
    }
}

