/*
 * Decompiled with CFR 0.152.
 */
package br.com.maximasolutions.estoque.report;

import br.com.maximasolutions.administrativo.modelo.Configuracao;
import br.com.maximasolutions.core.MaximaException;
import br.com.maximasolutions.core.PrintReport;
import br.com.maximasolutions.estoque.modelo.Orcamento;
import br.com.maximasolutions.estoque.modelo.OrcamentoItem;
import br.com.maximasolutions.estoque.modelo.VendaProdutoComprovanteA4Tipo;
import br.com.maximasolutions.estoque.service.VendaProdutoAgrupa;
import java.net.URL;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.data.JRBeanCollectionDataSource;

public class OrcamentoReport {
    private final Configuracao conf;
    private final String jasper;
    private Map<String, Object> params;
    private JRDataSource jrds;

    public OrcamentoReport(Configuracao conf1) {
        this.conf = conf1;
        this.jasper = this.conf.getVendaProdutoComprovanteA4Tipo().equals((Object)VendaProdutoComprovanteA4Tipo.MEIA_FOLHA) ? "/jasper/estoque/vendaProduto/orcamento-meia-folha-view.jasper" : "/jasper/estoque/vendaProduto/orcamento-view.jasper";
    }

    public void visualiza(Orcamento orcamento, List<OrcamentoItem> itens) throws MaximaException {
        try {
            this.geraRelatorio(orcamento, itens);
            new PrintReport().showReport(this.jasper, this.jrds, this.params);
        }
        catch (ClassNotFoundException | SQLException | JRException ex) {
            Logger.getLogger(OrcamentoReport.class.getName()).log(Level.SEVERE, null, ex);
            throw new MaximaException("ERRO: N\u00e3o foi poss\u00edvel gerar o relat\u00f3rio de visualiza\u00e7\u00e3o da venda.\n" + ex.getMessage());
        }
    }

    public void exportaPdf(Orcamento orcamento, List<OrcamentoItem> itens, String arquivoDestino) throws MaximaException {
        try {
            this.geraRelatorio(orcamento, itens);
            new PrintReport().exportaReport(this.jasper, this.jrds, this.params, arquivoDestino);
        }
        catch (ClassNotFoundException | SQLException | JRException ex) {
            Logger.getLogger(OrcamentoReport.class.getName()).log(Level.SEVERE, null, ex);
            throw new MaximaException("ERRO: N\u00e3o foi poss\u00edvel gerar o relat\u00f3rio de visualiza\u00e7\u00e3o da venda.\n" + ex.getMessage());
        }
    }

    private void geraRelatorio(Orcamento orcamento, List<OrcamentoItem> itens) {
        itens.forEach(i -> {
            if (i.getObservacao() != null && !i.getObservacao().isEmpty()) {
                i.setDescricao(i.getDescricao() + " (" + i.getObservacao() + ")");
                System.out.println("Descricao: " + i.getDescricao());
            }
        });
        Collections.sort(itens, Comparator.comparing(OrcamentoItem::getServico));
        if (this.conf.getAgruparItensImpressao().booleanValue()) {
            itens = VendaProdutoAgrupa.agrupaOrcamento(itens);
        }
        this.jrds = new JRBeanCollectionDataSource((Collection)itens);
        this.params = new HashMap();
        this.params.put("EMPRESA", this.conf.getNomeEmpresa());
        this.params.put("CNPJ", this.conf.getCnpjEmpresa());
        this.params.put("ENDERECO", this.conf.getEmpresaNFe().getEnderecoCompleto());
        this.params.put("TELEFONE", this.conf.getTelefoneEmpresa());
        this.params.put("CIDADE", this.conf.getEmpresaNFe().getMunicipio().getNome() + "/" + this.conf.getEmpresaNFe().getMunicipio().getEstado().getSigla());
        this.params.put("Logo", "logo.png");
        String faturamento = "PEDIDO N\u00c3O FATURADO";
        this.params.put("FATURAMENTO", faturamento);
        URL web = OrcamentoReport.class.getResource("/jasper/estoque/vendaProduto/");
        this.params.put("subrel", web.toString());
    }
}

