/*
 * Decompiled with CFR 0.152.
 */
package br.com.maximasolutions.estoque.report;

import br.com.maximasolutions.administrativo.modelo.Configuracao;
import br.com.maximasolutions.core.MaximaConfig;
import br.com.maximasolutions.core.MaximaException;
import br.com.maximasolutions.core.PrintReport;
import br.com.maximasolutions.estoque.modelo.VendaProduto;
import br.com.maximasolutions.estoque.modelo.VendaProdutoComprovanteA4Tipo;
import br.com.maximasolutions.estoque.modelo.VendaProdutoFaturamento;
import br.com.maximasolutions.estoque.modelo.VendaProdutoItem;
import br.com.maximasolutions.estoque.service.VendaProdutoAgrupa;
import br.com.maximasolutions.financeiro.modelo.ContaReceberParcela;
import br.com.maximasolutions.utils.MaximaDate;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.SQLException;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.data.JRBeanCollectionDataSource;

public class VendaProdutoReport {
    private String jasper = "/jasper/estoque/vendaProduto/pedido-view.jasper";
    private final Map<String, Object> params = new HashMap();
    private JRDataSource jrds;

    public VendaProdutoReport(Configuracao conf) {
        if (conf.getVendaProdutoComprovanteA4Tipo().equals((Object)VendaProdutoComprovanteA4Tipo.MEIA_FOLHA)) {
            this.jasper = "/jasper/estoque/vendaProduto/pedido-meia-folha-view.jasper";
        }
        if (conf.getVendaProdutoComprovanteA4Tipo().equals((Object)VendaProdutoComprovanteA4Tipo.MEIA_FOLHA)) {
            this.jasper = "/jasper/estoque/vendaProduto/pedido-meia-folha-view.jasper";
        }
        if (conf.getVendaProdutoComprovanteA4Tipo().equals((Object)VendaProdutoComprovanteA4Tipo.FOLHA_INTEIRA_RECIBO_ENTREGA)) {
            this.jasper = "/jasper/estoque/vendaProduto/pedido-view-recibo-entrega.jasper";
            this.params.put("RECIBO", conf.getVendaProdutoComprovanteReciboEntrega());
        }
        if (conf.getVendaProdutoComprovanteA4Tipo().equals((Object)VendaProdutoComprovanteA4Tipo.PERSONALIZADO)) {
            String jasperPedido = MaximaConfig.getJasperPedido();
            this.jasper = "/jasper/estoque/vendaProduto/" + jasperPedido;
        }
    }

    public void visualiza(VendaProduto vendaProduto, List<VendaProdutoItem> itens, List<VendaProdutoFaturamento> faturamentos, List<ContaReceberParcela> parcelas, Configuracao conf) throws MaximaException {
        try {
            this.geraRelatorio(vendaProduto, itens, faturamentos, conf);
            new PrintReport().showReport(this.jasper, this.jrds, this.params);
        }
        catch (ClassNotFoundException | SQLException | JRException ex) {
            Logger.getLogger(VendaProdutoReport.class.getName()).log(Level.SEVERE, null, ex);
            throw new MaximaException("ERRO: N\u00e3o foi poss\u00edvel gerar o relat\u00f3rio de visualiza\u00e7\u00e3o da venda.\n" + ex.getMessage());
        }
    }

    public void visualizaOS(VendaProduto vendaProduto, List<VendaProdutoItem> itens, List<VendaProdutoFaturamento> faturamentos, List<ContaReceberParcela> parcelas, Configuracao conf) throws MaximaException {
        try {
            this.geraRelatorio(vendaProduto, itens, faturamentos, conf);
            new PrintReport().showReport("/jasper/estoque/vendaProduto/os_view.jasper", this.jrds, this.params);
        }
        catch (ClassNotFoundException | SQLException | JRException ex) {
            Logger.getLogger(VendaProdutoReport.class.getName()).log(Level.SEVERE, null, ex);
            throw new MaximaException("ERRO: N\u00e3o foi poss\u00edvel gerar o relat\u00f3rio de visualiza\u00e7\u00e3o da venda.\n" + ex.getMessage());
        }
    }

    public void exportaPdf(VendaProduto vendaProduto, List<VendaProdutoItem> itens, List<VendaProdutoFaturamento> faturamentos, List<ContaReceberParcela> parcelas, Configuracao conf, String arquivoDestino) throws MaximaException {
        try {
            this.geraRelatorio(vendaProduto, itens, faturamentos, conf);
            new PrintReport().exportaReport(this.jasper, this.jrds, this.params, arquivoDestino);
        }
        catch (ClassNotFoundException | SQLException | JRException ex) {
            Logger.getLogger(VendaProdutoReport.class.getName()).log(Level.SEVERE, null, ex);
            throw new MaximaException("ERRO: N\u00e3o foi poss\u00edvel gerar o relat\u00f3rio de visualiza\u00e7\u00e3o da venda.\n" + ex.getMessage());
        }
    }

    private void geraRelatorio(VendaProduto vendaProduto, List<VendaProdutoItem> itens, List<VendaProdutoFaturamento> parcelas, Configuracao conf) {
        itens.forEach(i -> {
            if (i.getObservacao() != null && !i.getObservacao().isEmpty()) {
                i.setDescricao(i.getDescricao() + " (" + i.getObservacao() + ")");
                System.out.println("Descricao: " + i.getDescricao());
            }
        });
        Collections.sort(itens, Comparator.comparing(VendaProdutoItem::getServico));
        BigDecimal valorProdutos = BigDecimal.ZERO;
        BigDecimal valorServicos = BigDecimal.ZERO;
        for (VendaProdutoItem item : itens) {
            if (item.getServico().booleanValue()) {
                valorServicos = valorServicos.add(item.getPrecoTotal());
                continue;
            }
            valorProdutos = valorProdutos.add(item.getPrecoTotal());
        }
        if (conf.getAgruparItensImpressao().booleanValue()) {
            itens = VendaProdutoAgrupa.agrupa(itens);
        }
        this.params.put("valorPecas", valorProdutos);
        this.params.put("valorServicos", valorServicos);
        this.jrds = new JRBeanCollectionDataSource((Collection)itens);
        this.params.put("EMPRESA", conf.getNomeEmpresa());
        this.params.put("CNPJ", conf.getCnpjEmpresa());
        this.params.put("ENDERECO", conf.getEmpresaNFe().getEnderecoCompleto());
        this.params.put("TELEFONE", conf.getTelefoneEmpresa());
        this.params.put("CIDADE", conf.getEmpresaNFe().getMunicipio().getNome() + "/" + conf.getEmpresaNFe().getMunicipio().getEstado().getSigla());
        this.params.put("Logo", "logo.png");
        this.params.put("INSTRUCAO", conf.getVendaProdutoComprovanteReciboEntrega());
        String faturamento = "PEDIDO N\u00c3O FATURADO";
        if (vendaProduto.isFaturado().booleanValue()) {
            faturamento = "PEDIDO FATURADO EM: " + MaximaDate.getData((LocalDate)vendaProduto.getDataFaturamento());
            this.params.put("PARCELAS", parcelas);
        } else {
            this.params.put("PARCELAS", new ArrayList());
        }
        this.params.put("FATURAMENTO", faturamento);
        URL web = VendaProdutoReport.class.getResource("/jasper/estoque/vendaProduto/");
        this.params.put("subrel", web.toString());
    }
}

