/*
 * Decompiled with CFR 0.152.
 */
package br.com.maximasolutions.estoque.repository;

import br.com.maximasolutions.estoque.modelo.EntradaMateriaPrima;
import br.com.maximasolutions.estoque.repository.EntradaMateriaPrimaRepositoryCustom;
import br.com.maximasolutions.geral.modelo.Fornecedor;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.List;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

@Repository
public interface EntradaMateriaPrimaRepository
extends JpaRepository<EntradaMateriaPrima, Long>,
EntradaMateriaPrimaRepositoryCustom {
    @Query(value="SELECT o FROM EntradaMateriaPrima o WHERE o.excluida = false AND o.nfeChaveAcesso like :chaveAcesso")
    public EntradaMateriaPrima getByChaveAcesso(@Param(value="chaveAcesso") String var1);

    @Query(value="SELECT o FROM EntradaMateriaPrima o WHERE (o.dataEmissao between :dataInicio and :dataFim) AND o.excluida = false AND o.xml is not null ORDER BY o.dataEmissao")
    public List<EntradaMateriaPrima> listaSped(@Param(value="dataInicio") LocalDate var1, @Param(value="dataFim") LocalDate var2);

    @Query(value="SELECT o.fornecedor FROM EntradaMateriaPrima o WHERE (o.dataEmissao between :dataInicio and :dataFim) AND o.excluida = false AND o.xml is not null GROUP BY o.fornecedor.id")
    public List<Fornecedor> listaSpedFornecedores(@Param(value="dataInicio") LocalDate var1, @Param(value="dataFim") LocalDate var2);

    @Query(value="SELECT sum(o.valorIcms) FROM EntradaMateriaPrima o WHERE (o.dataEmissao between :dataInicio and :dataFim) AND o.excluida = false AND o.xml is not null ORDER BY o.dataEmissao")
    public BigDecimal valorIcmsSped(@Param(value="dataInicio") LocalDate var1, @Param(value="dataFim") LocalDate var2);

    @Query(value="SELECT o FROM EntradaMateriaPrima o WHERE o.excluida = false AND o.xml is not null ORDER BY o.dataEmissao")
    public List<EntradaMateriaPrima> manutencao();
}

