/*
 * Decompiled with CFR 0.152.
 */
package br.com.maximasolutions.estoque.repository;

import br.com.maximasolutions.estoque.modelo.EntradaProduto;
import br.com.maximasolutions.estoque.repository.EntradaProdutoRepositoryCustom;
import br.com.maximasolutions.geral.modelo.Fornecedor;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;

public class EntradaProdutoRepositoryCustomImpl
implements EntradaProdutoRepositoryCustom {
    @PersistenceContext
    private EntityManager entityManager;

    public List<EntradaProduto> pesquisa(LocalDate inicio, LocalDate fim, Boolean excluida, String filtro) {
        String hql = "SELECT o FROM EntradaProduto o WHERE (o.dataEmissao between :inicio and :fim) and (o.fornecedor.nome like '%" + filtro + "%' or o.numeroNota like '" + filtro + "')";
        String where = "";
        where = excluida != null && excluida != false ? where + " AND o.excluida = true " : where + " AND o.excluida = false ";
        String orderBy = " ORDER BY o.dataEmissao DESC, o.id DESC";
        return this.entityManager.createQuery(hql + where + orderBy).setParameter("inicio", (Object)inicio).setParameter("fim", (Object)fim).getResultList();
    }

    public BigDecimal totalPesquisa(LocalDate inicio, LocalDate fim, Boolean excluida, String filtro) {
        String hql = "SELECT SUM(o.total) FROM EntradaProduto o WHERE (o.dataEmissao between :inicio and :fim) and o.fornecedor.nome like '%" + filtro + "%'";
        String where = "";
        where = excluida != null && excluida != false ? where + " AND o.excluida = true " : where + " AND o.excluida = false ";
        return (BigDecimal)this.entityManager.createQuery(hql + where).setParameter("inicio", (Object)inicio).setParameter("fim", (Object)fim).getSingleResult();
    }

    public BigDecimal totalCaixa(Long movimentoCaixaId) {
        String hql = "SELECT SUM(o.total) FROM EntradaProduto o WHERE o.movimentoCaixa.id = " + movimentoCaixaId + " AND o.excluida = false";
        return (BigDecimal)this.entityManager.createQuery(hql).getSingleResult();
    }

    public List<EntradaProduto> relatorio(LocalDate inicio, LocalDate fim, Fornecedor fornecedor) {
        String hql = "SELECT o FROM EntradaProduto o WHERE o.excluida = false AND (o.dataEmissao between :inicio and :fim) ";
        String where = "";
        if (fornecedor != null && fornecedor.getId() != null) {
            where = where + " AND o.fornecedor.id =  " + fornecedor.getId() + " ";
        }
        String orderBy = " ORDER BY o.dataEmissao DESC, o.id DESC";
        return this.entityManager.createQuery(hql + where + orderBy).setParameter("inicio", (Object)inicio).setParameter("fim", (Object)fim).getResultList();
    }
}

