/*
 * Decompiled with CFR 0.152.
 */
package br.com.maximasolutions.estoque.service;

import br.com.maximasolutions.administrativo.modelo.Configuracao;
import br.com.maximasolutions.administrativo.repository.ConfiguracaoRepository;
import br.com.maximasolutions.core.MaximaConfig;
import br.com.maximasolutions.core.MaximaException;
import br.com.maximasolutions.core.MaximaValidacaoException;
import br.com.maximasolutions.estoque.modelo.DevolucaoTipo;
import br.com.maximasolutions.estoque.modelo.Pedido;
import br.com.maximasolutions.estoque.modelo.PedidoItem;
import br.com.maximasolutions.estoque.modelo.Produto;
import br.com.maximasolutions.estoque.modelo.ProdutoExtrato;
import br.com.maximasolutions.estoque.modelo.ProdutoExtratoTipo;
import br.com.maximasolutions.estoque.modelo.TipoMovimentacao;
import br.com.maximasolutions.estoque.modelo.VendaProduto;
import br.com.maximasolutions.estoque.modelo.VendaProdutoItem;
import br.com.maximasolutions.estoque.repository.PedidoItemRepository;
import br.com.maximasolutions.estoque.repository.PedidoRepository;
import br.com.maximasolutions.estoque.repository.ProdutoExtratoRepository;
import br.com.maximasolutions.estoque.repository.ProdutoRepository;
import br.com.maximasolutions.estoque.repository.VendaProdutoItemRepository;
import br.com.maximasolutions.estoque.repository.VendaProdutoRepository;
import br.com.maximasolutions.estoque.service.DevolucaoService;
import br.com.maximasolutions.estoque.utils.VendaProdutoUtils;
import br.com.maximasolutions.financeiro.modelo.MovimentoCaixa;
import br.com.maximasolutions.financeiro.repository.MovimentoCaixaRepository;
import br.com.maximasolutions.geral.modelo.Cliente;
import br.com.maximasolutions.geral.repository.ClienteRepository;
import br.com.maximasolutions.utils.MaximaNumber;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(rollbackFor={MaximaException.class, MaximaValidacaoException.class})
public class DevolucaoServiceImpl
implements DevolucaoService {
    @Autowired
    private PedidoRepository pedidoRepository;
    @Autowired
    private PedidoItemRepository pedidoItemRepository;
    @Autowired
    private VendaProdutoRepository vendaProdutoRepository;
    @Autowired
    private VendaProdutoItemRepository vendaProdutoItemRepository;
    @Autowired
    private ClienteRepository clienteRepository;
    @Autowired
    private ConfiguracaoRepository configuracaoRepository;
    @Autowired
    private MovimentoCaixaRepository movimentoCaixaRepository;
    @Autowired
    private ProdutoRepository produtoRepository;
    @Autowired
    private ProdutoExtratoRepository produtoExtratoRepository;

    public VendaProduto salva(Pedido pedido, DevolucaoTipo devolucaoTipo) throws MaximaValidacaoException, MaximaException {
        Configuracao conf = this.configuracaoRepository.load();
        pedido = (Pedido)this.pedidoRepository.findById((Object)pedido.getId()).get();
        pedido.setTipoMovimentacao(TipoMovimentacao.DEVOLUCAO);
        MovimentoCaixa movimentoCaixa = this.movimentoCaixaRepository.getCaixaAberto(MaximaConfig.getCaixaId().longValue());
        this.validaDevolucao(pedido, movimentoCaixa, conf);
        VendaProdutoUtils vendaProdutoUtils = new VendaProdutoUtils();
        VendaProduto vendaProduto = vendaProdutoUtils.createVendaProduto(null, pedido, movimentoCaixa);
        vendaProduto.setTotalLiquido(vendaProduto.getTotal());
        vendaProduto.setDevolucaoTipo(devolucaoTipo);
        vendaProduto.setDevolucao(Boolean.TRUE);
        vendaProduto = (VendaProduto)this.vendaProdutoRepository.save((Object)vendaProduto);
        List pedidoItemLista = this.pedidoItemRepository.itens(pedido.getId());
        for (PedidoItem pedidoItem : pedidoItemLista) {
            VendaProdutoItem vendaProdutoItem = (VendaProdutoItem)this.vendaProdutoItemRepository.save((Object)vendaProdutoUtils.createVendaProdutoItem(null, pedidoItem, vendaProduto));
            this.baixaEstoque(vendaProdutoItem);
        }
        if (devolucaoTipo.equals((Object)DevolucaoTipo.GERAR_CREDITO)) {
            this.adicionaValeCliente(vendaProduto);
        }
        pedido.setFinalizado(Boolean.valueOf(true));
        this.pedidoRepository.save((Object)pedido);
        return vendaProduto;
    }

    public VendaProduto delete(VendaProduto vendaProduto) throws MaximaValidacaoException, MaximaException {
        if ((vendaProduto = (VendaProduto)this.vendaProdutoRepository.findById((Object)vendaProduto.getId()).get()).isExcluida().booleanValue()) {
            throw new MaximaValidacaoException("Devolu\u00e7\u00e3o j\u00e1 exclu\u00edda do sistema. Opera\u00e7\u00e3o n\u00e3o pode ser realizada.");
        }
        vendaProduto.setExcluida(Boolean.TRUE);
        vendaProduto.setDataExclusao(LocalDateTime.now());
        vendaProduto = (VendaProduto)this.vendaProdutoRepository.save((Object)vendaProduto);
        List vendaProdutoItemLista = this.vendaProdutoItemRepository.listaPorVenda(vendaProduto.getId().longValue());
        for (VendaProdutoItem vendaProdutoItem : vendaProdutoItemLista) {
            this.devolveEstoque(vendaProdutoItem);
        }
        if (vendaProduto.getDevolucaoTipo().equals((Object)DevolucaoTipo.GERAR_CREDITO)) {
            this.removeValeCliente(vendaProduto);
        }
        return vendaProduto;
    }

    private void adicionaValeCliente(VendaProduto vendaProduto) {
        Cliente cliente = (Cliente)this.clienteRepository.findById((Object)vendaProduto.getCliente().getId()).get();
        cliente.setVale(cliente.getVale().add(MaximaNumber.negativa((BigDecimal)vendaProduto.getTotal())));
        this.clienteRepository.save((Object)cliente);
    }

    private void removeValeCliente(VendaProduto vendaProduto) throws MaximaValidacaoException {
        Cliente cliente = (Cliente)this.clienteRepository.findById((Object)vendaProduto.getCliente().getId()).get();
        if (cliente.getVale().compareTo(vendaProduto.getTotal()) < 0) {
            throw new MaximaValidacaoException("Cliente n\u00e3o possui valor em VALE suficiente para executar essa opera\u00e7\u00e3o.");
        }
        cliente.setVale(cliente.getVale().subtract(MaximaNumber.negativa((BigDecimal)vendaProduto.getTotal())));
        this.clienteRepository.save((Object)cliente);
    }

    private void baixaEstoque(VendaProdutoItem vendaProdutoItem) {
        Produto produto = this.produtoRepository.get(vendaProdutoItem.getProduto().getId().longValue());
        BigDecimal estoqueAnterior = produto.getEstoqueAtual();
        produto.setEstoqueAtual(produto.getEstoqueAtual().subtract(vendaProdutoItem.getQuantidade()));
        produto.setSincronizado(Boolean.FALSE);
        produto = (Produto)this.produtoRepository.save((Object)produto);
        this.produtoExtratoRepository.save((Object)new ProdutoExtrato(produto, LocalDate.now(), "DEVOLU\u00c7\u00c3O [" + vendaProdutoItem.getVendaProduto().getId() + "]", MaximaNumber.negativa((BigDecimal)vendaProdutoItem.getQuantidade()), "", estoqueAnterior, produto.getEstoqueAtual(), ProdutoExtratoTipo.DEVOLUCAO));
    }

    private void devolveEstoque(VendaProdutoItem vendaProdutoItem) {
        Produto produto = this.produtoRepository.get(vendaProdutoItem.getProduto().getId().longValue());
        BigDecimal estoqueAnterior = produto.getEstoqueAtual();
        produto.setEstoqueAtual(produto.getEstoqueAtual().add(vendaProdutoItem.getQuantidade()));
        produto.setSincronizado(Boolean.FALSE);
        produto = (Produto)this.produtoRepository.save((Object)produto);
        this.produtoExtratoRepository.save((Object)new ProdutoExtrato(produto, LocalDate.now(), "DEVOLU\u00c7\u00c3O [" + vendaProdutoItem.getVendaProduto().getId() + "]", vendaProdutoItem.getQuantidade(), "", estoqueAnterior, produto.getEstoqueAtual(), ProdutoExtratoTipo.DEVOLUCAO_DELETE));
    }

    private void validaDevolucao(Pedido pedido, MovimentoCaixa movimentoCaixa, Configuracao conf) throws MaximaValidacaoException {
        if (!pedido.getTipoMovimentacao().equals((Object)TipoMovimentacao.DEVOLUCAO)) {
            throw new MaximaValidacaoException("Tipo de movimenta\u00e7\u00e3o deve ser do tipo DEVOLU\u00c7\u00c3O.");
        }
        if (pedido.getCliente() == null) {
            throw new MaximaValidacaoException("Selecione o cliente para efetuar a devolu\u00e7\u00e3o.");
        }
        if (conf.getCliente() != null && pedido.getCliente().getId().equals(conf.getCliente().getId())) {
            throw new MaximaValidacaoException("O cliente selecionado n\u00e3o pode ser o PADR\u00c3O CONSUMIDOR.");
        }
        if (movimentoCaixa == null || movimentoCaixa.getFechado().booleanValue()) {
            throw new MaximaValidacaoException("Movimento de caixa fechado. N\u00e3o \u00e9 poss\u00edvel finalizar.");
        }
    }
}

