/*
 * Decompiled with CFR 0.152.
 */
package br.com.maximasolutions.estoque.service;

import br.com.maximasolutions.administrativo.modelo.Configuracao;
import br.com.maximasolutions.administrativo.repository.ConfiguracaoRepository;
import br.com.maximasolutions.core.MaximaConfig;
import br.com.maximasolutions.core.MaximaException;
import br.com.maximasolutions.estoque.bean.EntradaProdutoItemOrderBy;
import br.com.maximasolutions.estoque.bean.RelatorioEntradaProdutoItemBean;
import br.com.maximasolutions.estoque.modelo.CategoriaProduto;
import br.com.maximasolutions.estoque.modelo.EntradaProduto;
import br.com.maximasolutions.estoque.modelo.EntradaProdutoItem;
import br.com.maximasolutions.estoque.modelo.Produto;
import br.com.maximasolutions.estoque.modelo.ProdutoExtrato;
import br.com.maximasolutions.estoque.modelo.ProdutoExtratoTipo;
import br.com.maximasolutions.estoque.modelo.VendaProduto;
import br.com.maximasolutions.estoque.repository.EntradaProdutoItemRepository;
import br.com.maximasolutions.estoque.repository.EntradaProdutoRepository;
import br.com.maximasolutions.estoque.repository.PedidoItemRepository;
import br.com.maximasolutions.estoque.repository.PedidoRepository;
import br.com.maximasolutions.estoque.repository.ProdutoExtratoRepository;
import br.com.maximasolutions.estoque.repository.ProdutoRepository;
import br.com.maximasolutions.estoque.repository.VendaProdutoRepository;
import br.com.maximasolutions.estoque.service.EntradaProdutoService;
import br.com.maximasolutions.financeiro.modelo.MovimentoCaixa;
import br.com.maximasolutions.financeiro.repository.ContaReceberParcelaRepository;
import br.com.maximasolutions.financeiro.repository.MovimentoCaixaRepository;
import br.com.maximasolutions.geral.modelo.Fornecedor;
import br.com.maximasolutions.utils.MaximaNumber;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(rollbackFor={MaximaException.class})
public class EntradaProdutoServiceImpl
implements EntradaProdutoService {
    @Autowired
    private EntradaProdutoRepository entradaProdutoRepository;
    @Autowired
    private EntradaProdutoItemRepository entradaProdutoItemRepository;
    @Autowired
    private ContaReceberParcelaRepository contaReceberParcelaRepository;
    @Autowired
    private PedidoRepository pedidoRepository;
    @Autowired
    private PedidoItemRepository pedidoItemRepository;
    @Autowired
    private MovimentoCaixaRepository movimentoCaixaRepository;
    @Autowired
    private ProdutoRepository produtoRepository;
    @Autowired
    private ProdutoExtratoRepository produtoExtratoRepository;
    @Autowired
    private ConfiguracaoRepository configuracaoRepository;
    @Autowired
    private VendaProdutoRepository vendaProdutoRepository;

    @Transactional(readOnly=true)
    public EntradaProduto getById(Long id) {
        Optional entradaProduto = this.entradaProdutoRepository.findById((Object)id);
        if (!entradaProduto.isPresent()) {
            return null;
        }
        return (EntradaProduto)entradaProduto.get();
    }

    public EntradaProduto salva(EntradaProduto entradaProduto, List<EntradaProdutoItem> itens) throws MaximaException {
        Configuracao conf = this.configuracaoRepository.load();
        if (conf.getEntradaProdutoCaixa().booleanValue()) {
            MovimentoCaixa movimentoCaixa = this.movimentoCaixaRepository.getCaixaAberto(Long.parseLong(MaximaConfig.getInstance().getProperty("caixa_id", "1")));
            if (movimentoCaixa == null) {
                throw new MaximaException("Nenhum movimento de caixa aberto. N\u00e3o \u00e9 permitido continuar.");
            }
            entradaProduto.setMovimentoCaixa(movimentoCaixa);
        }
        if (entradaProduto.getNfeChaveAcesso() != null && !entradaProduto.getNfeChaveAcesso().isEmpty()) {
            boolean existe = false;
            List lista = this.entradaProdutoRepository.listaPorChaveAcesso(entradaProduto.getNfeChaveAcesso());
            for (EntradaProduto ep : lista) {
                if (entradaProduto.getId() == null) {
                    existe = true;
                    break;
                }
                if (entradaProduto.getId() == null || ep.getId().equals(entradaProduto.getId())) continue;
                existe = true;
                break;
            }
            if (existe) {
                throw new MaximaException("Nota fiscal j\u00e1 cadastrada para entrada de produto.");
            }
        }
        entradaProduto = (EntradaProduto)this.entradaProdutoRepository.save((Object)entradaProduto);
        BigDecimal valorProdutos = BigDecimal.ZERO;
        for (EntradaProdutoItem item : itens) {
            ProdutoExtrato produtoExtrato;
            Produto produto = (Produto)this.produtoRepository.findById((Object)item.getProduto().getId()).get();
            BigDecimal estoqueAnterior = produto.getEstoqueAtual();
            BigDecimal quantidade = item.getQuantidade();
            BigDecimal precoCusto = item.getPrecoCusto();
            if (item.getFatorConversao() != null && item.getFatorConversao().compareTo(BigDecimal.ZERO) > 0) {
                quantidade = quantidade.multiply(item.getFatorConversao()).setScale(4, RoundingMode.HALF_EVEN);
                precoCusto = precoCusto.divide(item.getFatorConversao(), 2, RoundingMode.HALF_EVEN);
            }
            if (item.getId() == null) {
                if (!item.getExcluido().booleanValue()) {
                    item.setEntradaProduto(entradaProduto);
                    item = (EntradaProdutoItem)this.entradaProdutoItemRepository.save((Object)item);
                    produto.setEstoqueAtual(produto.getEstoqueAtual().add(quantidade));
                    if (entradaProduto.getAtualizarCusto().booleanValue()) {
                        produto.setUltimoCusto(precoCusto);
                    }
                    produto.setPrecoVenda(item.getPrecoVenda());
                    produto.setSincronizado(Boolean.valueOf(false));
                    produto = (Produto)this.produtoRepository.save((Object)produto);
                    produtoExtrato = new ProdutoExtrato(produto, LocalDate.now(), "ENTRADA [" + entradaProduto.getId() + "]", quantidade, "", estoqueAnterior, produto.getEstoqueAtual(), ProdutoExtratoTipo.ENTRADA);
                    this.produtoExtratoRepository.save((Object)produtoExtrato);
                }
            } else if (item.getExcluido().booleanValue()) {
                item.setAtivo(Boolean.FALSE);
                item = (EntradaProdutoItem)this.entradaProdutoItemRepository.save((Object)item);
                produto.setEstoqueAtual(produto.getEstoqueAtual().subtract(quantidade));
                produto.setSincronizado(Boolean.valueOf(false));
                produto = (Produto)this.produtoRepository.save((Object)produto);
                produtoExtrato = new ProdutoExtrato(produto, LocalDate.now(), "ENTRADA [" + entradaProduto.getId() + "]", MaximaNumber.negativa((BigDecimal)quantidade), "", estoqueAnterior, produto.getEstoqueAtual(), ProdutoExtratoTipo.ENTRADA_ITEM_DELETE);
                this.produtoExtratoRepository.save((Object)produtoExtrato);
            }
            if (item.getExcluido().booleanValue()) continue;
            valorProdutos = valorProdutos.add(item.getTotalCusto());
        }
        entradaProduto.setValorProdutos(valorProdutos);
        entradaProduto.setTotal(valorProdutos.add(entradaProduto.getFrete()));
        if (entradaProduto.getTotal().compareTo(BigDecimal.ZERO) == 0) {
            entradaProduto.setExcluida(Boolean.valueOf(true));
        }
        return (EntradaProduto)this.entradaProdutoRepository.save((Object)entradaProduto);
    }

    public EntradaProduto delete(EntradaProduto entradaProduto) throws MaximaException {
        if ((entradaProduto = (EntradaProduto)this.entradaProdutoRepository.findById((Object)entradaProduto.getId()).get()).getExcluida().booleanValue()) {
            throw new MaximaException("Entrada de produto j\u00e1 removida.");
        }
        VendaProduto vendaProduto = this.vendaProdutoRepository.getByEntradaProduto(entradaProduto.getId());
        if (vendaProduto != null && !vendaProduto.isExcluida().booleanValue()) {
            throw new MaximaException("Entrada de produto vinculado a uma venda.\nDeve ser exclu\u00eddo a venda para remover a entrada de produto.");
        }
        entradaProduto.setExcluida(Boolean.TRUE);
        entradaProduto.setDataExclusao(LocalDateTime.now());
        entradaProduto = (EntradaProduto)this.entradaProdutoRepository.save((Object)entradaProduto);
        List itens = this.entradaProdutoItemRepository.lista(entradaProduto.getId().longValue());
        for (EntradaProdutoItem item : itens) {
            Produto produto = (Produto)this.produtoRepository.findById((Object)item.getProduto().getId()).get();
            BigDecimal estoqueAnterior = produto.getEstoqueAtual();
            BigDecimal quantidade = item.getQuantidade();
            if (item.getFatorConversao() != null && item.getFatorConversao().compareTo(BigDecimal.ZERO) > 0) {
                quantidade = quantidade.multiply(item.getFatorConversao()).setScale(4, RoundingMode.HALF_EVEN);
            }
            produto.setEstoqueAtual(produto.getEstoqueAtual().subtract(quantidade));
            produto.setSincronizado(Boolean.valueOf(false));
            produto = (Produto)this.produtoRepository.save((Object)produto);
            ProdutoExtrato produtoExtrato = new ProdutoExtrato(produto, LocalDate.now(), "ENTRADA [" + entradaProduto.getId() + "]", MaximaNumber.negativa((BigDecimal)quantidade), "", estoqueAnterior, produto.getEstoqueAtual(), ProdutoExtratoTipo.ENTRADA_DELETE);
            this.produtoExtratoRepository.save((Object)produtoExtrato);
        }
        return entradaProduto;
    }

    @Transactional(readOnly=true)
    public List<EntradaProdutoItem> listItens(EntradaProduto entradaProduto) {
        return this.entradaProdutoItemRepository.lista(entradaProduto.getId().longValue());
    }

    @Transactional(readOnly=true)
    public List<EntradaProduto> lista(LocalDate inicio, LocalDate fim, Boolean excluida, String filtro) {
        return this.entradaProdutoRepository.pesquisa(inicio, fim, excluida, filtro);
    }

    public BigDecimal totalLista(LocalDate inicio, LocalDate fim, Boolean excluida, String filtro) {
        return this.entradaProdutoRepository.totalPesquisa(inicio, fim, excluida, filtro);
    }

    public BigDecimal totalPorCaixa(MovimentoCaixa movimentoCaixa) {
        return this.entradaProdutoRepository.totalCaixa(movimentoCaixa.getId());
    }

    public List<EntradaProduto> relatorio(LocalDate inicio, LocalDate fim, Fornecedor fornecedor) {
        return this.entradaProdutoRepository.relatorio(inicio, fim, fornecedor);
    }

    public List<RelatorioEntradaProdutoItemBean> relatorioProdutos(LocalDate inicio, LocalDate fim, Fornecedor fornecedor, CategoriaProduto categoriaProduto, Boolean agruparProdutos, EntradaProdutoItemOrderBy orderBy) {
        List lista = this.entradaProdutoItemRepository.relatorio(inicio, fim, fornecedor, categoriaProduto, agruparProdutos, orderBy);
        ArrayList<RelatorioEntradaProdutoItemBean> retorno = new ArrayList<RelatorioEntradaProdutoItemBean>();
        for (Object[] obj : lista) {
            RelatorioEntradaProdutoItemBean bean = new RelatorioEntradaProdutoItemBean();
            bean.setCodigo((String)obj[0]);
            bean.setProduto((String)obj[2]);
            bean.setQuantidade((BigDecimal)obj[4]);
            bean.setValorMedio(new BigDecimal((Double)obj[5]));
            bean.setTotal((BigDecimal)obj[6]);
            bean.setProdutoId((Long)obj[8]);
            bean.setUnidade((String)obj[10]);
            retorno.add(bean);
        }
        return retorno;
    }

    @Transactional(readOnly=true)
    public List<EntradaProduto> listaPorProduto(Produto produto) {
        return this.entradaProdutoRepository.listaPorProduto(produto.getId());
    }
}

