/*
 * Decompiled with CFR 0.152.
 */
package br.com.maximasolutions.estoque.service;

import br.com.maximasolutions.config.StageManager;
import br.com.maximasolutions.core.MaximaException;
import br.com.maximasolutions.estoque.modelo.EstoqueBalanco;
import br.com.maximasolutions.estoque.modelo.EstoqueBalancoProduto;
import br.com.maximasolutions.estoque.modelo.Produto;
import br.com.maximasolutions.estoque.modelo.ProdutoExtrato;
import br.com.maximasolutions.estoque.modelo.ProdutoExtratoTipo;
import br.com.maximasolutions.estoque.repository.EstoqueBalancoProdutoRepository;
import br.com.maximasolutions.estoque.repository.EstoqueBalancoRepository;
import br.com.maximasolutions.estoque.repository.ProdutoExtratoRepository;
import br.com.maximasolutions.estoque.repository.ProdutoRepository;
import br.com.maximasolutions.estoque.service.EstoqueBalancoService;
import br.com.maximasolutions.utils.MaximaNumber;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(rollbackFor={MaximaException.class})
public class EstoqueBalancoServiceImpl
implements EstoqueBalancoService {
    @Autowired
    @Lazy
    private StageManager stageManager;
    @Autowired
    private EstoqueBalancoRepository estoqueBalancoRepository;
    @Autowired
    private EstoqueBalancoProdutoRepository estoqueBalancoProdutoRepository;
    @Autowired
    private ProdutoRepository produtoRepository;
    @Autowired
    private ProdutoExtratoRepository produtoExtratoRepository;

    @Transactional(readOnly=true)
    public EstoqueBalanco getById(Long id) {
        Optional estoqueBalanco = this.estoqueBalancoRepository.findById((Object)id);
        if (!estoqueBalanco.isPresent()) {
            return null;
        }
        return (EstoqueBalanco)estoqueBalanco.get();
    }

    public void zerarEstoque() throws MaximaException {
        List produtos = this.produtoRepository.findAll();
        EstoqueBalanco balanco = (EstoqueBalanco)this.estoqueBalancoRepository.save((Object)this.novoBalanco());
        int count = 1;
        for (Produto produto : produtos) {
            BigDecimal estoqueAnterior = produto.getEstoqueAtual();
            produto.setEstoqueAtual(BigDecimal.ZERO);
            produto.setUltimaAlteracao(LocalDateTime.now());
            produto = (Produto)this.produtoRepository.save((Object)produto);
            ProdutoExtrato produtoExtrato = new ProdutoExtrato(produto, LocalDate.now(), "BALAN\u00c7O [" + balanco.getId() + "]", BigDecimal.ZERO, "", estoqueAnterior, produto.getEstoqueAtual(), ProdutoExtratoTipo.BALANCO);
            this.produtoExtratoRepository.save((Object)produtoExtrato);
            this.estoqueBalancoProdutoRepository.save((Object)this.novoBalancoProduto(balanco, produto, estoqueAnterior, produto.getEstoqueAtual(), BigDecimal.ZERO, count));
            ++count;
        }
    }

    public EstoqueBalanco salva(EstoqueBalanco estoqueBalanco, List<EstoqueBalancoProduto> produtos) throws MaximaException {
        estoqueBalanco = (EstoqueBalanco)this.estoqueBalancoRepository.save((Object)estoqueBalanco);
        for (EstoqueBalancoProduto item : produtos) {
            item.setBalanco(estoqueBalanco);
            item = (EstoqueBalancoProduto)this.estoqueBalancoProdutoRepository.save((Object)item);
            Produto produto = (Produto)this.produtoRepository.findById((Object)item.getProduto().getId()).get();
            produto.setEstoqueAtual(item.getEstoqueAtual());
            produto = (Produto)this.produtoRepository.save((Object)produto);
            ProdutoExtrato produtoExtrato = new ProdutoExtrato(produto, LocalDate.now(), "BALAN\u00c7O [" + estoqueBalanco.getId() + "]", item.getQuantidade(), "", item.getEstoqueAnterior(), produto.getEstoqueAtual(), ProdutoExtratoTipo.BALANCO);
            this.produtoExtratoRepository.save((Object)produtoExtrato);
        }
        return estoqueBalanco;
    }

    public EstoqueBalanco delete(EstoqueBalanco estoqueBalanco) throws MaximaException {
        if ((estoqueBalanco = (EstoqueBalanco)this.estoqueBalancoRepository.findById((Object)estoqueBalanco.getId()).get()).getExcluido().booleanValue()) {
            throw new MaximaException("Balan\u00e7o j\u00e1 exclu\u00eddo.");
        }
        estoqueBalanco.setExcluido(Boolean.TRUE);
        estoqueBalanco.setDataExclusao(LocalDateTime.now());
        estoqueBalanco = (EstoqueBalanco)this.estoqueBalancoRepository.save((Object)estoqueBalanco);
        List itens = this.estoqueBalancoProdutoRepository.lista(estoqueBalanco.getId().longValue());
        for (EstoqueBalancoProduto item : itens) {
            Produto produto = (Produto)this.produtoRepository.findById((Object)item.getProduto().getId()).get();
            if (produto.getEstoqueAtual().compareTo(item.getEstoqueAtual()) != 0) {
                throw new MaximaException("Produto: [ " + produto.getNome().toUpperCase() + " ] com estoque alterado ap\u00f3s o balan\u00e7o.\nOpera\u00e7\u00e3o n\u00e3o pode ser removida.");
            }
            produto.setEstoqueAtual(item.getEstoqueAnterior());
            produto = (Produto)this.produtoRepository.save((Object)produto);
            ProdutoExtrato produtoExtrato = new ProdutoExtrato(produto, LocalDate.now(), "BALAN\u00c7O DELETE [" + estoqueBalanco.getId() + "]", MaximaNumber.negativa((BigDecimal)item.getQuantidade()), "", item.getEstoqueAtual(), item.getEstoqueAnterior(), ProdutoExtratoTipo.BALANCO_DELETE);
            this.produtoExtratoRepository.save((Object)produtoExtrato);
        }
        return estoqueBalanco;
    }

    @Transactional(readOnly=true)
    public List<EstoqueBalancoProduto> produtos(EstoqueBalanco estoqueBalanco) {
        return this.estoqueBalancoProdutoRepository.lista(estoqueBalanco.getId().longValue());
    }

    @Transactional(readOnly=true)
    public List<EstoqueBalanco> lista(LocalDate inicio, LocalDate fim, Boolean excluida, String filtro) {
        return this.estoqueBalancoRepository.pesquisa(inicio, fim, excluida, filtro);
    }

    private EstoqueBalancoProduto novoBalancoProduto(EstoqueBalanco balanco, Produto produto, BigDecimal estoqueAnterior, BigDecimal estoqueAtual, BigDecimal quantidade, int numItem) {
        EstoqueBalancoProduto bp = new EstoqueBalancoProduto();
        bp.setBalanco(balanco);
        bp.setDataOperacao(LocalDateTime.now());
        bp.setEstoqueAnterior(estoqueAnterior);
        bp.setEstoqueAtual(estoqueAtual);
        bp.setExcluido(Boolean.FALSE);
        bp.setProduto(produto);
        bp.setQuantidade(quantidade);
        bp.setCodigo(produto.getCodigo());
        bp.setDescricao(produto.getNome());
        bp.setNumItem(Integer.valueOf(numItem));
        bp.setReferencia(produto.getReferencia());
        bp.setUuid(UUID.randomUUID().toString());
        return bp;
    }

    private EstoqueBalanco novoBalanco() {
        EstoqueBalanco balanco = new EstoqueBalanco();
        balanco.setDataOperacao(LocalDate.now());
        balanco.setExcluido(Boolean.FALSE);
        balanco.setHistorico("ZERAR ESTOQUE");
        balanco.setHoraOperacao(LocalDateTime.now());
        balanco.setUsuario(this.stageManager.getUsuario());
        return balanco;
    }
}

