/*
 * Decompiled with CFR 0.152.
 */
package br.com.maximasolutions.estoque.service;

import br.com.maximasolutions.core.MaximaException;
import br.com.maximasolutions.estoque.modelo.MateriaPrima;
import br.com.maximasolutions.estoque.modelo.MateriaPrimaExtrato;
import br.com.maximasolutions.estoque.modelo.MateriaPrimaExtratoTipo;
import br.com.maximasolutions.estoque.repository.MateriaPrimaExtratoRepository;
import br.com.maximasolutions.estoque.repository.MateriaPrimaRepository;
import br.com.maximasolutions.estoque.service.MateriaPrimaService;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(rollbackFor={MaximaException.class})
public class MateriaPrimaServiceImpl
implements MateriaPrimaService {
    @Autowired
    private MateriaPrimaRepository materiaPrimaRepository;
    @Autowired
    private MateriaPrimaExtratoRepository materiaPrimaExtratoRepository;

    public MateriaPrima salva(MateriaPrima materiaPrima) throws MaximaException {
        materiaPrima.setUltimaAlteracao(LocalDateTime.now());
        MateriaPrima existe = this.materiaPrimaRepository.getByCodigo(materiaPrima.getCodigo());
        if (existe != null) {
            if (materiaPrima.getId() == null) {
                throw new MaximaException("C\u00f3digo j\u00e1 cadastrado para outro materiaPrima.");
            }
            if (!materiaPrima.getId().equals(existe.getId())) {
                throw new MaximaException("C\u00f3digo j\u00e1 cadastrado para outro materiaPrima.");
            }
        }
        materiaPrima = (MateriaPrima)this.materiaPrimaRepository.save((Object)materiaPrima);
        MateriaPrimaExtrato extrato = new MateriaPrimaExtrato(materiaPrima, LocalDate.now(), materiaPrima.getEstoqueAtual(), "NOVO", BigDecimal.ZERO, materiaPrima.getEstoqueAtual(), MateriaPrimaExtratoTipo.CADASTRO);
        this.materiaPrimaExtratoRepository.save((Object)extrato);
        return materiaPrima;
    }

    public MateriaPrima getByCodigo(String codigo) {
        return this.materiaPrimaRepository.getByCodigo(codigo);
    }

    public List<MateriaPrima> pesquisa(String valor) {
        return this.materiaPrimaRepository.pesquisa("%" + valor + "%");
    }

    public List<MateriaPrima> listaSped() {
        return this.materiaPrimaRepository.listaSped();
    }
}

