/*
 * Decompiled with CFR 0.152.
 */
package br.com.maximasolutions.estoque.service;

import br.com.maximasolutions.controller.ImportacaoProdutoDto;
import br.com.maximasolutions.core.MaximaException;
import br.com.maximasolutions.estoque.bean.ProdutoExtratoDto;
import br.com.maximasolutions.estoque.bean.ProdutoInventarioBean;
import br.com.maximasolutions.estoque.modelo.CategoriaProduto;
import br.com.maximasolutions.estoque.modelo.Produto;
import br.com.maximasolutions.estoque.modelo.ProdutoComposicao;
import br.com.maximasolutions.estoque.modelo.ProdutoFoto;
import br.com.maximasolutions.estoque.modelo.ProdutoIngrediente;
import br.com.maximasolutions.estoque.modelo.ProdutoMva;
import br.com.maximasolutions.estoque.modelo.VendaProduto;
import br.com.maximasolutions.estoque.modelo.VendaProdutoItem;
import br.com.maximasolutions.estoque.relatorio.bean.RelatorioInventarioBean;
import br.com.maximasolutions.geral.modelo.Estado;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.List;

public interface ProdutoService {
    public List<Produto> listaTodos();

    public Produto getById(long var1);

    public Produto save(Produto var1) throws MaximaException;

    public Produto salva(Produto var1, List<ProdutoComposicao> var2, List<ProdutoIngrediente> var3, ProdutoFoto var4, ProdutoFoto var5) throws MaximaException;

    public Produto salva(Produto var1, List<Produto> var2) throws MaximaException;

    public void alteraPreco(List<Produto> var1, BigDecimal var2) throws MaximaException;

    public Produto importa(ImportacaoProdutoDto var1) throws MaximaException;

    public void salvaListaOrdenada(List<Produto> var1) throws MaximaException;

    public List<Produto> getListaOrdenada();

    public Produto remove(Produto var1) throws MaximaException;

    public Produto getByCodigoBarras(String var1);

    public List<Produto> listaPorCodigoBarras(String var1);

    public Produto getByCodigoEntrada(String var1);

    public List<Produto> getByCodigoInterno(String var1);

    public String geraCodigo();

    public List<Produto> pesquisa(String var1);

    public List<Produto> pesquisa(CategoriaProduto var1, Boolean var2, Boolean var3, Boolean var4, String var5);

    public List<ProdutoComposicao> listaProdutosCombo(Produto var1);

    public List<ProdutoIngrediente> listaIngredientes(Produto var1);

    public List<Produto> lista(CategoriaProduto var1, Boolean var2);

    public List<Produto> listaBalanca();

    public List<Produto> listaSped();

    public List<RelatorioInventarioBean> relatorioInventario(CategoriaProduto var1);

    public List<Produto> relatorioLista(CategoriaProduto var1, Boolean var2, Boolean var3, String var4);

    public List<Produto> relatorioTabelaPreco(CategoriaProduto var1, Boolean var2);

    public List<Produto> relatorioEstoqueBaixo(CategoriaProduto var1);

    public List<ProdutoInventarioBean> listaInventario(LocalDate var1);

    public List<Produto> listaProdutosTamanhos(Produto var1);

    public List<Produto> listaSincronizar();

    public List<Produto> listaVendasExternas();

    public ProdutoFoto getFotoPrincipal(Long var1);

    public ProdutoFoto getFoto(Long var1);

    public List<VendaProduto> listarVendas(Produto var1);

    public List<VendaProdutoItem> listarVendaItens(Produto var1);

    public void atualizaEstoque(Produto var1, BigDecimal var2);

    public List<ProdutoExtratoDto> extratoProduto(Long var1);

    public ProdutoMva getMva(Long var1, Estado var2) throws MaximaException;

    public void atualizaFornecedor();
}

