/*
 * Decompiled with CFR 0.152.
 */
package br.com.maximasolutions.estoque.service;

import br.com.maximasolutions.administrativo.modelo.Configuracao;
import br.com.maximasolutions.administrativo.repository.ConfiguracaoRepository;
import br.com.maximasolutions.core.ImpressoraModelo;
import br.com.maximasolutions.core.MaximaConfig;
import br.com.maximasolutions.core.MaximaException;
import br.com.maximasolutions.core.MaximaImpressao;
import br.com.maximasolutions.core.MaximaValidacaoException;
import br.com.maximasolutions.delivery.modelo.Entregador;
import br.com.maximasolutions.estoque.bean.VendaProdutoItemBean;
import br.com.maximasolutions.estoque.bean.VendaProdutoItemOrderBy;
import br.com.maximasolutions.estoque.bean.VendasCategoriasBean;
import br.com.maximasolutions.estoque.modelo.CategoriaProduto;
import br.com.maximasolutions.estoque.modelo.EntradaProduto;
import br.com.maximasolutions.estoque.modelo.EntradaProdutoItem;
import br.com.maximasolutions.estoque.modelo.Orcamento;
import br.com.maximasolutions.estoque.modelo.Pedido;
import br.com.maximasolutions.estoque.modelo.PedidoItem;
import br.com.maximasolutions.estoque.modelo.PedidoStatus;
import br.com.maximasolutions.estoque.modelo.Produto;
import br.com.maximasolutions.estoque.modelo.ProdutoComposicao;
import br.com.maximasolutions.estoque.modelo.ProdutoExtrato;
import br.com.maximasolutions.estoque.modelo.ProdutoExtratoTipo;
import br.com.maximasolutions.estoque.modelo.TipoMovimentacao;
import br.com.maximasolutions.estoque.modelo.VendaProduto;
import br.com.maximasolutions.estoque.modelo.VendaProdutoAgrupado;
import br.com.maximasolutions.estoque.modelo.VendaProdutoComprovanteTipo;
import br.com.maximasolutions.estoque.modelo.VendaProdutoFaturamento;
import br.com.maximasolutions.estoque.modelo.VendaProdutoItem;
import br.com.maximasolutions.estoque.modelo.VendaProdutoTipo;
import br.com.maximasolutions.estoque.modelo.VendaProdutoTipoEmissao;
import br.com.maximasolutions.estoque.printer.VendaProdutoPrinter;
import br.com.maximasolutions.estoque.relatorio.bean.RelatorioVendaProdutoPorDiaBean;
import br.com.maximasolutions.estoque.relatorio.dto.VendaProdutoGraficoDto;
import br.com.maximasolutions.estoque.report.VendaProdutoReport;
import br.com.maximasolutions.estoque.repository.EntradaProdutoItemRepository;
import br.com.maximasolutions.estoque.repository.EntradaProdutoRepository;
import br.com.maximasolutions.estoque.repository.OrcamentoRepository;
import br.com.maximasolutions.estoque.repository.PedidoItemRepository;
import br.com.maximasolutions.estoque.repository.PedidoRepository;
import br.com.maximasolutions.estoque.repository.ProdutoComposicaoRepository;
import br.com.maximasolutions.estoque.repository.ProdutoExtratoRepository;
import br.com.maximasolutions.estoque.repository.ProdutoRepository;
import br.com.maximasolutions.estoque.repository.VendaProdutoAgrupadoRepository;
import br.com.maximasolutions.estoque.repository.VendaProdutoComboRepository;
import br.com.maximasolutions.estoque.repository.VendaProdutoFaturamentoRepository;
import br.com.maximasolutions.estoque.repository.VendaProdutoItemRepository;
import br.com.maximasolutions.estoque.repository.VendaProdutoRepository;
import br.com.maximasolutions.estoque.service.DevolucaoService;
import br.com.maximasolutions.estoque.service.EntradaProdutoService;
import br.com.maximasolutions.estoque.service.VendaProdutoService;
import br.com.maximasolutions.estoque.utils.VendaProdutoUtils;
import br.com.maximasolutions.financeiro.bean.MovimentoCaixaItemVendidoBean;
import br.com.maximasolutions.financeiro.modelo.CondicaoRecebimento;
import br.com.maximasolutions.financeiro.modelo.ContaReceber;
import br.com.maximasolutions.financeiro.modelo.ContaReceberParcela;
import br.com.maximasolutions.financeiro.modelo.FormaPagamento;
import br.com.maximasolutions.financeiro.modelo.MovimentacaoEntrada;
import br.com.maximasolutions.financeiro.modelo.MovimentoCaixa;
import br.com.maximasolutions.financeiro.modelo.MovimentoCaixaExtratoTipo;
import br.com.maximasolutions.financeiro.repository.ContaReceberParcelaRepository;
import br.com.maximasolutions.financeiro.repository.ContaReceberRepository;
import br.com.maximasolutions.financeiro.repository.MovimentacaoEntradaRepository;
import br.com.maximasolutions.financeiro.repository.MovimentoCaixaExtratoRepository;
import br.com.maximasolutions.financeiro.repository.MovimentoCaixaRepository;
import br.com.maximasolutions.financeiro.utils.MovimentoCaixaUtils;
import br.com.maximasolutions.food.modelo.Comanda;
import br.com.maximasolutions.food.repository.MesaRepository;
import br.com.maximasolutions.geral.modelo.Cliente;
import br.com.maximasolutions.geral.modelo.Fornecedor;
import br.com.maximasolutions.geral.modelo.Vendedor;
import br.com.maximasolutions.geral.repository.ClienteRepository;
import br.com.maximasolutions.geral.repository.FornecedorRepository;
import br.com.maximasolutions.utils.MaximaDate;
import br.com.maximasolutions.utils.MaximaNumber;
import br.com.maximasolutions.utils.MaximaUtils;
import br.com.maximasolutions.vendasexternas.repository.PedidoVendaExternaRepository;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(rollbackFor={MaximaException.class, MaximaValidacaoException.class})
public class VendaProdutoServiceImpl
implements VendaProdutoService {
    @Autowired
    private VendaProdutoRepository vendaProdutoRepository;
    @Autowired
    private VendaProdutoItemRepository vendaProdutoItemRepository;
    @Autowired
    private ClienteRepository clienteRepository;
    @Autowired
    private ContaReceberRepository contaReceberRepository;
    @Autowired
    private ContaReceberParcelaRepository contaReceberParcelaRepository;
    @Autowired
    private PedidoRepository pedidoRepository;
    @Autowired
    private PedidoItemRepository pedidoItemRepository;
    @Autowired
    private MovimentoCaixaRepository movimentoCaixaRepository;
    @Autowired
    private MovimentoCaixaExtratoRepository movimentoCaixaExtratoRepository;
    @Autowired
    private ProdutoRepository produtoRepository;
    @Autowired
    private ProdutoComposicaoRepository produtoComposicaoRepository;
    @Autowired
    private ProdutoExtratoRepository produtoExtratoRepository;
    @Autowired
    private ConfiguracaoRepository configuracaoRepository;
    @Autowired
    private MovimentacaoEntradaRepository movimentacaoEntradaRepository;
    @Autowired
    private VendaProdutoAgrupadoRepository vendaProdutoAgrupadoRepository;
    @Autowired
    private VendaProdutoFaturamentoRepository vendaProdutoFaturamentoRepository;
    @Autowired
    private VendaProdutoComboRepository vendaProdutoComboRepository;
    @Autowired
    private PedidoVendaExternaRepository pedidoVendaExternaRepository;
    @Autowired
    private DevolucaoService devolucaoService;
    @Autowired
    private MesaRepository mesaRepository;
    @Autowired
    private OrcamentoRepository orcamentoRepository;
    @Autowired
    private EntradaProdutoRepository entradaProdutoRepository;
    @Autowired
    private EntradaProdutoItemRepository entradaProdutoItemRepository;
    @Autowired
    private FornecedorRepository fornecedorRepository;
    @Autowired
    private EntradaProdutoService entradaProdutoService;

    @Transactional(readOnly=true)
    public VendaProduto getById(Long id) {
        Optional vendaProduto = this.vendaProdutoRepository.findById((Object)id);
        if (!vendaProduto.isPresent()) {
            return null;
        }
        return (VendaProduto)vendaProduto.get();
    }

    @Transactional(readOnly=true)
    public VendaProduto getByPedido(Long pedidoId) {
        return this.vendaProdutoRepository.getByPedido(pedidoId);
    }

    @Transactional(readOnly=true)
    public VendaProduto getUltima(Long caixaId) {
        return this.vendaProdutoRepository.getUltima(caixaId);
    }

    @Transactional(readOnly=true)
    public VendaProduto getUltimaMovimentoCaixa(Long movimentoCaixaId) {
        List lista = this.vendaProdutoRepository.getUltimaUpdate(movimentoCaixaId, (Pageable)PageRequest.of((int)0, (int)1));
        if (lista.isEmpty()) {
            return null;
        }
        return (VendaProduto)lista.get(0);
    }

    @Transactional(readOnly=true)
    public VendaProduto getByContaReceber(ContaReceber contaReceber) {
        return this.vendaProdutoRepository.getByContaReceber(contaReceber.getId());
    }

    public VendaProduto fechamentoPDV(Pedido pedido, Cliente cliente, CondicaoRecebimento condicaoRecebimento, BigDecimal valorRecebimento, BigDecimal troco) throws MaximaException {
        VendaProduto vendaProduto = this.salva(pedido, cliente, TipoMovimentacao.PEDIDO_VENDA);
        ArrayList<VendaProdutoFaturamento> recebimentos = new ArrayList<VendaProdutoFaturamento>();
        VendaProdutoFaturamento fat = new VendaProdutoFaturamento();
        fat.setCondicaoRecebimento(condicaoRecebimento);
        fat.setDataEmissao(LocalDateTime.now());
        fat.setDataEntrada(vendaProduto.getDataEmissao());
        fat.setHistorico("");
        if (troco != null && troco.compareTo(BigDecimal.ZERO) > 0) {
            valorRecebimento = valorRecebimento.subtract(troco);
        }
        fat.setValor(valorRecebimento);
        fat.setVendaProduto(vendaProduto);
        fat.setValorTroco(troco);
        recebimentos.add(fat);
        vendaProduto = this.faturamento(vendaProduto, recebimentos, troco);
        return vendaProduto;
    }

    public VendaProduto fechamentoPDV(Pedido pedido, Cliente cliente, List<VendaProdutoFaturamento> recebimentos, BigDecimal troco) throws MaximaException {
        VendaProduto vendaExiste = this.vendaProdutoRepository.getByPedido(pedido.getId());
        if (vendaExiste != null) {
            if (vendaExiste.isFaturado().booleanValue()) {
                throw new MaximaException("AVISO: Venda j\u00e1 faturada.");
            }
            if (vendaExiste.isExcluida().booleanValue() || !vendaExiste.isAtivo().booleanValue()) {
                throw new MaximaException("AVSO: Venda exclu\u00edda.");
            }
        }
        VendaProduto vendaProduto = this.salva(pedido, cliente, TipoMovimentacao.PEDIDO_VENDA);
        vendaProduto = this.faturamento(vendaProduto, recebimentos, troco);
        return vendaProduto;
    }

    public VendaProduto fechamentoSemFaturamento(Pedido pedido, Cliente cliente) throws MaximaException {
        VendaProduto vendaProduto = this.salva(pedido, cliente, TipoMovimentacao.PEDIDO_VENDA);
        vendaProduto.setFaturado(Boolean.TRUE);
        vendaProduto.setDataFaturamento(LocalDate.now());
        vendaProduto.setTotalLiquido(BigDecimal.ZERO);
        return vendaProduto;
    }

    public VendaProduto salva(Pedido pedido, Cliente cliente, TipoMovimentacao tipoMovimentacao) throws MaximaException {
        Configuracao conf = this.configuracaoRepository.load();
        pedido = (Pedido)this.pedidoRepository.findById((Object)pedido.getId()).get();
        if (cliente != null) {
            pedido.setCliente(cliente);
        }
        if (pedido.getExcluido().booleanValue()) {
            throw new MaximaException("Aviso: Pedido exclu\u00eddo.\nVenda n\u00e3o finalizada.");
        }
        MovimentoCaixa movimentoCaixa = this.movimentoCaixaRepository.getCaixaAberto(Long.parseLong(MaximaConfig.getInstance().getProperty("caixa_id", "1")));
        if (movimentoCaixa == null) {
            throw new MaximaException("Aviso: Nenhum movimento de caixa aberto.");
        }
        Orcamento orcamento = this.orcamentoRepository.getByPedido(pedido.getId());
        if (orcamento != null) {
            orcamento.setFinalizado(Boolean.valueOf(true));
            orcamento = (Orcamento)this.orcamentoRepository.save((Object)orcamento);
        }
        if (tipoMovimentacao.equals((Object)TipoMovimentacao.CONDICIONAL) && (cliente == null || cliente.getId().equals(conf.getCliente().getId()))) {
            throw new MaximaException("Opera\u00e7\u00e3o n\u00e3o permitida para o cliente informado.");
        }
        VendaProdutoUtils vendaProdutoUtils = new VendaProdutoUtils();
        pedido.setFinalizado(Boolean.TRUE);
        pedido.setUltimaAlteracao(LocalDateTime.now());
        pedido.setTipoMovimentacao(tipoMovimentacao);
        pedido = (Pedido)this.pedidoRepository.save((Object)pedido);
        VendaProduto vendaProduto = this.vendaProdutoRepository.getByPedido(pedido.getId());
        if (vendaProduto != null && vendaProduto.isExcluida().booleanValue()) {
            throw new MaximaException("Aviso: Pedido exclu\u00eddo.\nVenda n\u00e3o finalizada.");
        }
        vendaProduto = vendaProdutoUtils.createVendaProduto(vendaProduto, pedido, movimentoCaixa);
        if (tipoMovimentacao.equals((Object)TipoMovimentacao.CONSIGNADO)) {
            vendaProduto.setTipo(VendaProdutoTipo.CONSIGNADO);
        } else if (tipoMovimentacao.equals((Object)TipoMovimentacao.CONDICIONAL)) {
            vendaProduto.setDataEmissao(pedido.getDataEmissao());
            vendaProduto.setTipo(VendaProdutoTipo.CONDICIONAL);
        } else if (vendaProduto.getTipo() != null && vendaProduto.getTipo().equals((Object)VendaProdutoTipo.CONDICIONAL)) {
            vendaProduto.setTipo(VendaProdutoTipo.VENDA_DIRETA);
            vendaProduto.setDataEmissao(LocalDate.now());
        }
        vendaProduto.setPedido(pedido);
        if (pedido.getComanda() != null) {
            vendaProduto.setObservacao("COMANDA: " + pedido.getComanda().getNome());
            Comanda comanda = (Comanda)this.mesaRepository.findById((Object)pedido.getComanda().getId()).get();
            comanda.setOcupado(Boolean.valueOf(false));
            this.mesaRepository.save((Object)comanda);
        }
        vendaProduto.setOrcamento(orcamento);
        vendaProduto = (VendaProduto)this.vendaProdutoRepository.save((Object)vendaProduto);
        List pedidoItens = this.pedidoItemRepository.itensAll(pedido.getId());
        for (PedidoItem pedidoItem : pedidoItens) {
            ProdutoExtrato produtoExtrato;
            Produto produto;
            System.out.println("=== venda produto entrada: ");
            if (MaximaConfig.getDino().booleanValue() && pedidoItem.getTroca().booleanValue()) {
                EntradaProduto entradaProduto = null;
                if (vendaProduto.getEntradaProduto() != null) {
                    entradaProduto = vendaProduto.getEntradaProduto();
                    List entradaItens = this.entradaProdutoItemRepository.lista(vendaProduto.getEntradaProduto().getId().longValue());
                    boolean existe = false;
                    for (EntradaProdutoItem item : entradaItens) {
                        if (!item.getProduto().getId().equals(pedidoItem.getProduto().getId())) continue;
                        if (pedidoItem.getExcluido().booleanValue()) {
                            item.setExcluido(Boolean.valueOf(true));
                        }
                        existe = true;
                        break;
                    }
                    if (existe) {
                        entradaProduto = this.entradaProdutoService.salva(entradaProduto, entradaItens);
                        continue;
                    }
                }
                if (pedidoItem.getExcluido().booleanValue() && entradaProduto == null || !MaximaConfig.getDino().booleanValue()) continue;
                if (cliente.getCpf() == null || cliente.getCpf().isEmpty()) {
                    throw new MaximaException("Cpf n\u00e3o informado no cadastro do cliente. Preenchimento obrigat\u00f3rio para venda com troca.");
                }
                if (pedidoItem.getQuantidade().compareTo(BigDecimal.ZERO) >= 0) continue;
                if (entradaProduto == null) {
                    entradaProduto = new EntradaProduto();
                }
                entradaProduto.setAtualizarCusto(Boolean.FALSE);
                entradaProduto.setDataEmissao(LocalDate.now());
                entradaProduto.setDataOperacao(LocalDateTime.now());
                entradaProduto.setDesconto(BigDecimal.ZERO);
                entradaProduto.setDespesa(BigDecimal.ZERO);
                entradaProduto.setExcluida(Boolean.FALSE);
                entradaProduto.setFrete(BigDecimal.ZERO);
                entradaProduto.setHistorico("");
                entradaProduto.setHistoricoDespesa("");
                entradaProduto.setMovimentoCaixa(movimentoCaixa);
                List fornecedores = this.fornecedorRepository.getByCnpj(cliente.getCpf());
                Fornecedor fornecedor = fornecedores.isEmpty() ? (Fornecedor)this.fornecedorRepository.save((Object)new Fornecedor().converter(cliente)) : (Fornecedor)fornecedores.get(0);
                entradaProduto.setFornecedor(fornecedor);
                entradaProduto.setTotal(entradaProduto.getTotal().add(pedidoItem.getPrecoTotal().multiply(new BigDecimal("-1"))));
                entradaProduto.setValorProdutos(entradaProduto.getValorProdutos().add(pedidoItem.getPrecoTotal().multiply(new BigDecimal("-1"))));
                EntradaProdutoItem entradaItem = new EntradaProdutoItem();
                entradaItem.setAtivo(Boolean.TRUE);
                entradaItem.setCodigoBarras(pedidoItem.getCodigo());
                entradaItem.setDataOperacao(LocalDate.now());
                entradaItem.setDesconto(BigDecimal.ZERO);
                entradaItem.setDescricao(pedidoItem.getDescricao());
                entradaItem.setExcluido(Boolean.FALSE);
                entradaItem.setNumItem(Integer.valueOf(1));
                entradaItem.setPrecoCusto(pedidoItem.getPrecoTotal().multiply(new BigDecimal("-1")));
                entradaItem.setPrecoVenda(pedidoItem.getProduto().getPrecoVenda());
                entradaItem.setProduto(pedidoItem.getProduto());
                entradaItem.setQuantidade(pedidoItem.getQuantidade().multiply(new BigDecimal("-1")));
                entradaItem.setReferencia(pedidoItem.getProduto().getReferencia());
                entradaItem.setTotalCusto(pedidoItem.getPrecoTotal().multiply(new BigDecimal("-1")));
                entradaItem.setUnidade(pedidoItem.getUnidade());
                entradaProduto = (EntradaProduto)this.entradaProdutoRepository.save((Object)entradaProduto);
                entradaItem.setEntradaProduto(entradaProduto);
                this.entradaProdutoItemRepository.save((Object)entradaItem);
                vendaProduto.setEntradaProduto(entradaProduto);
                vendaProduto = (VendaProduto)this.vendaProdutoRepository.save((Object)vendaProduto);
                Produto produto2 = (Produto)this.produtoRepository.findById((Object)pedidoItem.getProduto().getId()).get();
                if (!conf.getPermiteEstoqueNegativo().booleanValue() && produto2.isEstoqueNegativo().booleanValue() && produto2.getEstoqueAtual().compareTo(pedidoItem.getQuantidade()) < 0) {
                    throw new MaximaException("AVISO: Produto: " + produto2.getNome() + "\nEstoque insuficiente!");
                }
                BigDecimal estoqueAnterior = produto2.getEstoqueAtual();
                produto2.setEstoqueAtual(produto2.getEstoqueAtual().add(pedidoItem.getQuantidade().multiply(new BigDecimal("-1"))));
                produto2.setSincronizado(Boolean.FALSE);
                produto2 = (Produto)this.produtoRepository.save((Object)produto2);
                ProdutoExtrato produtoExtrato2 = new ProdutoExtrato(produto2, LocalDate.now(), "VENDA[" + vendaProduto.getId() + "]", pedidoItem.getQuantidade(), "", estoqueAnterior, produto2.getEstoqueAtual(), ProdutoExtratoTipo.VENDA_DIRETA_DELETE_ITEM);
                this.produtoExtratoRepository.save((Object)produtoExtrato2);
                continue;
            }
            VendaProdutoItem vendaProdutoItem = this.vendaProdutoItemRepository.getByPedidoItem(pedidoItem.getId());
            if (pedidoItem.getExcluido().booleanValue()) {
                if (vendaProdutoItem == null || !vendaProdutoItem.isAtivo().booleanValue()) continue;
                produto = (Produto)this.produtoRepository.findById((Object)vendaProdutoItem.getProduto().getId()).get();
                if (!conf.getPermiteEstoqueNegativo().booleanValue() && produto.isEstoqueNegativo().booleanValue() && produto.getEstoqueAtual().compareTo(pedidoItem.getQuantidade()) < 0) {
                    throw new MaximaException("AVISO: Produto: " + produto.getNome() + "\nEstoque insuficiente!");
                }
                BigDecimal estoqueAnterior = produto.getEstoqueAtual();
                produto.setEstoqueAtual(produto.getEstoqueAtual().add(vendaProdutoItem.getQuantidade()));
                produto.setSincronizado(Boolean.FALSE);
                produto = (Produto)this.produtoRepository.save((Object)produto);
                produtoExtrato = new ProdutoExtrato(produto, LocalDate.now(), "VENDA[" + vendaProduto.getId() + "]", vendaProdutoItem.getQuantidade(), "", estoqueAnterior, produto.getEstoqueAtual(), ProdutoExtratoTipo.VENDA_DIRETA_DELETE_ITEM);
                this.produtoExtratoRepository.save((Object)produtoExtrato);
                vendaProdutoItem.setAtivo(Boolean.FALSE);
                vendaProdutoItem.setDataExclusao(LocalDateTime.now());
                this.vendaProdutoItemRepository.save((Object)vendaProdutoItem);
                continue;
            }
            if (vendaProdutoItem != null && pedidoItem.getEditado().booleanValue()) {
                BigDecimal quantidadeDiferenca = null;
                if (vendaProdutoItem.getQuantidade().compareTo(pedidoItem.getQuantidade()) != 0) {
                    quantidadeDiferenca = vendaProdutoItem.getQuantidade().compareTo(pedidoItem.getQuantidade()) < 0 ? MaximaNumber.negativa((BigDecimal)vendaProdutoItem.getQuantidade().subtract(pedidoItem.getQuantidade())) : pedidoItem.getQuantidade().subtract(vendaProdutoItem.getQuantidade());
                }
                vendaProdutoItem.setVendedor(pedidoItem.getVendedor());
                vendaProdutoItem.setPrecoUnitario(pedidoItem.getPrecoUnitario());
                vendaProdutoItem.setDesconto(pedidoItem.getDesconto());
                vendaProdutoItem.setQuantidade(pedidoItem.getQuantidade());
                vendaProdutoItem.setPrecoTotal(pedidoItem.getPrecoTotal());
                vendaProdutoItem.setObservacao(pedidoItem.getObservacao());
                vendaProdutoItem = (VendaProdutoItem)this.vendaProdutoItemRepository.save((Object)vendaProdutoItem);
                pedidoItem.setEditado(Boolean.FALSE);
                this.pedidoItemRepository.save((Object)pedidoItem);
                if (quantidadeDiferenca != null) {
                    Produto produto3 = (Produto)this.produtoRepository.findById((Object)vendaProdutoItem.getProduto().getId()).get();
                    BigDecimal estoqueAnterior = produto3.getEstoqueAtual();
                    produto3.setEstoqueAtual(produto3.getEstoqueAtual().subtract(quantidadeDiferenca));
                    produto3.setUltimaVenda(LocalDate.now());
                    produto3.setSincronizado(Boolean.FALSE);
                    produto3 = (Produto)this.produtoRepository.save((Object)produto3);
                    ProdutoExtrato produtoExtrato3 = new ProdutoExtrato(produto3, LocalDate.now(), "VENDA[" + vendaProduto.getId() + "]", MaximaNumber.negativa((BigDecimal)quantidadeDiferenca), "", estoqueAnterior, produto3.getEstoqueAtual(), ProdutoExtratoTipo.VENDA_DIRETA_EDITA_ITEM);
                    this.produtoExtratoRepository.save((Object)produtoExtrato3);
                }
            }
            if (vendaProdutoItem != null) continue;
            produto = (Produto)this.produtoRepository.findById((Object)pedidoItem.getProduto().getId()).get();
            BigDecimal estoqueAnterior = produto.getEstoqueAtual();
            produto.setEstoqueAtual(produto.getEstoqueAtual().subtract(pedidoItem.getQuantidade()));
            produto.setUltimaVenda(LocalDate.now());
            produto.setSincronizado(Boolean.valueOf(false));
            produto = (Produto)this.produtoRepository.save((Object)produto);
            produtoExtrato = new ProdutoExtrato(produto, LocalDate.now(), "VENDA[" + vendaProduto.getId() + "]", MaximaNumber.negativa((BigDecimal)pedidoItem.getQuantidade()), "", estoqueAnterior, produto.getEstoqueAtual(), ProdutoExtratoTipo.VENDA_DIRETA);
            this.produtoExtratoRepository.save((Object)produtoExtrato);
            if (pedidoItem.getProduto().getCombo().booleanValue()) {
                this.vendaProdutoComboRepository.save((Object)vendaProdutoUtils.createVendaProdutoCombo(null, pedidoItem, vendaProduto));
                List subProdutos = this.produtoComposicaoRepository.lista(pedidoItem.getProduto().getId());
                for (ProdutoComposicao produtoComposicao : subProdutos) {
                    vendaProdutoItem = null;
                    vendaProdutoItem = vendaProdutoUtils.createVendaProdutoItemCombo(vendaProdutoItem, pedidoItem, vendaProduto, produtoComposicao);
                    vendaProdutoItem = (VendaProdutoItem)this.vendaProdutoItemRepository.save((Object)vendaProdutoItem);
                    produto = (Produto)this.produtoRepository.findById((Object)vendaProdutoItem.getProduto().getId()).get();
                    estoqueAnterior = produto.getEstoqueAtual();
                    produto.setEstoqueAtual(produto.getEstoqueAtual().subtract(vendaProdutoItem.getQuantidade()));
                    produto.setUltimaVenda(LocalDate.now());
                    produto.setSincronizado(Boolean.FALSE);
                    produto = (Produto)this.produtoRepository.save((Object)produto);
                    produtoExtrato = new ProdutoExtrato(produto, LocalDate.now(), "VENDA[" + vendaProduto.getId() + "]", MaximaNumber.negativa((BigDecimal)vendaProdutoItem.getQuantidade()), "", estoqueAnterior, produto.getEstoqueAtual(), ProdutoExtratoTipo.VENDA_DIRETA);
                    this.produtoExtratoRepository.save((Object)produtoExtrato);
                }
                continue;
            }
            vendaProdutoItem = vendaProdutoUtils.createVendaProdutoItem(vendaProdutoItem, pedidoItem, vendaProduto);
            vendaProdutoItem = (VendaProdutoItem)this.vendaProdutoItemRepository.save((Object)vendaProdutoItem);
        }
        List itens = this.vendaProdutoItemRepository.listaPorVenda(vendaProduto.getId().longValue());
        BigDecimal totalProdutos = BigDecimal.ZERO;
        for (VendaProdutoItem item : itens) {
            System.out.println("== ITEM: " + item.getPrecoUnitario() + "  |  " + item.getQuantidade() + "  |  " + item.getPrecoTotal());
            totalProdutos = totalProdutos.add(item.getPrecoTotal());
        }
        System.out.println("==== total venda: " + vendaProduto.getTotal());
        if (vendaProduto.getTotal().compareTo(totalProdutos) != 0) {
            throw new MaximaException("O valor total da venda n\u00e3o confere com o valor da soma dos produtos.");
        }
        return vendaProduto;
    }

    public VendaProduto salva(Pedido pedido, Cliente cliente, TipoMovimentacao tipoMovimentacao, Entregador entregador) throws MaximaException {
        if (entregador == null) {
            throw new MaximaException("Informe o entregador.");
        }
        System.out.println("== Salvar venda em entrega ==");
        pedido = (Pedido)this.pedidoRepository.findById((Object)pedido.getId()).get();
        pedido.setPedidoStatus(PedidoStatus.EM_ENTREGA);
        pedido.setEntregador(entregador);
        pedido = (Pedido)this.pedidoRepository.save((Object)pedido);
        return this.salva(pedido, cliente, tipoMovimentacao);
    }

    public VendaProduto faturamento(VendaProduto vendaProduto, List<VendaProdutoFaturamento> faturamentos, BigDecimal troco) throws MaximaException {
        if ((vendaProduto = (VendaProduto)this.vendaProdutoRepository.findById((Object)vendaProduto.getId()).get()).isFaturado().booleanValue()) {
            throw new MaximaException("AVISO: Venda j\u00e1 faturada.");
        }
        if (vendaProduto.isExcluida().booleanValue() || !vendaProduto.isAtivo().booleanValue()) {
            throw new MaximaException("AVSO: Venda exclu\u00edda.");
        }
        if (faturamentos == null || faturamentos.isEmpty()) {
            throw new MaximaException("AVISO: Nenhum recebimento informado.");
        }
        MovimentoCaixa movimentoCaixa = this.movimentoCaixaRepository.getCaixaAberto(Long.parseLong(MaximaConfig.getInstance().getProperty("caixa_id", "1")));
        if (movimentoCaixa == null) {
            throw new MaximaException("Nenhum movimento de caixa aberto.\nVenda n\u00e3o pode ser faturada.");
        }
        Configuracao conf = this.configuracaoRepository.load();
        if (conf == null) {
            throw new MaximaException("N\u00e3o foi poss\u00edvel carregar a tabela de configura\u00e7\u00f5es.\nVenda n\u00e3o pode ser faturada.");
        }
        if (conf.getCentroCusto() == null) {
            throw new MaximaException("Centro de custo n\u00e3o configurado.\nVenda n\u00e3o pode ser faturada.");
        }
        vendaProduto.setFaturado(Boolean.TRUE);
        vendaProduto.setDataFaturamento(LocalDate.now());
        BigDecimal somaFaturamento = BigDecimal.ZERO;
        for (VendaProdutoFaturamento fat : faturamentos) {
            if (troco != null && troco.compareTo(BigDecimal.ZERO) > 0 && fat.getCondicaoRecebimento().getPermiteTroco().booleanValue()) {
                fat.setValor(fat.getValor().subtract(troco));
            }
            System.out.println("==== fat: " + fat.getCondicaoRecebimento().getNome() + ": " + fat.getValor() + " | " + fat.getValorRecebimento());
            fat.setVendaProduto(vendaProduto);
            fat = (VendaProdutoFaturamento)this.vendaProdutoFaturamentoRepository.save((Object)fat);
            somaFaturamento = somaFaturamento.add(fat.getValor());
            movimentoCaixa = (MovimentoCaixa)this.movimentoCaixaRepository.save((Object)MovimentoCaixaUtils.addRecebimento((MovimentoCaixa)movimentoCaixa, (FormaPagamento)fat.getCondicaoRecebimento().getFormaPagamento(), (BigDecimal)fat.getValorRecebimento(), (Boolean)true, (Boolean)fat.getCondicaoRecebimento().getAdicionarValorCaixa()));
        }
        if (vendaProduto.getValorDevolucao().compareTo(BigDecimal.ZERO) != 0) {
            movimentoCaixa.setDevolucoes(movimentoCaixa.getDevolucoes().add(vendaProduto.getValorDevolucao()));
            movimentoCaixa = (MovimentoCaixa)this.movimentoCaixaRepository.save((Object)movimentoCaixa);
        }
        if (vendaProduto.getTotal().compareTo(somaFaturamento) != 0) {
            throw new MaximaException("AVISO: Soma dos valores recebidos diferente do valor total da venda.");
        }
        VendaProdutoUtils vendaProdutoUtils = new VendaProdutoUtils();
        ContaReceber contaReceber = vendaProdutoUtils.createContaReceber(vendaProduto, conf.getCentroCusto());
        contaReceber = (ContaReceber)this.contaReceberRepository.save((Object)contaReceber);
        List parcelas = vendaProdutoUtils.createContaReceberParcela(contaReceber, faturamentos, troco);
        BigDecimal valorLiquido = BigDecimal.ZERO;
        for (ContaReceberParcela crp : parcelas) {
            if (crp.getCondicaoPagamento().getFormaPagamento().equals((Object)FormaPagamento.PROMISSORIA)) {
                BigDecimal saldoDisponivel;
                BigDecimal valorDevido = this.contaReceberParcelaRepository.valorPendentePorCliente(vendaProduto.getCliente().getId().longValue());
                if (valorDevido == null) {
                    valorDevido = BigDecimal.ZERO;
                }
                if ((saldoDisponivel = vendaProduto.getCliente().getLimite().subtract(valorDevido)).compareTo(crp.getTotal()) < 0) {
                    BigDecimal limiteDisponivel = vendaProduto.getCliente().getLimite();
                    String saldo = "[0,00]";
                    if (limiteDisponivel.compareTo(BigDecimal.ZERO) > 0 && (limiteDisponivel = limiteDisponivel.subtract(valorDevido)).compareTo(BigDecimal.ZERO) > 0) {
                        saldo = "[" + MaximaNumber.formataNumero((BigDecimal)limiteDisponivel) + "]";
                    }
                    throw new MaximaException("Cliente n\u00e3o possui limite suficiente para compra na promiss\u00f3ria" + saldo + ".");
                }
            }
            if (crp.getCondicaoPagamento().getFormaPagamento().equals((Object)FormaPagamento.VALECOMPRA)) {
                crp.setValeTroca(Boolean.TRUE);
                BigDecimal valorTroca = vendaProduto.getPedido().getValorTroca().multiply(new BigDecimal("-1"));
                if (valorTroca.compareTo(BigDecimal.ZERO) > 0) {
                    if (valorTroca.compareTo(crp.getValorLiquido()) < 0) {
                        throw new MaximaException("Cliente n\u00e3o possui vale troca neste valor.");
                    }
                } else {
                    if (vendaProduto.getCliente().getVale().compareTo(crp.getValorLiquido()) < 0) {
                        throw new MaximaException("Cliente n\u00e3o possui vale troca neste valor.");
                    }
                    Cliente cliente = (Cliente)this.clienteRepository.findById((Object)vendaProduto.getCliente().getId()).get();
                    cliente.setVale(cliente.getVale().subtract(crp.getValorLiquido()));
                    this.clienteRepository.save((Object)cliente);
                }
            }
            if (crp.getCondicaoPagamento().getFormaPagamento().equals((Object)FormaPagamento.BONUS)) {
                crp.setBonus(Boolean.TRUE);
                if (vendaProduto.getCliente().getBonus().compareTo(crp.getValorLiquido()) < 0) {
                    throw new MaximaException("Cliente n\u00e3o possui b\u00f4nus neste valor.");
                }
                Cliente cliente = (Cliente)this.clienteRepository.findById((Object)vendaProduto.getCliente().getId()).get();
                cliente.setBonus(cliente.getBonus().subtract(crp.getValorLiquido()));
                this.clienteRepository.save((Object)cliente);
            }
            crp = (ContaReceberParcela)this.contaReceberParcelaRepository.save((Object)crp);
            valorLiquido = valorLiquido.add(crp.getValorLiquido());
            if (!crp.isQuitado() || crp.getBonus().booleanValue() || crp.getValeTroca().booleanValue()) continue;
            MovimentacaoEntrada rec = vendaProdutoUtils.createMovimentacaoEntrada(crp, movimentoCaixa);
            rec = (MovimentacaoEntrada)this.movimentacaoEntradaRepository.save((Object)rec);
            this.movimentoCaixaExtratoRepository.save((Object)MovimentoCaixaUtils.getExtrato((MovimentoCaixa)movimentoCaixa, (Long)rec.getId(), (BigDecimal)rec.getValorLiquido(), (BigDecimal)movimentoCaixa.getValorEmCaixa(), (MovimentoCaixaExtratoTipo)MovimentoCaixaExtratoTipo.VENDA, (FormaPagamento)rec.getFormaPagamento()));
        }
        vendaProduto.setTotalLiquido(valorLiquido);
        vendaProduto.setContaReceber(contaReceber);
        vendaProduto.setTroco(troco);
        vendaProduto = (VendaProduto)this.vendaProdutoRepository.save((Object)vendaProduto);
        return vendaProduto;
    }

    public VendaProduto agrupa(List<VendaProduto> vendas) throws MaximaException {
        if (vendas == null || vendas.size() < 2) {
            throw new MaximaException("Selecione ao menos duas vendas para agrupas.");
        }
        VendaProduto novo = new VendaProduto();
        novo.setAtivo(Boolean.TRUE);
        novo.setCliente(vendas.get(0).getCliente());
        novo.setCpf(vendas.get(0).getCliente().getCpf());
        novo.setDataEmissao(vendas.get(0).getDataEmissao());
        novo.setDataOperacao(LocalDateTime.now());
        novo.setExcluida(Boolean.FALSE);
        novo.setFaturado(Boolean.FALSE);
        novo.setMovimentoCaixa(this.movimentoCaixaRepository.getCaixaAberto(Long.parseLong(MaximaConfig.getInstance().getProperty("caixa_id", "1"))));
        novo.setObservacao("");
        novo.setTipo(VendaProdutoTipo.VENDA_DIRETA);
        novo.setTipoEmissao(VendaProdutoTipoEmissao.PEDIDO_VENDA);
        novo = (VendaProduto)this.vendaProdutoRepository.save((Object)novo);
        BigDecimal total = BigDecimal.ZERO;
        BigDecimal produtos = BigDecimal.ZERO;
        BigDecimal pecas = BigDecimal.ZERO;
        BigDecimal servicos = BigDecimal.ZERO;
        BigDecimal desconto = BigDecimal.ZERO;
        BigDecimal custoProdutos = BigDecimal.ZERO;
        BigDecimal custoServicos = BigDecimal.ZERO;
        BigDecimal custoTotal = BigDecimal.ZERO;
        Integer numItem = 1;
        for (VendaProduto venda : vendas) {
            total = total.add(venda.getTotal());
            produtos = produtos.add(venda.getValorProdutos());
            pecas = pecas.add(venda.getValorPecas());
            servicos = servicos.add(venda.getValorServico());
            desconto = desconto.add(venda.getDesconto());
            custoProdutos = custoProdutos.add(venda.getCustoProdutos());
            custoServicos = custoServicos.add(venda.getCustoServicos());
            custoTotal = custoTotal.add(venda.getCustoTotal());
            List itens = this.vendaProdutoItemRepository.listaPorVenda(venda.getId().longValue());
            for (VendaProdutoItem item : itens) {
                VendaProdutoItem novoItem = new VendaProdutoItem();
                novoItem.setAtivo(item.isAtivo());
                novoItem.setDataExclusao(item.getDataExclusao());
                novoItem.setDataMovimento(item.getDataMovimento());
                novoItem.setDesconto(item.getDesconto());
                novoItem.setDescricao(item.getDescricao());
                novoItem.setNumItem(numItem);
                novoItem.setObservacao(item.getObservacao());
                novoItem.setPrecoCusto(item.getPrecoCusto());
                novoItem.setPrecoTotal(item.getPrecoTotal());
                novoItem.setPrecoUnitario(item.getPrecoUnitario());
                novoItem.setProduto(item.getProduto());
                novoItem.setQuantidade(item.getQuantidade());
                novoItem.setUnidade(item.getUnidade());
                novoItem.setVendaProduto(novo);
                novoItem.setVendedor(item.getVendedor());
                this.vendaProdutoItemRepository.save((Object)novoItem);
                Integer n = numItem;
                Integer n2 = numItem = Integer.valueOf(numItem + 1);
            }
            venda.setExcluida(Boolean.TRUE);
            venda.setAgrupado(Boolean.TRUE);
            venda = (VendaProduto)this.vendaProdutoRepository.save((Object)venda);
            VendaProdutoAgrupado agrupado = new VendaProdutoAgrupado();
            agrupado.setAgrupado(venda);
            agrupado.setDataOperacao(LocalDateTime.now());
            agrupado.setNovo(novo);
            this.vendaProdutoAgrupadoRepository.save((Object)agrupado);
        }
        novo.setDesconto(desconto);
        novo.setTotal(total);
        novo.setValorProdutos(produtos);
        novo.setValorPecas(pecas);
        novo.setValorServico(servicos);
        novo.setCustoProdutos(custoProdutos);
        novo.setCustoServicos(custoServicos);
        novo.setCustoTotal(custoTotal);
        return (VendaProduto)this.vendaProdutoRepository.save((Object)novo);
    }

    public VendaProduto delete(VendaProduto vendaProduto) throws MaximaException {
        if ((vendaProduto = (VendaProduto)this.vendaProdutoRepository.findById((Object)vendaProduto.getId()).get()).isExcluida().booleanValue() || !vendaProduto.isAtivo().booleanValue()) {
            throw new MaximaException("Venda j\u00e1 deletada.\nN\u00e3o \u00e9 poss\u00edvel continuar.");
        }
        if (this.pedidoVendaExternaRepository.getByVenda(vendaProduto.getId()) != null) {
            throw new MaximaException("AVISO: Venda referente a um pedido externo.\nExclus\u00e3o deve ser feita atrav\u00e9s do m\u00f3dulo de pedidos.");
        }
        if (vendaProduto.getDevolucao().booleanValue()) {
            try {
                return this.devolucaoService.delete(vendaProduto);
            }
            catch (MaximaValidacaoException ex) {
                throw new MaximaException(ex.getMessage());
            }
        }
        if (vendaProduto.isFaturado().booleanValue()) {
            this.deleteFaturamento(vendaProduto, Boolean.valueOf(true));
        }
        vendaProduto.setExcluida(Boolean.TRUE);
        vendaProduto.setDataExclusao(LocalDateTime.now());
        vendaProduto = (VendaProduto)this.vendaProdutoRepository.save((Object)vendaProduto);
        List itens = this.vendaProdutoItemRepository.listaPorVenda(vendaProduto.getId().longValue());
        for (VendaProdutoItem item : itens) {
            Produto produto = (Produto)this.produtoRepository.findById((Object)item.getProduto().getId()).get();
            BigDecimal estoqueAnterior = produto.getEstoqueAtual();
            produto.setEstoqueAtual(produto.getEstoqueAtual().add(item.getQuantidade()));
            produto.setSincronizado(Boolean.FALSE);
            produto = (Produto)this.produtoRepository.save((Object)produto);
            ProdutoExtrato produtoExtrato = new ProdutoExtrato(produto, LocalDate.now(), "VENDA[" + vendaProduto.getId() + "]", item.getQuantidade(), "", estoqueAnterior, produto.getEstoqueAtual(), ProdutoExtratoTipo.VENDA_DIRETA_DELETE);
            this.produtoExtratoRepository.save((Object)produtoExtrato);
        }
        if (vendaProduto.getEntradaProduto() != null) {
            this.entradaProdutoService.delete(vendaProduto.getEntradaProduto());
        }
        return vendaProduto;
    }

    public VendaProduto deleteFaturamento(VendaProduto vendaProduto, Boolean deleteVenda) throws MaximaException {
        if ((vendaProduto = (VendaProduto)this.vendaProdutoRepository.findById((Object)vendaProduto.getId()).get()).isExcluida().booleanValue() || !vendaProduto.isAtivo().booleanValue()) {
            throw new MaximaException("Venda j\u00e1 deletada.\nN\u00e3o \u00e9 poss\u00edvel continuar.");
        }
        if (!vendaProduto.isFaturado().booleanValue()) {
            throw new MaximaException("Venda n\u00e3o faturada.\nN\u00e3o \u00e9 poss\u00edvel continuar.");
        }
        if (!deleteVenda.booleanValue()) {
            vendaProduto.setFaturado(Boolean.FALSE);
            vendaProduto.setDataFaturamento(null);
            vendaProduto.setTotalLiquido(BigDecimal.ZERO);
        }
        vendaProduto = (VendaProduto)this.vendaProdutoRepository.save((Object)vendaProduto);
        MovimentoCaixa movimentoCaixa = vendaProduto.getMovimentoCaixa();
        if (vendaProduto.getContaReceber() != null) {
            List parcelas = this.contaReceberParcelaRepository.listPorContaReceber(vendaProduto.getContaReceber().getId().longValue());
            for (ContaReceberParcela crp : parcelas) {
                Cliente cliente;
                crp.setExcluido(Boolean.TRUE);
                crp.setDataExcluido(LocalDateTime.now());
                Boolean adicionarValorAoCaixa = false;
                if (crp.getCondicaoPagamento() != null) {
                    adicionarValorAoCaixa = crp.getCondicaoPagamento().getAdicionarValorCaixa();
                }
                movimentoCaixa = (MovimentoCaixa)this.movimentoCaixaRepository.save((Object)MovimentoCaixaUtils.deleteRecebimento((MovimentoCaixa)movimentoCaixa, (FormaPagamento)crp.getFormaPagamento(), (BigDecimal)crp.getValorLiquido(), (Boolean)true, (Boolean)adicionarValorAoCaixa));
                if (!crp.isQuitado()) continue;
                if (crp.getValeTroca().booleanValue()) {
                    cliente = (Cliente)this.clienteRepository.findById((Object)crp.getCliente().getId()).get();
                    cliente.setVale(cliente.getVale().add(crp.getValorLiquido()));
                    this.clienteRepository.save((Object)cliente);
                }
                if (crp.getBonus().booleanValue()) {
                    cliente = (Cliente)this.clienteRepository.findById((Object)crp.getCliente().getId()).get();
                    cliente.setBonus(cliente.getBonus().add(crp.getValorLiquido()));
                    this.clienteRepository.save((Object)cliente);
                }
                List recebimentos = this.movimentacaoEntradaRepository.listContaReceber(vendaProduto.getContaReceber().getId());
                for (MovimentacaoEntrada rec : recebimentos) {
                    rec.setEstornada(Boolean.TRUE);
                    rec.setDataEstorno(LocalDateTime.now());
                    rec = (MovimentacaoEntrada)this.movimentacaoEntradaRepository.save((Object)rec);
                    this.movimentoCaixaExtratoRepository.save((Object)MovimentoCaixaUtils.getExtrato((MovimentoCaixa)movimentoCaixa, (Long)rec.getId(), (BigDecimal)MaximaNumber.negativa((BigDecimal)rec.getValorLiquido()), (BigDecimal)movimentoCaixa.getValorEmCaixa(), (MovimentoCaixaExtratoTipo)MovimentoCaixaExtratoTipo.VENDA, (FormaPagamento)rec.getFormaPagamento()));
                }
            }
        }
        if (vendaProduto.getValorDevolucao().compareTo(BigDecimal.ZERO) != 0) {
            movimentoCaixa.setDevolucoes(movimentoCaixa.getDevolucoes().subtract(vendaProduto.getValorDevolucao()));
            this.movimentoCaixaRepository.save((Object)movimentoCaixa);
        }
        return vendaProduto;
    }

    @Transactional(readOnly=true)
    public List<VendaProduto> listaPorMovimentoCaixa(MovimentoCaixa movimentoCaixa) {
        return this.vendaProdutoRepository.listaPorMovimentoCaixa(movimentoCaixa.getId().longValue());
    }

    @Transactional(readOnly=true)
    public List<VendaProduto> listaPorMovimentoCaixaSemFaturar(MovimentoCaixa movimentoCaixa) {
        return this.vendaProdutoRepository.listaPorMovimentoCaixaSemFaturar(movimentoCaixa.getId().longValue());
    }

    @Transactional(readOnly=true)
    public List<VendaProdutoItem> listItens(VendaProduto vendaProduto) {
        return this.vendaProdutoItemRepository.listaPorVenda(vendaProduto.getId().longValue());
    }

    @Transactional(readOnly=true)
    public List<ContaReceberParcela> listParcelas(VendaProduto vendaProduto) {
        if (vendaProduto.getContaReceber() == null) {
            return new ArrayList<ContaReceberParcela>();
        }
        return this.contaReceberParcelaRepository.listPorContaReceber(vendaProduto.getContaReceber().getId().longValue());
    }

    @Transactional(readOnly=true)
    public List<VendaProdutoFaturamento> listaFaturamentos(VendaProduto vendaProduto) {
        return this.vendaProdutoFaturamentoRepository.lista(vendaProduto.getId());
    }

    @Transactional(readOnly=true)
    public List<VendaProduto> faturadas(LocalDate inicio, LocalDate fim, String filtro) {
        return this.vendaProdutoRepository.lista(inicio, fim, filtro);
    }

    @Transactional(readOnly=true)
    public List<VendaProduto> faturadas(LocalDate inicio, LocalDate fim, Cliente cliente) {
        if (cliente != null) {
            return this.vendaProdutoRepository.lista(inicio, fim, cliente.getId());
        }
        return this.vendaProdutoRepository.lista(inicio, fim, "%%");
    }

    @Transactional(readOnly=true)
    public List<VendaProduto> listaCondicional(String filtro) {
        return this.vendaProdutoRepository.listaCondicional(VendaProdutoTipo.CONDICIONAL, "%" + filtro + "%");
    }

    @Transactional(readOnly=true)
    public List<VendaProduto> listaEmEntrega(String filtro) {
        return this.vendaProdutoRepository.listaEmEntrega(PedidoStatus.EM_ENTREGA, "%" + filtro + "%");
    }

    @Transactional(readOnly=true)
    public List<VendaProduto> lista(LocalDate inicio, LocalDate fim, String filtro) {
        return this.vendaProdutoRepository.lista(inicio, fim, filtro);
    }

    @Transactional(readOnly=true)
    public List<VendaProduto> emAberto(LocalDate inicio, LocalDate fim, String filtro) {
        return this.vendaProdutoRepository.emAberto(inicio, fim, filtro);
    }

    @Transactional(readOnly=true)
    public List<VendaProduto> lista(LocalDate inicio, LocalDate fim, Boolean faturado, Boolean excluida, String filtro) {
        Optional venda;
        Long vendaId = null;
        try {
            vendaId = Long.parseLong(filtro);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (vendaId != null && (venda = this.vendaProdutoRepository.findById((Object)vendaId)).isPresent()) {
            ArrayList<VendaProduto> vendas = new ArrayList<VendaProduto>();
            vendas.add((VendaProduto)venda.get());
            return vendas;
        }
        return this.vendaProdutoRepository.pesquisa(inicio, fim, faturado, excluida, filtro);
    }

    public BigDecimal totalLista(LocalDate inicio, LocalDate fim, Boolean faturado, Boolean excluida, String filtro) {
        BigDecimal total = this.vendaProdutoRepository.totalPesquisa(inicio, fim, faturado, excluida, filtro);
        if (total == null) {
            total = BigDecimal.ZERO;
        }
        return total;
    }

    public BigDecimal liquidoLista(LocalDate inicio, LocalDate fim, Boolean faturado, Boolean excluida, String filtro) {
        BigDecimal liquido = this.vendaProdutoRepository.liquidoPesquisa(inicio, fim, faturado, excluida, filtro);
        if (liquido == null) {
            liquido = BigDecimal.ZERO;
        }
        return liquido;
    }

    @Transactional(readOnly=true)
    public BigDecimal total(LocalDate inicio, LocalDate fim, String filtro) {
        return this.vendaProdutoRepository.total(inicio, fim, filtro);
    }

    @Transactional(readOnly=true)
    public BigDecimal totalPorPeriodo(LocalDate inicio, LocalDate fim) {
        return this.vendaProdutoRepository.total(inicio, fim);
    }

    @Transactional(readOnly=true)
    public BigDecimal totalCondicaoPagamento(LocalDate inicio, LocalDate fim, CondicaoRecebimento condicaoRecebimento) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Transactional(readOnly=true)
    public BigDecimal quantidadeCondicaoPagamento(LocalDate inicio, LocalDate fim, CondicaoRecebimento condicaoRecebimento) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Transactional(readOnly=true)
    public List<VendaProduto> relatorio(LocalDate inicio, LocalDate fim, Boolean faturado, Cliente cliente, Vendedor vendedor) {
        return this.vendaProdutoRepository.relatorio(inicio, fim, faturado, cliente, vendedor);
    }

    @Transactional(readOnly=true)
    public List<RelatorioVendaProdutoPorDiaBean> relatorio(LocalDate inicio, LocalDate fim, Vendedor vendedor) {
        return this.vendaProdutoRepository.relatorio(inicio, fim, vendedor);
    }

    @Transactional(readOnly=true)
    public List<VendaProdutoItemBean> relatorioProdutos(LocalDate inicio, LocalDate fim, Boolean faturado, Cliente cliente, Vendedor vendedor, CategoriaProduto categoriaProduto, Boolean agruparProdutos, VendaProdutoItemOrderBy orderBy) {
        List lista = null;
        lista = this.vendaProdutoItemRepository.relatorio(inicio, fim, faturado, cliente, vendedor, categoriaProduto, agruparProdutos, orderBy);
        ArrayList<VendaProdutoItemBean> retorno = new ArrayList<VendaProdutoItemBean>();
        lista.stream().map(obj -> {
            BigDecimal servicoCusto;
            BigDecimal produtoCusto;
            BigDecimal quantidade = new BigDecimal(String.valueOf(obj[4]));
            BigDecimal precoUnitario = new BigDecimal(String.valueOf(obj[5]));
            BigDecimal desconto = new BigDecimal(String.valueOf(obj[7]));
            BigDecimal valorMedio = precoUnitario;
            if (quantidade.compareTo(BigDecimal.ZERO) > 0) {
                precoUnitario.subtract(desconto.divide(quantidade, 2, RoundingMode.HALF_EVEN));
            }
            BigDecimal total = new BigDecimal(String.valueOf(obj[6]));
            BigDecimal custo = BigDecimal.ZERO;
            if (obj[8] != null && (produtoCusto = new BigDecimal(String.valueOf(obj[8]))).compareTo(BigDecimal.ZERO) > 0) {
                custo = produtoCusto;
            }
            if (obj[9] != null && (servicoCusto = new BigDecimal(String.valueOf(obj[9]))).compareTo(BigDecimal.ZERO) > 0) {
                custo = servicoCusto;
            }
            VendaProdutoItemBean bean = new VendaProdutoItemBean();
            bean.setProdutoId(Long.valueOf(obj[10].toString()));
            bean.setCodigo(String.valueOf(obj[0]));
            bean.setProduto(String.valueOf(obj[2]));
            bean.setValorMedio(valorMedio);
            bean.setQuantidade(quantidade);
            bean.setTotal(total);
            bean.setCustoUnitario(custo);
            if (!agruparProdutos.booleanValue()) {
                bean.setVendaId(MaximaUtils.completaZeroEsquerda((String)obj[11].toString(), (Integer)6));
                LocalDate dataEmissao = (LocalDate)obj[12];
                bean.setDataVenda(dataEmissao.format(DateTimeFormatter.ofPattern("dd/MM/yyyy")));
                bean.setCustoTotal(custo.multiply(quantidade).setScale(2, RoundingMode.HALF_EVEN));
                bean.setEstoqueAtual(new BigDecimal(0));
            } else {
                System.out.println("=== " + String.valueOf(obj[11]));
                try {
                    bean.setCustoTotal(new BigDecimal(String.valueOf(obj[11])));
                }
                catch (Exception e) {
                    bean.setCustoTotal(BigDecimal.ZERO);
                }
                bean.setEstoqueAtual(new BigDecimal(String.valueOf(obj[12])));
            }
            return bean;
        }).forEachOrdered(bean -> retorno.add((VendaProdutoItemBean)bean));
        return retorno;
    }

    @Transactional(readOnly=true)
    public List<VendaProdutoItemBean> relatorioProdutosAgrupados(LocalDate inicio, LocalDate fim, Boolean faturado, Vendedor vendedor) {
        List lista = null;
        lista = this.vendaProdutoItemRepository.relatorioAgrupado(inicio, fim, faturado, vendedor);
        ArrayList<VendaProdutoItemBean> retorno = new ArrayList<VendaProdutoItemBean>();
        lista.stream().map(obj -> {
            BigDecimal servicoCusto;
            BigDecimal produtoCusto;
            BigDecimal quantidade = new BigDecimal(String.valueOf(obj[4]));
            BigDecimal precoUnitario = new BigDecimal(String.valueOf(obj[5]));
            BigDecimal desconto = new BigDecimal(String.valueOf(obj[7]));
            BigDecimal valorMedio = precoUnitario;
            if (quantidade.compareTo(BigDecimal.ZERO) > 0) {
                precoUnitario.subtract(desconto.divide(quantidade, 2, RoundingMode.HALF_EVEN));
            }
            BigDecimal total = new BigDecimal(String.valueOf(obj[6]));
            BigDecimal custo = BigDecimal.ZERO;
            if (obj[8] != null && (produtoCusto = new BigDecimal(String.valueOf(obj[8]))).compareTo(BigDecimal.ZERO) > 0) {
                custo = produtoCusto;
            }
            if (obj[9] != null && (servicoCusto = new BigDecimal(String.valueOf(obj[9]))).compareTo(BigDecimal.ZERO) > 0) {
                custo = servicoCusto;
            }
            VendaProdutoItemBean bean = new VendaProdutoItemBean();
            bean.setProdutoId(Long.valueOf(obj[10].toString()));
            bean.setCodigo(String.valueOf(obj[0]));
            bean.setProduto(String.valueOf(obj[2]));
            bean.setValorMedio(valorMedio);
            bean.setQuantidade(quantidade);
            bean.setTotal(total);
            bean.setCustoUnitario(custo);
            try {
                bean.setCustoTotal(new BigDecimal(String.valueOf(obj[11])));
            }
            catch (Exception e) {
                bean.setCustoTotal(BigDecimal.ZERO);
            }
            bean.setEstoqueAtual(new BigDecimal(String.valueOf(obj[12])));
            bean.setCategoriaNome(String.valueOf(obj[1]));
            return bean;
        }).forEachOrdered(bean -> retorno.add((VendaProdutoItemBean)bean));
        return retorno;
    }

    @Transactional(readOnly=true)
    public List<VendaProdutoItemBean> relatorioProdutosAgrupadosCliente(LocalDate inicio, LocalDate fim, Boolean faturado, Cliente cliente) {
        List lista = null;
        lista = this.vendaProdutoItemRepository.relatorioAgrupadoCliente(inicio, fim, faturado, cliente);
        ArrayList<VendaProdutoItemBean> retorno = new ArrayList<VendaProdutoItemBean>();
        lista.stream().map(obj -> {
            BigDecimal servicoCusto;
            BigDecimal produtoCusto;
            BigDecimal quantidade = new BigDecimal(String.valueOf(obj[4]));
            BigDecimal precoUnitario = new BigDecimal(String.valueOf(obj[5]));
            BigDecimal desconto = new BigDecimal(String.valueOf(obj[7]));
            BigDecimal valorMedio = precoUnitario;
            if (quantidade.compareTo(BigDecimal.ZERO) > 0) {
                precoUnitario.subtract(desconto.divide(quantidade, 2, RoundingMode.HALF_EVEN));
            }
            BigDecimal total = new BigDecimal(String.valueOf(obj[6]));
            BigDecimal custo = BigDecimal.ZERO;
            if (obj[8] != null && (produtoCusto = new BigDecimal(String.valueOf(obj[8]))).compareTo(BigDecimal.ZERO) > 0) {
                custo = produtoCusto;
            }
            if (obj[9] != null && (servicoCusto = new BigDecimal(String.valueOf(obj[9]))).compareTo(BigDecimal.ZERO) > 0) {
                custo = servicoCusto;
            }
            VendaProdutoItemBean bean = new VendaProdutoItemBean();
            bean.setProdutoId(Long.valueOf(obj[10].toString()));
            bean.setCodigo(String.valueOf(obj[0]));
            bean.setProduto(String.valueOf(obj[2]));
            bean.setValorMedio(valorMedio);
            bean.setQuantidade(quantidade);
            bean.setTotal(total);
            bean.setCustoUnitario(custo);
            try {
                bean.setCustoTotal(new BigDecimal(String.valueOf(obj[11])));
            }
            catch (Exception e) {
                bean.setCustoTotal(BigDecimal.ZERO);
            }
            bean.setEstoqueAtual(new BigDecimal(String.valueOf(obj[12])));
            bean.setCategoriaNome(String.valueOf(obj[1]));
            return bean;
        }).forEachOrdered(bean -> retorno.add((VendaProdutoItemBean)bean));
        return retorno;
    }

    @Transactional(readOnly=true)
    public void imprimeUltimaVenda() throws MaximaException {
        VendaProduto venda = this.vendaProdutoRepository.getUltima(null);
        if (venda == null) {
            throw new MaximaException("Nenhuma venda encontrada.");
        }
        this.imprime(venda);
    }

    @Transactional(readOnly=true)
    public void imprimeVenda(VendaProduto venda) throws MaximaException {
        if ((venda = (VendaProduto)this.vendaProdutoRepository.findById((Object)venda.getId()).get()) == null) {
            throw new MaximaException("Nenhuma venda encontrada.");
        }
        this.imprime(venda);
    }

    @Transactional(readOnly=true)
    public void imprimeOS(VendaProduto venda) throws MaximaException {
        if ((venda = (VendaProduto)this.vendaProdutoRepository.findById((Object)venda.getId()).get()) == null) {
            throw new MaximaException("Nenhuma venda encontrada.");
        }
        String tipoJasper = "os_view.jasper";
        List itens = this.vendaProdutoItemRepository.listaPorVenda(venda.getId().longValue());
        Configuracao conf = this.configuracaoRepository.load();
        new VendaProdutoReport(conf).visualizaOS(venda, itens, new ArrayList(), new ArrayList(), conf);
    }

    private void imprime(VendaProduto venda) throws MaximaException {
        String tipoJasper = MaximaConfig.getJasperPedido();
        List<VendaProdutoItem> itens = new ArrayList();
        itens = tipoJasper.contains("deluxe") ? this.vendaProdutoItemRepository.listaPorVendaOrderByCategoria(venda.getId().longValue()) : this.vendaProdutoItemRepository.listaPorVenda(venda.getId().longValue());
        if (venda.getEntradaProduto() != null) {
            List entradaItens = this.entradaProdutoService.listItens(venda.getEntradaProduto());
            for (EntradaProdutoItem epi : entradaItens) {
                VendaProdutoItem item2 = new VendaProdutoItem();
                item2.setProduto(epi.getProduto());
                item2.setDescricao(epi.getDescricao());
                item2.setQuantidade(epi.getQuantidade());
                item2.setPrecoUnitario(epi.getPrecoCusto());
                item2.setPrecoTotal(epi.getTotalCusto());
                item2.setDesconto(BigDecimal.ZERO);
                item2.setVendaProduto(venda);
                itens.add(item2);
            }
        }
        itens.forEach(item -> System.out.println("=== " + item.getProduto().getCategoriaProduto()));
        List parcelas = null;
        if (venda.getContaReceber() != null) {
            parcelas = this.contaReceberParcelaRepository.listPorContaReceber(venda.getContaReceber().getId().longValue());
        }
        List faturamentos = this.vendaProdutoFaturamentoRepository.lista(venda.getId());
        Configuracao conf = this.configuracaoRepository.load();
        ImpressoraModelo impressoraModelo = conf.getImpressoraModelo();
        if (impressoraModelo.equals((Object)ImpressoraModelo.A4)) {
            System.out.println("=== venda: " + venda.getTotal());
            new VendaProdutoReport(conf).visualiza(venda, itens, faturamentos, parcelas, conf);
            return;
        }
        System.out.println("=== modelo impressora: " + impressoraModelo);
        String textoImprime = "";
        if (conf.getVendaProdutoComprovanteTipo().equals((Object)VendaProdutoComprovanteTipo.COMPLETO_MAIOR)) {
            textoImprime = VendaProdutoPrinter.modeloMaior((VendaProduto)venda, itens, (List)faturamentos, (List)parcelas, (Configuracao)conf);
        }
        if (conf.getVendaProdutoComprovanteTipo().equals((Object)VendaProdutoComprovanteTipo.COMPLETO_MENOR)) {
            textoImprime = VendaProdutoPrinter.modeloMenor((VendaProduto)venda, itens, (List)faturamentos, (List)parcelas, (Configuracao)conf);
        }
        if (conf.getVendaProdutoComprovanteTipo().equals((Object)VendaProdutoComprovanteTipo.SIMPLIFICADO)) {
            textoImprime = VendaProdutoPrinter.modeloSimplificado((VendaProduto)venda, itens, (List)faturamentos, (List)parcelas, (Configuracao)conf);
        }
        try {
            new MaximaImpressao(conf).printText(textoImprime);
        }
        catch (MaximaValidacaoException ex) {
            Logger.getLogger(VendaProdutoServiceImpl.class.getName()).log(Level.SEVERE, null, ex);
            throw new MaximaException(ex.getMessage());
        }
    }

    @Transactional(readOnly=true)
    public List<VendasCategoriasBean> vendasCategorias(LocalDate dataInicio, LocalDate dataFim) {
        List list = this.vendaProdutoItemRepository.vendidosCategorias(dataInicio, dataFim);
        ArrayList<VendasCategoriasBean> retorno = new ArrayList<VendasCategoriasBean>();
        list.forEach(obj -> retorno.add(new VendasCategoriasBean((String)obj[0], (BigDecimal)obj[1], (BigDecimal)obj[2], null)));
        return retorno;
    }

    @Transactional(readOnly=true)
    public List<MovimentoCaixaItemVendidoBean> listaProdutosPorMovimentoCaixa(MovimentoCaixa movimentoCaixa) {
        List list = this.vendaProdutoItemRepository.listaVendidos(movimentoCaixa.getId());
        ArrayList<MovimentoCaixaItemVendidoBean> retorno = new ArrayList<MovimentoCaixaItemVendidoBean>();
        list.forEach(obj -> retorno.add(new MovimentoCaixaItemVendidoBean((Long)obj[0], (String)obj[1], (BigDecimal)obj[2], new BigDecimal((Double)obj[3]), (BigDecimal)obj[4], (Long)obj[5])));
        return retorno;
    }

    @Transactional(readOnly=true)
    public List<VendaProdutoGraficoDto> grafico(LocalDate inicio, LocalDate fim, Boolean faturado, Cliente cliente) {
        return this.vendaProdutoRepository.grafico(inicio, fim, faturado, cliente);
    }

    @Transactional(readOnly=true)
    public List<Object[]> faturamentos(LocalDate inicio, LocalDate fim, Vendedor vendedor) {
        if (vendedor == null) {
            return this.vendaProdutoFaturamentoRepository.listaPorPeriodo(inicio, fim);
        }
        return this.vendaProdutoFaturamentoRepository.listaPorPeriodo(inicio, fim, vendedor.getId());
    }

    @Transactional(readOnly=true)
    public VendaProduto listaPdvToErp() {
        List vendas = this.vendaProdutoRepository.listaSincronizarErp((Pageable)PageRequest.of((int)0, (int)1));
        if (vendas.size() == 1) {
            return (VendaProduto)vendas.get(0);
        }
        return null;
    }

    public void testeFaturamento() {
        LocalDate inicio = MaximaDate.convertToLocalDate((String)"27/02/2023");
        LocalDate fim = MaximaDate.convertToLocalDate((String)"27/02/2023");
        List vendas = this.vendaProdutoRepository.lista(inicio, fim, "%%");
        for (VendaProduto venda : vendas) {
            List faturamento = this.vendaProdutoFaturamentoRepository.lista(venda.getId());
            BigDecimal totalFat = BigDecimal.ZERO;
            for (VendaProdutoFaturamento fat : faturamento) {
                totalFat = totalFat.add(fat.getValor());
            }
            if (venda.getTotal().compareTo(totalFat) != 0 && faturamento.size() == 1) {
                VendaProdutoFaturamento fat = (VendaProdutoFaturamento)faturamento.get(0);
                fat.setValor(venda.getTotal());
                this.vendaProdutoFaturamentoRepository.save((Object)fat);
            }
            System.out.println(venda.getId());
        }
    }
}

