/*
 * Decompiled with CFR 0.152.
 */
package br.com.maximasolutions.financeiro.boleto;

import br.com.maximasolutions.financeiro.modelo.BoletoEmitido;
import br.com.maximasolutions.utils.MaximaDate;
import br.com.maximasolutions.utils.MaximaUtils;
import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfImportedPage;
import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.PdfTemplate;
import com.lowagie.text.pdf.PdfWriter;
import java.awt.Desktop;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import org.apache.commons.io.FileUtils;
import org.jrimum.bopepo.BancosSuportados;
import org.jrimum.bopepo.Boleto;
import org.jrimum.bopepo.view.BoletoViewer;
import org.jrimum.domkee.comum.pessoa.endereco.CEP;
import org.jrimum.domkee.comum.pessoa.endereco.Endereco;
import org.jrimum.domkee.comum.pessoa.endereco.UnidadeFederativa;
import org.jrimum.domkee.financeiro.banco.Banco;
import org.jrimum.domkee.financeiro.banco.febraban.Agencia;
import org.jrimum.domkee.financeiro.banco.febraban.Carteira;
import org.jrimum.domkee.financeiro.banco.febraban.Cedente;
import org.jrimum.domkee.financeiro.banco.febraban.ContaBancaria;
import org.jrimum.domkee.financeiro.banco.febraban.NumeroDaConta;
import org.jrimum.domkee.financeiro.banco.febraban.Sacado;
import org.jrimum.domkee.financeiro.banco.febraban.TipoDeTitulo;
import org.jrimum.domkee.financeiro.banco.febraban.Titulo;

/*
 * Exception performing whole class analysis ignored.
 */
public class BopepoGerandoVariosBoletosEmUmPDF {
    public void gerarPdfCarne(List<BoletoEmitido> boletosEmitidos) throws IOException {
        List boletos = this.crieBoletos(boletosEmitidos);
        String template = "template.pdf";
        ArrayList<byte[]> boletosImprimir = new ArrayList<byte[]>();
        for (Boleto boleto : boletos) {
            boletosImprimir.add(new BoletoViewer(boleto, template).getPdfAsByteArray());
        }
        try {
            byte[] pdfBoletos = BopepoGerandoVariosBoletosEmUmPDF.mergeFilesInPages(boletosImprimir);
            File arquivoPdf = new File("boletos.pdf");
            FileUtils.writeByteArrayToFile((File)arquivoPdf, (byte[])pdfBoletos);
            this.mostreBoletoNaTela(arquivoPdf);
        }
        catch (DocumentException ex) {
            Logger.getLogger(BopepoGerandoVariosBoletosEmUmPDF.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public static byte[] mergeFilesInPages(List<byte[]> pdfFilesAsByteArray) throws DocumentException, IOException {
        Document document = new Document();
        ByteArrayOutputStream byteOS = new ByteArrayOutputStream();
        PdfWriter writer = PdfWriter.getInstance((Document)document, (OutputStream)byteOS);
        document.open();
        PdfContentByte cb = writer.getDirectContent();
        float pagePosition = 0.0f;
        for (byte[] pdfFile : pdfFilesAsByteArray) {
            PdfReader reader = new PdfReader(pdfFile);
            for (int i = 1; i <= reader.getNumberOfPages(); ++i) {
                PdfImportedPage page;
                float documentHeight = cb.getPdfDocument().getPageSize().getHeight();
                if (documentHeight - (pagePosition += (page = writer.getImportedPage(reader, i)).getHeight()) <= 0.0f) {
                    document.newPage();
                    pagePosition = page.getHeight();
                }
                cb.addTemplate((PdfTemplate)page, 0.0f, documentHeight - pagePosition);
            }
        }
        byteOS.flush();
        document.close();
        byte[] arquivoEmBytes = byteOS.toByteArray();
        byteOS.close();
        return arquivoEmBytes;
    }

    List<Boleto> crieBoletos(List<BoletoEmitido> boletosEmitidos) {
        ArrayList<Boleto> boletos = new ArrayList<Boleto>();
        for (BoletoEmitido boletoEmitido : boletosEmitidos) {
            ContaBancaria contaBancaria = this.getContaBancaria(boletoEmitido);
            Cedente cedente = this.getCedente(boletoEmitido);
            Sacado sacado = this.getSacado(boletoEmitido);
            Titulo titulo = this.crieOsDadosDoNovoTitulo(new Titulo(contaBancaria, sacado, cedente), boletoEmitido.getNumeroDocumento(), boletoEmitido);
            Boleto boleto = this.crieOsDadosDoNovoBoleto(new Boleto(titulo), boletoEmitido);
            boletos.add(boleto);
        }
        return boletos;
    }

    final Boleto crieOsDadosDoNovoBoleto(Boleto boleto, BoletoEmitido boletoEmitido) {
        boleto.setLocalPagamento("Pag\u00e1vel em qualquer banco at\u00e9 o vencimento.");
        HashMap<String, String> extra = new HashMap<String, String>();
        String clienteNome = boletoEmitido.getClienteNome().toUpperCase();
        String clienteCpf = "";
        clienteCpf = MaximaUtils.removeCaracteres((String)boletoEmitido.getClienteCnpj()).length() == 11 ? " - CPF: " + MaximaUtils.formatCPF((String)boletoEmitido.getClienteCnpj()) : " - CNPJ: " + MaximaUtils.formatCNPJ((String)boletoEmitido.getClienteCnpj());
        extra.put("txtSacadoMaxima", clienteNome + clienteCpf);
        boleto.setTextosExtras(extra);
        HashMap<String, BufferedImage> imagensExtras = new HashMap<String, BufferedImage>();
        File imageLogoBoleto = new File("logo_boleto.png");
        if (imageLogoBoleto.exists()) {
            try {
                imagensExtras.put("txtLogoEmpresa", ImageIO.read(imageLogoBoleto));
            }
            catch (IOException ex) {
                Logger.getLogger(BopepoGerandoVariosBoletosEmUmPDF.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        boleto.setImagensExtras(imagensExtras);
        return boleto;
    }

    final Titulo crieOsDadosDoNovoTitulo(Titulo titulo, String numero, BoletoEmitido boletoEmitido) {
        titulo.setNumeroDoDocumento(numero);
        titulo.setNossoNumero(boletoEmitido.getNossoNumero());
        titulo.setDigitoDoNossoNumero(boletoEmitido.getNossoNumeroDigito());
        titulo.setValor(boletoEmitido.getValor());
        titulo.setDataDoDocumento(MaximaDate.getDate((LocalDate)boletoEmitido.getDataEmissao()));
        titulo.setDataDoVencimento(MaximaDate.getDate((LocalDate)boletoEmitido.getDataVencimento()));
        titulo.setTipoDeDocumento(TipoDeTitulo.FAT_FATURA);
        titulo.setAceite(Titulo.Aceite.A);
        return titulo;
    }

    final Sacado getSacado(BoletoEmitido boletoEmitido) {
        Sacado sacado = new Sacado(boletoEmitido.getClienteNome(), boletoEmitido.getClienteCnpj());
        Endereco enderecoSac = new Endereco();
        enderecoSac.setUF(UnidadeFederativa.valueOfSigla((String)boletoEmitido.getClienteUF()));
        enderecoSac.setLocalidade(boletoEmitido.getClienteMunicipio());
        enderecoSac.setCep(new CEP(boletoEmitido.getClienteCep()));
        enderecoSac.setBairro(boletoEmitido.getClienteBairro());
        enderecoSac.setLogradouro(boletoEmitido.getClienteEndereco());
        enderecoSac.setNumero(boletoEmitido.getClienteNumero());
        sacado.addEndereco(enderecoSac);
        return sacado;
    }

    final Cedente getCedente(BoletoEmitido boletoEmitido) {
        return new Cedente("M. A. S. Christovam Junior ME", "09.439.300/0001-46");
    }

    final ContaBancaria getContaBancaria(BoletoEmitido boletoEmitido) {
        ContaBancaria contaBancaria = new ContaBancaria((Banco)BancosSuportados.BANCO_SANTANDER.create());
        String convenio = boletoEmitido.getNumeroConvenio().substring(0, boletoEmitido.getNumeroConvenio().length() - 1);
        String convenioDigito = boletoEmitido.getNumeroConvenio().substring(boletoEmitido.getNumeroConvenio().length() - 1);
        System.out.println("== CONV: " + boletoEmitido.getNumeroConvenio() + " | " + convenio + ":" + convenioDigito);
        contaBancaria.setNumeroDaConta(new NumeroDaConta(Integer.valueOf(Integer.parseInt(convenio)), convenioDigito));
        contaBancaria.setCarteira(new Carteira(Integer.valueOf(101)));
        contaBancaria.setAgencia(new Agencia(Integer.valueOf(Integer.parseInt(boletoEmitido.getAgencia())), boletoEmitido.getAgenciaDigito()));
        return contaBancaria;
    }

    final void mostreBoletoNaTela(File arquivoBoleto) {
        try {
            Desktop.getDesktop().open(arquivoBoleto);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

