/*
 * Decompiled with CFR 0.152.
 */
package br.com.maximasolutions.financeiro.controller;

import br.com.maximasolutions.core.MaximaAlert;
import br.com.maximasolutions.core.MaximaController;
import br.com.maximasolutions.core.MaximaIcone;
import br.com.maximasolutions.financeiro.modelo.BancoBoleto;
import br.com.maximasolutions.financeiro.modelo.BancoTipo;
import br.com.maximasolutions.financeiro.service.BancoBoletoService;
import br.com.maximasolutions.utils.MaximaDate;
import br.com.maximasolutions.utils.MaximaUtils;
import java.net.URL;
import java.time.LocalDateTime;
import java.util.ResourceBundle;
import java.util.Set;
import javafx.collections.FXCollections;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.TextField;
import javafx.stage.Stage;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;

@Controller
public class BancoBoletoFormController
extends MaximaController
implements Initializable {
    @FXML
    private TextField tfUltimaAlteracao;
    @FXML
    private TextField tfId;
    @FXML
    private Button btnSalva;
    @FXML
    private ComboBox<BancoTipo> cbbBanco;
    @FXML
    private TextField tfAgencia;
    @FXML
    private TextField tfAgenciaDigito;
    @FXML
    private TextField tfConta;
    @FXML
    private TextField tfContaDigito;
    @FXML
    private TextField tfConvenio;
    @FXML
    private TextField tfCarteira;
    @FXML
    private TextField tfNossoNumero;
    @FXML
    private CheckBox ccbAtivo;
    @Autowired
    private BancoBoletoService bancoBoletoService;
    private BancoBoleto bancoBoleto;

    public void initialize(URL url, ResourceBundle rb) {
        this.bancoBoleto = null;
        this.carregaIcones();
        this.registraAcoes();
        this.loadCombos();
        this.loadMascaras();
    }

    private void salva() {
        if (this.bancoBoleto == null) {
            this.bancoBoleto = new BancoBoleto();
        }
        this.bancoBoleto.setAgencia(MaximaUtils.getText((String)this.tfAgencia.getText()));
        this.bancoBoleto.setAgenciaDigito(MaximaUtils.getText((String)this.tfAgenciaDigito.getText()));
        this.bancoBoleto.setAtivo(Boolean.valueOf(this.ccbAtivo.isSelected()));
        this.bancoBoleto.setBancoTipo((BancoTipo)this.cbbBanco.getSelectionModel().getSelectedItem());
        this.bancoBoleto.setCarteira(MaximaUtils.getText((String)this.tfCarteira.getText()));
        this.bancoBoleto.setConta(MaximaUtils.getText((String)this.tfConta.getText()));
        this.bancoBoleto.setContaDigito(MaximaUtils.getText((String)this.tfContaDigito.getText()));
        this.bancoBoleto.setNossoNumero(MaximaUtils.getText((String)this.tfNossoNumero.getText()));
        this.bancoBoleto.setNumeroConvenio(MaximaUtils.getText((String)this.tfConvenio.getText()));
        this.bancoBoleto.setUltimaAlteracao(LocalDateTime.now());
        ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
        Validator validator = factory.getValidator();
        Set violations = validator.validate((Object)this.bancoBoleto, new Class[0]);
        String mensagemError = "";
        mensagemError = violations.stream().map(obj -> obj.getMessage() + "\n").reduce(mensagemError, String::concat);
        if (!mensagemError.isEmpty()) {
            MaximaAlert.alerta((String)mensagemError);
            return;
        }
        this.bancoBoletoService.save(this.bancoBoleto);
        MaximaAlert.mensagemInformativa((String)"Banco boleto salvo com sucesso.");
        Stage stage = (Stage)this.tfId.getScene().getWindow();
        stage.close();
    }

    public void inicializa(BancoBoleto bancoBoleto1) {
        this.bancoBoleto = bancoBoleto1;
        if (this.bancoBoleto != null) {
            this.tfId.setText(this.bancoBoleto.getId().toString());
            this.tfUltimaAlteracao.setText(MaximaDate.getDataHora((LocalDateTime)this.bancoBoleto.getUltimaAlteracao()));
            this.ccbAtivo.setSelected(this.bancoBoleto.getAtivo().booleanValue());
            this.cbbBanco.getSelectionModel().select((Object)this.bancoBoleto.getBancoTipo());
            this.tfAgencia.setText(this.bancoBoleto.getAgencia());
            this.tfAgenciaDigito.setText(this.bancoBoleto.getAgenciaDigito());
            this.tfConta.setText(this.bancoBoleto.getConta());
            this.tfContaDigito.setText(this.bancoBoleto.getContaDigito());
            this.tfConvenio.setText(this.bancoBoleto.getNumeroConvenio());
            this.tfCarteira.setText(this.bancoBoleto.getCarteira());
            this.tfNossoNumero.setText(this.bancoBoleto.getNossoNumero());
            this.cbbBanco.requestFocus();
        }
    }

    private void loadCombos() {
        this.cbbBanco.setItems(FXCollections.observableArrayList((Object[])BancoTipo.values()));
    }

    private void loadMascaras() {
    }

    private void carregaIcones() {
        this.btnSalva.setGraphic((Node)new MaximaIcone().getIconeConfirma());
    }

    private void registraAcoes() {
        this.btnSalva.setOnAction(event -> this.salva());
    }
}

