/*
 * Decompiled with CFR 0.152.
 */
package br.com.maximasolutions.financeiro.controller;

import br.com.maximasolutions.administrativo.core.PermissaoControleValida;
import br.com.maximasolutions.administrativo.modelo.PermissaoControle;
import br.com.maximasolutions.administrativo.modelo.PermissaoControleAcao;
import br.com.maximasolutions.administrativo.service.UsuarioService;
import br.com.maximasolutions.config.StageManager;
import br.com.maximasolutions.core.MaximaAlert;
import br.com.maximasolutions.core.MaximaController;
import br.com.maximasolutions.core.MaximaDialogFX;
import br.com.maximasolutions.core.MaximaIcone;
import br.com.maximasolutions.financeiro.controller.CentroCustoFormController;
import br.com.maximasolutions.financeiro.modelo.CentroCusto;
import br.com.maximasolutions.financeiro.service.CentroCustoService;
import java.io.IOException;
import java.net.URL;
import java.util.Collection;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.stage.Stage;
import javafx.util.Callback;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Controller;

@Controller
public class CentroCustoController
extends MaximaController
implements Initializable {
    @Lazy
    @Autowired
    private StageManager stageManager;
    @FXML
    private Button btnNovo;
    @FXML
    private Button btnEdita;
    @FXML
    private Button btnDelete;
    @FXML
    private Button btnAtualiza;
    @FXML
    private TableView<CentroCusto> tabela;
    @FXML
    private TableColumn<CentroCusto, String> colNome;
    @Autowired
    private CentroCustoService centroCustoService;
    @Autowired
    private UsuarioService usuarioService;
    private ObservableList<CentroCusto> centroCustoList;

    public void initialize(URL url, ResourceBundle rb) {
        this.carregaIcones();
        this.centroCustoList = FXCollections.observableArrayList();
        this.tabela.setOnMouseClicked(event -> {
            if (event.getClickCount() == 2) {
                this.editaCentroCusto();
            }
        });
        this.setColumnProperties();
        this.loadTabela();
        this.registraAcoes();
    }

    public void inicializa() {
        this.acoes = this.usuarioService.acoes(this.stageManager.getUsuario(), PermissaoControle.CentroCusto);
    }

    private void novoCentroCusto() {
        if (!PermissaoControleValida.acaoPermitida((StageManager)this.stageManager, (List)this.acoes, (PermissaoControleAcao)PermissaoControleAcao.ADD).booleanValue()) {
            return;
        }
        this.formCentroCusto(null);
        this.loadTabela();
    }

    private void editaCentroCusto() {
        if (!PermissaoControleValida.acaoPermitida((StageManager)this.stageManager, (List)this.acoes, (PermissaoControleAcao)PermissaoControleAcao.EDIT).booleanValue()) {
            return;
        }
        CentroCusto centroCusto = (CentroCusto)this.tabela.getSelectionModel().getSelectedItem();
        if (centroCusto == null) {
            MaximaAlert.alerta((String)"Selecione um centro de custo para editar.");
            return;
        }
        this.formCentroCusto(centroCusto);
        this.loadTabela();
    }

    private void formCentroCusto(CentroCusto centroCusto) {
        try {
            Stage stage = new MaximaDialogFX().createWindowForm(this.stageManager, "/fxml/financeiro/centroCusto/CentroCustoForm.fxml", "Edita Centro de Custo");
            CentroCustoFormController controller = (CentroCustoFormController)stage.getUserData();
            controller.inicializa(centroCusto);
            stage.showAndWait();
        }
        catch (IOException ex) {
            Logger.getLogger(CentroCustoController.class.getName()).log(Level.SEVERE, null, ex);
            MaximaAlert.alerta((String)("Ocorreu um erro ao abrir form centro custo.\n" + ex.getMessage()));
        }
    }

    private void deleteCentroCusto() {
        if (!PermissaoControleValida.acaoPermitida((StageManager)this.stageManager, (List)this.acoes, (PermissaoControleAcao)PermissaoControleAcao.DELETE).booleanValue()) {
            return;
        }
        CentroCusto centroCusto = (CentroCusto)this.tabela.getSelectionModel().getSelectedItem();
        if (centroCusto == null) {
            MaximaAlert.alerta((String)"Selecione um centro de custo para remover.");
            return;
        }
        if (MaximaAlert.confirmacao((String)("Deseja remover o centro de custo: '" + centroCusto.getNome() + "'?"))) {
            this.centroCustoService.deleteById(centroCusto.getId());
            MaximaAlert.confirmacao((String)"Centro de custo deletado com sucesso.");
        }
        this.loadTabela();
    }

    private void loadTabela() {
        this.centroCustoList.clear();
        List list = this.centroCustoService.list();
        this.centroCustoList.addAll((Collection)list);
        this.tabela.setItems(this.centroCustoList);
    }

    private void carregaIcones() {
        this.btnNovo.setGraphic((Node)new MaximaIcone().getIconeNovo());
        this.btnEdita.setGraphic((Node)new MaximaIcone().edita());
        this.btnDelete.setGraphic((Node)new MaximaIcone().getIconeDelete());
        this.btnAtualiza.setGraphic((Node)new MaximaIcone().getIconeAtualiza());
    }

    private void setColumnProperties() {
        this.colNome.setCellValueFactory((Callback)new PropertyValueFactory("nome"));
    }

    private void registraAcoes() {
        this.btnNovo.setOnAction(event -> this.novoCentroCusto());
        this.btnEdita.setOnAction(event -> this.editaCentroCusto());
        this.btnDelete.setOnAction(event -> this.deleteCentroCusto());
        this.btnAtualiza.setOnAction(event -> this.loadTabela());
    }
}

