/*
 * Decompiled with CFR 0.152.
 */
package br.com.maximasolutions.financeiro.controller;

import br.com.maximasolutions.administrativo.core.PermissaoControleValida;
import br.com.maximasolutions.administrativo.modelo.PermissaoControle;
import br.com.maximasolutions.administrativo.modelo.PermissaoControleAcao;
import br.com.maximasolutions.administrativo.service.UsuarioService;
import br.com.maximasolutions.config.StageManager;
import br.com.maximasolutions.core.MaximaAlert;
import br.com.maximasolutions.core.MaximaController;
import br.com.maximasolutions.core.MaximaDialogFX;
import br.com.maximasolutions.core.MaximaIcone;
import br.com.maximasolutions.financeiro.controller.CondicaoRecebimentoFormController;
import br.com.maximasolutions.financeiro.modelo.CondicaoRecebimento;
import br.com.maximasolutions.financeiro.service.CondicaoRecebimentoService;
import java.io.IOException;
import java.net.URL;
import java.util.Collection;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.stage.Stage;
import javafx.util.Callback;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Controller;

@Controller
public class CondicaoRecebimentoController
extends MaximaController
implements Initializable {
    @Lazy
    @Autowired
    private StageManager stageManager;
    @FXML
    private Button btnNovo;
    @FXML
    private Button btnEdita;
    @FXML
    private Button btnDelete;
    @FXML
    private Button btnAtualiza;
    @FXML
    private TableView<CondicaoRecebimento> tabela;
    @FXML
    private TableColumn<CondicaoRecebimento, String> colNome;
    @Autowired
    private CondicaoRecebimentoService condicaoRecebimentoService;
    @Autowired
    private UsuarioService usuarioService;
    private ObservableList<CondicaoRecebimento> condicaoRecebimentoList;

    public void initialize(URL url, ResourceBundle rb) {
        this.carregaIcones();
        this.condicaoRecebimentoList = FXCollections.observableArrayList();
        this.tabela.setOnMouseClicked(event -> {
            if (event.getClickCount() == 2) {
                this.editaCondicaoRecebimento();
            }
        });
        this.setColumnProperties();
        this.loadTabela();
        this.registraAcoes();
    }

    public void inicializa() {
        this.acoes = this.usuarioService.acoes(this.stageManager.getUsuario(), PermissaoControle.CondicaoRecebimento);
    }

    private void novoCondicaoRecebimento() {
        if (!PermissaoControleValida.acaoPermitida((StageManager)this.stageManager, (List)this.acoes, (PermissaoControleAcao)PermissaoControleAcao.ADD).booleanValue()) {
            return;
        }
        this.formCondicaoRecebimento(null);
        this.loadTabela();
    }

    private void editaCondicaoRecebimento() {
        if (!PermissaoControleValida.acaoPermitida((StageManager)this.stageManager, (List)this.acoes, (PermissaoControleAcao)PermissaoControleAcao.EDIT).booleanValue()) {
            return;
        }
        CondicaoRecebimento condicaoRecebimento = (CondicaoRecebimento)this.tabela.getSelectionModel().getSelectedItem();
        if (condicaoRecebimento == null) {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"Selecione uma condi\u00e7\u00e3o de pagamento para editar.");
            return;
        }
        this.formCondicaoRecebimento(condicaoRecebimento);
        this.loadTabela();
    }

    private void formCondicaoRecebimento(CondicaoRecebimento condicaoRecebimento) {
        try {
            Stage stage = new MaximaDialogFX().createWindowForm(this.stageManager, "/fxml/financeiro/condicaoRecebimento/CondicaoRecebimentoForm.fxml", "Edita Condi\u00e7\u00e3o de Recebimento");
            CondicaoRecebimentoFormController controller = (CondicaoRecebimentoFormController)stage.getUserData();
            controller.inicializa(condicaoRecebimento);
            stage.showAndWait();
        }
        catch (IOException ex) {
            Logger.getLogger(CondicaoRecebimentoController.class.getName()).log(Level.SEVERE, null, ex);
            MaximaAlert.alerta((String)("Ocorreu um erro ao abrir form condi\u00e7\u00e3o de pagamento.\n" + ex.getMessage()));
        }
    }

    private void deleteCondicaoRecebimento() {
        if (!PermissaoControleValida.acaoPermitida((StageManager)this.stageManager, (List)this.acoes, (PermissaoControleAcao)PermissaoControleAcao.DELETE).booleanValue()) {
            return;
        }
        CondicaoRecebimento condicaoRecebimento = (CondicaoRecebimento)this.tabela.getSelectionModel().getSelectedItem();
        if (condicaoRecebimento == null) {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"Selecione uma condi\u00e7\u00e3o de pagamento para remover.");
            return;
        }
        if (MaximaAlert.SIM_NAO((StageManager)this.stageManager, (String)("Deseja remover a condi\u00e7\u00e3o de pagamento: '" + condicaoRecebimento.getNome() + "'?"))) {
            this.condicaoRecebimentoService.deleteById(condicaoRecebimento.getId());
            MaximaAlert.informe((StageManager)this.stageManager, (String)"Condi\u00e7\u00e3o de pagamento deletada com sucesso.");
        }
        this.loadTabela();
    }

    private void loadTabela() {
        this.condicaoRecebimentoList.clear();
        List list = this.condicaoRecebimentoService.list();
        this.condicaoRecebimentoList.addAll((Collection)list);
        this.tabela.setItems(this.condicaoRecebimentoList);
    }

    private void carregaIcones() {
        this.btnNovo.setGraphic((Node)new MaximaIcone().getIconeNovo());
        this.btnEdita.setGraphic((Node)new MaximaIcone().edita());
        this.btnDelete.setGraphic((Node)new MaximaIcone().getIconeDelete());
        this.btnAtualiza.setGraphic((Node)new MaximaIcone().getIconeAtualiza());
    }

    private void setColumnProperties() {
        this.colNome.setCellValueFactory((Callback)new PropertyValueFactory("nome"));
    }

    private void registraAcoes() {
        this.btnNovo.setOnAction(event -> this.novoCondicaoRecebimento());
        this.btnEdita.setOnAction(event -> this.editaCondicaoRecebimento());
        this.btnDelete.setOnAction(event -> this.deleteCondicaoRecebimento());
        this.btnAtualiza.setOnAction(event -> this.loadTabela());
    }
}

