/*
 * Decompiled with CFR 0.152.
 */
package br.com.maximasolutions.financeiro.controller;

import br.com.maximasolutions.config.StageManager;
import br.com.maximasolutions.core.MaximaAlert;
import br.com.maximasolutions.core.MaximaController;
import br.com.maximasolutions.core.MaximaException;
import br.com.maximasolutions.core.MaximaIcone;
import br.com.maximasolutions.financeiro.modelo.CondicaoRecebimento;
import br.com.maximasolutions.financeiro.modelo.CondicaoRecebimentoTipo;
import br.com.maximasolutions.financeiro.modelo.FormaPagamento;
import br.com.maximasolutions.financeiro.service.CondicaoRecebimentoService;
import br.com.maximasolutions.utils.MaximaMask;
import br.com.maximasolutions.utils.MaximaNumber;
import java.math.BigDecimal;
import java.net.URL;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.collections.FXCollections;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.TextField;
import javafx.stage.Stage;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Controller;

@Controller
public class CondicaoRecebimentoFormController
extends MaximaController
implements Initializable {
    @FXML
    private TextField tfNome;
    @FXML
    private TextField tfId;
    @FXML
    private Button btnSalva;
    @FXML
    private ComboBox<CondicaoRecebimentoTipo> cbbCondicaoRecebimento;
    @FXML
    private ComboBox<FormaPagamento> cbbFormaPagamento;
    @FXML
    private TextField tfQuantidadeParcelas;
    @FXML
    private TextField tfPrazoPrimeiraParcela;
    @FXML
    private TextField tfIntervaloParcelas;
    @FXML
    private TextField tfTaxaRecebimento;
    @FXML
    private TextField tfOrdem;
    @FXML
    private CheckBox ccbFixarDiaParcela;
    @FXML
    private CheckBox ccbLancarRecebimento;
    @FXML
    private CheckBox ccbExigirCliente;
    @FXML
    private CheckBox ccbPermiteTroco;
    @FXML
    private CheckBox ccbValorCaixa;
    @FXML
    private CheckBox ccbVendasExternas;
    @FXML
    private CheckBox ccbAtivo;
    @FXML
    private CheckBox ccbExibirPdv;
    @FXML
    private CheckBox ccbEmitirCupom;
    @Autowired
    @Lazy
    private StageManager stageManager;
    @Autowired
    private CondicaoRecebimentoService condicaoRecebimentoService;
    private CondicaoRecebimento condicaoRecebimento;

    public void initialize(URL url, ResourceBundle rb) {
        this.condicaoRecebimento = null;
        this.carregaIcones();
        this.registraAcoes();
        this.loadCombos();
        this.loadMascaras();
    }

    private void salva() {
        if (this.condicaoRecebimento == null) {
            this.condicaoRecebimento = new CondicaoRecebimento();
        }
        this.condicaoRecebimento.setAtivo(Boolean.valueOf(this.ccbAtivo.isSelected()));
        this.condicaoRecebimento.setNome(this.tfNome.getText().trim().toUpperCase());
        this.condicaoRecebimento.setTipo((CondicaoRecebimentoTipo)this.cbbCondicaoRecebimento.getSelectionModel().getSelectedItem());
        this.condicaoRecebimento.setFormaPagamento((FormaPagamento)this.cbbFormaPagamento.getSelectionModel().getSelectedItem());
        try {
            this.condicaoRecebimento.setParcelas(Integer.valueOf(Integer.parseInt(this.tfQuantidadeParcelas.getText())));
            this.condicaoRecebimento.setDiasParaEntrada(Integer.valueOf(Integer.parseInt(this.tfPrazoPrimeiraParcela.getText())));
            this.condicaoRecebimento.setIntervaloEntreParcelas(Integer.valueOf(Integer.parseInt(this.tfIntervaloParcelas.getText())));
        }
        catch (NumberFormatException numberFormatException) {
            MaximaAlert.alerta((String)"Informe os valores corretos (n\u00fameros) para os campos:\n- Quantidade de Parcelas.\n- Prazo Primeira Pracela\n- Intervalo entre parcelas");
            return;
        }
        this.condicaoRecebimento.setFixarDia(Boolean.valueOf(this.ccbFixarDiaParcela.isSelected()));
        this.condicaoRecebimento.setRecebido(Boolean.valueOf(this.ccbLancarRecebimento.isSelected()));
        this.condicaoRecebimento.setExigirCliente(Boolean.valueOf(this.ccbExigirCliente.isSelected()));
        this.condicaoRecebimento.setTaxaRecebimento(MaximaNumber.moneyToBigDecimal((String)this.tfTaxaRecebimento.getText()));
        this.condicaoRecebimento.setPermiteTroco(Boolean.valueOf(this.ccbPermiteTroco.isSelected()));
        this.condicaoRecebimento.setOrdem(Integer.valueOf(this.tfOrdem.getText()));
        this.condicaoRecebimento.setAdicionarValorCaixa(Boolean.valueOf(this.ccbValorCaixa.isSelected()));
        this.condicaoRecebimento.setPermiteVendasExternas(Boolean.valueOf(this.ccbVendasExternas.isSelected()));
        this.condicaoRecebimento.setExibirAtalhoPdv(Boolean.valueOf(this.ccbExibirPdv.isSelected()));
        this.condicaoRecebimento.setEmitirCupomFiscal(Boolean.valueOf(this.ccbEmitirCupom.isSelected()));
        ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
        Validator validator = factory.getValidator();
        Set violations = validator.validate((Object)this.condicaoRecebimento, new Class[0]);
        String mensagemError = "";
        mensagemError = violations.stream().map(obj -> obj.getMessage() + "\n").reduce(mensagemError, String::concat);
        if (!mensagemError.isEmpty()) {
            MaximaAlert.alerta((String)mensagemError);
            return;
        }
        if (this.condicaoRecebimento.getFormaPagamento().equals((Object)FormaPagamento.VALECOMPRA) && !this.condicaoRecebimento.getRecebido().booleanValue()) {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"O campo lan\u00e7ar recebimento deve estar marcado para essa forma de recebimento.");
            return;
        }
        try {
            this.condicaoRecebimentoService.save(this.condicaoRecebimento);
            MaximaAlert.informe((StageManager)this.stageManager, (String)"Condi\u00e7\u00e3o de pagamento salvo com sucesso.");
            Stage stage = (Stage)this.tfNome.getScene().getWindow();
            stage.close();
        }
        catch (MaximaException ex) {
            Logger.getLogger(CondicaoRecebimentoFormController.class.getName()).log(Level.SEVERE, null, ex);
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"ERRO: N\u00e3o foi poss\u00edvel salvar a condi\u00e7\u00e3o de recebimento.");
        }
    }

    public void inicializa(CondicaoRecebimento condicaoRecebimento1) {
        this.condicaoRecebimento = condicaoRecebimento1;
        if (this.condicaoRecebimento != null) {
            this.tfId.setText(this.condicaoRecebimento.getId().toString());
            this.ccbAtivo.setSelected(this.condicaoRecebimento.getAtivo().booleanValue());
            this.tfNome.setText(this.condicaoRecebimento.getNome());
            this.cbbCondicaoRecebimento.getSelectionModel().select((Object)this.condicaoRecebimento.getTipo());
            this.cbbFormaPagamento.getSelectionModel().select((Object)this.condicaoRecebimento.getFormaPagamento());
            this.tfQuantidadeParcelas.setText(String.valueOf(this.condicaoRecebimento.getParcelas()));
            this.tfPrazoPrimeiraParcela.setText(String.valueOf(this.condicaoRecebimento.getDiasParaEntrada()));
            this.tfIntervaloParcelas.setText(String.valueOf(this.condicaoRecebimento.getIntervaloEntreParcelas()));
            this.ccbFixarDiaParcela.setSelected(this.condicaoRecebimento.getFixarDia().booleanValue());
            this.ccbLancarRecebimento.setSelected(this.condicaoRecebimento.getRecebido().booleanValue());
            this.ccbExigirCliente.setSelected(this.condicaoRecebimento.getExigirCliente().booleanValue());
            this.ccbPermiteTroco.setSelected(this.condicaoRecebimento.getPermiteTroco().booleanValue());
            this.tfTaxaRecebimento.setText(MaximaNumber.formataNumero((BigDecimal)this.condicaoRecebimento.getTaxaRecebimento()));
            this.tfOrdem.setText(this.condicaoRecebimento.getOrdem().toString());
            this.ccbValorCaixa.setSelected(this.condicaoRecebimento.getAdicionarValorCaixa().booleanValue());
            this.ccbVendasExternas.setSelected(this.condicaoRecebimento.getPermiteVendasExternas().booleanValue());
            this.ccbExibirPdv.setSelected(this.condicaoRecebimento.getExibirAtalhoPdv().booleanValue());
            this.ccbEmitirCupom.setSelected(this.condicaoRecebimento.getEmitirCupomFiscal().booleanValue());
            this.tfNome.selectAll();
            this.tfNome.requestFocus();
        }
    }

    private void loadCombos() {
        this.cbbCondicaoRecebimento.setItems(FXCollections.observableArrayList((Object[])CondicaoRecebimentoTipo.values()));
        this.cbbFormaPagamento.setItems(FXCollections.observableArrayList((Object[])FormaPagamento.values()));
    }

    private void loadMascaras() {
        MaximaMask.monetaryField((TextField)this.tfTaxaRecebimento);
    }

    private void carregaIcones() {
        this.btnSalva.setGraphic((Node)new MaximaIcone().getIconeConfirma());
    }

    private void registraAcoes() {
        this.btnSalva.setOnAction(event -> this.salva());
    }
}

