/*
 * Decompiled with CFR 0.152.
 */
package br.com.maximasolutions.financeiro.controller;

import br.com.caelum.stella.DigitoPara;
import br.com.caelum.stella.boleto.utils.StellaStringUtils;
import br.com.maximasolutions.administrativo.core.PermissaoControleValida;
import br.com.maximasolutions.administrativo.modelo.Configuracao;
import br.com.maximasolutions.administrativo.modelo.PermissaoControle;
import br.com.maximasolutions.administrativo.modelo.PermissaoControleAcao;
import br.com.maximasolutions.administrativo.service.ConfiguracaoService;
import br.com.maximasolutions.administrativo.service.UsuarioService;
import br.com.maximasolutions.config.StageManager;
import br.com.maximasolutions.core.MaximaAlert;
import br.com.maximasolutions.core.MaximaController;
import br.com.maximasolutions.core.MaximaDialogFX;
import br.com.maximasolutions.core.MaximaIcone;
import br.com.maximasolutions.core.MaximaValidacaoException;
import br.com.maximasolutions.core.PrintReport;
import br.com.maximasolutions.estoque.relatorio.controller.RelatorioVendaProdutoController;
import br.com.maximasolutions.financeiro.controller.ContaPagarController;
import br.com.maximasolutions.financeiro.controller.ContaReceberEditaFormController;
import br.com.maximasolutions.financeiro.controller.ContaReceberFormController;
import br.com.maximasolutions.financeiro.controller.RecebimentoFormController;
import br.com.maximasolutions.financeiro.controller.RecebimentoMultiploFormController;
import br.com.maximasolutions.financeiro.modelo.BancoBoleto;
import br.com.maximasolutions.financeiro.modelo.BoletoEmitido;
import br.com.maximasolutions.financeiro.modelo.ContaReceberParcela;
import br.com.maximasolutions.financeiro.modelo.FormaPagamento;
import br.com.maximasolutions.financeiro.service.BancoBoletoService;
import br.com.maximasolutions.financeiro.service.BoletoEmitidoService;
import br.com.maximasolutions.financeiro.service.BoletoTecnospeedService;
import br.com.maximasolutions.financeiro.service.ContaReceberParcelaService;
import br.com.maximasolutions.financeiro.service.MovimentoCaixaService;
import br.com.maximasolutions.financeiro.utils.FormaPagamentoUtils;
import br.com.maximasolutions.geral.modelo.Cliente;
import br.com.maximasolutions.javafx.formatter.ColumnDateFormatter;
import br.com.maximasolutions.javafx.formatter.ColumnNumberFormatter;
import br.com.maximasolutions.sat.core.ControleSAT;
import br.com.maximasolutions.utils.MaximaDate;
import br.com.maximasolutions.utils.MaximaNumber;
import java.io.IOException;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.SQLException;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.DatePicker;
import javafx.scene.control.Label;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.input.KeyCode;
import javafx.stage.Stage;
import javafx.util.Callback;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.data.JRBeanCollectionDataSource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Controller;

@Controller
public class ContaReceberController
extends MaximaController
implements Initializable {
    @FXML
    private Button btnRecebimento;
    @FXML
    private Button btnDelete;
    @FXML
    private Button btnAddContaReceber;
    @FXML
    private Button btnEdita;
    @FXML
    private TableView<ContaReceberParcela> tabela;
    @FXML
    private TableColumn<ContaReceberParcela, String> colCliente;
    @FXML
    private TableColumn<ContaReceberParcela, String> colCodigo;
    @FXML
    private TableColumn<ContaReceberParcela, String> colObservacao;
    @FXML
    private TableColumn<ContaReceberParcela, String> colData;
    @FXML
    private TableColumn<ContaReceberParcela, String> colFormaPagamento;
    @FXML
    private TableColumn<ContaReceberParcela, BigDecimal> colTotal;
    @FXML
    private TableColumn<ContaReceberParcela, BigDecimal> colTotalPendente;
    @FXML
    private DatePicker tfInicio;
    @FXML
    private DatePicker tfFim;
    @FXML
    private TextField tfFiltro;
    @FXML
    private ComboBox<FormaPagamento> cbbFormaPagamento;
    @FXML
    private Button btnPesquisa;
    @FXML
    private Label lblTotal;
    @Lazy
    @Autowired
    private StageManager stageManager;
    @Autowired
    private ContaReceberParcelaService contaReceberParcelaService;
    @Autowired
    private MovimentoCaixaService movimentoCaixaService;
    @Autowired
    private ConfiguracaoService configuracaoService;
    @Autowired
    private BoletoEmitidoService boletoEmitidoService;
    @Autowired
    private BoletoTecnospeedService tecnospeedService;
    @Autowired
    private BancoBoletoService bancoBoletoService;
    @Autowired
    private UsuarioService usuarioService;
    private ObservableList<ContaReceberParcela> contaReceberParcelaList;
    private ControleSAT controleSAT;
    private Configuracao conf;

    public void initialize(URL url, ResourceBundle rb) {
        this.conf = this.configuracaoService.load();
        this.tfInicio.setValue((Object)MaximaDate.getPrimeiroDiaMes());
        this.tfFim.setValue((Object)MaximaDate.getUltimoDiaMes());
        this.contaReceberParcelaList = FXCollections.observableArrayList();
        this.tabela.setOnMouseClicked(event -> {
            if (event.getClickCount() == 2) {
                // empty if block
            }
        });
        this.carregaIcones();
        this.setColumnProperties();
        this.loadTabela();
        this.registraAcoes();
        this.carregaCombos();
    }

    public void inicializa() {
        this.acoes = this.usuarioService.acoes(this.stageManager.getUsuario(), PermissaoControle.ContaReceber);
    }

    private void imprimeVendaSelecionada() {
        ContaReceberParcela contaReceberParcela = (ContaReceberParcela)this.tabela.getSelectionModel().getSelectedItem();
        if (contaReceberParcela == null) {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"Nenhuma venda selecionada para impress\u00e3o.");
            return;
        }
    }

    private void editaContaReceber() {
        if (!PermissaoControleValida.acaoPermitida((StageManager)this.stageManager, (List)this.acoes, (PermissaoControleAcao)PermissaoControleAcao.EDIT).booleanValue()) {
            return;
        }
        ContaReceberParcela contaReceberParcela = (ContaReceberParcela)this.tabela.getSelectionModel().getSelectedItem();
        if (contaReceberParcela == null) {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"Selecione uma parcela para editar os dados.");
            return;
        }
        if ((contaReceberParcela = this.contaReceberParcelaService.load(contaReceberParcela.getId())).existePagamento().booleanValue()) {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"Parcela com recebimento efetuado. N\u00e3o pode ser alterada.");
            return;
        }
        try {
            Stage formContaPagar = new MaximaDialogFX().createWindowForm(this.stageManager, "/fxml/financeiro/contaReceber/ContaReceberEditaForm.fxml", "Edi\u00e7\u00e3o de Contas a Receber");
            ContaReceberEditaFormController controller = (ContaReceberEditaFormController)formContaPagar.getUserData();
            controller.inicializa(contaReceberParcela);
            formContaPagar.showAndWait();
            this.loadTabela();
        }
        catch (IOException ex) {
            Logger.getLogger(ContaPagarController.class.getSimpleName()).log(Level.SEVERE, null, ex);
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"Erro: N\u00e3o encontrado arquivo 'ContaReceberEditaForm'.\n");
        }
    }

    private void novoContaReceber() {
        if (!PermissaoControleValida.acaoPermitida((StageManager)this.stageManager, (List)this.acoes, (PermissaoControleAcao)PermissaoControleAcao.ADD).booleanValue()) {
            return;
        }
        try {
            Stage formContaReceber = new MaximaDialogFX().createWindowForm(this.stageManager, "/fxml/financeiro/contaReceber/ContaReceberForm.fxml", "Cadastro de Contas a Receber");
            ContaReceberFormController controller = (ContaReceberFormController)formContaReceber.getUserData();
            controller.inicializa(null);
            formContaReceber.showAndWait();
            this.loadTabela();
        }
        catch (IOException ex) {
            Logger.getLogger(ContaPagarController.class.getSimpleName()).log(Level.SEVERE, null, ex);
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"Erro: N\u00e3o encontrado arquivo 'ContaReceberForm'.\n");
        }
    }

    private void efetuaRecebimento() {
        if (!PermissaoControleValida.acaoPermitida((StageManager)this.stageManager, (List)this.acoes, (PermissaoControleAcao)PermissaoControleAcao.RECEBIMENTO).booleanValue()) {
            return;
        }
        if (this.tabela.getSelectionModel().getSelectedItems().isEmpty()) {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"Selecione uma parcela para receber!");
            return;
        }
        if (this.tabela.getSelectionModel().getSelectedItems().size() == 1) {
            ContaReceberParcela contaReceberParcela = (ContaReceberParcela)this.tabela.getSelectionModel().getSelectedItem();
            contaReceberParcela = this.contaReceberParcelaService.load(contaReceberParcela.getId());
            try {
                Stage stage = new MaximaDialogFX().createWindowForm(this.stageManager, "/fxml/financeiro/contaReceber/RecebimentoForm.fxml", "Recebimento");
                RecebimentoFormController controller = (RecebimentoFormController)stage.getUserData();
                controller.inicializa(contaReceberParcela);
                stage.showAndWait();
                this.loadTabela();
            }
            catch (IOException ex) {
                Logger.getLogger(ContaReceberController.class.getName()).log(Level.SEVERE, null, ex);
                MaximaAlert.aviso((StageManager)this.stageManager, (String)("Erro: N\u00e3o foi poss\u00edvel abrir o m\u00f3dulo de recebimento.\n" + ex.getMessage()));
            }
        } else {
            ObservableList parcelas = this.tabela.getSelectionModel().getSelectedItems();
            Cliente cliente = ((ContaReceberParcela)parcelas.get(0)).getCliente();
            Boolean mesmoCliente = true;
            for (ContaReceberParcela parc : parcelas) {
                if (parc.getCliente().getId().equals(cliente.getId())) continue;
                mesmoCliente = false;
                break;
            }
            if (!mesmoCliente.booleanValue()) {
                MaximaAlert.aviso((StageManager)this.stageManager, (String)"Oper\u00e7\u00e3o n\u00e3o permitida. Clientes diversos selecionados.");
            }
            try {
                Stage stage = new MaximaDialogFX().createWindowForm(this.stageManager, "/fxml/financeiro/contaReceber/RecebimentoMultiploForm.fxml", "Recebimento");
                RecebimentoMultiploFormController controller = (RecebimentoMultiploFormController)stage.getUserData();
                controller.inicializa((List)parcelas);
                stage.showAndWait();
                this.loadTabela();
            }
            catch (IOException ex) {
                Logger.getLogger(ContaReceberController.class.getName()).log(Level.SEVERE, null, ex);
                MaximaAlert.aviso((StageManager)this.stageManager, (String)("Erro: N\u00e3o foi poss\u00edvel abrir o m\u00f3dulo de recebimento.\n" + ex.getMessage()));
            }
        }
    }

    private void geraBoleto() {
        if (!PermissaoControleValida.acaoPermitida((StageManager)this.stageManager, (List)this.acoes, (PermissaoControleAcao)PermissaoControleAcao.BOLETO_EMITIR).booleanValue()) {
            return;
        }
        ObservableList parcelas = this.tabela.getSelectionModel().getSelectedItems();
        if (parcelas == null || parcelas.isEmpty()) {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"Selecione ao menos uma parcela para gerar o boleto.");
            return;
        }
        ArrayList<BoletoEmitido> boletos = new ArrayList<BoletoEmitido>();
        BancoBoleto bancoBoleto = this.bancoBoletoService.load(this.conf.getBancoBoleto().getId().longValue());
        Long nossoNumero = Long.parseLong(bancoBoleto.getNossoNumero());
        boolean erro = false;
        for (ContaReceberParcela parcela : parcelas) {
            if ((parcela = this.contaReceberParcelaService.load(parcela.getId())).getBoleto().booleanValue()) {
                MaximaAlert.aviso((StageManager)this.stageManager, (String)("Boleto j\u00e1 emitido para a parcela [ " + parcela.getId() + " ]."));
                erro = true;
                break;
            }
            try {
                nossoNumero = nossoNumero + 1L;
                boletos.add(this.getBoletoEmitido(bancoBoleto, parcela, nossoNumero.toString()));
            }
            catch (Exception e) {
                Logger.getLogger(ContaReceberController.class.getSimpleName()).log(Level.SEVERE, null, e);
                MaximaAlert.aviso((StageManager)this.stageManager, (String)"Erro: N\u00e3o foi poss\u00edvel gerar o boleto.");
            }
        }
        if (erro) {
            return;
        }
        this.boletoEmitidoService.add(boletos);
        bancoBoleto = this.bancoBoletoService.load(bancoBoleto.getId().longValue());
        bancoBoleto.setNossoNumero(nossoNumero.toString());
        this.bancoBoletoService.save(bancoBoleto);
        MaximaAlert.informe((StageManager)this.stageManager, (String)"Boleto(s) emitido(s) com sucesso.");
        this.loadTabela();
    }

    private BoletoEmitido getBoletoEmitido(BancoBoleto bancoBoleto, ContaReceberParcela contaReceberParcela, String nossoNumero) {
        BoletoEmitido boletoEmitido = new BoletoEmitido();
        boletoEmitido.setAgencia(bancoBoleto.getAgencia());
        boletoEmitido.setAgenciaDigito(bancoBoleto.getAgenciaDigito());
        boletoEmitido.setBancoTipo(bancoBoleto.getBancoTipo());
        boletoEmitido.setCarteira(bancoBoleto.getCarteira());
        Cliente cliente = contaReceberParcela.getCliente();
        boletoEmitido.setCliente(cliente);
        boletoEmitido.setClienteBairro(cliente.getBairro());
        boletoEmitido.setClienteCep(cliente.getCep());
        boletoEmitido.setClienteCnpj(cliente.getCpf());
        boletoEmitido.setClienteEndereco(cliente.getEndereco());
        boletoEmitido.setClienteNumero(cliente.getNumero());
        boletoEmitido.setClienteMunicipio(cliente.getMunicipio().getNome());
        boletoEmitido.setClienteNome(cliente.getNome());
        boletoEmitido.setClienteUF(cliente.getMunicipio().getEstado().getSigla());
        boletoEmitido.setConta(bancoBoleto.getConta());
        boletoEmitido.setContaDigito(bancoBoleto.getContaDigito());
        boletoEmitido.setContaReceberParcela(contaReceberParcela);
        boletoEmitido.setDataEmissao(LocalDate.now());
        boletoEmitido.setDataVencimento(contaReceberParcela.getDataVencimento());
        boletoEmitido.setEmail(Boolean.FALSE);
        boletoEmitido.setNossoNumero(nossoNumero);
        boletoEmitido.setNossoNumeroDigito(this.calculaDVNossoNumero(nossoNumero));
        boletoEmitido.setNumeroDocumento(String.valueOf(contaReceberParcela.getId()));
        boletoEmitido.setNumeroConvenio(bancoBoleto.getNumeroConvenio());
        boletoEmitido.setRemessa(Boolean.FALSE);
        boletoEmitido.setValor(contaReceberParcela.getValorPendente());
        return boletoEmitido;
    }

    public String calculaDVNossoNumero(String nossoNumero) {
        if (nossoNumero == null || nossoNumero.length() > 12) {
            throw new IllegalArgumentException("Nosso N\u00famero inv\u00e1lido: " + nossoNumero);
        }
        DigitoPara digitoPara = new DigitoPara(StellaStringUtils.leftPadWithZeros((String)nossoNumero, (int)12));
        int digito = Integer.parseInt(digitoPara.comMultiplicadoresDeAte(2, 9).mod(11).trocandoPorSeEncontrar("0", new Integer[]{1}).trocandoPorSeEncontrar("1", new Integer[]{10}).calcula());
        if (digito > 1) {
            digito = 11 - digito;
        }
        return String.valueOf(digito);
    }

    private void deleteParcela() {
        if (!PermissaoControleValida.acaoPermitida((StageManager)this.stageManager, (List)this.acoes, (PermissaoControleAcao)PermissaoControleAcao.DELETE).booleanValue()) {
            return;
        }
        if (this.tabela.getSelectionModel().getSelectedItems().size() > 1) {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"N\u00e3o \u00e9 permitido a sele\u00e7\u00e3o de mais de uma parcela para este tipo de opera\u00e7\u00e3o.");
            return;
        }
        ContaReceberParcela contaReceberParcela = (ContaReceberParcela)this.tabela.getSelectionModel().getSelectedItem();
        if (contaReceberParcela == null) {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"Selecione uma parcela para remover.");
            return;
        }
        if (contaReceberParcela.getExcluido().booleanValue()) {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"Parcela j\u00e1 removida.");
            return;
        }
        if (!MaximaAlert.confirmacao((String)"Deseja remover a parcela selecionada?")) {
            return;
        }
        try {
            this.contaReceberParcelaService.remove(contaReceberParcela);
            MaximaAlert.informe((StageManager)this.stageManager, (String)"Parcela removida com sucesso.");
            this.loadTabela();
        }
        catch (MaximaValidacaoException ex) {
            Logger.getLogger(ContaReceberController.class.getName()).log(Level.SEVERE, null, ex);
            MaximaAlert.aviso((StageManager)this.stageManager, (String)ex.getMessage());
        }
    }

    private void setColumnProperties() {
        this.colCodigo.setCellValueFactory((Callback)new PropertyValueFactory("id"));
        this.colData.setCellValueFactory((Callback)new PropertyValueFactory("dataVencimento"));
        this.colCliente.setCellValueFactory((Callback)new PropertyValueFactory("cliente"));
        this.colObservacao.setCellValueFactory((Callback)new PropertyValueFactory("historico"));
        this.colFormaPagamento.setCellValueFactory((Callback)new PropertyValueFactory("formaPagamento"));
        this.colTotal.setCellValueFactory((Callback)new PropertyValueFactory("valor"));
        this.colTotalPendente.setCellValueFactory((Callback)new PropertyValueFactory("valorPendente"));
        this.colData.setCellFactory((Callback)new ColumnDateFormatter());
        this.colTotal.setCellFactory((Callback)new ColumnNumberFormatter());
        this.colTotalPendente.setCellFactory((Callback)new ColumnNumberFormatter());
        this.lblTotal.setAlignment(Pos.CENTER_RIGHT);
        this.tabela.getSelectionModel().setSelectionMode(SelectionMode.MULTIPLE);
    }

    private void loadTabela() {
        BigDecimal total;
        List list;
        this.contaReceberParcelaList.clear();
        LocalDate inicio = (LocalDate)this.tfInicio.getValue();
        LocalDate fim = (LocalDate)this.tfFim.getValue();
        if (inicio == null || fim == null) {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"Informe a data de in\u00edcio e fim para pesquisa.");
            return;
        }
        if (inicio.isAfter(fim)) {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"A data de in\u00edcio deve ser igual ou anterior a data final.");
            return;
        }
        String filtro = "%";
        if (this.tfFiltro.getText() != null) {
            filtro = filtro + this.tfFiltro.getText().trim();
        }
        filtro = filtro + "%";
        if (this.cbbFormaPagamento.getSelectionModel().getSelectedItem() == null) {
            list = this.contaReceberParcelaService.lista(inicio, fim, filtro);
            total = this.contaReceberParcelaService.total(inicio, fim, filtro);
        } else {
            list = this.contaReceberParcelaService.lista(inicio, fim, filtro, (FormaPagamento)this.cbbFormaPagamento.getSelectionModel().getSelectedItem());
            total = this.contaReceberParcelaService.total(inicio, fim, filtro, (FormaPagamento)this.cbbFormaPagamento.getSelectionModel().getSelectedItem());
        }
        this.contaReceberParcelaList.addAll((Collection)list);
        this.tabela.setItems(this.contaReceberParcelaList);
        this.lblTotal.setText("VALOR TOTAL: R$ " + MaximaNumber.bigDecimalToString((BigDecimal)total, (int)2));
    }

    private void carregaCombos() {
        this.cbbFormaPagamento.setItems(FXCollections.observableArrayList((Collection)FormaPagamentoUtils.listCombo()));
    }

    private void carregaIcones() {
        MaximaIcone maximaIcone = new MaximaIcone();
        this.btnRecebimento.setGraphic((Node)maximaIcone.getIconeMoney());
        this.btnDelete.setGraphic((Node)maximaIcone.getIconeDelete());
        this.btnPesquisa.setGraphic((Node)maximaIcone.getPesquisa());
    }

    private void registraAcoes() {
        this.btnEdita.setOnAction(evt -> this.editaContaReceber());
        this.btnAddContaReceber.setOnAction(event -> this.novoContaReceber());
        this.btnRecebimento.setOnAction(event -> this.efetuaRecebimento());
        this.btnDelete.setOnAction(event -> this.deleteParcela());
        this.btnPesquisa.setOnAction(event -> this.loadTabela());
        this.tfFiltro.setOnKeyPressed(event -> {
            if (event.getCode() == KeyCode.ENTER) {
                this.loadTabela();
            }
        });
    }

    private void imprimirCarne() {
        ObservableList parcelas = this.tabela.getSelectionModel().getSelectedItems();
        if (parcelas == null || parcelas.isEmpty()) {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"Selecione ao menos uma parcela para imprimir carne.");
            return;
        }
        try {
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("logo", "logo_boleto.png");
            params.put("pix", "pix_qrcode.jpeg");
            JRBeanCollectionDataSource jrds = new JRBeanCollectionDataSource((Collection)parcelas);
            new PrintReport().showReport("/jasper/financeiro/contasReceber/carne-receber.jasper", (JRDataSource)jrds, params);
        }
        catch (JRException ex) {
            Logger.getLogger("").log(Level.SEVERE, null, ex);
            MaximaAlert.aviso((StageManager)this.stageManager, (String)("Ocorreu um erro ao gerar relat\u00f3rio.\n" + ex.getMessage()));
        }
        catch (ClassNotFoundException | SQLException ex) {
            Logger.getLogger(RelatorioVendaProdutoController.class.getName()).log(Level.SEVERE, null, ex);
            MaximaAlert.aviso((StageManager)this.stageManager, (String)("Ocorreu um erro ao gerar relat\u00f3rio.\n" + ex.getMessage()));
        }
    }
}

