/*
 * Decompiled with CFR 0.152.
 */
package br.com.maximasolutions.financeiro.controller;

import br.com.maximasolutions.administrativo.core.PermissaoControleValida;
import br.com.maximasolutions.administrativo.modelo.Configuracao;
import br.com.maximasolutions.administrativo.modelo.PermissaoControle;
import br.com.maximasolutions.administrativo.modelo.PermissaoControleAcao;
import br.com.maximasolutions.administrativo.service.ConfiguracaoService;
import br.com.maximasolutions.administrativo.service.UsuarioService;
import br.com.maximasolutions.config.StageManager;
import br.com.maximasolutions.core.MaximaAlert;
import br.com.maximasolutions.core.MaximaController;
import br.com.maximasolutions.core.MaximaDialogFX;
import br.com.maximasolutions.core.MaximaIcone;
import br.com.maximasolutions.core.MaximaValidacaoException;
import br.com.maximasolutions.financeiro.controller.ContaPagarController;
import br.com.maximasolutions.financeiro.controller.ContaReceberEditaFormController;
import br.com.maximasolutions.financeiro.controller.RecebimentoFormController;
import br.com.maximasolutions.financeiro.modelo.ContaReceberParcela;
import br.com.maximasolutions.financeiro.service.BoletoEmitidoService;
import br.com.maximasolutions.financeiro.service.ContaReceberParcelaService;
import br.com.maximasolutions.financeiro.service.MovimentoCaixaService;
import br.com.maximasolutions.geral.form.ClientePesquisaForm;
import br.com.maximasolutions.geral.modelo.Cliente;
import br.com.maximasolutions.geral.service.ClienteService;
import br.com.maximasolutions.javafx.formatter.ColumnDateFormatter;
import br.com.maximasolutions.javafx.formatter.ColumnNumberFormatter;
import br.com.maximasolutions.sat.core.ControleSAT;
import br.com.maximasolutions.utils.MaximaNumber;
import java.io.IOException;
import java.math.BigDecimal;
import java.net.URL;
import java.util.Collection;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.collections.FXCollections;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.input.KeyCode;
import javafx.stage.Stage;
import javafx.util.Callback;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Controller;

@Controller
public class ExtratoClienteController
extends MaximaController
implements Initializable {
    @FXML
    private Button btnRecebimento;
    @FXML
    private Button btnDelete;
    @FXML
    private Button btnEdita;
    @FXML
    private TableView<ContaReceberParcela> tabela;
    @FXML
    private TableColumn<ContaReceberParcela, String> colCliente;
    @FXML
    private TableColumn<ContaReceberParcela, String> colCodigo;
    @FXML
    private TableColumn<ContaReceberParcela, String> colObservacao;
    @FXML
    private TableColumn<ContaReceberParcela, String> colData;
    @FXML
    private TableColumn<ContaReceberParcela, String> colFormaPagamento;
    @FXML
    private TableColumn<ContaReceberParcela, BigDecimal> colTotal;
    @FXML
    private TableColumn<ContaReceberParcela, BigDecimal> colTotalPendente;
    @FXML
    private TextField tfClienteCodigo;
    @FXML
    private TextField tfClienteDescricao;
    @FXML
    private Button btnPesquisa;
    @FXML
    private Button btnCliente;
    @FXML
    private Label lblTotal;
    @Lazy
    @Autowired
    private StageManager stageManager;
    @Autowired
    private ContaReceberParcelaService contaReceberParcelaService;
    @Autowired
    private MovimentoCaixaService movimentoCaixaService;
    @Autowired
    private ConfiguracaoService configuracaoService;
    @Autowired
    private BoletoEmitidoService boletoEmitidoService;
    @Autowired
    private ClienteService clienteService;
    @Autowired
    private UsuarioService usuarioService;
    private ControleSAT controleSAT;
    private Configuracao conf;
    private Cliente cliente;

    public void initialize(URL url, ResourceBundle rb) {
        this.carregaIcones();
        this.setColumnProperties();
    }

    public void inicializa() {
        this.acoes = this.usuarioService.acoes(this.stageManager.getUsuario(), PermissaoControle.ExtratoCliente);
        this.cliente = null;
        this.conf = this.configuracaoService.load();
        this.carregaCombos();
        this.registraAcoes();
    }

    private void imprimeVendaSelecionada() {
        ContaReceberParcela contaReceberParcela = (ContaReceberParcela)this.tabela.getSelectionModel().getSelectedItem();
        if (contaReceberParcela == null) {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"Nenhuma venda selecionada para impress\u00e3o.");
            return;
        }
    }

    private void editaContaReceber() {
        if (!PermissaoControleValida.acaoPermitida((StageManager)this.stageManager, (List)this.acoes, (PermissaoControleAcao)PermissaoControleAcao.EDIT).booleanValue()) {
            return;
        }
        ContaReceberParcela contaReceberParcela = (ContaReceberParcela)this.tabela.getSelectionModel().getSelectedItem();
        if (contaReceberParcela == null) {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"Selecione uma parcela para editar os dados.");
            return;
        }
        if ((contaReceberParcela = this.contaReceberParcelaService.load(contaReceberParcela.getId())).existePagamento().booleanValue()) {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"Parcela com recebimento efetuado. N\u00e3o pode ser alterada.");
            return;
        }
        try {
            Stage formContaPagar = new MaximaDialogFX().createWindowForm(this.stageManager, "/fxml/financeiro/contaReceber/ContaReceberEditaForm.fxml", "Edi\u00e7\u00e3o de Contas a Receber");
            ContaReceberEditaFormController controller = (ContaReceberEditaFormController)formContaPagar.getUserData();
            controller.inicializa(contaReceberParcela);
            formContaPagar.showAndWait();
            this.loadTabela();
        }
        catch (IOException ex) {
            Logger.getLogger(ContaPagarController.class.getSimpleName()).log(Level.SEVERE, null, ex);
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"Erro: N\u00e3o encontrado arquivo 'ContaReceberEditaForm'.\n");
        }
    }

    private void efetuaRecebimento() {
        if (!PermissaoControleValida.acaoPermitida((StageManager)this.stageManager, (List)this.acoes, (PermissaoControleAcao)PermissaoControleAcao.RECEBIMENTO).booleanValue()) {
            return;
        }
        if (this.tabela.getSelectionModel().getSelectedItems().size() > 1) {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"N\u00e3o \u00e9 permitido a sele\u00e7\u00e3o de mais de uma parcela para este tipo de opera\u00e7\u00e3o.");
            return;
        }
        ContaReceberParcela contaReceberParcela = (ContaReceberParcela)this.tabela.getSelectionModel().getSelectedItem();
        if (contaReceberParcela == null) {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"Selecione uma parcela para efetuar recebimento.");
            return;
        }
        contaReceberParcela = this.contaReceberParcelaService.load(contaReceberParcela.getId());
        try {
            Stage stage = new MaximaDialogFX().createWindowForm(this.stageManager, "/fxml/financeiro/contaReceber/RecebimentoForm.fxml", "Recebimento");
            RecebimentoFormController controller = (RecebimentoFormController)stage.getUserData();
            controller.inicializa(contaReceberParcela);
            stage.showAndWait();
            this.loadTabela();
        }
        catch (IOException ex) {
            Logger.getLogger(ExtratoClienteController.class.getName()).log(Level.SEVERE, null, ex);
            MaximaAlert.aviso((StageManager)this.stageManager, (String)("Erro: N\u00e3o foi poss\u00edvel abrir o m\u00f3dulo de recebimento.\n" + ex.getMessage()));
        }
    }

    private void geraBoleto() {
        MaximaAlert.aviso((StageManager)this.stageManager, (String)"Implementar.");
    }

    private void deleteParcela() {
        if (!PermissaoControleValida.acaoPermitida((StageManager)this.stageManager, (List)this.acoes, (PermissaoControleAcao)PermissaoControleAcao.DELETE).booleanValue()) {
            return;
        }
        if (this.tabela.getSelectionModel().getSelectedItems().size() > 1) {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"N\u00e3o \u00e9 permitido a sele\u00e7\u00e3o de mais de uma parcela para este tipo de opera\u00e7\u00e3o.");
            return;
        }
        ContaReceberParcela contaReceberParcela = (ContaReceberParcela)this.tabela.getSelectionModel().getSelectedItem();
        if (contaReceberParcela == null) {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"Selecione uma parcela para remover.");
            return;
        }
        if (contaReceberParcela.getExcluido().booleanValue()) {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"Parcela j\u00e1 removida.");
            return;
        }
        if (!MaximaAlert.confirmacao((String)"Deseja remover a parcela selecionada?")) {
            return;
        }
        try {
            this.contaReceberParcelaService.remove(contaReceberParcela);
            MaximaAlert.informe((StageManager)this.stageManager, (String)"Parcela removida com sucesso.");
            this.loadTabela();
        }
        catch (MaximaValidacaoException ex) {
            Logger.getLogger(ExtratoClienteController.class.getName()).log(Level.SEVERE, null, ex);
            MaximaAlert.aviso((StageManager)this.stageManager, (String)ex.getMessage());
        }
    }

    private void setColumnProperties() {
        this.colCodigo.setCellValueFactory((Callback)new PropertyValueFactory("id"));
        this.colData.setCellValueFactory((Callback)new PropertyValueFactory("dataVencimento"));
        this.colCliente.setCellValueFactory((Callback)new PropertyValueFactory("cliente"));
        this.colObservacao.setCellValueFactory((Callback)new PropertyValueFactory("historico"));
        this.colFormaPagamento.setCellValueFactory((Callback)new PropertyValueFactory("formaPagamento"));
        this.colTotal.setCellValueFactory((Callback)new PropertyValueFactory("valor"));
        this.colTotalPendente.setCellValueFactory((Callback)new PropertyValueFactory("valorPendente"));
        this.colData.setCellFactory((Callback)new ColumnDateFormatter());
        this.colTotal.setCellFactory((Callback)new ColumnNumberFormatter());
        this.colTotalPendente.setCellFactory((Callback)new ColumnNumberFormatter());
        this.lblTotal.setAlignment(Pos.CENTER_RIGHT);
        this.tabela.getSelectionModel().setSelectionMode(SelectionMode.MULTIPLE);
    }

    private void loadTabela() {
        if (this.cliente == null) {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"Selecione um cliente para visualizar o extrato.");
            return;
        }
        BigDecimal total = BigDecimal.ZERO;
        BigDecimal pendente = BigDecimal.ZERO;
        List parcelas = this.contaReceberParcelaService.extrato(this.cliente);
        this.tabela.getItems().clear();
        this.tabela.setItems(FXCollections.observableArrayList((Collection)parcelas));
        for (ContaReceberParcela parc : parcelas) {
            total = total.add(parc.getValor());
            pendente = pendente.add(parc.getValorPendente());
        }
        this.lblTotal.setText("VALOR TOTAL: R$ " + MaximaNumber.bigDecimalToString((BigDecimal)total, (int)2) + "   |   VALOR EM ABERTO: R$ " + MaximaNumber.bigDecimalToString((BigDecimal)pendente, (int)2));
    }

    private void carregaCombos() {
    }

    private void carregaIcones() {
        MaximaIcone maximaIcone = new MaximaIcone();
        this.btnRecebimento.setGraphic((Node)maximaIcone.getIconeMoney());
        this.btnDelete.setGraphic((Node)maximaIcone.getIconeDelete());
        this.btnPesquisa.setGraphic((Node)maximaIcone.getPesquisa());
    }

    private void registraAcoes() {
        this.btnEdita.setOnAction(evt -> this.editaContaReceber());
        this.btnRecebimento.setOnAction(event -> this.efetuaRecebimento());
        this.btnDelete.setOnAction(event -> this.deleteParcela());
        this.btnPesquisa.setOnAction(event -> this.loadTabela());
        this.btnCliente.setOnAction(event -> this.pesquisaClienteForm());
        this.tfClienteCodigo.setOnKeyPressed(event -> {
            if (event.getCode() == KeyCode.ENTER) {
                this.pesquisaCliente();
            }
        });
    }

    private void pesquisaCliente() {
        String clienteCodigo = this.tfClienteCodigo.getText().trim();
        if (clienteCodigo.isEmpty()) {
            return;
        }
        try {
            Long clienteCodigoNumero = Long.valueOf(clienteCodigo);
            Cliente clientePesquisa = this.clienteService.getById(clienteCodigoNumero);
            if (clientePesquisa != null) {
                this.cliente = clientePesquisa;
                this.loadDadosCliente();
                return;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        this.pesquisaClienteForm();
    }

    private void pesquisaClienteForm() {
        this.cliente = new ClientePesquisaForm().getCliente(this.stageManager, this.btnCliente.getScene(), this.tfClienteCodigo.getText());
        this.loadDadosCliente();
    }

    private void loadDadosCliente() {
        if (this.cliente != null) {
            this.tfClienteCodigo.setText(this.cliente.getId().toString());
            this.tfClienteDescricao.setText(this.cliente.getNome().toUpperCase());
        } else {
            this.tfClienteCodigo.setText("");
            this.tfClienteDescricao.setText("");
            this.tfClienteCodigo.requestFocus();
        }
    }
}

