/*
 * Decompiled with CFR 0.152.
 */
package br.com.maximasolutions.financeiro.controller;

import br.com.maximasolutions.administrativo.core.PermissaoControleValida;
import br.com.maximasolutions.administrativo.modelo.PermissaoControle;
import br.com.maximasolutions.administrativo.modelo.PermissaoControleAcao;
import br.com.maximasolutions.administrativo.service.UsuarioService;
import br.com.maximasolutions.config.StageManager;
import br.com.maximasolutions.core.MaximaAlert;
import br.com.maximasolutions.core.MaximaController;
import br.com.maximasolutions.core.MaximaDialogFX;
import br.com.maximasolutions.core.MaximaIcone;
import br.com.maximasolutions.core.MaximaValidacaoException;
import br.com.maximasolutions.financeiro.controller.RecebimentoDiretoFormController;
import br.com.maximasolutions.financeiro.modelo.FormaPagamento;
import br.com.maximasolutions.financeiro.modelo.MovimentacaoEntrada;
import br.com.maximasolutions.financeiro.service.MovimentacaoEntradaService;
import br.com.maximasolutions.financeiro.utils.FormaPagamentoUtils;
import br.com.maximasolutions.javafx.formatter.ColumnDateFormatter;
import br.com.maximasolutions.javafx.formatter.ColumnNumberFormatter;
import br.com.maximasolutions.utils.MaximaNumber;
import java.io.IOException;
import java.math.BigDecimal;
import java.net.URL;
import java.time.LocalDate;
import java.util.Collection;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.DatePicker;
import javafx.scene.control.Label;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.input.KeyCode;
import javafx.stage.Stage;
import javafx.util.Callback;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Controller;

@Controller
public class MovimentacaoEntradaController
extends MaximaController
implements Initializable {
    @FXML
    private TableView<MovimentacaoEntrada> tabela;
    @FXML
    private TableColumn<MovimentacaoEntrada, String> colDataRecebimento;
    @FXML
    private TableColumn<MovimentacaoEntrada, String> colCliente;
    @FXML
    private TableColumn<MovimentacaoEntrada, String> colFormaPagamento;
    @FXML
    private TableColumn<MovimentacaoEntrada, String> colHistorico;
    @FXML
    private TableColumn<MovimentacaoEntrada, BigDecimal> colValor;
    @FXML
    private TableColumn<MovimentacaoEntrada, BigDecimal> colValorLiquido;
    @FXML
    private DatePicker tfInicio;
    @FXML
    private DatePicker tfFim;
    @FXML
    private TextField tfFiltro;
    @FXML
    private ComboBox<FormaPagamento> cbbFormaPagamento;
    @FXML
    private Button btnPesquisa;
    @FXML
    private Button btnEstorna;
    @FXML
    private Button btnRecebimento;
    @FXML
    private Button btnImprime;
    @FXML
    private Label lblTotal;
    @Lazy
    @Autowired
    private StageManager stageManager;
    @Autowired
    private MovimentacaoEntradaService movimentacaoEntradaService;
    @Autowired
    private UsuarioService usuarioService;
    private ObservableList<MovimentacaoEntrada> movimentacaoEntradaList;

    public void initialize(URL url, ResourceBundle rb) {
        this.tfInicio.setValue((Object)LocalDate.now());
        this.tfFim.setValue((Object)LocalDate.now());
        this.movimentacaoEntradaList = FXCollections.observableArrayList();
        this.tabela.setOnMouseClicked(event -> {
            if (event.getClickCount() == 2) {
                // empty if block
            }
        });
        this.carregaIcones();
        this.setColumnProperties();
        this.loadTabela();
        this.registraAcoes();
        this.carregaCombos();
    }

    public void inicializa() {
        this.acoes = this.usuarioService.acoes(this.stageManager.getUsuario(), PermissaoControle.Recebimento);
    }

    private void novoRecebimento() {
        if (!PermissaoControleValida.acaoPermitida((StageManager)this.stageManager, (List)this.acoes, (PermissaoControleAcao)PermissaoControleAcao.ADD).booleanValue()) {
            return;
        }
        try {
            Stage form = new MaximaDialogFX().createWindowForm(this.stageManager, "/fxml/financeiro/movimentacaoEntrada/RecebimentoDiretoForm.fxml", "Novo Recebimento");
            RecebimentoDiretoFormController controller = (RecebimentoDiretoFormController)form.getUserData();
            controller.inicializa(null);
            form.showAndWait();
            this.loadTabela();
        }
        catch (IOException ex) {
            Logger.getLogger(MovimentacaoEntradaController.class.getName()).log(Level.SEVERE, null, ex);
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"ERRO: N\u00e3o foi poss\u00edvel abrir o m\u00f3dulo de novo recebimento.");
        }
    }

    private void estornaRecebimento() {
        if (!PermissaoControleValida.acaoPermitida((StageManager)this.stageManager, (List)this.acoes, (PermissaoControleAcao)PermissaoControleAcao.DELETE).booleanValue()) {
            return;
        }
        MovimentacaoEntrada recebimento = (MovimentacaoEntrada)this.tabela.getSelectionModel().getSelectedItem();
        if (recebimento == null) {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"Selecione um recebimento para estornar.");
            return;
        }
        if (MaximaAlert.SIM_NAO((StageManager)this.stageManager, (String)"Deseja estornar o recebimento selecionado?")) {
            try {
                this.movimentacaoEntradaService.estorna(recebimento);
                MaximaAlert.informe((StageManager)this.stageManager, (String)"Recebimento estornado com sucesso.");
                this.loadTabela();
            }
            catch (MaximaValidacaoException ex) {
                Logger.getLogger(MovimentacaoEntradaController.class.getName()).log(Level.SEVERE, null, ex);
                MaximaAlert.aviso((StageManager)this.stageManager, (String)ex.getMessage());
            }
        }
    }

    private void setColumnProperties() {
        this.colDataRecebimento.setCellValueFactory((Callback)new PropertyValueFactory("dataMovimento"));
        this.colCliente.setCellValueFactory((Callback)new PropertyValueFactory("cliente"));
        this.colHistorico.setCellValueFactory((Callback)new PropertyValueFactory("historico"));
        this.colFormaPagamento.setCellValueFactory((Callback)new PropertyValueFactory("formaPagamentoDesc"));
        this.colValor.setCellValueFactory((Callback)new PropertyValueFactory("total"));
        this.colValorLiquido.setCellValueFactory((Callback)new PropertyValueFactory("valorLiquido"));
        this.colDataRecebimento.setCellFactory((Callback)new ColumnDateFormatter());
        this.colValor.setCellFactory((Callback)new ColumnNumberFormatter());
        this.colValorLiquido.setCellFactory((Callback)new ColumnNumberFormatter());
        this.lblTotal.setAlignment(Pos.CENTER_RIGHT);
    }

    private void loadTabela() {
        this.movimentacaoEntradaList.clear();
        LocalDate inicio = (LocalDate)this.tfInicio.getValue();
        LocalDate fim = (LocalDate)this.tfFim.getValue();
        if (inicio == null || fim == null) {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"Informe a data de in\u00edcio e fim para pesquisa.");
            return;
        }
        if (inicio.isAfter(fim)) {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"A data de in\u00edcio deve ser igual ou anterior a data final.");
            return;
        }
        String filtro = "%";
        if (this.tfFiltro.getText() != null) {
            filtro = filtro + this.tfFiltro.getText().trim();
        }
        filtro = filtro + "%";
        List list = this.movimentacaoEntradaService.lista(inicio, fim, filtro, (FormaPagamento)this.cbbFormaPagamento.getSelectionModel().getSelectedItem());
        this.movimentacaoEntradaList.addAll((Collection)list);
        this.tabela.setItems(this.movimentacaoEntradaList);
        BigDecimal total = BigDecimal.ZERO;
        BigDecimal totalLiquido = BigDecimal.ZERO;
        for (MovimentacaoEntrada entrada : this.movimentacaoEntradaList) {
            total = total.add(entrada.getTotal());
            totalLiquido = totalLiquido.add(entrada.getValorLiquido());
        }
        this.lblTotal.setText("VALOR TOTAL: R$ " + MaximaNumber.bigDecimalToString((BigDecimal)total, (int)2));
        this.lblTotal.setText("BRUTO: R$ " + MaximaNumber.bigDecimalToString((BigDecimal)(total != null ? total : BigDecimal.ZERO), (int)2) + " | L\u00cdQUIDO: R$ " + MaximaNumber.bigDecimalToString((BigDecimal)(totalLiquido != null ? totalLiquido : total), (int)2));
    }

    private void carregaIcones() {
        MaximaIcone maximaIcone = new MaximaIcone();
        this.btnPesquisa.setGraphic((Node)maximaIcone.getPesquisa());
        this.btnEstorna.setGraphic((Node)maximaIcone.getIconeDelete());
    }

    private void registraAcoes() {
        this.tfFiltro.setOnKeyPressed(evt -> {
            if (evt.getCode() == KeyCode.ENTER) {
                this.loadTabela();
            }
        });
        this.btnPesquisa.setOnAction(t -> this.loadTabela());
        this.btnEstorna.setOnAction(event -> this.estornaRecebimento());
        this.btnRecebimento.setOnAction(event -> this.novoRecebimento());
        this.btnImprime.setOnAction(event -> {
            try {
                MovimentacaoEntrada recebimento = (MovimentacaoEntrada)this.tabela.getSelectionModel().getSelectedItem();
                if (recebimento == null) {
                    MaximaAlert.aviso((StageManager)this.stageManager, (String)"Selecione um recebimento para imprimir.");
                    return;
                }
                this.movimentacaoEntradaService.imprimeComprovante(recebimento);
            }
            catch (MaximaValidacaoException ex) {
                Logger.getLogger(MovimentacaoEntradaController.class.getName()).log(Level.SEVERE, null, ex);
                MaximaAlert.aviso((StageManager)this.stageManager, (String)ex.getMessage());
            }
        });
    }

    private void carregaCombos() {
        this.cbbFormaPagamento.setItems(FXCollections.observableArrayList((Collection)FormaPagamentoUtils.listCombo()));
    }
}

