/*
 * Decompiled with CFR 0.152.
 */
package br.com.maximasolutions.financeiro.controller;

import br.com.maximasolutions.administrativo.core.PermissaoControleValida;
import br.com.maximasolutions.administrativo.modelo.PermissaoControle;
import br.com.maximasolutions.administrativo.modelo.PermissaoControleAcao;
import br.com.maximasolutions.administrativo.service.UsuarioService;
import br.com.maximasolutions.config.StageManager;
import br.com.maximasolutions.core.MaximaAlert;
import br.com.maximasolutions.core.MaximaController;
import br.com.maximasolutions.core.MaximaDialogFX;
import br.com.maximasolutions.core.MaximaIcone;
import br.com.maximasolutions.core.MaximaValidacaoException;
import br.com.maximasolutions.financeiro.modelo.FormaPagamento;
import br.com.maximasolutions.financeiro.modelo.MovimentacaoSaida;
import br.com.maximasolutions.financeiro.service.MovimentacaoSaidaService;
import br.com.maximasolutions.financeiro.utils.FormaPagamentoUtils;
import br.com.maximasolutions.javafx.formatter.ColumnDateFormatter;
import br.com.maximasolutions.javafx.formatter.ColumnNumberFormatter;
import br.com.maximasolutions.utils.MaximaNumber;
import java.io.IOException;
import java.math.BigDecimal;
import java.net.URL;
import java.time.LocalDate;
import java.util.Collection;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.DatePicker;
import javafx.scene.control.Label;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.input.KeyCode;
import javafx.stage.Stage;
import javafx.util.Callback;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Controller;

@Controller
public class MovimentacaoSaidaController
extends MaximaController
implements Initializable {
    @FXML
    private TableView<MovimentacaoSaida> tabela;
    @FXML
    private TableColumn<MovimentacaoSaida, String> colDataPagamento;
    @FXML
    private TableColumn<MovimentacaoSaida, String> colFornecedor;
    @FXML
    private TableColumn<MovimentacaoSaida, String> colFormaPagamento;
    @FXML
    private TableColumn<MovimentacaoSaida, String> colHistorico;
    @FXML
    private TableColumn<MovimentacaoSaida, BigDecimal> colValor;
    @FXML
    private DatePicker tfInicio;
    @FXML
    private DatePicker tfFim;
    @FXML
    private TextField tfFiltro;
    @FXML
    private ComboBox<FormaPagamento> cbbFormaPagamento;
    @FXML
    private Button btnPesquisa;
    @FXML
    private Button btnEstorna;
    @FXML
    private Button btnNovo;
    @FXML
    private Label lblTotal;
    @Lazy
    @Autowired
    private StageManager stageManager;
    @Autowired
    private MovimentacaoSaidaService movimentacaoSaidaService;
    @Autowired
    private UsuarioService usuarioService;
    private ObservableList<MovimentacaoSaida> movimentacaoSaidaList;

    public void initialize(URL url, ResourceBundle rb) {
        this.carregaIcones();
        this.tfInicio.setValue((Object)LocalDate.now());
        this.tfFim.setValue((Object)LocalDate.now());
        this.movimentacaoSaidaList = FXCollections.observableArrayList();
        this.tabela.setOnMouseClicked(event -> {
            if (event.getClickCount() == 2) {
                // empty if block
            }
        });
        this.setColumnProperties();
        this.loadTabela();
        this.registraAcoes();
        this.carregaCombos();
    }

    public void inicializa() {
        this.acoes = this.usuarioService.acoes(this.stageManager.getUsuario(), PermissaoControle.Pagamento);
    }

    private void novoPagamento() {
        if (!PermissaoControleValida.acaoPermitida((StageManager)this.stageManager, (List)this.acoes, (PermissaoControleAcao)PermissaoControleAcao.ADD).booleanValue()) {
            return;
        }
        try {
            Stage pagamentoForm = new MaximaDialogFX().createWindowForm(this.stageManager, "/fxml/financeiro/movimentacaoSaida/PagamentoDiretoForm.fxml", "Novo Pagamento");
            pagamentoForm.showAndWait();
            this.loadTabela();
        }
        catch (IOException ex) {
            Logger.getLogger(MovimentacaoSaidaController.class.getName()).log(Level.SEVERE, null, ex);
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"Ocorreu um erro ao abrir m\u00f3dulo de novo pagamento.");
        }
    }

    private void estornaPagamento() {
        if (!PermissaoControleValida.acaoPermitida((StageManager)this.stageManager, (List)this.acoes, (PermissaoControleAcao)PermissaoControleAcao.DELETE).booleanValue()) {
            return;
        }
        MovimentacaoSaida recebimento = (MovimentacaoSaida)this.tabela.getSelectionModel().getSelectedItem();
        if (recebimento == null) {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"Selecione um pagamento para estornar.");
            return;
        }
        try {
            if (MaximaAlert.SIM_NAO_CANCELA((StageManager)this.stageManager, (String)"Deseja estornar o pagamento selecionado?")) {
                try {
                    this.movimentacaoSaidaService.estorna(recebimento);
                    MaximaAlert.informe((StageManager)this.stageManager, (String)"Pagamento estornado com sucesso.");
                    this.loadTabela();
                }
                catch (MaximaValidacaoException ex) {
                    Logger.getLogger(MovimentacaoSaidaController.class.getName()).log(Level.SEVERE, null, ex);
                    MaximaAlert.aviso((StageManager)this.stageManager, (String)ex.getMessage());
                }
            }
        }
        catch (MaximaValidacaoException ex) {
            Logger.getLogger(MovimentacaoSaidaController.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void setColumnProperties() {
        this.colDataPagamento.setCellValueFactory((Callback)new PropertyValueFactory("dataMovimento"));
        this.colFornecedor.setCellValueFactory((Callback)new PropertyValueFactory("fornecedor"));
        this.colHistorico.setCellValueFactory((Callback)new PropertyValueFactory("historico"));
        this.colFormaPagamento.setCellValueFactory((Callback)new PropertyValueFactory("formaPagamento"));
        this.colValor.setCellValueFactory((Callback)new PropertyValueFactory("total"));
        this.colDataPagamento.setCellFactory((Callback)new ColumnDateFormatter());
        this.colValor.setCellFactory((Callback)new ColumnNumberFormatter());
        this.lblTotal.setAlignment(Pos.CENTER_RIGHT);
    }

    private void loadTabela() {
        this.movimentacaoSaidaList.clear();
        LocalDate inicio = (LocalDate)this.tfInicio.getValue();
        LocalDate fim = (LocalDate)this.tfFim.getValue();
        if (inicio == null || fim == null) {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"Informe a data de in\u00edcio e fim para pesquisa.");
            return;
        }
        if (inicio.isAfter(fim)) {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"A data de in\u00edcio deve ser igual ou anterior a data final.");
            return;
        }
        String filtro = "%";
        if (this.tfFiltro.getText() != null) {
            filtro = filtro + this.tfFiltro.getText().trim();
        }
        filtro = filtro + "%";
        List list = this.movimentacaoSaidaService.lista(inicio, fim, filtro, (FormaPagamento)this.cbbFormaPagamento.getSelectionModel().getSelectedItem());
        this.movimentacaoSaidaList.addAll((Collection)list);
        this.tabela.setItems(this.movimentacaoSaidaList);
        BigDecimal total = BigDecimal.ZERO;
        for (MovimentacaoSaida saida : this.movimentacaoSaidaList) {
            total = total.add(saida.getTotal());
        }
        this.lblTotal.setText("VALOR TOTAL: R$ " + MaximaNumber.bigDecimalToString((BigDecimal)total, (int)2));
    }

    private void carregaIcones() {
        this.btnPesquisa.setGraphic((Node)new MaximaIcone().getPesquisa());
        this.btnEstorna.setGraphic((Node)new MaximaIcone().getIconeDelete());
        this.btnNovo.setGraphic((Node)new MaximaIcone().getIconeNovo());
    }

    private void registraAcoes() {
        this.btnNovo.setOnAction(t -> this.novoPagamento());
        this.btnPesquisa.setOnAction(t -> this.loadTabela());
        this.btnEstorna.setOnAction(event -> this.estornaPagamento());
        this.tfFiltro.setOnKeyPressed(event -> {
            if (event.getCode() == KeyCode.ENTER) {
                this.loadTabela();
            }
        });
    }

    private void carregaCombos() {
        this.cbbFormaPagamento.setItems(FXCollections.observableArrayList((Collection)FormaPagamentoUtils.listCombo()));
    }
}

