/*
 * Decompiled with CFR 0.152.
 */
package br.com.maximasolutions.financeiro.controller;

import br.com.maximasolutions.config.StageManager;
import br.com.maximasolutions.core.MaximaAlert;
import br.com.maximasolutions.core.MaximaController;
import br.com.maximasolutions.core.MaximaIcone;
import br.com.maximasolutions.core.MaximaValidacaoException;
import br.com.maximasolutions.financeiro.modelo.Conta;
import br.com.maximasolutions.financeiro.modelo.ContaPagarParcela;
import br.com.maximasolutions.financeiro.modelo.FormaPagamento;
import br.com.maximasolutions.financeiro.modelo.MovimentacaoSaida;
import br.com.maximasolutions.financeiro.service.CondicaoRecebimentoService;
import br.com.maximasolutions.financeiro.service.ContaPagarParcelaService;
import br.com.maximasolutions.financeiro.service.ContaService;
import br.com.maximasolutions.financeiro.service.MovimentacaoSaidaService;
import br.com.maximasolutions.financeiro.utils.FormaPagamentoUtils;
import br.com.maximasolutions.utils.MaximaMask;
import br.com.maximasolutions.utils.MaximaNumber;
import br.com.maximasolutions.utils.MaximaUtils;
import java.math.BigDecimal;
import java.net.URL;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Collection;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.collections.FXCollections;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.DatePicker;
import javafx.scene.control.TextField;
import javafx.stage.Stage;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Controller;

@Controller
public class PagamentoFormController
extends MaximaController
implements Initializable {
    @Lazy
    @Autowired
    private StageManager stageManager;
    @FXML
    private TextField tfFornecedor;
    @FXML
    private TextField tfId;
    @FXML
    private TextField tfCentroCusto;
    @FXML
    private TextField tfDataVencimento;
    @FXML
    private TextField tfValorParcela;
    @FXML
    private TextField tfValorPendente;
    @FXML
    private TextField tfHistorico;
    @FXML
    private TextField tfJuros;
    @FXML
    private TextField tfDesconto;
    @FXML
    private TextField tfValorPagar;
    @FXML
    private TextField tfValorPago;
    @FXML
    private TextField tfHistoricoPagamento;
    @FXML
    private ComboBox<FormaPagamento> cbbFormaPagamento;
    @FXML
    private ComboBox<Conta> cbbConta;
    @FXML
    private DatePicker tfDataPagamento;
    @FXML
    private Button btnSalva;
    @Autowired
    private ContaPagarParcelaService contaPagarParcelaService;
    @Autowired
    private CondicaoRecebimentoService condicaoPagamentoService;
    @Autowired
    private MovimentacaoSaidaService movimentacaoSaidaService;
    @Autowired
    private ContaService contaService;
    private ContaPagarParcela contaPagarParcela;

    public void initialize(URL url, ResourceBundle rb) {
        this.carregaIcones();
        this.registraAcoes();
        this.carregaCombos();
        this.carregaMascaras();
    }

    public void inicializa(ContaPagarParcela crp) {
        this.contaPagarParcela = this.contaPagarParcelaService.load(crp.getId());
        if (this.contaPagarParcela != null) {
            this.tfId.setText(this.contaPagarParcela.getId().toString());
            this.tfFornecedor.setText(this.contaPagarParcela.getFornecedor().getNome());
            this.tfCentroCusto.setText(this.contaPagarParcela.getCentroCusto().getNome().toUpperCase());
            this.tfDataVencimento.setText(this.contaPagarParcela.getDataVencimento().format(DateTimeFormatter.ofPattern("dd/MM/yyyy")));
            this.tfValorParcela.setText(MaximaNumber.bigDecimalToString((BigDecimal)this.contaPagarParcela.getValor(), (int)2));
            this.tfValorPendente.setText(MaximaNumber.bigDecimalToString((BigDecimal)this.contaPagarParcela.getValorPendente(), (int)2));
            this.tfHistorico.setText(this.contaPagarParcela.getHistorico());
            this.tfHistoricoPagamento.setText(this.contaPagarParcela.getHistorico());
        }
        this.calculaValorPagar();
    }

    private void salva() {
        Boolean lancarMovimentoCaixa;
        MovimentacaoSaida recebimento = this.createPagamento();
        if (!this.validaPagamento(recebimento)) {
            return;
        }
        try {
            lancarMovimentoCaixa = MaximaAlert.SIM_NAO_CANCELA((StageManager)this.stageManager, (String)"Deseja lan\u00e7ar o pagamento no movimento de caixa?");
        }
        catch (MaximaValidacaoException ex) {
            return;
        }
        try {
            this.movimentacaoSaidaService.pagaParcela(this.contaPagarParcela, recebimento, lancarMovimentoCaixa, (Conta)this.cbbConta.getSelectionModel().getSelectedItem());
            MaximaAlert.informe((StageManager)this.stageManager, (String)"Pagamento efetuado com sucesso.");
            this.closeForm();
        }
        catch (MaximaValidacaoException ex) {
            Logger.getLogger(PagamentoFormController.class.getName()).log(Level.SEVERE, null, ex);
            MaximaAlert.aviso((StageManager)this.stageManager, (String)ex.getMessage());
        }
    }

    private void calculaValorPagar() {
        BigDecimal valorPendente = this.contaPagarParcela.getValorPendente();
        BigDecimal valorJuros = MaximaNumber.moneyToBigDecimal((String)this.tfJuros.getText());
        BigDecimal valorDesconto = MaximaNumber.moneyToBigDecimal((String)this.tfDesconto.getText());
        BigDecimal valorPagar = valorPendente.add(valorJuros).subtract(valorDesconto);
        this.tfValorPagar.setText(MaximaNumber.bigDecimalToString((BigDecimal)valorPagar, (int)2));
    }

    private boolean validaPagamento(MovimentacaoSaida pag) {
        String msgError = "";
        Boolean valido = true;
        if (pag.getFormaPagamento() == null) {
            this.cbbFormaPagamento.getStyleClass().add((Object)"error");
            valido = false;
        } else {
            this.cbbFormaPagamento.getStyleClass().remove((Object)"error");
        }
        if (pag.getDataMovimento() == null) {
            this.tfDataPagamento.getStyleClass().add((Object)"error");
            valido = false;
        } else {
            this.tfDataPagamento.getStyleClass().remove((Object)"error");
        }
        BigDecimal valorRecebido = MaximaNumber.moneyToBigDecimal((String)this.tfValorPago.getText());
        BigDecimal valorPagar = MaximaNumber.moneyToBigDecimal((String)this.tfValorPagar.getText());
        if (valorRecebido == null) {
            this.tfValorPago.getStyleClass().add((Object)"error");
            valido = false;
        } else {
            this.tfValorPago.getStyleClass().remove((Object)"error");
            if (pag.getJuros().compareTo(BigDecimal.ZERO) > 0 || pag.getDesconto().compareTo(BigDecimal.ZERO) > 0) {
                if (pag.getTotal().compareTo(valorPagar) != 0) {
                    msgError = msgError + "O valor pago deve ser igual ao valor a pagar (Devido ao preenchimento de juros e/ou desconto).\n";
                }
            } else {
                if (valorPagar.compareTo(BigDecimal.ZERO) > 0) {
                    if (valorRecebido.compareTo(BigDecimal.ZERO) <= 0) {
                        this.tfValorPago.getStyleClass().add((Object)"error");
                        valido = false;
                    } else {
                        this.tfValorPago.getStyleClass().remove((Object)"error");
                    }
                }
                if (valorRecebido.compareTo(valorPagar) > 0) {
                    msgError = msgError + "O valor pago n\u00e3o pode ser maior que o valor a pagar.\n";
                }
                if (valido.booleanValue() && valorRecebido.compareTo(valorPagar) < 0 && !MaximaAlert.SIM_NAO((StageManager)this.stageManager, (String)"Deseja efetuar pagamento PARCIAL da parcela?")) {
                    valido = false;
                }
            }
        }
        if (!msgError.isEmpty()) {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)msgError);
            valido = false;
        }
        return valido;
    }

    private void carregaCombos() {
        this.cbbFormaPagamento.setItems(FXCollections.observableArrayList((Collection)FormaPagamentoUtils.listCombo()));
        this.cbbConta.setItems(FXCollections.observableArrayList((Collection)this.contaService.combo()));
    }

    private void carregaIcones() {
        this.btnSalva.setGraphic((Node)new MaximaIcone().getIconeConfirma());
    }

    private void carregaMascaras() {
        MaximaMask.monetaryField((TextField)this.tfJuros);
        MaximaMask.monetaryField((TextField)this.tfDesconto);
        MaximaMask.monetaryField((TextField)this.tfValorPago);
    }

    private void registraAcoes() {
        this.btnSalva.setOnAction(event -> this.salva());
        this.tfJuros.setOnKeyReleased(event -> this.calculaValorPagar());
        this.tfJuros.focusedProperty().addListener((ov, oldV, newV) -> this.calculaValorPagar());
        this.tfDesconto.setOnKeyReleased(event -> this.calculaValorPagar());
        this.tfDesconto.focusedProperty().addListener((ov, oldV, newV) -> this.calculaValorPagar());
    }

    private void closeForm() {
        Stage stage = (Stage)this.btnSalva.getScene().getWindow();
        stage.close();
    }

    private MovimentacaoSaida createPagamento() {
        MovimentacaoSaida rec = new MovimentacaoSaida();
        rec.setFornecedor(this.contaPagarParcela.getContaPagar().getFornecedor());
        rec.setContaPagarParcela(this.contaPagarParcela);
        rec.setDataOperacao(LocalDateTime.now());
        rec.setDataMovimento((LocalDate)this.tfDataPagamento.getValue());
        rec.setDesconto(MaximaNumber.moneyToBigDecimal((String)this.tfDesconto.getText()));
        rec.setEstornada(Boolean.FALSE);
        rec.setFormaPagamento((FormaPagamento)this.cbbFormaPagamento.getSelectionModel().getSelectedItem());
        rec.setHistorico(MaximaUtils.getText((String)this.tfHistoricoPagamento.getText()));
        rec.setJuros(MaximaNumber.moneyToBigDecimal((String)this.tfJuros.getText()));
        rec.setTotal(MaximaNumber.moneyToBigDecimal((String)this.tfValorPago.getText()));
        rec.setValor(rec.getTotal().add(rec.getDesconto()).subtract(rec.getJuros()));
        return rec;
    }
}

