/*
 * Decompiled with CFR 0.152.
 */
package br.com.maximasolutions.financeiro.controller;

import br.com.maximasolutions.administrativo.modelo.Configuracao;
import br.com.maximasolutions.administrativo.service.ConfiguracaoService;
import br.com.maximasolutions.config.StageManager;
import br.com.maximasolutions.core.ImpressoraModelo;
import br.com.maximasolutions.core.MaximaAlert;
import br.com.maximasolutions.core.MaximaController;
import br.com.maximasolutions.core.MaximaIcone;
import br.com.maximasolutions.core.MaximaImpressao;
import br.com.maximasolutions.core.MaximaValidacaoException;
import br.com.maximasolutions.estoque.modelo.VendaProduto;
import br.com.maximasolutions.estoque.service.VendaProdutoService;
import br.com.maximasolutions.financeiro.controller.PagamentoFormController;
import br.com.maximasolutions.financeiro.modelo.CentroCusto;
import br.com.maximasolutions.financeiro.modelo.Conta;
import br.com.maximasolutions.financeiro.modelo.ContaReceber;
import br.com.maximasolutions.financeiro.modelo.ContaReceberParcela;
import br.com.maximasolutions.financeiro.modelo.FormaPagamento;
import br.com.maximasolutions.financeiro.modelo.MovimentacaoEntrada;
import br.com.maximasolutions.financeiro.printer.RecebimentoPrinter;
import br.com.maximasolutions.financeiro.service.CentroCustoService;
import br.com.maximasolutions.financeiro.service.ContaService;
import br.com.maximasolutions.financeiro.service.MovimentacaoEntradaService;
import br.com.maximasolutions.financeiro.utils.FormaPagamentoUtils;
import br.com.maximasolutions.geral.form.ClientePesquisaForm;
import br.com.maximasolutions.geral.modelo.Cliente;
import br.com.maximasolutions.geral.service.ClienteService;
import br.com.maximasolutions.utils.MaximaMask;
import br.com.maximasolutions.utils.MaximaNumber;
import br.com.maximasolutions.utils.MaximaUtils;
import java.math.BigDecimal;
import java.net.URL;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.collections.FXCollections;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.DatePicker;
import javafx.scene.control.TextField;
import javafx.scene.input.KeyCode;
import javafx.stage.Stage;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Controller;

@Controller
public class RecebimentoDiretoFormController
extends MaximaController
implements Initializable {
    @FXML
    private TextField tfClienteCodigo;
    @FXML
    private TextField tfClienteDescricao;
    @FXML
    private TextField tfDesconto;
    @FXML
    private TextField tfJuros;
    @FXML
    private TextField tfValor;
    @FXML
    private TextField tfValorTotal;
    @FXML
    private TextField tfHistorico;
    @FXML
    private TextField tfNumeroNota;
    @FXML
    private DatePicker tfDataLancamento;
    @FXML
    private DatePicker tfDataVencimento;
    @FXML
    private ComboBox<CentroCusto> cbbCentroCusto;
    @FXML
    private ComboBox<FormaPagamento> cbbFormaPagamento;
    @FXML
    private ComboBox<Conta> cbbContaMovimento;
    @FXML
    private Button btnSalva;
    @FXML
    private Button btnCliente;
    private Cliente cliente;
    @Autowired
    private ClienteService clienteService;
    @Autowired
    private MovimentacaoEntradaService movimentacaoEntradaService;
    @Autowired
    private CentroCustoService centroCustoService;
    @Autowired
    private ContaService contaService;
    @Autowired
    private ConfiguracaoService configuracaoService;
    @Autowired
    private VendaProdutoService vendaProdutoService;
    @Autowired
    @Lazy
    private StageManager stageManager;

    public void initialize(URL url, ResourceBundle rb) {
        this.carregaIcones();
        this.registraAcoes();
        this.carregaCombos();
        this.carregaMascaras();
    }

    public void inicializa(ContaReceberParcela cpp) {
        this.tfDataLancamento.setValue((Object)LocalDate.now());
        this.tfClienteCodigo.requestFocus();
        Configuracao conf = this.configuracaoService.load();
        this.tfDataLancamento.setValue((Object)LocalDate.now());
        this.tfDataVencimento.setValue((Object)LocalDate.now());
        if (conf.getFixarDataRecebimento().booleanValue()) {
            this.tfDataLancamento.setDisable(true);
            this.tfDataVencimento.setDisable(true);
        }
    }

    private void salva() {
        MovimentacaoEntrada recebimento;
        Boolean lancarMovimentoCaixa;
        if (!this.valida()) {
            return;
        }
        try {
            lancarMovimentoCaixa = MaximaAlert.SIM_NAO_CANCELA((StageManager)this.stageManager, (String)"Deseja lan\u00e7ar o recebimento no movimento de caixa?");
        }
        catch (MaximaValidacaoException ex) {
            return;
        }
        try {
            ContaReceber contaReceber = this.createContaReceber();
            ContaReceberParcela parcela = this.createParcela(contaReceber);
            recebimento = this.movimentacaoEntradaService.recebimentoDireto(contaReceber, parcela, this.createRecebimento(parcela), lancarMovimentoCaixa, (Conta)this.cbbContaMovimento.getSelectionModel().getSelectedItem());
            MaximaAlert.informe((StageManager)this.stageManager, (String)"Recebimento efetuado com sucesso.");
            Stage stage = (Stage)this.btnSalva.getScene().getWindow();
            stage.close();
        }
        catch (MaximaValidacaoException ex) {
            Logger.getLogger(PagamentoFormController.class.getName()).log(Level.SEVERE, null, ex);
            MaximaAlert.aviso((StageManager)this.stageManager, (String)ex.getMessage());
            return;
        }
        if (MaximaAlert.SIM_NAO((StageManager)this.stageManager, (String)"Deseja imprimir o comprovante?")) {
            Configuracao conf = this.configuracaoService.load();
            if (conf.getImpressoraModelo().equals((Object)ImpressoraModelo.A4)) {
                try {
                    this.movimentacaoEntradaService.imprimeComprovante(recebimento);
                }
                catch (MaximaValidacaoException maximaValidacaoException) {
                    MaximaAlert.aviso((StageManager)this.stageManager, (String)maximaValidacaoException.getMessage());
                }
            } else {
                String comprovante = RecebimentoPrinter.comprovante((Configuracao)conf, (MovimentacaoEntrada)recebimento, (VendaProduto)this.vendaProdutoService.getByContaReceber(recebimento.getContaReceberParcela().getContaReceber()));
                try {
                    new MaximaImpressao(conf).printText(comprovante);
                }
                catch (MaximaValidacaoException maximaValidacaoException) {
                    // empty catch block
                }
            }
        }
    }

    private void carregaMascaras() {
        MaximaMask.monetaryField((TextField)this.tfValor);
        MaximaMask.monetaryField((TextField)this.tfDesconto);
        MaximaMask.monetaryField((TextField)this.tfJuros);
        MaximaMask.monetaryField((TextField)this.tfValorTotal);
    }

    private void pesquisaCliente() {
        String clienteCodigo = this.tfClienteCodigo.getText().trim();
        if (clienteCodigo.isEmpty()) {
            return;
        }
        try {
            Long clienteCodigoNumero = Long.valueOf(clienteCodigo);
            Cliente clientePesquisa = this.clienteService.getById(clienteCodigoNumero);
            if (clientePesquisa != null) {
                this.cliente = clientePesquisa;
                this.loadDadosCliente();
                return;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        this.pesquisaClienteForm();
    }

    private void pesquisaClienteForm() {
        this.cliente = new ClientePesquisaForm().getCliente(this.stageManager, this.btnCliente.getScene(), this.tfClienteCodigo.getText());
        this.loadDadosCliente();
    }

    private void loadDadosCliente() {
        if (this.cliente != null) {
            this.tfClienteCodigo.setText(this.cliente.getId().toString());
            this.tfClienteDescricao.setText(this.cliente.getNome().toUpperCase());
            this.tfDataLancamento.requestFocus();
        } else {
            this.tfClienteCodigo.setText("");
            this.tfClienteDescricao.setText("");
            this.tfClienteCodigo.requestFocus();
        }
    }

    private void carregaCombos() {
        this.cbbCentroCusto.setItems(FXCollections.observableArrayList((Collection)this.centroCustoService.combo()));
        this.cbbContaMovimento.setItems(FXCollections.observableArrayList((Collection)this.contaService.combo()));
        this.cbbFormaPagamento.setItems(FXCollections.observableArrayList((Collection)FormaPagamentoUtils.listCombo()));
    }

    private void carregaIcones() {
        this.btnSalva.setGraphic((Node)new MaximaIcone().getIconeConfirma());
        this.btnCliente.setGraphic((Node)new MaximaIcone().getPesquisa());
    }

    private void calculaTotal() {
        BigDecimal valorParcela = MaximaNumber.moneyToBigDecimal((String)this.tfValor.getText());
        BigDecimal desconto = MaximaNumber.moneyToBigDecimal((String)this.tfDesconto.getText());
        BigDecimal juros = MaximaNumber.moneyToBigDecimal((String)this.tfJuros.getText());
        if (valorParcela == null) {
            return;
        }
        if (desconto == null) {
            desconto = BigDecimal.ZERO;
        }
        if (juros == null) {
            juros = BigDecimal.ZERO;
        }
        BigDecimal total = valorParcela.subtract(desconto).add(juros);
        this.tfValorTotal.setText(MaximaNumber.bigDecimalToString((BigDecimal)total, (int)2));
    }

    private void registraAcoes() {
        this.btnSalva.setOnAction(event -> this.salva());
        this.btnCliente.setOnAction(event -> this.pesquisaClienteForm());
        this.tfClienteCodigo.setOnKeyPressed(event -> {
            if (event.getCode() == KeyCode.ENTER) {
                this.pesquisaCliente();
            }
        });
        this.tfValor.setOnKeyReleased(t -> this.calculaTotal());
        this.tfDesconto.setOnKeyReleased(t -> this.calculaTotal());
        this.tfJuros.setOnKeyReleased(t -> this.calculaTotal());
    }

    private boolean valida() {
        String msgError = "";
        Boolean valido = true;
        if (this.cliente == null) {
            this.tfClienteCodigo.getStyleClass().add((Object)"error");
            this.tfClienteDescricao.getStyleClass().add((Object)"error");
            valido = false;
        } else {
            this.tfClienteCodigo.getStyleClass().remove((Object)"error");
            this.tfClienteDescricao.getStyleClass().remove((Object)"error");
        }
        if (this.tfDataLancamento.getValue() == null) {
            this.tfDataLancamento.getStyleClass().add((Object)"error");
            valido = false;
        } else {
            this.tfDataLancamento.getStyleClass().remove((Object)"error");
        }
        if (this.cbbCentroCusto.getSelectionModel().getSelectedItem() == null) {
            this.cbbCentroCusto.getStyleClass().add((Object)"error");
            valido = false;
        } else {
            this.cbbCentroCusto.getStyleClass().remove((Object)"error");
        }
        if (this.tfDataVencimento.getValue() == null) {
            this.tfDataVencimento.getStyleClass().add((Object)"error");
            valido = false;
        } else {
            this.tfDataVencimento.getStyleClass().remove((Object)"error");
        }
        BigDecimal valorParcela = MaximaNumber.moneyToBigDecimal((String)this.tfValor.getText());
        if (valorParcela == null || valorParcela.compareTo(BigDecimal.ZERO) <= 0) {
            this.tfValor.getStyleClass().add((Object)"error");
            valido = false;
        } else {
            this.tfValor.getStyleClass().remove((Object)"error");
        }
        BigDecimal valorTotal = MaximaNumber.moneyToBigDecimal((String)this.tfValorTotal.getText());
        if (valorTotal == null || valorTotal.compareTo(BigDecimal.ZERO) <= 0) {
            this.tfValorTotal.getStyleClass().add((Object)"error");
            valido = false;
        } else {
            this.tfValorTotal.getStyleClass().remove((Object)"error");
        }
        return valido;
    }

    private ContaReceber createContaReceber() {
        ContaReceber contaReceber = new ContaReceber();
        contaReceber.setCentroCusto((CentroCusto)this.cbbCentroCusto.getSelectionModel().getSelectedItem());
        contaReceber.setCliente(this.cliente);
        contaReceber.setNumeroNota(MaximaUtils.getText((String)this.tfNumeroNota.getText()));
        contaReceber.setDataDocumento(LocalDate.now());
        return contaReceber;
    }

    private ContaReceberParcela createParcela(ContaReceber contaReceber) {
        ContaReceberParcela parcela = new ContaReceberParcela();
        parcela.setCentroCusto(contaReceber.getCentroCusto());
        parcela.setDataEmissao(LocalDateTime.now());
        parcela.setDataOperacao(LocalDateTime.now());
        parcela.setDataPagamento((LocalDate)this.tfDataVencimento.getValue());
        parcela.setDataVencimento((LocalDate)this.tfDataVencimento.getValue());
        parcela.setExcluido(Boolean.valueOf(false));
        parcela.setFormaPagamento((FormaPagamento)this.cbbFormaPagamento.getSelectionModel().getSelectedItem());
        parcela.setCliente(contaReceber.getCliente());
        parcela.setHistorico(MaximaUtils.getText((String)this.tfHistorico.getText()));
        parcela.setNumeroNota(contaReceber.getNumeroNota());
        parcela.setNumeroParcela("1/1");
        parcela.setRecebimentoEstornado(Boolean.valueOf(false));
        parcela.setQuitado(true);
        parcela.setValor(MaximaNumber.moneyToBigDecimal((String)this.tfValor.getText()));
        parcela.setValorPendente(BigDecimal.ZERO);
        parcela.setValorLiquido(MaximaNumber.moneyToBigDecimal((String)this.tfValor.getText()));
        return parcela;
    }

    private MovimentacaoEntrada createRecebimento(ContaReceberParcela contaReceberParcela) {
        MovimentacaoEntrada pagto = new MovimentacaoEntrada();
        pagto.setDireto(Boolean.valueOf(true));
        pagto.setCliente(this.cliente);
        pagto.setContaReceberParcela(contaReceberParcela);
        pagto.setDataOperacao(LocalDateTime.now());
        pagto.setDataMovimento((LocalDate)this.tfDataVencimento.getValue());
        pagto.setDesconto(MaximaNumber.moneyToBigDecimal((String)this.tfDesconto.getText()));
        pagto.setEstornada(Boolean.FALSE);
        pagto.setFormaPagamento((FormaPagamento)this.cbbFormaPagamento.getSelectionModel().getSelectedItem());
        pagto.setHistorico(MaximaUtils.getText((String)this.tfHistorico.getText()));
        pagto.setJuros(MaximaNumber.moneyToBigDecimal((String)this.tfJuros.getText()));
        pagto.setTotal(MaximaNumber.moneyToBigDecimal((String)this.tfValorTotal.getText()));
        pagto.setValor(pagto.getTotal().add(pagto.getDesconto()).subtract(pagto.getJuros()));
        pagto.setValorLiquido(pagto.getValor());
        return pagto;
    }
}

