/*
 * Decompiled with CFR 0.152.
 */
package br.com.maximasolutions.financeiro.controller;

import br.com.maximasolutions.administrativo.modelo.Configuracao;
import br.com.maximasolutions.administrativo.service.ConfiguracaoService;
import br.com.maximasolutions.config.StageManager;
import br.com.maximasolutions.core.ImpressoraModelo;
import br.com.maximasolutions.core.MaximaAlert;
import br.com.maximasolutions.core.MaximaController;
import br.com.maximasolutions.core.MaximaIcone;
import br.com.maximasolutions.core.MaximaImpressao;
import br.com.maximasolutions.core.MaximaValidacaoException;
import br.com.maximasolutions.estoque.modelo.VendaProduto;
import br.com.maximasolutions.estoque.service.VendaProdutoService;
import br.com.maximasolutions.financeiro.modelo.Conta;
import br.com.maximasolutions.financeiro.modelo.ContaReceberParcela;
import br.com.maximasolutions.financeiro.modelo.FormaPagamento;
import br.com.maximasolutions.financeiro.modelo.MovimentacaoEntrada;
import br.com.maximasolutions.financeiro.printer.RecebimentoPrinter;
import br.com.maximasolutions.financeiro.service.CondicaoRecebimentoService;
import br.com.maximasolutions.financeiro.service.ContaReceberParcelaService;
import br.com.maximasolutions.financeiro.service.ContaService;
import br.com.maximasolutions.financeiro.service.MovimentacaoEntradaService;
import br.com.maximasolutions.financeiro.utils.FormaPagamentoUtils;
import br.com.maximasolutions.utils.MaximaMask;
import br.com.maximasolutions.utils.MaximaNumber;
import br.com.maximasolutions.utils.MaximaUtils;
import java.math.BigDecimal;
import java.net.URL;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Collection;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.collections.FXCollections;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.DatePicker;
import javafx.scene.control.TextField;
import javafx.stage.Stage;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Controller;

@Controller
public class RecebimentoFormController
extends MaximaController
implements Initializable {
    @Lazy
    @Autowired
    private StageManager stageManager;
    @FXML
    private TextField tfCliente;
    @FXML
    private TextField tfClienteVale;
    @FXML
    private TextField tfId;
    @FXML
    private TextField tfCentroCusto;
    @FXML
    private TextField tfDataVencimento;
    @FXML
    private TextField tfValorParcela;
    @FXML
    private TextField tfValorPendente;
    @FXML
    private TextField tfHistorico;
    @FXML
    private TextField tfJuros;
    @FXML
    private TextField tfDesconto;
    @FXML
    private TextField tfValorReceber;
    @FXML
    private TextField tfValorRecebido;
    @FXML
    private TextField tfHistoricoRecebimento;
    @FXML
    private ComboBox<FormaPagamento> cbbFormaRecebimento;
    @FXML
    private ComboBox<Conta> cbbConta;
    @FXML
    private DatePicker tfDataRecebimento;
    @FXML
    private Button btnSalva;
    @Autowired
    private VendaProdutoService vendaProdutoService;
    @Autowired
    private CondicaoRecebimentoService condicaoPagamentoService;
    @Autowired
    private MovimentacaoEntradaService movimentacaoEntradaService;
    @Autowired
    private ContaService contaService;
    @Autowired
    private ConfiguracaoService configuracaoService;
    @Autowired
    private ContaReceberParcelaService contaReceberParcelaService;
    private ContaReceberParcela contaReceberParcela;

    public void initialize(URL url, ResourceBundle rb) {
        this.carregaIcones();
        this.registraAcoes();
        this.carregaCombos();
        this.carregaMascaras();
    }

    public void inicializa(ContaReceberParcela crp) {
        Configuracao conf;
        this.contaReceberParcela = this.contaReceberParcelaService.load(crp.getId());
        if (this.contaReceberParcela != null) {
            this.tfId.setText(this.contaReceberParcela.getId().toString());
            this.tfCliente.setText(this.contaReceberParcela.getCliente().getNome());
            this.tfClienteVale.setText(MaximaNumber.formataNumero((BigDecimal)this.contaReceberParcela.getCliente().getVale()));
            this.tfCentroCusto.setText(this.contaReceberParcela.getCentroCusto().getNome().toUpperCase());
            this.tfDataVencimento.setText(this.contaReceberParcela.getDataVencimento().format(DateTimeFormatter.ofPattern("dd/MM/yyyy")));
            this.tfValorParcela.setText(MaximaNumber.bigDecimalToString((BigDecimal)this.contaReceberParcela.getValor(), (int)2));
            this.tfValorPendente.setText(MaximaNumber.bigDecimalToString((BigDecimal)this.contaReceberParcela.getValorPendente(), (int)2));
            this.tfHistorico.setText(this.contaReceberParcela.getHistorico());
            this.tfHistoricoRecebimento.setText(this.contaReceberParcela.getHistorico());
            if (this.contaReceberParcela.getCliente().getVale().compareTo(BigDecimal.ZERO) > 0) {
                // empty if block
            }
        }
        if ((conf = this.configuracaoService.load()).getFixarDataRecebimento().booleanValue()) {
            this.tfDataRecebimento.setValue((Object)LocalDate.now());
            this.tfDataRecebimento.setDisable(true);
        }
        this.calculaValorReceber();
    }

    private void salva() {
        Boolean lancarMovimentoCaixa;
        MovimentacaoEntrada recebimento = this.createRecebimento();
        if (!this.validaRecebimento(recebimento)) {
            return;
        }
        try {
            lancarMovimentoCaixa = MaximaAlert.SIM_NAO_CANCELA((StageManager)this.stageManager, (String)"Deseja lan\u00e7ar o recebimento no movimento de caixa?");
        }
        catch (MaximaValidacaoException ex) {
            return;
        }
        try {
            recebimento = this.movimentacaoEntradaService.recebeParcela(this.contaReceberParcela, recebimento, lancarMovimentoCaixa, (Conta)this.cbbConta.getSelectionModel().getSelectedItem());
            MaximaAlert.informe((StageManager)this.stageManager, (String)"Recebimento efetuado com sucesso.");
            if (MaximaAlert.SIM_NAO((StageManager)this.stageManager, (String)"Deseja imprimir o comprovante?")) {
                Configuracao conf = this.configuracaoService.load();
                if (conf.getImpressoraModelo().equals((Object)ImpressoraModelo.A4)) {
                    try {
                        this.movimentacaoEntradaService.imprimeComprovante(recebimento);
                    }
                    catch (MaximaValidacaoException maximaValidacaoException) {
                        MaximaAlert.aviso((StageManager)this.stageManager, (String)maximaValidacaoException.getMessage());
                    }
                } else {
                    String comprovante = RecebimentoPrinter.comprovante((Configuracao)conf, (MovimentacaoEntrada)recebimento, (VendaProduto)this.vendaProdutoService.getByContaReceber(recebimento.getContaReceberParcela().getContaReceber()));
                    try {
                        new MaximaImpressao(conf).printText(comprovante);
                    }
                    catch (MaximaValidacaoException maximaValidacaoException) {
                        // empty catch block
                    }
                }
            }
            this.closeForm();
        }
        catch (MaximaValidacaoException ex) {
            Logger.getLogger(RecebimentoFormController.class.getName()).log(Level.SEVERE, null, ex);
            MaximaAlert.aviso((StageManager)this.stageManager, (String)ex.getMessage());
        }
    }

    private void calculaValorReceber() {
        BigDecimal valorPendente = this.contaReceberParcela.getValorPendente();
        BigDecimal valorJuros = MaximaNumber.moneyToBigDecimal((String)this.tfJuros.getText());
        BigDecimal valorDesconto = MaximaNumber.moneyToBigDecimal((String)this.tfDesconto.getText());
        BigDecimal valorReceber = valorPendente.add(valorJuros).subtract(valorDesconto);
        this.tfValorReceber.setText(MaximaNumber.bigDecimalToString((BigDecimal)valorReceber, (int)2));
    }

    private boolean validaRecebimento(MovimentacaoEntrada rec) {
        String msgError = "";
        if (rec.getCondicaoPagamento() == null && rec.getFormaPagamento() == null) {
            msgError = msgError + "Informe a forma de recebimento.\n";
        }
        if (rec.getDataMovimento() == null) {
            msgError = msgError + "Informe a data de recebimento.\n";
        }
        BigDecimal valorRecebido = MaximaNumber.moneyToBigDecimal((String)this.tfValorRecebido.getText());
        BigDecimal valorReceber = MaximaNumber.moneyToBigDecimal((String)this.tfValorReceber.getText());
        if (valorRecebido == null) {
            msgError = msgError + "Informe o valor recebido.\n";
        } else if (rec.getJuros().compareTo(BigDecimal.ZERO) > 0 || rec.getDesconto().compareTo(BigDecimal.ZERO) > 0) {
            if (rec.getTotal().compareTo(valorReceber) != 0) {
                msgError = msgError + "O valor recebido deve ser igual ao valor a receber (Devido ao preenchimento de juros e/ou desconto).\n";
            }
        } else {
            if (valorReceber.compareTo(BigDecimal.ZERO) > 0 && valorRecebido.compareTo(BigDecimal.ZERO) <= 0) {
                msgError = msgError + "O valor recebido deve ser maior que zero.\n";
            }
            if (valorRecebido.compareTo(valorReceber) > 0) {
                msgError = msgError + "O valor recebido n\u00e3o pode ser maior que o valor a receber.\n";
            }
        }
        if (!msgError.isEmpty()) {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)msgError);
            return false;
        }
        return true;
    }

    private void carregaCombos() {
        this.cbbFormaRecebimento.setItems(FXCollections.observableArrayList((Collection)FormaPagamentoUtils.listCombo()));
        this.cbbConta.setItems(FXCollections.observableArrayList((Collection)this.contaService.combo()));
    }

    private void carregaIcones() {
        this.btnSalva.setGraphic((Node)new MaximaIcone().getIconeConfirma());
    }

    private void carregaMascaras() {
        MaximaMask.monetaryField((TextField)this.tfJuros);
        MaximaMask.monetaryField((TextField)this.tfDesconto);
        MaximaMask.monetaryField((TextField)this.tfValorRecebido);
    }

    private void registraAcoes() {
        this.btnSalva.setOnAction(event -> this.salva());
        this.tfJuros.setOnKeyReleased(event -> this.calculaValorReceber());
        this.tfJuros.focusedProperty().addListener((ov, oldV, newV) -> this.calculaValorReceber());
        this.tfDesconto.setOnKeyReleased(event -> this.calculaValorReceber());
        this.tfDesconto.focusedProperty().addListener((ov, oldV, newV) -> this.calculaValorReceber());
    }

    private void closeForm() {
        Stage stage = (Stage)this.btnSalva.getScene().getWindow();
        stage.close();
    }

    private MovimentacaoEntrada createRecebimento() {
        MovimentacaoEntrada rec = new MovimentacaoEntrada();
        rec.setCliente(this.contaReceberParcela.getContaReceber().getCliente());
        rec.setFormaPagamento((FormaPagamento)this.cbbFormaRecebimento.getSelectionModel().getSelectedItem());
        rec.setContaReceberParcela(this.contaReceberParcela);
        rec.setDataEmissao(LocalDateTime.now());
        rec.setDataMovimento((LocalDate)this.tfDataRecebimento.getValue());
        rec.setDesconto(MaximaNumber.moneyToBigDecimal((String)this.tfDesconto.getText()));
        rec.setEstornada(Boolean.FALSE);
        if (rec.getCondicaoPagamento() != null) {
            rec.setFormaPagamento(rec.getCondicaoPagamento().getFormaPagamento());
        }
        rec.setHistorico(MaximaUtils.getText((String)this.tfHistoricoRecebimento.getText()));
        rec.setJuros(MaximaNumber.moneyToBigDecimal((String)this.tfJuros.getText()));
        rec.setTotal(MaximaNumber.moneyToBigDecimal((String)this.tfValorRecebido.getText()));
        rec.setValor(rec.getTotal().add(rec.getDesconto()).subtract(rec.getJuros()));
        rec.setValorLiquido(rec.getTotal());
        return rec;
    }
}

