/*
 * Decompiled with CFR 0.152.
 */
package br.com.maximasolutions.financeiro.controller;

import br.com.maximasolutions.administrativo.modelo.Configuracao;
import br.com.maximasolutions.administrativo.service.ConfiguracaoService;
import br.com.maximasolutions.config.StageManager;
import br.com.maximasolutions.core.MaximaAlert;
import br.com.maximasolutions.core.MaximaController;
import br.com.maximasolutions.core.MaximaIcone;
import br.com.maximasolutions.core.MaximaValidacaoException;
import br.com.maximasolutions.estoque.service.VendaProdutoService;
import br.com.maximasolutions.financeiro.modelo.Conta;
import br.com.maximasolutions.financeiro.modelo.ContaReceberParcela;
import br.com.maximasolutions.financeiro.modelo.FormaPagamento;
import br.com.maximasolutions.financeiro.modelo.MovimentacaoEntrada;
import br.com.maximasolutions.financeiro.service.CondicaoRecebimentoService;
import br.com.maximasolutions.financeiro.service.ContaReceberParcelaService;
import br.com.maximasolutions.financeiro.service.ContaService;
import br.com.maximasolutions.financeiro.service.MovimentacaoEntradaService;
import br.com.maximasolutions.financeiro.utils.FormaPagamentoUtils;
import br.com.maximasolutions.utils.MaximaMask;
import br.com.maximasolutions.utils.MaximaNumber;
import br.com.maximasolutions.utils.MaximaUtils;
import java.math.BigDecimal;
import java.net.URL;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.collections.FXCollections;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.DatePicker;
import javafx.scene.control.TextField;
import javafx.stage.Stage;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Controller;

@Controller
public class RecebimentoMultiploFormController
extends MaximaController
implements Initializable {
    @Lazy
    @Autowired
    private StageManager stageManager;
    @FXML
    private TextField tfCliente;
    @FXML
    private TextField tfClienteVale;
    @FXML
    private TextField tfId;
    @FXML
    private TextField tfCentroCusto;
    @FXML
    private TextField tfDataVencimento;
    @FXML
    private TextField tfValorParcela;
    @FXML
    private TextField tfValorPendente;
    @FXML
    private TextField tfHistorico;
    @FXML
    private TextField tfJuros;
    @FXML
    private TextField tfDesconto;
    @FXML
    private TextField tfValorReceber;
    @FXML
    private TextField tfValorRecebido;
    @FXML
    private TextField tfHistoricoRecebimento;
    @FXML
    private ComboBox<FormaPagamento> cbbFormaRecebimento;
    @FXML
    private ComboBox<Conta> cbbConta;
    @FXML
    private DatePicker tfDataRecebimento;
    @FXML
    private Button btnSalva;
    @Autowired
    private VendaProdutoService vendaProdutoService;
    @Autowired
    private CondicaoRecebimentoService condicaoPagamentoService;
    @Autowired
    private MovimentacaoEntradaService movimentacaoEntradaService;
    @Autowired
    private ContaService contaService;
    @Autowired
    private ConfiguracaoService configuracaoService;
    @Autowired
    private ContaReceberParcelaService contaReceberParcelaService;
    private List<ContaReceberParcela> parcelas;

    public void initialize(URL url, ResourceBundle rb) {
        this.carregaIcones();
        this.registraAcoes();
        this.carregaCombos();
        this.carregaMascaras();
    }

    public void inicializa(List<ContaReceberParcela> listaParcelas) {
        this.parcelas = listaParcelas;
        BigDecimal valorReceber = BigDecimal.ZERO;
        for (ContaReceberParcela parc : listaParcelas) {
            valorReceber = valorReceber.add(parc.getValorPendente());
        }
        this.tfId.setText("DIVERSOS");
        this.tfCliente.setText(listaParcelas.get(0).getCliente().getNome());
        this.tfClienteVale.setText(MaximaNumber.formataNumero((BigDecimal)listaParcelas.get(0).getCliente().getVale()));
        this.tfCentroCusto.setText(listaParcelas.get(0).getCentroCusto().getNome().toUpperCase());
        this.tfDataVencimento.setText("DIVERSOS");
        this.tfValorParcela.setText(MaximaNumber.bigDecimalToString((BigDecimal)valorReceber, (int)2));
        this.tfValorPendente.setText(MaximaNumber.bigDecimalToString((BigDecimal)valorReceber, (int)2));
        this.tfHistorico.setText("DIVERSOS");
        this.tfHistoricoRecebimento.setText("");
        Configuracao conf = this.configuracaoService.load();
        this.tfDataRecebimento.setValue((Object)LocalDate.now());
        this.tfDataRecebimento.setDisable(true);
        this.calculaValorReceber();
    }

    private void salva() {
        Boolean lancarMovimentoCaixa;
        try {
            lancarMovimentoCaixa = MaximaAlert.SIM_NAO_CANCELA((StageManager)this.stageManager, (String)"Deseja lan\u00e7ar o recebimento no movimento de caixa?");
        }
        catch (MaximaValidacaoException ex) {
            return;
        }
        try {
            for (ContaReceberParcela parc : this.parcelas) {
                MovimentacaoEntrada recebimento = this.createRecebimento(parc);
                if (!this.validaRecebimento(recebimento)) {
                    return;
                }
                this.movimentacaoEntradaService.recebeParcela(parc, recebimento, lancarMovimentoCaixa, (Conta)this.cbbConta.getSelectionModel().getSelectedItem());
            }
            MaximaAlert.informe((StageManager)this.stageManager, (String)"Recebimento efetuado com sucesso.");
            this.closeForm();
        }
        catch (MaximaValidacaoException ex) {
            Logger.getLogger(RecebimentoMultiploFormController.class.getName()).log(Level.SEVERE, null, ex);
            MaximaAlert.aviso((StageManager)this.stageManager, (String)ex.getMessage());
        }
    }

    private void calculaValorReceber() {
        BigDecimal valorPendente = MaximaNumber.moneyToBigDecimal((String)this.tfValorPendente.getText());
        BigDecimal valorJuros = MaximaNumber.moneyToBigDecimal((String)this.tfJuros.getText());
        BigDecimal valorDesconto = MaximaNumber.moneyToBigDecimal((String)this.tfDesconto.getText());
        BigDecimal valorReceber = valorPendente.add(valorJuros).subtract(valorDesconto);
        this.tfValorReceber.setText(MaximaNumber.bigDecimalToString((BigDecimal)valorReceber, (int)2));
        this.tfValorRecebido.setText(MaximaNumber.bigDecimalToString((BigDecimal)valorReceber, (int)2));
    }

    private boolean validaRecebimento(MovimentacaoEntrada rec) {
        String msgError = "";
        if (rec.getCondicaoPagamento() == null && rec.getFormaPagamento() == null) {
            msgError = msgError + "Informe a forma de recebimento.\n";
        }
        if (rec.getDataMovimento() == null) {
            msgError = msgError + "Informe a data de recebimento.\n";
        }
        BigDecimal valorRecebido = MaximaNumber.moneyToBigDecimal((String)this.tfValorRecebido.getText());
        BigDecimal valorReceber = MaximaNumber.moneyToBigDecimal((String)this.tfValorReceber.getText());
        if (valorRecebido == null) {
            msgError = msgError + "Informe o valor recebido.\n";
        } else if (rec.getJuros().compareTo(BigDecimal.ZERO) > 0 || rec.getDesconto().compareTo(BigDecimal.ZERO) > 0) {
            if (rec.getTotal().compareTo(valorReceber) != 0) {
                msgError = msgError + "O valor recebido deve ser igual ao valor a receber (Devido ao preenchimento de juros e/ou desconto).\n";
            }
        } else {
            if (valorReceber.compareTo(BigDecimal.ZERO) > 0 && valorRecebido.compareTo(BigDecimal.ZERO) <= 0) {
                msgError = msgError + "O valor recebido deve ser maior que zero.\n";
            }
            if (valorRecebido.compareTo(valorReceber) > 0) {
                msgError = msgError + "O valor recebido n\u00e3o pode ser maior que o valor a receber.\n";
            }
        }
        if (!msgError.isEmpty()) {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)msgError);
            return false;
        }
        return true;
    }

    private void carregaCombos() {
        this.cbbFormaRecebimento.setItems(FXCollections.observableArrayList((Collection)FormaPagamentoUtils.listCombo()));
        this.cbbConta.setItems(FXCollections.observableArrayList((Collection)this.contaService.combo()));
    }

    private void carregaIcones() {
        this.btnSalva.setGraphic((Node)new MaximaIcone().getIconeConfirma());
    }

    private void carregaMascaras() {
        MaximaMask.monetaryField((TextField)this.tfJuros);
        MaximaMask.monetaryField((TextField)this.tfDesconto);
        MaximaMask.monetaryField((TextField)this.tfValorRecebido);
    }

    private void registraAcoes() {
        this.btnSalva.setOnAction(event -> this.salva());
        this.tfJuros.setOnKeyReleased(event -> this.calculaValorReceber());
        this.tfJuros.focusedProperty().addListener((ov, oldV, newV) -> this.calculaValorReceber());
        this.tfDesconto.setOnKeyReleased(event -> this.calculaValorReceber());
        this.tfDesconto.focusedProperty().addListener((ov, oldV, newV) -> this.calculaValorReceber());
    }

    private void closeForm() {
        Stage stage = (Stage)this.btnSalva.getScene().getWindow();
        stage.close();
    }

    private MovimentacaoEntrada createRecebimento(ContaReceberParcela contaReceberParcela) {
        MovimentacaoEntrada rec = new MovimentacaoEntrada();
        rec.setCliente(contaReceberParcela.getContaReceber().getCliente());
        rec.setFormaPagamento((FormaPagamento)this.cbbFormaRecebimento.getSelectionModel().getSelectedItem());
        rec.setContaReceberParcela(contaReceberParcela);
        rec.setDataEmissao(LocalDateTime.now());
        rec.setDataMovimento((LocalDate)this.tfDataRecebimento.getValue());
        rec.setDesconto(MaximaNumber.moneyToBigDecimal((String)this.tfDesconto.getText()));
        rec.setEstornada(Boolean.FALSE);
        if (rec.getCondicaoPagamento() != null) {
            rec.setFormaPagamento(rec.getCondicaoPagamento().getFormaPagamento());
        }
        rec.setHistorico(MaximaUtils.getText((String)this.tfHistoricoRecebimento.getText()));
        rec.setJuros(MaximaNumber.moneyToBigDecimal((String)this.tfJuros.getText()));
        rec.setTotal(contaReceberParcela.getValorPendente());
        rec.setValor(rec.getTotal().add(rec.getDesconto()).subtract(rec.getJuros()));
        rec.setValorLiquido(rec.getTotal());
        return rec;
    }
}

