/*
 * Decompiled with CFR 0.152.
 */
package br.com.maximasolutions.financeiro.printer;

import br.com.maximasolutions.administrativo.modelo.Configuracao;
import br.com.maximasolutions.core.ESCPrinter;
import br.com.maximasolutions.core.MaximaConfig;
import br.com.maximasolutions.core.MaximaImpressao;
import br.com.maximasolutions.core.MaximaValidacaoException;
import br.com.maximasolutions.estoque.modelo.CategoriaProduto;
import br.com.maximasolutions.estoque.modelo.Pedido;
import br.com.maximasolutions.estoque.modelo.PedidoItem;
import br.com.maximasolutions.estoque.modelo.VendaProduto;
import br.com.maximasolutions.financeiro.bean.MovimentoCaixaItemVendidoBean;
import br.com.maximasolutions.financeiro.bean.MovimentoCaixaRecebimentoBean;
import br.com.maximasolutions.financeiro.modelo.MovimentacaoEntrada;
import br.com.maximasolutions.financeiro.modelo.MovimentoCaixa;
import br.com.maximasolutions.financeiro.modelo.MovimentoCaixaSangria;
import br.com.maximasolutions.utils.MaximaDate;
import br.com.maximasolutions.utils.MaximaNumber;
import br.com.maximasolutions.utils.MaximaUtils;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.print.PrintException;

public class MovimentoCaixaPrinter {
    private BigDecimal totalEntradaProduto = BigDecimal.ZERO;
    private BigDecimal ticketMedioVenda = BigDecimal.ZERO;
    private BigDecimal ticketMedioProduto = BigDecimal.ZERO;
    private BigDecimal quantidadeProdutos = BigDecimal.ZERO;
    private BigDecimal quantidadeVendas = BigDecimal.ZERO;
    private Integer quantidadeCupons = 0;
    private BigDecimal valorCupons = BigDecimal.ZERO;
    private List<VendaProduto> vendas = new ArrayList();
    private List<MovimentacaoEntrada> outrosRecebimentos = new ArrayList();
    private Long comandasCanceladas = 0L;
    private Long comandaItensCancelados = 0L;
    private List<Pedido> pedidosCancelados = new ArrayList();
    private List<PedidoItem> itensCancelados = new ArrayList();

    public void setPedidosCancelados(List<Pedido> pedidosCancelados) {
        this.pedidosCancelados = pedidosCancelados;
    }

    public void setItensCancelados(List<PedidoItem> itensCancelados) {
        this.itensCancelados = itensCancelados;
    }

    public void setQuantidadeCupons(Integer quantidadeCupons) {
        this.quantidadeCupons = quantidadeCupons;
    }

    public void setValorCupons(BigDecimal valorCupons) {
        this.valorCupons = valorCupons;
    }

    public void setComandaItensCancelados(Long comandaItensCancelados) {
        this.comandaItensCancelados = comandaItensCancelados;
    }

    public void setComandasCanceladas(Long comandasCanceladas) {
        this.comandasCanceladas = comandasCanceladas;
    }

    public void setOutrosRecebimentos(List<MovimentacaoEntrada> outrosRecebimentos) {
        this.outrosRecebimentos = outrosRecebimentos;
    }

    public void setVendas(List<VendaProduto> vendas) {
        this.vendas = vendas;
    }

    public void setTotalEntradaProduto(BigDecimal totalEntradaProduto) {
        this.totalEntradaProduto = totalEntradaProduto;
    }

    public void setTicketMedioVenda(BigDecimal ticketMedioVenda) {
        this.ticketMedioVenda = ticketMedioVenda;
    }

    public void setTicketMedioProduto(BigDecimal ticketMedioProduto) {
        this.ticketMedioProduto = ticketMedioProduto;
    }

    public void setQuantidadeProdutos(BigDecimal quantidadeProdutos) {
        this.quantidadeProdutos = quantidadeProdutos;
    }

    public void setQuantidadeVendas(BigDecimal quantidadeVendas) {
        this.quantidadeVendas = quantidadeVendas;
    }

    public void imprimeFechamentoCaixa(MovimentoCaixa caixa, List<MovimentoCaixaRecebimentoBean> recebimentos, List<CategoriaProduto> categorias, List<MovimentoCaixaItemVendidoBean> itens, Configuracao conf) throws MaximaValidacaoException {
        String txtOutrosRecebimentos = "";
        BigDecimal totalOutrosRecebimentos = BigDecimal.ZERO;
        if (this.outrosRecebimentos != null && this.outrosRecebimentos.size() > 0) {
            txtOutrosRecebimentos = txtOutrosRecebimentos + ESCPrinter.negrita((String)"OUTROS RECEBIMENTOS") + "\n";
            for (Object rec : this.outrosRecebimentos) {
                txtOutrosRecebimentos = txtOutrosRecebimentos + MaximaDate.getData((LocalDate)rec.getDataMovimento()) + "  ";
                txtOutrosRecebimentos = txtOutrosRecebimentos + MaximaUtils.completaDireita((String)rec.getFormaPagamento().getDescricao(), (String)" ", (int)17) + "  ";
                txtOutrosRecebimentos = txtOutrosRecebimentos + MaximaUtils.completaEsquerda((String)MaximaNumber.formataNumero((BigDecimal)rec.getTotal()), (String)" ", (int)17) + "\n";
                totalOutrosRecebimentos = totalOutrosRecebimentos.add(rec.getTotal());
            }
            txtOutrosRecebimentos = txtOutrosRecebimentos + MaximaUtils.completaDireita((String)"", (String)"-", (int)48) + "\n";
        }
        String txt = "" + ESCPrinter.iniciaImpressao();
        txt = txt + MaximaUtils.limitaTexto((String)(conf.getCnpjEmpresa() + " | " + conf.getNomeEmpresa()), (int)48) + "\n";
        txt = txt + MaximaUtils.completaDireita((String)"", (String)"=", (int)48) + "\n";
        txt = txt + MaximaUtils.centraliza((String)"RELAT\u00d3RIO - MOVIMENTO DE CAIXA", (int)48) + "\n";
        txt = txt + MaximaUtils.completaDireita((String)"", (String)"=", (int)48) + "\n";
        txt = txt + "DATA DE ABERTURA...: " + caixa.getDataAbertura().format(DateTimeFormatter.ofPattern("dd/MM/yyyy HH:mm:ss")) + "\n";
        txt = txt + "DATA DE FECHAMENTO.: " + (caixa.getDataFechamento() == null ? "" : caixa.getDataFechamento().format(DateTimeFormatter.ofPattern("dd/MM/yyyy HH:mm:ss"))) + "\n";
        txt = txt + MaximaUtils.completaDireita((String)"", (String)"-", (int)48) + "\n";
        txt = txt + "VALOR ABERTURA.............:" + MaximaUtils.completaEsquerda((String)MaximaNumber.bigDecimalToString((BigDecimal)caixa.getSaldoAbertura(), (int)2), (String)" ", (int)20) + "\n";
        txt = txt + ESCPrinter.negrita((String)("TOTAL EM CAIXA.............:" + MaximaUtils.completaEsquerda((String)MaximaNumber.bigDecimalToString((BigDecimal)caixa.getValorEmCaixa(), (int)2), (String)" ", (int)20))) + "\n\n";
        for (MovimentoCaixaRecebimentoBean rec : recebimentos) {
            txt = txt + MaximaUtils.completaDireita((String)rec.getNome(), (String)".", (int)19) + ":" + MaximaUtils.completaEsquerda((String)MaximaNumber.bigDecimalToString((BigDecimal)rec.getValor(), (int)2), (String)" ", (int)28) + "\n";
        }
        txt = txt + MaximaUtils.completaDireita((String)"OUTROS RECEBIMENTOS", (String)".", (int)19) + ":" + MaximaUtils.completaEsquerda((String)MaximaNumber.bigDecimalToString((BigDecimal)totalOutrosRecebimentos, (int)2), (String)" ", (int)28) + "\n";
        txt = txt + "SUPRIMENTO.........:" + MaximaUtils.completaEsquerda((String)MaximaNumber.bigDecimalToString((BigDecimal)caixa.getSuprimento(), (int)2), (String)" ", (int)28) + "\n";
        txt = txt + "PAGAMENTOS.........:" + MaximaUtils.completaEsquerda((String)("-" + MaximaNumber.bigDecimalToString((BigDecimal)caixa.getPagamentos(), (int)2)), (String)" ", (int)28) + "\n";
        txt = txt + "SANGRIA............:" + MaximaUtils.completaEsquerda((String)("-" + MaximaNumber.bigDecimalToString((BigDecimal)caixa.getSangria(), (int)2)), (String)" ", (int)28) + "\n";
        txt = txt + "\n";
        txt = txt + ESCPrinter.negrita((String)("TOTAL VENDIDO..............:" + MaximaUtils.completaEsquerda((String)MaximaNumber.bigDecimalToString((BigDecimal)caixa.getTotalVendas(), (int)2), (String)" ", (int)20))) + "\n";
        txt = txt + ESCPrinter.negrita((String)("QUANTIDADE DE VENDAS.......:" + MaximaUtils.completaEsquerda((String)MaximaNumber.bigDecimalToString((BigDecimal)this.quantidadeVendas, (int)0), (String)" ", (int)20))) + "\n";
        txt = txt + ESCPrinter.negrita((String)("VALOR MEDIO DE CADA VENDA..:" + MaximaUtils.completaEsquerda((String)MaximaNumber.bigDecimalToString((BigDecimal)this.ticketMedioVenda, (int)2), (String)" ", (int)20))) + "\n";
        txt = txt + ESCPrinter.negrita((String)("QUANTIDADE ITENS VENDIDOS..:" + MaximaUtils.completaEsquerda((String)MaximaNumber.bigDecimalToString((BigDecimal)this.quantidadeProdutos, (int)0), (String)" ", (int)20))) + "\n";
        txt = txt + ESCPrinter.negrita((String)("VALOR MEDIO DE CADA ITEM...:" + MaximaUtils.completaEsquerda((String)MaximaNumber.bigDecimalToString((BigDecimal)this.ticketMedioProduto, (int)2), (String)" ", (int)20))) + "\n";
        if (this.totalEntradaProduto != null && this.totalEntradaProduto.compareTo(BigDecimal.ZERO) > 0) {
            txt = txt + ESCPrinter.negrita((String)("TOTAL COMPRAS...............:" + MaximaUtils.completaEsquerda((String)MaximaNumber.bigDecimalToString((BigDecimal)this.totalEntradaProduto, (int)2), (String)" ", (int)20))) + "\n";
        }
        if (MaximaConfig.menuFood().booleanValue()) {
            txt = txt + ESCPrinter.negrita((String)("\nCOMANDAS CANCELADAS........:" + MaximaUtils.completaEsquerda((String)this.comandasCanceladas.toString(), (String)" ", (int)20))) + "\n";
            txt = txt + ESCPrinter.negrita((String)("COMANDAS ITENS CANCELADOS..:" + MaximaUtils.completaEsquerda((String)this.comandaItensCancelados.toString(), (String)" ", (int)20))) + "\n";
        } else {
            if (!this.pedidosCancelados.isEmpty()) {
                txt = txt + ESCPrinter.negrita((String)"\n-------------- PEDIDOS CANCELADOS --------------") + "\n";
                for (Pedido pedido : this.pedidosCancelados) {
                    txt = txt + MaximaDate.getDataHora((LocalDateTime)pedido.getHora()) + " " + MaximaUtils.completaEsquerda((String)MaximaNumber.formataNumero((BigDecimal)pedido.getTotal()), (String)" ", (int)28) + "\n";
                }
            }
            if (!this.itensCancelados.isEmpty()) {
                txt = txt + ESCPrinter.negrita((String)"\n-------------- ITENS CANCELADOS --------------") + "\n";
                for (PedidoItem pedidoItem : this.itensCancelados) {
                    txt = txt + MaximaDate.getDataHora((LocalDateTime)pedidoItem.getDataExclusao()) + " - " + MaximaNumber.quantidadeToString((BigDecimal)pedidoItem.getQuantidade()) + " x " + pedidoItem.getDescricao() + "\n";
                }
            }
        }
        txt = txt + MaximaUtils.completaDireita((String)"", (String)"-", (int)48) + "\n";
        if (caixa.getDevolucoes().compareTo(BigDecimal.ZERO) != 0) {
            txt = txt + "\n";
            txt = txt + "DEVOLU\u00c7\u00d5ES.........:" + MaximaUtils.completaEsquerda((String)MaximaNumber.bigDecimalToString((BigDecimal)caixa.getDevolucoes(), (int)2), (String)" ", (int)28) + "\n";
            txt = txt + MaximaUtils.completaDireita((String)"", (String)"-", (int)48) + "\n";
        }
        txt = txt + MaximaUtils.completaDireita((String)"", (String)"-", (int)48) + "\n";
        txt = txt + "\n";
        txt = txt + "CUPONS.............:" + MaximaUtils.completaEsquerda((String)MaximaNumber.bigDecimalToString((BigDecimal)this.valorCupons, (int)2), (String)" ", (int)28) + "\n";
        txt = txt + MaximaUtils.completaDireita((String)"", (String)"-", (int)48) + "\n";
        if (conf.getMovimentoCaixaImprimeOutrosRecebimentos().booleanValue()) {
            txt = txt + txtOutrosRecebimentos;
        }
        if (conf.getMovimentoCaixaImprimeVendas().booleanValue() && this.vendas != null && this.vendas.size() > 0) {
            txt = txt + ESCPrinter.negrita((String)"VENDAS") + "\n";
            for (VendaProduto venda : this.vendas) {
                txt = txt + MaximaUtils.completaZeroEsquerda((String)venda.getId().toString(), (Integer)8) + "  ";
                txt = txt + venda.getDataHora() + " ";
                txt = txt + MaximaUtils.completaEsquerda((String)MaximaNumber.formataNumero((BigDecimal)venda.getTotal()), (String)" ", (int)18) + "\n";
            }
            txt = txt + MaximaUtils.completaDireita((String)"", (String)"-", (int)48) + "\n";
        }
        if (conf.getMovimentoCaixaImprimeProdutos().booleanValue() && categorias != null) {
            for (CategoriaProduto cp : categorias) {
                String txtProdutos = "";
                txtProdutos = txtProdutos + ESCPrinter.negrita((String)cp.getNome().toUpperCase()) + "\n";
                BigDecimal totalCategoria = BigDecimal.ZERO;
                if (itens != null) {
                    for (MovimentoCaixaItemVendidoBean obj : itens) {
                        if (!obj.getCategoria().equals(cp.getId())) continue;
                        txtProdutos = txtProdutos + MaximaUtils.completaEsquerda((String)MaximaNumber.bigDecimalToString((BigDecimal)obj.getQuantidade(), (int)3), (String)" ", (int)7) + "  " + MaximaUtils.completaDireita((String)obj.getDescricao(), (String)" ", (int)29) + MaximaUtils.completaEsquerda((String)MaximaNumber.bigDecimalToString((BigDecimal)obj.getValorTotal(), (int)2), (String)" ", (int)10) + "\n";
                        totalCategoria = totalCategoria.add(obj.getValorTotal());
                    }
                }
                txtProdutos = txtProdutos + ESCPrinter.negrita((String)MaximaUtils.completaEsquerda((String)("TOTAL: R$ " + MaximaNumber.bigDecimalToString((BigDecimal)totalCategoria, (int)2)), (String)" ", (int)48)) + "\n\n";
                if (totalCategoria.compareTo(BigDecimal.ZERO) <= 0) continue;
                txt = txt + txtProdutos;
            }
        }
        txt = txt + ESCPrinter.maximaSoft();
        txt = txt + ESCPrinter.FINAL_IMPRESSAO;
        txt = MaximaUtils.removeAcentos((String)txt);
        try {
            new MaximaImpressao(conf).printText(txt);
        }
        catch (MaximaValidacaoException ex) {
            Logger.getLogger(MovimentoCaixaPrinter.class.getName()).log(Level.SEVERE, null, ex);
            throw new MaximaValidacaoException("Ocorreu um erro ao imprimir fechamento de caixa.");
        }
    }

    public void imprimeAberturaCaixa(MovimentoCaixa movimentoCaixa, Configuracao conf) throws PrintException, MaximaValidacaoException {
        String texto = "";
        texto = texto + "" + ESCPrinter.iniciaImpressao();
        texto = texto + MaximaUtils.repete((String)"-", (int)48) + "\n";
        texto = texto + MaximaUtils.centraliza((String)ESCPrinter.negrita((String)"ABERTURA DE CAIXA"), (int)48) + "\n";
        texto = texto + MaximaUtils.repete((String)"-", (int)48) + "\n";
        texto = texto + "DATA ABERTURA.....: " + movimentoCaixa.getDataAbertura().format(DateTimeFormatter.ofPattern("dd/MM/yyyy HH:mm:ss")) + "\n";
        texto = texto + "SALDO ABERTURA....: R$ " + ESCPrinter.negrita((String)MaximaNumber.bigDecimalToString((BigDecimal)movimentoCaixa.getSaldoAbertura(), (int)2)) + "\n";
        texto = texto + MaximaUtils.repete((String)"-", (int)48) + "\n";
        texto = texto + ESCPrinter.FINAL_IMPRESSAO;
        try {
            new MaximaImpressao(conf).printText(texto);
        }
        catch (MaximaValidacaoException ex) {
            Logger.getLogger(MovimentoCaixaPrinter.class.getName()).log(Level.SEVERE, null, ex);
            throw new MaximaValidacaoException("Ocorreu um erro ao imprimir comprovante de abertura do caixa.");
        }
    }

    public void imprimeSangriaCaixa(MovimentoCaixaSangria sangria, Configuracao conf) throws PrintException, MaximaValidacaoException {
        String texto = "";
        texto = texto + "" + ESCPrinter.iniciaImpressao();
        texto = texto + MaximaUtils.repete((String)"-", (int)48) + "\n";
        texto = texto + MaximaUtils.centraliza((String)ESCPrinter.negrita((String)"SANGRIA DE CAIXA"), (int)48) + "\n";
        texto = texto + MaximaUtils.repete((String)"-", (int)48) + "\n";
        texto = texto + "DATA.....: " + LocalDateTime.now().format(DateTimeFormatter.ofPattern("dd/MM/yyyy HH:mm:ss")) + "\n";
        texto = texto + "VALOR....: R$ " + ESCPrinter.negrita((String)MaximaNumber.bigDecimalToString((BigDecimal)sangria.getValor(), (int)2)) + "\n";
        if (sangria.getDescricao() != null) {
            texto = texto + sangria.getDescricao().toUpperCase() + "\n";
        }
        texto = texto + MaximaUtils.repete((String)"-", (int)48) + "\n\n\n";
        texto = texto + ESCPrinter.FINAL_IMPRESSAO;
        try {
            new MaximaImpressao(conf).printText(texto);
        }
        catch (MaximaValidacaoException ex) {
            Logger.getLogger(MovimentoCaixaPrinter.class.getName()).log(Level.SEVERE, null, ex);
            throw new MaximaValidacaoException("Ocorreu um erro ao imprimir comprovante de abertura do caixa.");
        }
    }
}

