/*
 * Decompiled with CFR 0.152.
 */
package br.com.maximasolutions.financeiro.printer;

import br.com.maximasolutions.administrativo.modelo.Configuracao;
import br.com.maximasolutions.core.ESCPrinter;
import br.com.maximasolutions.estoque.modelo.VendaProduto;
import br.com.maximasolutions.financeiro.modelo.MovimentacaoEntrada;
import br.com.maximasolutions.utils.MaximaDate;
import br.com.maximasolutions.utils.MaximaNumber;
import br.com.maximasolutions.utils.MaximaUtils;
import java.math.BigDecimal;
import java.time.LocalDate;

public class RecebimentoPrinter {
    public static String comprovante(Configuracao conf, MovimentacaoEntrada recebimento, VendaProduto venda) {
        String texto = "\n";
        texto = texto + MaximaUtils.centraliza((String)conf.getNomeEmpresa().toUpperCase(), (int)48) + "\n";
        texto = texto + "FONE: " + conf.getTelefoneEmpresa() + "\n" + ESCPrinter.LINHA;
        texto = texto + "COMPROVANTE DE PAGAMENTO\n";
        texto = texto + "DOCUMENTO N\u00c3O FISCAL\n";
        texto = texto + ESCPrinter.LINHA + "\n";
        texto = texto + new String(ESCPrinter.BOLD) + "CLIENTE: " + recebimento.getCliente().getNome().toUpperCase() + new String(ESCPrinter.BOLD_END) + "\n";
        texto = texto + "C\u00d3DIGO DE RECEBIMENTO: " + recebimento.getId() + "\n";
        if (venda != null) {
            texto = texto + "C\u00d3DIGO VENDA: " + venda.getId() + "\n";
        }
        texto = texto + "DATA: " + MaximaDate.getData((LocalDate)recebimento.getDataMovimento()) + "\n";
        texto = texto + "FORMA DE PAGAMENTO: " + recebimento.getFormaPagamento().toString().toUpperCase() + "\n\n";
        texto = texto + new String(ESCPrinter.BOLD) + "VALOR: " + MaximaNumber.formataNumero((BigDecimal)recebimento.getTotal()) + new String(ESCPrinter.BOLD_END) + "\n";
        texto = texto + ESCPrinter.FINAL_IMPRESSAO;
        return texto;
    }
}

