/*
 * Decompiled with CFR 0.152.
 */
package br.com.maximasolutions.financeiro.repository;

import br.com.maximasolutions.financeiro.modelo.ContaPagarParcela;
import br.com.maximasolutions.financeiro.modelo.FormaPagamento;
import br.com.maximasolutions.financeiro.repository.ContaPagarParcelaRepositoryCustom;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.List;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

@Repository
public interface ContaPagarParcelaRepository
extends JpaRepository<ContaPagarParcela, Long>,
ContaPagarParcelaRepositoryCustom {
    @Query(value="SELECT o FROM ContaPagarParcela o WHERE o.excluido = false AND o.contaPagar.id = :contaPagarId ORDER BY o.dataVencimento")
    public List<ContaPagarParcela> listPorContaPagar(@Param(value="contaPagarId") long var1);

    @Query(value="SELECT o FROM ContaPagarParcela o WHERE o.excluido = false AND o.quitado = false and o.dataVencimento <= :vencimento ORDER BY o.dataVencimento")
    public List<ContaPagarParcela> listEmAberto(@Param(value="vencimento") LocalDate var1);

    @Query(value="SELECT o FROM ContaPagarParcela o WHERE o.excluido = false AND o.quitado = false AND (o.dataVencimento between :inicio and :fim) and (o.fornecedor.nome like :filtro or o.fornecedor.fantasia like :filtro or o.historico like :filtro) ORDER BY o.dataVencimento ASC")
    public List<ContaPagarParcela> lista(@Param(value="inicio") LocalDate var1, @Param(value="fim") LocalDate var2, @Param(value="filtro") String var3);

    @Query(value="SELECT o FROM ContaPagarParcela o WHERE o.excluido = false AND o.quitado = false AND (o.dataVencimento between :inicio and :fim) and (o.fornecedor.nome like :filtro or o.fornecedor.fantasia like :filtro or o.historico like :filtro) AND o.formaPagamento = :formaPagamento ORDER BY o.dataVencimento ASC")
    public List<ContaPagarParcela> lista(@Param(value="inicio") LocalDate var1, @Param(value="fim") LocalDate var2, @Param(value="filtro") String var3, @Param(value="formaPagamento") FormaPagamento var4);

    @Query(value="SELECT SUM(o.valorPendente) FROM ContaPagarParcela o WHERE o.excluido = false AND o.quitado = false AND (o.dataVencimento between :inicio and :fim) and (o.fornecedor.nome like :filtro or o.fornecedor.fantasia like :filtro or o.historico like :filtro)")
    public BigDecimal total(@Param(value="inicio") LocalDate var1, @Param(value="fim") LocalDate var2, @Param(value="filtro") String var3);

    @Query(value="SELECT COUNT(o.id) FROM ContaPagarParcela o WHERE o.centroCusto.id = 0 OR o.fornecedor.id = 0")
    public Long quantidadeAtualizacoes();

    @Modifying
    @Query(value="SELECT o FROM ContaPagarParcela o WHERE o.centroCusto.id = 0 OR o.fornecedor.id = 0")
    public List<ContaPagarParcela> listaAtualizacoes();
}

