/*
 * Decompiled with CFR 0.152.
 */
package br.com.maximasolutions.financeiro.repository;

import br.com.maximasolutions.financeiro.modelo.ContaReceberParcela;
import br.com.maximasolutions.financeiro.modelo.FormaPagamento;
import br.com.maximasolutions.financeiro.repository.ContaReceberParcelaRepositoryCustom;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.List;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

@Repository
public interface ContaReceberParcelaRepository
extends JpaRepository<ContaReceberParcela, Long>,
ContaReceberParcelaRepositoryCustom {
    @Query(value="SELECT o FROM ContaReceberParcela o WHERE o.excluido = false AND o.cliente.id = :clienteId ORDER BY o.dataVencimento")
    public List<ContaReceberParcela> listPorCliente(@Param(value="clienteId") long var1);

    @Query(value="SELECT sum(o.valorPendente) FROM ContaReceberParcela o WHERE o.excluido = false AND o.cliente.id = :clienteId AND o.quitado = false ORDER BY o.dataVencimento")
    public BigDecimal valorPendentePorCliente(@Param(value="clienteId") long var1);

    @Query(value="SELECT o FROM ContaReceberParcela o WHERE o.excluido = false AND o.cliente.id = :clienteId ORDER BY o.quitado, o.dataVencimento")
    public List<ContaReceberParcela> extrato(@Param(value="clienteId") long var1);

    @Query(value="SELECT o FROM ContaReceberParcela o WHERE o.excluido = false AND o.contaReceber.id = :contaReceberId ORDER BY o.dataVencimento")
    public List<ContaReceberParcela> listPorContaReceber(@Param(value="contaReceberId") long var1);

    @Query(value="SELECT o FROM ContaReceberParcela o WHERE o.excluido = false AND o.quitado = false and o.dataVencimento <= :vencimento ORDER BY o.dataVencimento")
    public List<ContaReceberParcela> listEmAberto(@Param(value="vencimento") LocalDate var1);

    @Query(value="SELECT o FROM ContaReceberParcela o WHERE o.excluido = false AND o.quitado = false AND (o.dataVencimento between :inicio and :fim) and o.cliente.nome like :filtro ORDER BY o.dataVencimento ASC, o.cliente.nome ASC")
    public List<ContaReceberParcela> lista(@Param(value="inicio") LocalDate var1, @Param(value="fim") LocalDate var2, @Param(value="filtro") String var3);

    @Query(value="SELECT o FROM ContaReceberParcela o WHERE o.excluido = false AND o.quitado = false AND (o.dataVencimento between :inicio and :fim) and o.cliente.nome like :filtro and o.formaPagamento = :formaPagamento ORDER BY o.dataVencimento ASC, o.cliente.nome ASC")
    public List<ContaReceberParcela> lista(@Param(value="inicio") LocalDate var1, @Param(value="fim") LocalDate var2, @Param(value="filtro") String var3, @Param(value="formaPagamento") FormaPagamento var4);

    @Query(value="SELECT sum(o.valorPendente) FROM ContaReceberParcela o WHERE o.excluido = false AND o.quitado = false AND (o.dataVencimento between :inicio and :fim) and o.cliente.nome like :filtro")
    public BigDecimal total(@Param(value="inicio") LocalDate var1, @Param(value="fim") LocalDate var2, @Param(value="filtro") String var3);

    @Query(value="SELECT sum(o.valorPendente) FROM ContaReceberParcela o WHERE o.excluido = false AND o.quitado = false AND (o.dataVencimento between :inicio and :fim) and o.cliente.nome like :filtro and o.formaPagamento = :formaPagamento ")
    public BigDecimal total(@Param(value="inicio") LocalDate var1, @Param(value="fim") LocalDate var2, @Param(value="filtro") String var3, @Param(value="formaPagamento") FormaPagamento var4);

    @Query(value="SELECT COUNT(o.id) FROM ContaReceberParcela o WHERE o.centroCusto.id = 0 OR o.cliente.id = 0")
    public Long quantidadeAtualizacoes();

    @Query(value="SELECT o FROM ContaReceberParcela o WHERE o.centroCusto.id = 0 OR o.cliente.id = 0")
    public List<ContaReceberParcela> listaAtualizacoes(Pageable var1);
}

