/*
 * Decompiled with CFR 0.152.
 */
package br.com.maximasolutions.financeiro.repository;

import br.com.maximasolutions.financeiro.modelo.FormaPagamento;
import br.com.maximasolutions.financeiro.modelo.MovimentacaoEntrada;
import br.com.maximasolutions.financeiro.repository.MovimentacaoEntradaRepositoryCustom;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.List;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

@Repository
public interface MovimentacaoEntradaRepository
extends JpaRepository<MovimentacaoEntrada, Long>,
MovimentacaoEntradaRepositoryCustom {
    @Query(value="select o from MovimentacaoEntrada o where o.estornada = false order by o.dataMovimento desc, o.id desc")
    public List<MovimentacaoEntrada> list();

    @Query(value="select o from MovimentacaoEntrada o where o.estornada = false and o.cliente.nome like :valor order by o.cliente.nome asc, o.dataMovimento desc, o.id desc")
    public List<MovimentacaoEntrada> pesquisa(@Param(value="valor") String var1);

    @Query(value="select o from MovimentacaoEntrada o WHERE o.estornada = false order by o.dataMovimento desc")
    public List<MovimentacaoEntrada> list(Pageable var1);

    @Query(value="select o from MovimentacaoEntrada o WHERE o.estornada = false and o.contaReceberParcela.id = :parcelaId order by o.dataMovimento")
    public List<MovimentacaoEntrada> listByContaReceberParcela(@Param(value="parcelaId") long var1);

    @Query(value="SELECT o FROM MovimentacaoEntrada o WHERE o.estornada = false AND (o.dataMovimento between :inicio and :fim) and o.cliente.id = :clienteId ORDER BY o.dataMovimento DESC, o.cliente.nome")
    public List<MovimentacaoEntrada> lista(@Param(value="inicio") LocalDate var1, @Param(value="fim") LocalDate var2, @Param(value="clienteId") Long var3);

    @Query(value="SELECT o FROM MovimentacaoEntrada o WHERE o.estornada = false AND (o.dataMovimento between :inicio and :fim) and o.cliente.nome like :filtro ORDER BY o.dataMovimento DESC, o.id DESC")
    public List<MovimentacaoEntrada> lista(@Param(value="inicio") LocalDate var1, @Param(value="fim") LocalDate var2, @Param(value="filtro") String var3);

    @Query(value="SELECT o FROM MovimentacaoEntrada o WHERE o.estornada = false AND (o.dataMovimento between :inicio and :fim) and o.cliente.nome like :filtro and o.formaPagamento = :formaPagamento ORDER BY o.dataMovimento DESC, o.id DESC")
    public List<MovimentacaoEntrada> lista(@Param(value="inicio") LocalDate var1, @Param(value="fim") LocalDate var2, @Param(value="filtro") String var3, @Param(value="formaPagamento") FormaPagamento var4);

    @Query(value="SELECT SUM(o.valorLiquido) FROM MovimentacaoEntrada o WHERE o.estornada = false AND (o.dataMovimento between :inicio and :fim) and o.cliente.nome like :filtro ORDER BY o.dataMovimento DESC, o.id DESC")
    public BigDecimal totalLiquido(@Param(value="inicio") LocalDate var1, @Param(value="fim") LocalDate var2, @Param(value="filtro") String var3);

    @Query(value="SELECT SUM(o.total) FROM MovimentacaoEntrada o WHERE o.estornada = false AND (o.dataMovimento between :inicio and :fim) and o.cliente.nome like :filtro ORDER BY o.dataMovimento DESC, o.id DESC")
    public BigDecimal totalBruto(@Param(value="inicio") LocalDate var1, @Param(value="fim") LocalDate var2, @Param(value="filtro") String var3);

    @Query(value="SELECT SUM(o.valorLiquido) FROM MovimentacaoEntrada o WHERE o.estornada = false AND (o.dataMovimento between :inicio and :fim) and o.cliente.nome like :filtro and o.formaPagamento = :formaPagamento  ORDER BY o.dataMovimento DESC, o.id DESC")
    public BigDecimal totalLiquido(@Param(value="inicio") LocalDate var1, @Param(value="fim") LocalDate var2, @Param(value="filtro") String var3, @Param(value="formaPagamento") FormaPagamento var4);

    @Query(value="SELECT SUM(o.total) FROM MovimentacaoEntrada o WHERE o.estornada = false AND (o.dataMovimento between :inicio and :fim) and o.cliente.nome like :filtro and o.formaPagamento = :formaPagamento  ORDER BY o.dataMovimento DESC, o.id DESC")
    public BigDecimal totalBruto(@Param(value="inicio") LocalDate var1, @Param(value="fim") LocalDate var2, @Param(value="filtro") String var3, @Param(value="formaPagamento") FormaPagamento var4);

    @Query(value="select count(o.id) from MovimentacaoEntrada o")
    public long count();

    @Query(value="SELECT o FROM MovimentacaoEntrada o WHERE o.estornada = false AND o.contaReceberParcela.contaReceber.id = :contaReceberId ORDER BY o.dataMovimento")
    public List<MovimentacaoEntrada> listContaReceber(@Param(value="contaReceberId") Long var1);

    @Query(value="SELECT COUNT(o.id) FROM MovimentacaoEntrada o WHERE o.estornada = false AND o.contaReceberParcela.contaReceber.id = :contaReceberId")
    public Long quantidadeRecebimentos(@Param(value="contaReceberId") Long var1);

    @Query(value="UPDATE MovimentacaoEntrada o SET o.valorLiquido = o.total WHERE o.valorLiquido is null")
    @Modifying
    public void atualizaValorLiquido();

    @Query(value="select o from MovimentacaoEntrada o where o.estornada = false and o.movimentoCaixa.id = :movimentoCaixaId order by o.dataMovimento desc, o.id desc")
    public List<MovimentacaoEntrada> listaPorMovimentoCaixa(@Param(value="movimentoCaixaId") Long var1);
}

