/*
 * Decompiled with CFR 0.152.
 */
package br.com.maximasolutions.financeiro.repository;

import br.com.maximasolutions.financeiro.modelo.FormaPagamento;
import br.com.maximasolutions.financeiro.modelo.MovimentacaoSaida;
import br.com.maximasolutions.financeiro.repository.MovimentacaoSaidaRepositoryCustom;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.List;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

@Repository
public interface MovimentacaoSaidaRepository
extends JpaRepository<MovimentacaoSaida, Long>,
MovimentacaoSaidaRepositoryCustom {
    @Query(value="select o from MovimentacaoSaida o where o.estornada = false order by o.dataMovimento desc, o.id desc")
    public List<MovimentacaoSaida> list();

    @Query(value="select o from MovimentacaoSaida o where o.estornada = false and o.fornecedor.nome like :valor order by o.fornecedor.nome asc, o.dataMovimento desc, o.id desc")
    public List<MovimentacaoSaida> pesquisa(@Param(value="valor") String var1);

    @Query(value="select o from MovimentacaoSaida o WHERE o.estornada = false order by o.dataMovimento desc")
    public List<MovimentacaoSaida> list(Pageable var1);

    @Query(value="SELECT o FROM MovimentacaoSaida o WHERE o.estornada = false AND (o.dataMovimento between :inicio and :fim) and o.fornecedor.id = :fornecedorId ORDER BY o.dataMovimento DESC, o.fornecedor.nome ASC")
    public List<MovimentacaoSaida> lista(@Param(value="inicio") LocalDate var1, @Param(value="fim") LocalDate var2, @Param(value="fornecedorId") Long var3);

    @Query(value="SELECT o FROM MovimentacaoSaida o WHERE o.estornada = false AND (o.dataMovimento between :inicio and :fim) and (o.fornecedor.nome like :filtro OR o.historico like :filtro) ORDER BY o.dataMovimento DESC, o.id DESC")
    public List<MovimentacaoSaida> lista(@Param(value="inicio") LocalDate var1, @Param(value="fim") LocalDate var2, @Param(value="filtro") String var3);

    @Query(value="SELECT o FROM MovimentacaoSaida o WHERE o.estornada = false AND (o.dataMovimento between :inicio and :fim) and (o.fornecedor.nome like :filtro OR o.historico like :filtro) AND o.formaPagamento = :formaPagamento ORDER BY o.dataMovimento DESC, o.id DESC")
    public List<MovimentacaoSaida> lista(@Param(value="inicio") LocalDate var1, @Param(value="fim") LocalDate var2, @Param(value="filtro") String var3, @Param(value="formaPagamento") FormaPagamento var4);

    @Query(value="SELECT sum(o.total) FROM MovimentacaoSaida o WHERE o.estornada = false AND (o.dataMovimento between :inicio and :fim) and o.fornecedor.nome like :filtro")
    public BigDecimal total(@Param(value="inicio") LocalDate var1, @Param(value="fim") LocalDate var2, @Param(value="filtro") String var3);

    @Query(value="select count(o.id) from MovimentacaoSaida o")
    public long count();
}

