/*
 * Decompiled with CFR 0.152.
 */
package br.com.maximasolutions.financeiro.repository;

import br.com.maximasolutions.financeiro.modelo.FormaPagamento;
import br.com.maximasolutions.financeiro.modelo.MovimentacaoSaida;
import br.com.maximasolutions.financeiro.repository.MovimentacaoSaidaRepositoryCustom;
import java.time.LocalDate;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;

public class MovimentacaoSaidaRepositoryCustomImpl
implements MovimentacaoSaidaRepositoryCustom {
    @PersistenceContext
    private EntityManager entityManager;

    public List<MovimentacaoSaida> relatorio(LocalDate inicio, LocalDate fim, Long fornecedorId, Long centroCustoId, FormaPagamento formaPagamento) throws Exception {
        String hql = "SELECT o FROM MovimentacaoSaida o WHERE o.estornada = false AND (o.dataMovimento BETWEEN :dataInicial AND :dataFinal) ";
        if (fornecedorId != null) {
            hql = hql + "AND (o.fornecedor.id = " + fornecedorId + ") ";
        }
        if (centroCustoId != null) {
            hql = hql + "AND (o.contaPagarParcela.centroCusto.id = " + centroCustoId + ") ";
        }
        if (formaPagamento != null) {
            hql = hql + "AND (o.formaPagamento = :formaPagamento) ";
        }
        Query query = this.entityManager.createQuery(hql + "ORDER BY o.dataMovimento DESC, o.fornecedor.nome ASC").setParameter("dataInicial", (Object)inicio).setParameter("dataFinal", (Object)fim);
        if (formaPagamento != null) {
            query.setParameter("formaPagamento", (Object)formaPagamento);
        }
        return query.getResultList();
    }
}

