/*
 * Decompiled with CFR 0.152.
 */
package br.com.maximasolutions.financeiro.repository;

import br.com.maximasolutions.financeiro.modelo.MovimentoCaixa;
import java.time.LocalDateTime;
import java.util.List;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

@Repository
public interface MovimentoCaixaRepository
extends JpaRepository<MovimentoCaixa, Long> {
    @Query(value="SELECT o FROM MovimentoCaixa o WHERE o.fechado = false AND o.caixa.id = :caixaId ")
    public MovimentoCaixa getCaixaAberto(@Param(value="caixaId") long var1);

    @Query(value="SELECT o FROM MovimentoCaixa o ORDER BY o.dataAbertura DESC ")
    public List<MovimentoCaixa> list();

    @Query(value="SELECT o FROM MovimentoCaixa o WHERE o.dataAbertura BETWEEN :dataInicio AND :dataFim ORDER BY o.dataAbertura DESC ")
    public List<MovimentoCaixa> list(@Param(value="dataInicio") LocalDateTime var1, @Param(value="dataFim") LocalDateTime var2);

    @Query(value="SELECT o FROM MovimentoCaixa o WHERE (o.dataAbertura BETWEEN :dataInicio AND :dataFim) and o.caixa.id = :caixaId ORDER BY o.dataAbertura DESC ")
    public List<MovimentoCaixa> lista(@Param(value="dataInicio") LocalDateTime var1, @Param(value="dataFim") LocalDateTime var2, @Param(value="caixaId") long var3);

    @Query(value="SELECT o FROM MovimentoCaixa o WHERE o.sincronizadoErp IS NULL OR o.sincronizadoErp = FALSE ORDER BY o.id ")
    public List<MovimentoCaixa> listaSincronizarErp();
}

