/*
 * Decompiled with CFR 0.152.
 */
package br.com.maximasolutions.financeiro.service;

import br.com.maximasolutions.administrativo.modelo.Configuracao;
import br.com.maximasolutions.administrativo.service.ConfiguracaoService;
import br.com.maximasolutions.core.MaximaException;
import br.com.maximasolutions.core.MaximaFile;
import br.com.maximasolutions.core.MaximaValidacaoException;
import br.com.maximasolutions.financeiro.boleto.SantanderRemessa;
import br.com.maximasolutions.financeiro.repository.BancoBoletoRepository;
import br.com.maximasolutions.financeiro.repository.BoletoEmitidoRepository;
import br.com.maximasolutions.financeiro.service.BoletoTecnospeedService;
import java.io.IOException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(rollbackFor={MaximaException.class})
public class BoletoTecnospeedServiceImpl
implements BoletoTecnospeedService {
    @Autowired
    private ConfiguracaoService configuracaoService;
    @Autowired
    private BoletoEmitidoRepository boletoEmitidoRepository;
    @Autowired
    private BancoBoletoRepository bancoBoletoRepository;

    public void geraRemessa() throws MaximaValidacaoException {
        Configuracao conf = this.configuracaoService.load();
        if (conf.getBancoBoleto() == null) {
            throw new MaximaValidacaoException("AVISO: Banco para emiss\u00e3o de boleto n\u00e3o configurado.");
        }
        List boletosEmitidos = this.boletoEmitidoRepository.remessa();
        String texto = SantanderRemessa.gera((Configuracao)conf, (List)boletosEmitidos);
        try {
            MaximaFile.escreveTexto((String)"C:/Maxima/remessa.rem", (String)texto);
        }
        catch (IOException ex) {
            Logger.getLogger(BoletoTecnospeedServiceImpl.class.getName()).log(Level.SEVERE, null, ex);
            throw new MaximaValidacaoException("ERRO: Falha ao escrever arquivo de remessa.\n" + ex.getMessage());
        }
        boletosEmitidos.stream().map(boleto -> {
            boleto.setRemessa(Boolean.valueOf(true));
            return boleto;
        }).forEachOrdered(boleto -> this.boletoEmitidoRepository.save(boleto));
    }
}

