/*
 * Decompiled with CFR 0.152.
 */
package br.com.maximasolutions.financeiro.service;

import br.com.maximasolutions.core.MaximaException;
import br.com.maximasolutions.core.MaximaValidacaoException;
import br.com.maximasolutions.financeiro.modelo.CentroCusto;
import br.com.maximasolutions.financeiro.modelo.ContaPagar;
import br.com.maximasolutions.financeiro.modelo.ContaPagarParcela;
import br.com.maximasolutions.financeiro.modelo.FormaPagamento;
import br.com.maximasolutions.financeiro.repository.ContaPagarParcelaRepository;
import br.com.maximasolutions.financeiro.repository.ContaPagarRepository;
import br.com.maximasolutions.financeiro.service.ContaPagarParcelaService;
import br.com.maximasolutions.geral.modelo.Fornecedor;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(rollbackFor={MaximaException.class, MaximaValidacaoException.class})
public class ContaPagarParcelaServiceImpl
implements ContaPagarParcelaService {
    @Autowired
    private ContaPagarRepository contaPagarRepository;
    @Autowired
    private ContaPagarParcelaRepository contaPagarParcelaRepository;

    @Transactional(rollbackFor={MaximaValidacaoException.class})
    public void add(Fornecedor fornecedor, CentroCusto centroCusto, LocalDate dataEmissao, String numeroNota, List<ContaPagarParcela> parcelas) throws MaximaValidacaoException {
        if (fornecedor == null) {
            throw new MaximaValidacaoException("O campo fornecedor \u00e9 obrigat\u00f3rio.");
        }
        ContaPagar contaPagar = new ContaPagar();
        contaPagar.setCentroCusto(centroCusto);
        contaPagar.setFornecedor(fornecedor);
        contaPagar.setNumeroNota(numeroNota);
        contaPagar = (ContaPagar)this.contaPagarRepository.save((Object)contaPagar);
        for (ContaPagarParcela parc : parcelas) {
            parc.setCentroCusto(contaPagar.getCentroCusto());
            parc.setFornecedor(contaPagar.getFornecedor());
            parc.setNumeroNota(contaPagar.getNumeroNota());
            parc.setContaPagar(contaPagar);
            parc.setDataEmissao(LocalDateTime.now());
            parc.setDataOperacao(LocalDateTime.now());
            parc.setExcluido(Boolean.FALSE);
            parc.setQuitado(Boolean.FALSE.booleanValue());
            parc.setValorLiquido(parc.getValor());
            this.contaPagarParcelaRepository.save((Object)parc);
        }
    }

    @Transactional(readOnly=true)
    public List<ContaPagarParcela> listEmAberto() {
        return this.contaPagarParcelaRepository.listEmAberto(LocalDate.now());
    }

    @Transactional(readOnly=true)
    public List<ContaPagarParcela> lista(LocalDate inicio, LocalDate fim, String filtro) {
        return this.contaPagarParcelaRepository.lista(inicio, fim, filtro);
    }

    @Transactional(readOnly=true)
    public List<ContaPagarParcela> lista(LocalDate inicio, LocalDate fim, String filtro, FormaPagamento formaPagamento) {
        if (formaPagamento == null) {
            return this.contaPagarParcelaRepository.lista(inicio, fim, filtro);
        }
        return this.contaPagarParcelaRepository.lista(inicio, fim, filtro, formaPagamento);
    }

    @Transactional(readOnly=true)
    public BigDecimal total(LocalDate inicio, LocalDate fim, String filtro) {
        BigDecimal total = this.contaPagarParcelaRepository.total(inicio, fim, filtro);
        if (total == null) {
            total = BigDecimal.ZERO;
        }
        return total;
    }

    @Transactional(readOnly=true)
    public ContaPagarParcela load(Long id) {
        ContaPagarParcela parcela = (ContaPagarParcela)this.contaPagarParcelaRepository.findById((Object)id).get();
        return parcela;
    }

    @Transactional(rollbackFor={MaximaValidacaoException.class})
    public ContaPagarParcela salvaEdicao(ContaPagarParcela contaPagarParcela) throws MaximaValidacaoException {
        ContaPagarParcela validaParcela = (ContaPagarParcela)this.contaPagarParcelaRepository.findById((Object)contaPagarParcela.getId()).get();
        if (validaParcela.getExcluido().booleanValue() || validaParcela.existePagamento().booleanValue()) {
            throw new MaximaValidacaoException("Parcela exclu\u00edda ou com pagamento efetuado. N\u00e3o pode ser alterada.");
        }
        return (ContaPagarParcela)this.contaPagarParcelaRepository.save((Object)contaPagarParcela);
    }

    @Transactional(rollbackFor={MaximaValidacaoException.class})
    public void remove(ContaPagarParcela contaPagarParcela) throws MaximaValidacaoException {
        if ((contaPagarParcela = (ContaPagarParcela)this.contaPagarParcelaRepository.findById((Object)contaPagarParcela.getId()).get()).getExcluido().booleanValue()) {
            throw new MaximaValidacaoException("Parcela j\u00e1 removida.");
        }
        if (contaPagarParcela.getValorPendente().compareTo(contaPagarParcela.getValor()) != 0) {
            throw new MaximaValidacaoException("Parcela com pagamento efetuado.\nN\u00e3o pode ser removida.");
        }
        contaPagarParcela.setExcluido(Boolean.TRUE);
        contaPagarParcela.setDataExcluido(LocalDateTime.now());
        this.contaPagarParcelaRepository.save((Object)contaPagarParcela);
    }

    public List<ContaPagarParcela> relatorio(LocalDate inicio, LocalDate fim, Fornecedor forncedor, CentroCusto centroCusto, FormaPagamento formaPagamento) {
        return this.contaPagarParcelaRepository.relatorio(inicio, fim, forncedor, centroCusto, formaPagamento);
    }
}

