/*
 * Decompiled with CFR 0.152.
 */
package br.com.maximasolutions.financeiro.service;

import br.com.maximasolutions.core.MaximaException;
import br.com.maximasolutions.core.MaximaValidacaoException;
import br.com.maximasolutions.estoque.modelo.VendaProduto;
import br.com.maximasolutions.estoque.repository.VendaProdutoRepository;
import br.com.maximasolutions.financeiro.boleto.bean.BoletoRetornoDetalhe;
import br.com.maximasolutions.financeiro.modelo.BoletoEmitido;
import br.com.maximasolutions.financeiro.modelo.CentroCusto;
import br.com.maximasolutions.financeiro.modelo.ContaReceber;
import br.com.maximasolutions.financeiro.modelo.ContaReceberParcela;
import br.com.maximasolutions.financeiro.modelo.FormaPagamento;
import br.com.maximasolutions.financeiro.repository.BoletoEmitidoRepository;
import br.com.maximasolutions.financeiro.repository.ContaReceberParcelaRepository;
import br.com.maximasolutions.financeiro.repository.ContaReceberRepository;
import br.com.maximasolutions.financeiro.service.ContaReceberParcelaService;
import br.com.maximasolutions.geral.modelo.Cliente;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(rollbackFor={MaximaException.class, MaximaValidacaoException.class})
public class ContaReceberParcelaServiceImpl
implements ContaReceberParcelaService {
    @Autowired
    private ContaReceberRepository contaReceberRepository;
    @Autowired
    private ContaReceberParcelaRepository contaReceberParcelaRepository;
    @Autowired
    private VendaProdutoRepository vendaProdutoRepository;
    @Autowired
    private BoletoEmitidoRepository boletoEmitidoRepository;

    @Transactional(rollbackFor={MaximaValidacaoException.class})
    public void add(Cliente cliente, CentroCusto centroCusto, LocalDate dataEmissao, String numeroNota, List<ContaReceberParcela> parcelas) throws MaximaValidacaoException {
        if (cliente == null) {
            throw new MaximaValidacaoException("O campo cliente \u00e9 obrigat\u00f3rio.");
        }
        ContaReceber contaReceber = new ContaReceber();
        contaReceber.setCentroCusto(centroCusto);
        contaReceber.setCliente(cliente);
        contaReceber.setNumeroNota(numeroNota);
        contaReceber = (ContaReceber)this.contaReceberRepository.save((Object)contaReceber);
        for (ContaReceberParcela parc : parcelas) {
            parc.setCentroCusto(contaReceber.getCentroCusto());
            parc.setCliente(contaReceber.getCliente());
            parc.setNumeroNota(contaReceber.getNumeroNota());
            parc.setContaReceber(contaReceber);
            parc.setDataEmissao(LocalDateTime.now());
            parc.setDataOperacao(LocalDateTime.now());
            parc.setExcluido(Boolean.FALSE);
            parc.setQuitado(Boolean.FALSE.booleanValue());
            parc.setValorLiquido(parc.getValor());
            this.contaReceberParcelaRepository.save((Object)parc);
        }
    }

    @Transactional(rollbackFor={MaximaValidacaoException.class})
    public ContaReceberParcela salvaEdicao(ContaReceberParcela contaReceberParcela) throws MaximaValidacaoException {
        ContaReceberParcela validaParcela = (ContaReceberParcela)this.contaReceberParcelaRepository.findById((Object)contaReceberParcela.getId()).get();
        if (validaParcela.getExcluido().booleanValue() || validaParcela.existePagamento().booleanValue()) {
            throw new MaximaValidacaoException("Parcela exclu\u00edda ou com recebimento efetuado. N\u00e3o pode ser alterada.");
        }
        return (ContaReceberParcela)this.contaReceberParcelaRepository.save((Object)contaReceberParcela);
    }

    @Transactional(readOnly=true)
    public List<ContaReceberParcela> listEmAberto() {
        return this.contaReceberParcelaRepository.listEmAberto(LocalDate.now());
    }

    @Transactional(readOnly=true)
    public List<ContaReceberParcela> lista(LocalDate inicio, LocalDate fim, String filtro) {
        return this.contaReceberParcelaRepository.lista(inicio, fim, filtro);
    }

    @Transactional(readOnly=true)
    public List<ContaReceberParcela> lista(LocalDate inicio, LocalDate fim, String filtro, FormaPagamento formaPagamento) {
        return this.contaReceberParcelaRepository.lista(inicio, fim, filtro, formaPagamento);
    }

    @Transactional(readOnly=true)
    public List<ContaReceberParcela> extrato(Cliente cliente) {
        return this.contaReceberParcelaRepository.extrato(cliente.getId().longValue());
    }

    @Transactional(readOnly=true)
    public BigDecimal total(LocalDate inicio, LocalDate fim, String filtro) {
        BigDecimal total = this.contaReceberParcelaRepository.total(inicio, fim, filtro);
        if (total == null) {
            total = BigDecimal.ZERO;
        }
        return total;
    }

    @Transactional(readOnly=true)
    public BigDecimal total(LocalDate inicio, LocalDate fim, String filtro, FormaPagamento formaPagamento) {
        BigDecimal total = this.contaReceberParcelaRepository.total(inicio, fim, filtro, formaPagamento);
        if (total == null) {
            total = BigDecimal.ZERO;
        }
        return total;
    }

    @Transactional(readOnly=true)
    public ContaReceberParcela load(Long id) {
        ContaReceberParcela parcela = (ContaReceberParcela)this.contaReceberParcelaRepository.findById((Object)id).get();
        return parcela;
    }

    @Transactional(rollbackFor={MaximaValidacaoException.class})
    public void remove(ContaReceberParcela contaReceberParcela) throws MaximaValidacaoException {
        if ((contaReceberParcela = (ContaReceberParcela)this.contaReceberParcelaRepository.findById((Object)contaReceberParcela.getId()).get()).getExcluido().booleanValue()) {
            throw new MaximaValidacaoException("Parcela j\u00e1 removida.");
        }
        if (contaReceberParcela.getValorPendente().compareTo(contaReceberParcela.getValor()) != 0) {
            throw new MaximaValidacaoException("Parcela com recebimento efetuado.\nN\u00e3o pode ser removida.");
        }
        VendaProduto vendaProduto = this.vendaProdutoRepository.getByContaReceber(contaReceberParcela.getContaReceber().getId());
        if (vendaProduto != null) {
            throw new MaximaValidacaoException("Parcela referente a uma venda.\nN\u00e3o pode ser removida.");
        }
        contaReceberParcela.setExcluido(Boolean.TRUE);
        contaReceberParcela.setDataExcluido(LocalDateTime.now());
        this.contaReceberParcelaRepository.save((Object)contaReceberParcela);
    }

    @Transactional(readOnly=true)
    public List<ContaReceberParcela> lista(VendaProduto vendaProduto) {
        return this.contaReceberParcelaRepository.listPorContaReceber(vendaProduto.getContaReceber().getId().longValue());
    }

    public List<ContaReceberParcela> parcelasEmLote(List<BoletoRetornoDetalhe> recebimentos) throws MaximaValidacaoException {
        ArrayList<ContaReceberParcela> parcelas = new ArrayList<ContaReceberParcela>();
        for (BoletoRetornoDetalhe rec : recebimentos) {
            ContaReceberParcela parc;
            Long numero;
            try {
                numero = Long.parseLong(rec.getNumeroDocumento());
            }
            catch (NumberFormatException numberFormatException) {
                continue;
            }
            BoletoEmitido boleto = this.boletoEmitidoRepository.get(String.valueOf(numero));
            if (boleto == null || (parc = (ContaReceberParcela)this.contaReceberParcelaRepository.findById((Object)boleto.getContaReceberParcela().getId()).get()).getExcluido().booleanValue() || parc.isQuitado()) continue;
            parc.setJuros(rec.getJuros());
            parc.setTotal(rec.getTotal());
            parc.setDataPagamento(rec.getDataRecebimento());
            parcelas.add(parc);
        }
        return parcelas;
    }

    public List<ContaReceberParcela> relatorio(LocalDate inicio, LocalDate fim, Cliente cliente, CentroCusto centroCusto, FormaPagamento formaPagamento) throws Exception {
        Long clienteId = cliente == null ? null : cliente.getId();
        Long centroCustoId = centroCusto == null ? null : centroCusto.getId();
        return this.contaReceberParcelaRepository.relatorio(inicio, fim, clienteId, centroCustoId, formaPagamento);
    }
}

