/*
 * Decompiled with CFR 0.152.
 */
package br.com.maximasolutions.financeiro.service;

import br.com.maximasolutions.core.MaximaValidacaoException;
import br.com.maximasolutions.financeiro.modelo.Conta;
import br.com.maximasolutions.financeiro.modelo.ContaExtratoTipo;
import br.com.maximasolutions.financeiro.repository.ContaExtratoRepository;
import br.com.maximasolutions.financeiro.repository.ContaRepository;
import br.com.maximasolutions.financeiro.service.ContaService;
import br.com.maximasolutions.financeiro.utils.ContaExtratoUtils;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class ContaServiceImpl
implements ContaService {
    @Autowired
    private ContaRepository contaRepository;
    @Autowired
    private ContaExtratoRepository contaExtratoRepository;

    @Transactional(readOnly=true)
    public List<Conta> list() {
        return this.contaRepository.list();
    }

    @Transactional(readOnly=true)
    public Conta load(long id) {
        return (Conta)this.contaRepository.getOne((Object)id);
    }

    @Transactional(rollbackFor={MaximaValidacaoException.class})
    public Conta save(Conta conta, String nome, BigDecimal saldoAbertura) throws MaximaValidacaoException {
        if (conta.getId() == null) {
            conta.setAtivo(Boolean.TRUE);
            conta.setNome(nome);
            conta.setSaldoAbertura(saldoAbertura);
            conta.setSaldoAtual(saldoAbertura);
            conta = (Conta)this.contaRepository.save((Object)conta);
            this.contaExtratoRepository.save((Object)ContaExtratoUtils.create((Conta)conta, (BigDecimal)conta.getSaldoAbertura(), (BigDecimal)conta.getSaldoAtual(), (Long)conta.getId(), (ContaExtratoTipo)ContaExtratoTipo.ABERTURA));
        } else {
            conta = (Conta)this.contaRepository.findById((Object)conta.getId()).get();
            conta.setNome(nome);
            conta = (Conta)this.contaRepository.save((Object)conta);
        }
        return conta;
    }

    @Transactional(rollbackFor={MaximaValidacaoException.class})
    public void deleteById(Long id) throws MaximaValidacaoException {
        Conta conta = (Conta)this.contaRepository.findById((Object)id).get();
        if (!conta.getAtivo().booleanValue()) {
            throw new MaximaValidacaoException("Conta j\u00e1 deletada do sistema.");
        }
        conta.setAtivo(Boolean.FALSE);
        conta.setDataDesativacao(LocalDateTime.now());
        conta = (Conta)this.contaRepository.save((Object)conta);
        this.contaExtratoRepository.save((Object)ContaExtratoUtils.create((Conta)conta, (BigDecimal)BigDecimal.ZERO, (BigDecimal)conta.getSaldoAtual(), (Long)conta.getId(), (ContaExtratoTipo)ContaExtratoTipo.ENCERRAMENTO));
    }

    @Transactional(readOnly=true)
    public List<Conta> pesquisa(String valor) {
        return this.contaRepository.pesquisa("%" + valor + "%");
    }

    @Transactional(readOnly=true)
    public List<Conta> combo() {
        ArrayList<Conta> list = new ArrayList<Conta>();
        list.add(null);
        list.addAll(this.contaRepository.list());
        return list;
    }
}

