/*
 * Decompiled with CFR 0.152.
 */
package br.com.maximasolutions.financeiro.service;

import br.com.maximasolutions.core.MaximaException;
import br.com.maximasolutions.financeiro.modelo.CentroCusto;
import br.com.maximasolutions.financeiro.modelo.ContaReceber;
import br.com.maximasolutions.financeiro.modelo.ContaReceberParcela;
import br.com.maximasolutions.financeiro.modelo.Mensalidade;
import br.com.maximasolutions.financeiro.repository.CentroCustoRepository;
import br.com.maximasolutions.financeiro.repository.ContaReceberParcelaRepository;
import br.com.maximasolutions.financeiro.repository.ContaReceberRepository;
import br.com.maximasolutions.financeiro.repository.MensalidadeRepository;
import br.com.maximasolutions.financeiro.service.MensalidadeService;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class MensalidadeServiceImpl
implements MensalidadeService {
    @Autowired
    private MensalidadeRepository mensalidadeRepository;
    @Autowired
    private CentroCustoRepository centroCustoRepository;
    @Autowired
    private ContaReceberRepository contaReceberRepository;
    @Autowired
    private ContaReceberParcelaRepository contaReceberParcelaRepository;

    @Transactional(readOnly=true)
    public List<Mensalidade> list() {
        return this.mensalidadeRepository.lista(Integer.valueOf(1), Integer.valueOf(30), "%%");
    }

    @Transactional(readOnly=true)
    public Mensalidade load(long id) {
        return (Mensalidade)this.mensalidadeRepository.getOne((Object)id);
    }

    public Mensalidade save(Mensalidade mensalidade) throws MaximaException {
        return (Mensalidade)this.mensalidadeRepository.save((Object)mensalidade);
    }

    public void deleteById(Long id) {
        this.mensalidadeRepository.deleteById((Object)id);
    }

    @Transactional(readOnly=true)
    public List<Mensalidade> pesquisa(Integer inicio, Integer fim, String valor) {
        return this.mensalidadeRepository.lista(inicio, fim, "%" + valor + "%");
    }

    @Transactional(readOnly=true)
    public BigDecimal total(Integer inicio, Integer fim, String filtro) {
        BigDecimal total = this.mensalidadeRepository.total(inicio, fim, "%" + filtro + "%");
        if (total == null) {
            total = BigDecimal.ZERO;
        }
        return total;
    }

    public void gerarContasReceber() throws MaximaException {
        List mensalidades = this.mensalidadeRepository.lista(Integer.valueOf(1), Integer.valueOf(31), "%%");
        BigDecimal valor = BigDecimal.ZERO;
        CentroCusto centroCusto = (CentroCusto)this.centroCustoRepository.getOne((Object)2L);
        for (Mensalidade mensalidade : mensalidades) {
            System.out.println("===== " + mensalidade.getCliente().getNome().toUpperCase() + " =====");
            ContaReceber contaReceber = new ContaReceber();
            contaReceber.setCentroCusto(centroCusto);
            contaReceber.setCliente(mensalidade.getCliente());
            contaReceber.setDataDocumento(LocalDate.now());
            contaReceber.setHistorico("");
            contaReceber.setIntervaloParcela(Integer.valueOf(0));
            contaReceber.setNumeroNota("");
            contaReceber = (ContaReceber)this.contaReceberRepository.save((Object)contaReceber);
            for (int i = 1; i <= 12; ++i) {
                LocalDate vencimento = null;
                vencimento = i == 2 && mensalidade.getDiaVencimento() == 30 ? LocalDate.of(2023, i, 28) : LocalDate.of(2023, i, (int)mensalidade.getDiaVencimento());
                ContaReceberParcela parcela = new ContaReceberParcela();
                parcela.setBoleto(Boolean.valueOf(false));
                parcela.setCentroCusto(centroCusto);
                parcela.setCliente(mensalidade.getCliente());
                parcela.setCondicaoPagamento(mensalidade.getCondicaoRecebimento());
                parcela.setContaReceber(contaReceber);
                parcela.setDataEmissao(LocalDateTime.now());
                parcela.setDataOperacao(LocalDateTime.now());
                parcela.setDataVencimento(vencimento);
                parcela.setDesconto(BigDecimal.ZERO);
                parcela.setExcluido(Boolean.valueOf(false));
                parcela.setFormaPagamento(mensalidade.getCondicaoRecebimento().getFormaPagamento());
                parcela.setHistorico("");
                parcela.setJuros(BigDecimal.ZERO);
                parcela.setNumeroNota("");
                parcela.setNumeroParcela(String.valueOf(i));
                parcela.setQuitado(false);
                parcela.setRecebimentoEstornado(Boolean.valueOf(false));
                parcela.setTotal(mensalidade.getValorAtual());
                parcela.setValor(mensalidade.getValorAtual());
                parcela.setValorLiquido(mensalidade.getValorAtual());
                parcela.setValorOriginal(mensalidade.getValorAtual());
                parcela.setValorPendente(mensalidade.getValorAtual());
                this.contaReceberParcelaRepository.save((Object)parcela);
            }
            System.out.println("=====================================================================");
        }
        System.out.println("===== Valor total: " + valor);
    }
}

