/*
 * Decompiled with CFR 0.152.
 */
package br.com.maximasolutions.financeiro.service;

import br.com.maximasolutions.core.MaximaConfig;
import br.com.maximasolutions.core.MaximaException;
import br.com.maximasolutions.core.MaximaValidacaoException;
import br.com.maximasolutions.financeiro.modelo.CentroCusto;
import br.com.maximasolutions.financeiro.modelo.Conta;
import br.com.maximasolutions.financeiro.modelo.ContaExtratoTipo;
import br.com.maximasolutions.financeiro.modelo.ContaPagar;
import br.com.maximasolutions.financeiro.modelo.ContaPagarParcela;
import br.com.maximasolutions.financeiro.modelo.FormaPagamento;
import br.com.maximasolutions.financeiro.modelo.MovimentacaoSaida;
import br.com.maximasolutions.financeiro.modelo.MovimentoCaixa;
import br.com.maximasolutions.financeiro.modelo.MovimentoCaixaExtratoTipo;
import br.com.maximasolutions.financeiro.repository.ContaExtratoRepository;
import br.com.maximasolutions.financeiro.repository.ContaPagarParcelaRepository;
import br.com.maximasolutions.financeiro.repository.ContaPagarRepository;
import br.com.maximasolutions.financeiro.repository.ContaRepository;
import br.com.maximasolutions.financeiro.repository.MovimentacaoSaidaRepository;
import br.com.maximasolutions.financeiro.repository.MovimentoCaixaExtratoRepository;
import br.com.maximasolutions.financeiro.repository.MovimentoCaixaRepository;
import br.com.maximasolutions.financeiro.service.MovimentacaoSaidaService;
import br.com.maximasolutions.financeiro.utils.ContaExtratoUtils;
import br.com.maximasolutions.financeiro.utils.MovimentoCaixaUtils;
import br.com.maximasolutions.geral.modelo.Fornecedor;
import br.com.maximasolutions.utils.MaximaNumber;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(rollbackFor={MaximaException.class, MaximaValidacaoException.class})
public class MovimentacaoSaidaServiceImpl
implements MovimentacaoSaidaService {
    @Autowired
    private MovimentacaoSaidaRepository movimentacaoSaidaRepository;
    @Autowired
    private MovimentoCaixaRepository movimentoCaixaRepository;
    @Autowired
    private MovimentoCaixaExtratoRepository movimentoCaixaExtratoRepository;
    @Autowired
    private ContaPagarParcelaRepository contaPagarParcelaRepository;
    @Autowired
    private ContaRepository contaRepository;
    @Autowired
    private ContaExtratoRepository contaExtratoRepository;
    @Autowired
    private ContaPagarRepository contaPagarRepository;

    @Transactional(rollbackFor={MaximaValidacaoException.class})
    public MovimentacaoSaida pagamentoDireto(ContaPagar contaPagar, ContaPagarParcela contaPagarParcela, MovimentacaoSaida movimentacaoSaida, Boolean movimentoCaixa, Conta conta) throws MaximaValidacaoException {
        contaPagar = (ContaPagar)this.contaPagarRepository.save((Object)contaPagar);
        contaPagarParcela.setContaPagar(contaPagar);
        contaPagarParcela = (ContaPagarParcela)this.contaPagarParcelaRepository.save((Object)contaPagarParcela);
        MovimentoCaixa caixaAberto = null;
        if (movimentoCaixa.booleanValue() && (caixaAberto = this.movimentoCaixaRepository.getCaixaAberto(Long.parseLong(MaximaConfig.getInstance().getProperty("caixa_id", "1")))) == null) {
            throw new MaximaValidacaoException("Nenhum movimento de caixa aberto.");
        }
        movimentacaoSaida.setContaPagarParcela(contaPagarParcela);
        movimentacaoSaida.setMovimentoCaixa(caixaAberto);
        movimentacaoSaida.setDataOperacao(LocalDateTime.now());
        movimentacaoSaida.setConta(conta);
        movimentacaoSaida = (MovimentacaoSaida)this.movimentacaoSaidaRepository.save((Object)movimentacaoSaida);
        if (movimentoCaixa.booleanValue()) {
            if (!MovimentoCaixaUtils.temSaldo((MovimentoCaixa)caixaAberto, (FormaPagamento)movimentacaoSaida.getFormaPagamento(), (BigDecimal)movimentacaoSaida.getTotal()).booleanValue()) {
                throw new MaximaValidacaoException("Saldo em caixa insuficiente para executar o pagamento.");
            }
            caixaAberto = MovimentoCaixaUtils.addPagamento((MovimentoCaixa)caixaAberto, (FormaPagamento)movimentacaoSaida.getFormaPagamento(), (BigDecimal)movimentacaoSaida.getTotal());
            caixaAberto = (MovimentoCaixa)this.movimentoCaixaRepository.save((Object)caixaAberto);
            this.movimentoCaixaExtratoRepository.save((Object)MovimentoCaixaUtils.getExtrato((MovimentoCaixa)caixaAberto, (Long)movimentacaoSaida.getId(), (BigDecimal)movimentacaoSaida.getTotal().multiply(new BigDecimal("-1")), (BigDecimal)caixaAberto.getValorEmCaixa(), (MovimentoCaixaExtratoTipo)MovimentoCaixaExtratoTipo.PAGAMENTO, (FormaPagamento)movimentacaoSaida.getFormaPagamento()));
        }
        if (conta != null) {
            conta = (Conta)this.contaRepository.findById((Object)conta.getId()).get();
            conta.setSaldoAtual(conta.getSaldoAtual().subtract(movimentacaoSaida.getTotal()));
            conta = (Conta)this.contaRepository.save((Object)conta);
            this.contaExtratoRepository.save((Object)ContaExtratoUtils.create((Conta)conta, (BigDecimal)MaximaNumber.negativa((BigDecimal)movimentacaoSaida.getTotal()), (BigDecimal)conta.getSaldoAtual(), (Long)movimentacaoSaida.getId(), (ContaExtratoTipo)ContaExtratoTipo.PAGAMENTO));
        }
        return movimentacaoSaida;
    }

    @Transactional(rollbackFor={MaximaValidacaoException.class})
    public MovimentacaoSaida pagaParcela(ContaPagarParcela contaPagarParcela, MovimentacaoSaida movimentacaoSaida, Boolean movimentoCaixa, Conta conta) throws MaximaValidacaoException {
        contaPagarParcela = (ContaPagarParcela)this.contaPagarParcelaRepository.findById((Object)contaPagarParcela.getId()).get();
        MovimentoCaixa caixaAberto = null;
        if (movimentoCaixa.booleanValue() && (caixaAberto = this.movimentoCaixaRepository.getCaixaAberto(Long.parseLong(MaximaConfig.getInstance().getProperty("caixa_id", "1")))) == null) {
            throw new MaximaValidacaoException("Nenhum movimento de caixa aberto.");
        }
        if (contaPagarParcela.getExcluido().booleanValue()) {
            throw new MaximaValidacaoException("Parcela exclu\u00edda.");
        }
        if (contaPagarParcela.isQuitado()) {
            throw new MaximaValidacaoException("Parcela com recebimento total efetuado. N\u00e3o \u00e9 poss\u00edvel efetuar recebimento.");
        }
        contaPagarParcela.setValorPendente(contaPagarParcela.getValorPendente().add(movimentacaoSaida.getJuros()).subtract(movimentacaoSaida.getDesconto()).subtract(movimentacaoSaida.getTotal()));
        if (contaPagarParcela.getValorPendente().compareTo(BigDecimal.ZERO) < 0) {
            throw new MaximaValidacaoException("O valor pendente n\u00e3o pode ser menor que zero.");
        }
        if (contaPagarParcela.getValorPendente().compareTo(BigDecimal.ZERO) == 0) {
            contaPagarParcela.setQuitado(true);
            contaPagarParcela.setDataPagamento(movimentacaoSaida.getDataMovimento());
        }
        this.contaPagarParcelaRepository.save((Object)contaPagarParcela);
        movimentacaoSaida.setMovimentoCaixa(caixaAberto);
        movimentacaoSaida.setDataOperacao(LocalDateTime.now());
        movimentacaoSaida.setConta(conta);
        movimentacaoSaida = (MovimentacaoSaida)this.movimentacaoSaidaRepository.save((Object)movimentacaoSaida);
        if (movimentoCaixa.booleanValue()) {
            if (!MovimentoCaixaUtils.temSaldo((MovimentoCaixa)caixaAberto, (FormaPagamento)movimentacaoSaida.getFormaPagamento(), (BigDecimal)movimentacaoSaida.getTotal()).booleanValue()) {
                throw new MaximaValidacaoException("Saldo em caixa insuficiente para executar o pagamento.");
            }
            caixaAberto = MovimentoCaixaUtils.addPagamento((MovimentoCaixa)caixaAberto, (FormaPagamento)movimentacaoSaida.getFormaPagamento(), (BigDecimal)movimentacaoSaida.getTotal());
            caixaAberto = (MovimentoCaixa)this.movimentoCaixaRepository.save((Object)caixaAberto);
            this.movimentoCaixaExtratoRepository.save((Object)MovimentoCaixaUtils.getExtrato((MovimentoCaixa)caixaAberto, (Long)movimentacaoSaida.getId(), (BigDecimal)movimentacaoSaida.getTotal().multiply(new BigDecimal("-1")), (BigDecimal)caixaAberto.getValorEmCaixa(), (MovimentoCaixaExtratoTipo)MovimentoCaixaExtratoTipo.PAGAMENTO, (FormaPagamento)movimentacaoSaida.getFormaPagamento()));
        }
        if (conta != null) {
            conta = (Conta)this.contaRepository.findById((Object)conta.getId()).get();
            conta.setSaldoAtual(conta.getSaldoAtual().subtract(movimentacaoSaida.getTotal()));
            conta = (Conta)this.contaRepository.save((Object)conta);
            this.contaExtratoRepository.save((Object)ContaExtratoUtils.create((Conta)conta, (BigDecimal)MaximaNumber.negativa((BigDecimal)movimentacaoSaida.getTotal()), (BigDecimal)conta.getSaldoAtual(), (Long)movimentacaoSaida.getId(), (ContaExtratoTipo)ContaExtratoTipo.PAGAMENTO));
        }
        return movimentacaoSaida;
    }

    @Transactional(rollbackFor={MaximaValidacaoException.class})
    public void estorna(MovimentacaoSaida movimentacaoSaida) throws MaximaValidacaoException {
        MovimentoCaixa caixa;
        if ((movimentacaoSaida = (MovimentacaoSaida)this.movimentacaoSaidaRepository.findById((Object)movimentacaoSaida.getId()).get()).getEstornada().booleanValue()) {
            throw new MaximaValidacaoException("Recebimento estornado anteriormente.");
        }
        if (movimentacaoSaida.getMovimentoCaixa() != null && !(caixa = (MovimentoCaixa)this.movimentoCaixaRepository.findById((Object)movimentacaoSaida.getMovimentoCaixa().getId()).get()).getFechado().booleanValue()) {
            caixa = MovimentoCaixaUtils.deletePagamento((MovimentoCaixa)caixa, (FormaPagamento)movimentacaoSaida.getFormaPagamento(), (BigDecimal)movimentacaoSaida.getTotal());
            caixa = (MovimentoCaixa)this.movimentoCaixaRepository.save((Object)caixa);
            this.movimentoCaixaExtratoRepository.save((Object)MovimentoCaixaUtils.getExtrato((MovimentoCaixa)caixa, (Long)movimentacaoSaida.getId(), (BigDecimal)movimentacaoSaida.getTotal(), (BigDecimal)caixa.getValorEmCaixa(), (MovimentoCaixaExtratoTipo)MovimentoCaixaExtratoTipo.PAGAMENTO_ESTORNO, (FormaPagamento)movimentacaoSaida.getFormaPagamento()));
        }
        if (movimentacaoSaida.getConta() != null) {
            Conta conta = (Conta)this.contaRepository.findById((Object)movimentacaoSaida.getConta().getId()).get();
            conta.setSaldoAtual(conta.getSaldoAtual().add(movimentacaoSaida.getTotal()));
            conta = (Conta)this.contaRepository.save((Object)conta);
            this.contaExtratoRepository.save((Object)ContaExtratoUtils.create((Conta)conta, (BigDecimal)movimentacaoSaida.getTotal(), (BigDecimal)conta.getSaldoAtual(), (Long)movimentacaoSaida.getId(), (ContaExtratoTipo)ContaExtratoTipo.PAGAMENTO_ESTORNO));
        }
        movimentacaoSaida.setEstornada(Boolean.TRUE);
        movimentacaoSaida.setDataEstorno(LocalDateTime.now());
        movimentacaoSaida = (MovimentacaoSaida)this.movimentacaoSaidaRepository.save((Object)movimentacaoSaida);
        ContaPagarParcela parcela = (ContaPagarParcela)this.contaPagarParcelaRepository.findById((Object)movimentacaoSaida.getContaPagarParcela().getId()).get();
        parcela.setQuitado(false);
        parcela.setPagamentoEstornado(Boolean.TRUE);
        parcela.setValorPendente(parcela.getValorPendente().add(movimentacaoSaida.getTotal().add(movimentacaoSaida.getDesconto()).subtract(movimentacaoSaida.getJuros())));
        if (movimentacaoSaida.getDireto().booleanValue()) {
            parcela.setExcluido(Boolean.valueOf(true));
            parcela.setDataExcluido(LocalDateTime.now());
        }
        this.contaPagarParcelaRepository.save((Object)parcela);
    }

    @Transactional(readOnly=true)
    public List<MovimentacaoSaida> list() {
        return this.movimentacaoSaidaRepository.list();
    }

    @Transactional(readOnly=true)
    public MovimentacaoSaida load(long id) {
        return (MovimentacaoSaida)this.movimentacaoSaidaRepository.getOne((Object)id);
    }

    @Transactional(rollbackFor={MaximaValidacaoException.class})
    public MovimentacaoSaida save(MovimentacaoSaida movimentacaoSaida) throws MaximaValidacaoException {
        return (MovimentacaoSaida)this.movimentacaoSaidaRepository.save((Object)movimentacaoSaida);
    }

    public void deleteById(Long id) {
        this.movimentacaoSaidaRepository.deleteById((Object)id);
    }

    @Transactional(readOnly=true)
    public List<MovimentacaoSaida> pesquisa(String valor) {
        return this.movimentacaoSaidaRepository.pesquisa("%" + valor + "%");
    }

    @Transactional(readOnly=true)
    public List<MovimentacaoSaida> lista(LocalDate inicio, LocalDate fim, String filtro, FormaPagamento formaPagamento) {
        if (formaPagamento == null) {
            return this.movimentacaoSaidaRepository.lista(inicio, fim, "%" + filtro + "%");
        }
        return this.movimentacaoSaidaRepository.lista(inicio, fim, "%" + filtro + "%", formaPagamento);
    }

    @Transactional(readOnly=true)
    public List<MovimentacaoSaida> lista(LocalDate inicio, LocalDate fim, Fornecedor fornecedor) {
        if (fornecedor == null) {
            return this.movimentacaoSaidaRepository.lista(inicio, fim, "%%");
        }
        return this.movimentacaoSaidaRepository.lista(inicio, fim, fornecedor.getId());
    }

    @Transactional(readOnly=true)
    public BigDecimal total(LocalDate inicio, LocalDate fim, String filtro) {
        BigDecimal total = this.movimentacaoSaidaRepository.total(inicio, fim, "%" + filtro + "%");
        if (total == null) {
            total = BigDecimal.ZERO;
        }
        return total;
    }

    public List<MovimentacaoSaida> relatorio(LocalDate inicio, LocalDate fim, Fornecedor fornecedor, CentroCusto centroCusto, FormaPagamento formaPagamento) throws Exception {
        Long fornecedorId = null;
        Long centroCustoId = null;
        if (fornecedor != null) {
            fornecedorId = fornecedor.getId();
        }
        if (centroCusto != null) {
            centroCustoId = centroCusto.getId();
        }
        try {
            return this.movimentacaoSaidaRepository.relatorio(inicio, fim, fornecedorId, centroCustoId, formaPagamento);
        }
        catch (Exception ex) {
            Logger.getLogger(MovimentacaoSaidaServiceImpl.class.getName()).log(Level.SEVERE, null, ex);
            throw new Exception(ex);
        }
    }
}

