/*
 * Decompiled with CFR 0.152.
 */
package br.com.maximasolutions.fiscal.controller;

import br.com.maximasolutions.administrativo.modelo.Configuracao;
import br.com.maximasolutions.administrativo.service.ConfiguracaoService;
import br.com.maximasolutions.config.StageManager;
import br.com.maximasolutions.core.MaximaAlert;
import br.com.maximasolutions.core.MaximaController;
import br.com.maximasolutions.core.MaximaException;
import br.com.maximasolutions.core.MaximaIcone;
import br.com.maximasolutions.fiscal.certificado.OnCert;
import br.com.maximasolutions.utils.MaximaUtils;
import java.io.IOException;
import java.net.URL;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.cert.CertificateException;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.collections.FXCollections;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.TextField;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Controller;

@Controller
public class CertificadoFormController
extends MaximaController
implements Initializable {
    @FXML
    private TextField tfSenha;
    @FXML
    private ComboBox<String> cbbCertificado;
    @FXML
    private Button btnSalva;
    @Lazy
    @Autowired
    private StageManager stageManager;
    @Autowired
    private ConfiguracaoService configuracaoService;

    public void initialize(URL url, ResourceBundle rb) {
        this.carregaIcones();
        this.registraAcoes();
        this.inicializa();
    }

    public void inicializa() {
        this.carregaCombos();
        Configuracao conf = this.configuracaoService.load();
        this.cbbCertificado.getSelectionModel().select((Object)conf.getAliasCertificado());
        this.tfSenha.setText(conf.getSenhaCertificado());
    }

    private void salva() {
        Configuracao conf = this.configuracaoService.load();
        if (conf == null) {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"Nenhuma configurac\u00e3o salva. Salve a configura\u00e7\u00e3o antes de configurar o certificado digital.");
            return;
        }
        if (!this.validaForm()) {
            return;
        }
        conf.setAliasCertificado((String)this.cbbCertificado.getSelectionModel().getSelectedItem());
        conf.setSenhaCertificado(MaximaUtils.getText((String)this.tfSenha.getText()));
        try {
            this.configuracaoService.save(conf);
            MaximaAlert.informe((StageManager)this.stageManager, (String)"Certificado digital configurado com sucesso.");
        }
        catch (MaximaException ex) {
            Logger.getLogger(CertificadoFormController.class.getName()).log(Level.SEVERE, null, ex);
            MaximaAlert.aviso((StageManager)this.stageManager, (String)("AVISO: " + ex.getMessage()));
        }
    }

    private boolean validaForm() {
        boolean valido = true;
        String senha = this.tfSenha.getText();
        if (senha == null || senha.isEmpty()) {
            this.tfSenha.getStyleClass().add((Object)"error");
            valido = false;
        } else {
            this.tfSenha.getStyleClass().remove((Object)"error");
        }
        if (this.cbbCertificado.getSelectionModel().getSelectedItem() == null) {
            valido = false;
            this.cbbCertificado.getStyleClass().add((Object)"error");
        } else {
            this.cbbCertificado.getStyleClass().remove((Object)"error");
        }
        return valido;
    }

    private void carregaCombos() {
        try {
            Object[] list = OnCert.funcListaCertificados((boolean)true);
            this.cbbCertificado.setItems(FXCollections.observableArrayList((Object[])list));
        }
        catch (IOException | NoSuchAlgorithmException | NoSuchProviderException | CertificateException ex) {
            Logger.getLogger(CertificadoFormController.class.getName()).log(Level.SEVERE, null, ex);
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"ERRO: N\u00e3o foi poss\u00edvel carregar os certificados instalados no computador.");
        }
    }

    private void carregaIcones() {
        this.btnSalva.setGraphic((Node)new MaximaIcone().getIconeConfirma());
    }

    private void registraAcoes() {
        this.btnSalva.setOnAction(event -> this.salva());
    }
}

