/*
 * Decompiled with CFR 0.152.
 */
package br.com.maximasolutions.fiscal.controller;

import br.com.maximasolutions.config.StageManager;
import br.com.maximasolutions.core.MaximaAlert;
import br.com.maximasolutions.core.MaximaController;
import br.com.maximasolutions.core.MaximaDialogFX;
import br.com.maximasolutions.core.MaximaException;
import br.com.maximasolutions.core.MaximaIcone;
import br.com.maximasolutions.fiscal.controller.ContadorFormController;
import br.com.maximasolutions.fiscal.modelo.Contador;
import br.com.maximasolutions.fiscal.service.ContadorService;
import java.io.IOException;
import java.net.URL;
import java.util.Collection;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.input.KeyCode;
import javafx.stage.Stage;
import javafx.util.Callback;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Controller;

@Controller
public class ContadorController
extends MaximaController
implements Initializable {
    @Lazy
    @Autowired
    private StageManager stageManager;
    @FXML
    private Button btnNovo;
    @FXML
    private Button btnEdita;
    @FXML
    private Button btnDelete;
    @FXML
    private Button btnPesquisa;
    @FXML
    private TextField tfPesquisa;
    @FXML
    private TableView<Contador> tabela;
    @FXML
    private TableColumn<Contador, String> colNome;
    @FXML
    private TableColumn<Contador, String> colEndereco;
    @FXML
    private TableColumn<Contador, String> colTelefone;
    @FXML
    private TableColumn<Contador, String> colCidade;
    @FXML
    private TableColumn<Contador, Long> colId;
    @Autowired
    private ContadorService contadorService;
    private ObservableList<Contador> contadorList;

    public void initialize(URL url, ResourceBundle rb) {
        this.carregaIcones();
        this.contadorList = FXCollections.observableArrayList();
        this.tabela.setOnMouseClicked(event -> {
            if (event.getClickCount() == 2) {
                this.editaContador();
            }
        });
        this.setColumnProperties();
        this.loadTabela();
        this.registraAcoes();
    }

    private void novoContador() {
        try {
            Stage stage = new MaximaDialogFX().createWindowForm(this.stageManager, "/fxml/fiscal/contador/ContadorForm.fxml", "Novo Contador");
            ContadorFormController controller = (ContadorFormController)stage.getUserData();
            controller.inicializa(null);
            stage.showAndWait();
        }
        catch (IOException ex) {
            Logger.getLogger(ContadorController.class.getName()).log(Level.SEVERE, null, ex);
            MaximaAlert.alerta((String)("Ocorreu um erro ao abrir form contador.\n" + ex.getMessage()));
        }
        this.loadTabela();
    }

    private void editaContador() {
        Contador contador = (Contador)this.tabela.getSelectionModel().getSelectedItem();
        if (contador == null) {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"Selecione um contador para editar.");
            return;
        }
        try {
            Stage stage = new MaximaDialogFX().createWindowForm(this.stageManager, "/fxml/fiscal/contador/ContadorForm.fxml", "Edita Contador");
            ContadorFormController controller = (ContadorFormController)stage.getUserData();
            System.out.println("**** EDIT CLIENTE: " + contador.getId());
            controller.inicializa(contador.getId());
            stage.showAndWait();
        }
        catch (IOException ex) {
            Logger.getLogger(ContadorController.class.getName()).log(Level.SEVERE, null, ex);
            MaximaAlert.aviso((StageManager)this.stageManager, (String)("Ocorreu um erro ao abrir form contador.\n" + ex.getMessage()));
        }
        this.loadTabela();
    }

    private void deleteContador() {
        Contador contador = (Contador)this.tabela.getSelectionModel().getSelectedItem();
        if (contador == null) {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"Selecione um contador para remover.");
            return;
        }
        if (MaximaAlert.SIM_NAO((StageManager)this.stageManager, (String)("Deseja remover o contador: '" + contador.getNome() + "'?"))) {
            try {
                this.contadorService.delete(contador);
                MaximaAlert.informe((StageManager)this.stageManager, (String)"Contador deletado com sucesso.");
                this.loadTabela();
            }
            catch (MaximaException ex) {
                Logger.getLogger(ContadorController.class.getName()).log(Level.SEVERE, null, ex);
                MaximaAlert.aviso((StageManager)this.stageManager, (String)ex.getMessage());
            }
        }
    }

    private void loadTabela() {
        this.contadorList.clear();
        this.contadorList.addAll((Collection)this.contadorService.list(this.tfPesquisa.getText().trim()));
        this.tabela.setItems(this.contadorList);
    }

    private void carregaIcones() {
        this.btnNovo.setGraphic((Node)new MaximaIcone().getIconeNovo());
        this.btnEdita.setGraphic((Node)new MaximaIcone().edita());
        this.btnDelete.setGraphic((Node)new MaximaIcone().getIconeDelete());
        this.btnPesquisa.setGraphic((Node)new MaximaIcone().getPesquisa());
    }

    private void setColumnProperties() {
        this.colId.setCellValueFactory((Callback)new PropertyValueFactory("id"));
        this.colNome.setCellValueFactory((Callback)new PropertyValueFactory("nome"));
        this.colEndereco.setCellValueFactory((Callback)new PropertyValueFactory("enderecoCompleto"));
        this.colTelefone.setCellValueFactory((Callback)new PropertyValueFactory("telefone"));
        this.colCidade.setCellValueFactory((Callback)new PropertyValueFactory("municipio"));
    }

    private void registraAcoes() {
        this.btnNovo.setOnAction(event -> this.novoContador());
        this.btnEdita.setOnAction(event -> this.editaContador());
        this.btnDelete.setOnAction(event -> this.deleteContador());
        this.btnPesquisa.setOnAction(event -> this.loadTabela());
        this.tfPesquisa.setOnKeyPressed(event -> {
            if (event.getCode() == KeyCode.ENTER) {
                this.loadTabela();
            }
        });
    }
}

