/*
 * Decompiled with CFR 0.152.
 */
package br.com.maximasolutions.fiscal.controller;

import br.com.maximasolutions.config.StageManager;
import br.com.maximasolutions.core.MaximaAlert;
import br.com.maximasolutions.core.MaximaController;
import br.com.maximasolutions.core.MaximaDialogFX;
import br.com.maximasolutions.core.MaximaException;
import br.com.maximasolutions.core.MaximaIcone;
import br.com.maximasolutions.fiscal.modelo.Contador;
import br.com.maximasolutions.fiscal.service.ContadorService;
import br.com.maximasolutions.geral.controller.MunicipioPesquisaController;
import br.com.maximasolutions.geral.modelo.Municipio;
import br.com.maximasolutions.geral.service.MunicipioService;
import br.com.maximasolutions.utils.MaximaMask;
import br.com.maximasolutions.utils.MaximaUtils;
import br.com.maximasolutions.vendasexternas.controller.VendedorProdutoLancamentoFormController;
import java.io.IOException;
import java.net.URL;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.TextField;
import javafx.scene.input.KeyCode;
import javafx.scene.layout.AnchorPane;
import javafx.stage.Stage;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Controller;

@Controller
public class ContadorFormController
extends MaximaController
implements Initializable {
    @Autowired
    private ContadorService contadorService;
    @Autowired
    private MunicipioService municipioService;
    private Contador contador;
    @FXML
    private TextField tfId;
    @FXML
    private TextField tfRazaoSocial;
    @FXML
    private TextField tfCnpj;
    @FXML
    private TextField tfInscEstadual;
    @FXML
    private TextField tfEndereco;
    @FXML
    private TextField tfEnderecoNumero;
    @FXML
    private TextField tfBairro;
    @FXML
    private TextField tfCep;
    @FXML
    private TextField tfTelefone;
    @FXML
    private TextField tfComplemento;
    @FXML
    private TextField tfEmail;
    @FXML
    private TextField tfMunicipioCodigo;
    @FXML
    private TextField tfMunicipioDescricao;
    @FXML
    private TextField tfCRC;
    @FXML
    private Button btnSalva;
    @FXML
    private Button btnMunicipio;
    @FXML
    private AnchorPane frame;
    @Autowired
    @Lazy
    private StageManager stageManager;
    private Municipio municipio;

    public void initialize(URL url, ResourceBundle rb) {
        this.carregaIcones();
        this.loadCombos();
        this.setMascaras();
        this.registraAcoes();
    }

    public Contador getContador() {
        return this.contador;
    }

    public void inicializa(Long contadorId) {
        this.municipio = null;
        this.contador = null;
        if (contadorId != null) {
            this.contador = this.contadorService.getById(contadorId);
            this.loadContador(this.contador);
        }
    }

    private void loadContador(Contador contador) {
        if (contador != null) {
            this.tfId.setText(contador.getId().toString());
            this.tfRazaoSocial.setText(contador.getNome());
            this.tfTelefone.setText(contador.getTelefone());
            this.tfCnpj.setText(contador.getCpf());
            this.tfInscEstadual.setText(contador.getRg());
            this.tfCRC.setText(contador.getCrc());
            this.tfEndereco.setText(contador.getEndereco());
            this.tfEnderecoNumero.setText(contador.getNumero());
            this.tfBairro.setText(contador.getBairro());
            this.tfComplemento.setText(contador.getComplemento());
            this.tfCep.setText(contador.getCep());
            this.municipio = contador.getMunicipio();
            this.tfEmail.setText(contador.getEmail());
            this.tfMunicipioCodigo.setText(contador.getMunicipio().getId().toString());
            this.tfMunicipioDescricao.setText(contador.getMunicipio().getNome() + " - " + contador.getMunicipio().getEstado().getSigla());
        }
    }

    private void save() {
        this.loadContador();
        if (!this.validaForm()) {
            return;
        }
        if (!this.validaModelo().booleanValue()) {
            return;
        }
        try {
            this.contador = this.contadorService.save(this.contador);
            MaximaAlert.informe((StageManager)this.stageManager, (String)"Dados do contador salvos com sucesso.");
            this.close();
        }
        catch (MaximaException ex) {
            Logger.getLogger(ContadorFormController.class.getName()).log(Level.SEVERE, null, ex);
            MaximaAlert.aviso((StageManager)this.stageManager, (String)ex.getMessage());
        }
    }

    private void loadContador() {
        if (this.contador == null) {
            this.contador = new Contador();
        }
        this.contador.setAtivo(Boolean.TRUE);
        this.contador.setNome(MaximaUtils.getText((String)this.tfRazaoSocial.getText()));
        this.contador.setTelefone(MaximaUtils.removeCaracteres((String)this.tfTelefone.getText()));
        this.contador.setCpf(MaximaUtils.removeCaracteres((String)this.tfCnpj.getText()));
        this.contador.setRg(MaximaUtils.removeAcentos((String)this.tfInscEstadual.getText()));
        this.contador.setCrc(MaximaUtils.getText((String)this.tfCRC.getText()));
        this.contador.setEndereco(MaximaUtils.getText((String)this.tfEndereco.getText()));
        this.contador.setNumero(MaximaUtils.getText((String)this.tfEnderecoNumero.getText()));
        this.contador.setBairro(MaximaUtils.getText((String)this.tfBairro.getText()));
        this.contador.setComplemento(MaximaUtils.getText((String)this.tfComplemento.getText()));
        this.contador.setCep(MaximaUtils.removeCaracteres((String)this.tfCep.getText()));
        this.contador.setMunicipio(this.municipio);
        this.contador.setEmail(MaximaUtils.getText((String)this.tfEmail.getText()));
    }

    private void close() {
        Stage stage = (Stage)this.btnSalva.getScene().getWindow();
        stage.close();
    }

    private void carregaIcones() {
        this.btnSalva.setGraphic((Node)new MaximaIcone().getIconeConfirma());
    }

    private void loadCombos() {
    }

    private void setMascaras() {
        MaximaMask.cpfField((TextField)this.tfCnpj);
    }

    private void registraAcoes() {
        this.btnSalva.setOnAction(event -> this.save());
        this.btnMunicipio.setOnAction(event -> this.pesquisaMunicipioForm());
        this.tfMunicipioCodigo.setOnKeyPressed(event -> {
            if (event.getCode() == KeyCode.ENTER) {
                this.pesquisaMunicipio();
            }
        });
    }

    private void pesquisaMunicipio() {
        String municipioCodigo = this.tfMunicipioCodigo.getText().trim();
        if (municipioCodigo.isEmpty()) {
            return;
        }
        try {
            Long municipioCodigoNumero = Long.valueOf(municipioCodigo);
            Municipio municipioPesquisa = this.municipioService.load(municipioCodigoNumero.longValue());
            if (municipioPesquisa != null) {
                this.municipio = municipioPesquisa;
                this.loadDadosMunicipio();
                return;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        this.pesquisaMunicipioForm();
    }

    private void pesquisaMunicipioForm() {
        try {
            Stage stage = new MaximaDialogFX().createWindowForm(this.stageManager, "/fxml/geral/municipio/MunicipioPesquisa.fxml", "Pesquisa de cidades");
            MunicipioPesquisaController controller = (MunicipioPesquisaController)stage.getUserData();
            controller.setValorPesquisa(this.tfMunicipioCodigo.getText().trim());
            stage.showAndWait();
            Municipio municipioPesquisa = controller.getMunicipioSelecionado();
            if (municipioPesquisa != null) {
                this.municipio = municipioPesquisa;
                this.loadDadosMunicipio();
            }
        }
        catch (IOException ex) {
            Logger.getLogger(VendedorProdutoLancamentoFormController.class.getName()).log(Level.SEVERE, null, ex);
            MaximaAlert.alerta((String)("Ocorreu um erro ao abrir janela de pesquisa de vendedores.\n" + ex.getMessage()));
        }
    }

    private void loadDadosMunicipio() {
        if (this.municipio != null) {
            this.tfMunicipioCodigo.setText(this.municipio.getId().toString());
            this.tfMunicipioDescricao.setText(this.municipio.getNome().toUpperCase() + " - " + this.municipio.getEstado().getSigla());
            this.tfEmail.requestFocus();
        } else {
            this.tfMunicipioCodigo.setText("");
            this.tfMunicipioDescricao.setText("");
            this.tfMunicipioCodigo.requestFocus();
        }
    }

    private boolean validaForm() {
        boolean valido = true;
        if (this.contador.getNome() == null || this.contador.getNome().isEmpty()) {
            this.tfRazaoSocial.getStyleClass().add((Object)"error");
            valido = false;
        } else {
            this.tfRazaoSocial.getStyleClass().remove((Object)"error");
        }
        if (this.contador.getTelefone() == null || this.contador.getTelefone().isEmpty()) {
            valido = false;
            this.tfTelefone.getStyleClass().add((Object)"error");
        } else {
            this.tfTelefone.getStyleClass().remove((Object)"error");
        }
        if (this.contador.getMunicipio() == null) {
            valido = false;
            this.tfMunicipioCodigo.getStyleClass().add((Object)"error");
            this.tfMunicipioDescricao.getStyleClass().add((Object)"error");
        } else {
            this.tfMunicipioCodigo.getStyleClass().remove((Object)"error");
            this.tfMunicipioDescricao.getStyleClass().remove((Object)"error");
        }
        return valido;
    }

    private Boolean validaModelo() {
        ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
        Validator validator = factory.getValidator();
        Set violations = validator.validate((Object)this.contador, new Class[0]);
        String mensagemError = "";
        mensagemError = violations.stream().map(obj -> obj.getMessage() + "\n").reduce(mensagemError, String::concat);
        if (!mensagemError.isEmpty()) {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)mensagemError);
            return false;
        }
        return true;
    }
}

