/*
 * Decompiled with CFR 0.152.
 */
package br.com.maximasolutions.fiscal.controller;

import br.com.maximasolutions.config.StageManager;
import br.com.maximasolutions.core.MaximaAlert;
import br.com.maximasolutions.core.MaximaController;
import br.com.maximasolutions.core.MaximaDialogFX;
import br.com.maximasolutions.core.MaximaException;
import br.com.maximasolutions.core.MaximaIcone;
import br.com.maximasolutions.fiscal.controller.FiscalProdutoFormController;
import br.com.maximasolutions.fiscal.modelo.FiscalProduto;
import br.com.maximasolutions.fiscal.service.FiscalProdutoService;
import java.io.IOException;
import java.net.URL;
import java.util.Collection;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.input.KeyCode;
import javafx.stage.Stage;
import javafx.util.Callback;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Controller;

@Controller
public class FiscalProdutoController
extends MaximaController
implements Initializable {
    @Lazy
    @Autowired
    private StageManager stageManager;
    @FXML
    private Button btnNovo;
    @FXML
    private Button btnEdita;
    @FXML
    private Button btnDelete;
    @FXML
    private Button btnPesquisa;
    @FXML
    private TextField tfPesquisa;
    @FXML
    private TableView<FiscalProduto> tabela;
    @FXML
    private TableColumn<FiscalProduto, String> colNome;
    @FXML
    private TableColumn<FiscalProduto, String> colNcm;
    @FXML
    private TableColumn<FiscalProduto, String> colCfop;
    @FXML
    private TableColumn<FiscalProduto, String> colCst;
    @FXML
    private TableColumn<FiscalProduto, Long> colId;
    @Autowired
    private FiscalProdutoService fiscalProdutoService;
    private ObservableList<FiscalProduto> fiscalProdutoList;

    public void initialize(URL url, ResourceBundle rb) {
        this.carregaIcones();
        this.fiscalProdutoList = FXCollections.observableArrayList();
        this.tabela.setOnMouseClicked(event -> {
            if (event.getClickCount() == 2) {
                this.editaFiscalProduto();
            }
        });
        this.setColumnProperties();
        this.loadTabela();
        this.registraAcoes();
    }

    private void novoFiscalProduto() {
        this.showForm(null);
        this.loadTabela();
    }

    private void editaFiscalProduto() {
        FiscalProduto fiscalProduto = (FiscalProduto)this.tabela.getSelectionModel().getSelectedItem();
        if (fiscalProduto == null) {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"Selecione um fiscal produto para editar.");
            return;
        }
        this.showForm(fiscalProduto);
        this.loadTabela();
    }

    private void showForm(FiscalProduto fiscalProduto) {
        try {
            Stage stage = new MaximaDialogFX().createWindowForm(this.stageManager, "/fxml/fiscal/produtoFiscal/ProdutoFiscalForm.fxml", "Cadastro de Padr\u00e3o Fiscal");
            FiscalProdutoFormController controller = (FiscalProdutoFormController)stage.getUserData();
            controller.inicializa(fiscalProduto);
            stage.showAndWait();
        }
        catch (IOException ex) {
            Logger.getLogger(FiscalProdutoController.class.getName()).log(Level.SEVERE, null, ex);
            MaximaAlert.alerta((String)("Ocorreu um erro ao abrir form fiscal produto.\n" + ex.getMessage()));
        }
    }

    private void deleteFiscalProduto() {
        FiscalProduto fiscalProduto = (FiscalProduto)this.tabela.getSelectionModel().getSelectedItem();
        if (fiscalProduto == null) {
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"Selecione um fiscal produto para remover.");
            return;
        }
        if (MaximaAlert.SIM_NAO((StageManager)this.stageManager, (String)("Deseja remover o fiscal produto: '" + fiscalProduto.getNome() + "'?"))) {
            try {
                this.fiscalProdutoService.delete(fiscalProduto);
                MaximaAlert.informe((StageManager)this.stageManager, (String)"Fiscal Produto deletado com sucesso.");
                this.loadTabela();
            }
            catch (MaximaException ex) {
                Logger.getLogger(FiscalProdutoController.class.getName()).log(Level.SEVERE, null, ex);
                MaximaAlert.aviso((StageManager)this.stageManager, (String)ex.getMessage());
            }
        }
    }

    private void loadTabela() {
        this.fiscalProdutoList.clear();
        this.fiscalProdutoList.addAll((Collection)this.fiscalProdutoService.list(this.tfPesquisa.getText().trim()));
        this.tabela.setItems(this.fiscalProdutoList);
    }

    private void carregaIcones() {
        this.btnNovo.setGraphic((Node)new MaximaIcone().getIconeNovo());
        this.btnEdita.setGraphic((Node)new MaximaIcone().edita());
        this.btnDelete.setGraphic((Node)new MaximaIcone().getIconeDelete());
        this.btnPesquisa.setGraphic((Node)new MaximaIcone().getPesquisa());
    }

    private void setColumnProperties() {
        this.colId.setCellValueFactory((Callback)new PropertyValueFactory("id"));
        this.colNome.setCellValueFactory((Callback)new PropertyValueFactory("nome"));
        this.colCfop.setCellValueFactory((Callback)new PropertyValueFactory("cfop"));
        this.colNcm.setCellValueFactory((Callback)new PropertyValueFactory("ncm"));
        this.colCst.setCellValueFactory((Callback)new PropertyValueFactory("cst"));
    }

    private void registraAcoes() {
        this.btnNovo.setOnAction(event -> this.novoFiscalProduto());
        this.btnEdita.setOnAction(event -> this.editaFiscalProduto());
        this.btnDelete.setOnAction(event -> this.deleteFiscalProduto());
        this.btnPesquisa.setOnAction(event -> this.loadTabela());
        this.tfPesquisa.setOnKeyPressed(event -> {
            if (event.getCode() == KeyCode.ENTER) {
                this.loadTabela();
            }
        });
    }
}

