/*
 * Decompiled with CFR 0.152.
 */
package br.com.maximasolutions.fiscal.controller;

import br.com.maximasolutions.config.StageManager;
import br.com.maximasolutions.core.MaximaAlert;
import br.com.maximasolutions.core.MaximaController;
import br.com.maximasolutions.core.MaximaIcone;
import br.com.maximasolutions.fiscal.modelo.FiscalProduto;
import br.com.maximasolutions.fiscal.service.FiscalProdutoService;
import java.net.URL;
import java.util.Collection;
import java.util.List;
import java.util.ResourceBundle;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.input.KeyCode;
import javafx.stage.Stage;
import javafx.util.Callback;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Controller;

@Controller
public class FiscalProdutoPesquisaController
extends MaximaController
implements Initializable {
    @Lazy
    @Autowired
    private StageManager stageManager;
    @FXML
    private Button btnPesquisa;
    @FXML
    private Button btnSelecionar;
    @FXML
    private Button btnFechar;
    @FXML
    private TextField tfPesquisa;
    @FXML
    private TableView<FiscalProduto> tabela;
    @FXML
    private TableColumn<FiscalProduto, String> colNome;
    @FXML
    private TableColumn<FiscalProduto, String> colNcm;
    @FXML
    private TableColumn<FiscalProduto, String> colCfop;
    @FXML
    private TableColumn<FiscalProduto, String> colCst;
    @FXML
    private TableColumn<FiscalProduto, Long> colId;
    @Autowired
    private FiscalProdutoService fiscalProdutoService;
    private ObservableList<FiscalProduto> fiscalProdutoList;
    private FiscalProduto itemSelecionado;

    public void initialize(URL url, ResourceBundle rb) {
        this.itemSelecionado = null;
        this.carregaIcones();
        this.fiscalProdutoList = FXCollections.observableArrayList();
        this.setColumnProperties();
        this.loadTabela();
        this.registraAcoes();
        this.tfPesquisa.selectAll();
        this.tfPesquisa.requestFocus();
    }

    public FiscalProduto getItemSelecionado() {
        return this.itemSelecionado;
    }

    public void setValorPesquisa(String valor) {
        this.tfPesquisa.setText(valor);
        this.tfPesquisa.selectAll();
        this.tfPesquisa.requestFocus();
        if (valor != null && !valor.isEmpty()) {
            this.loadTabela();
        }
    }

    private void seleciona() {
        this.itemSelecionado = (FiscalProduto)this.tabela.getSelectionModel().getSelectedItem();
        if (this.itemSelecionado == null) {
            MaximaAlert.alerta((String)"Selecione um produto para continuar.");
            return;
        }
        this.fechaForm();
    }

    private void loadTabela() {
        String valorPesquisa = this.tfPesquisa.getText().trim();
        this.fiscalProdutoList.clear();
        List list = this.fiscalProdutoService.list(valorPesquisa);
        this.fiscalProdutoList.addAll((Collection)list);
        this.tabela.setItems(this.fiscalProdutoList);
    }

    private void carregaIcones() {
        this.btnPesquisa.setGraphic((Node)new MaximaIcone().getPesquisa());
        this.btnSelecionar.setGraphic((Node)new MaximaIcone().getIconeConfirma());
    }

    private void setColumnProperties() {
        this.colId.setCellValueFactory((Callback)new PropertyValueFactory("id"));
        this.colNome.setCellValueFactory((Callback)new PropertyValueFactory("nome"));
        this.colCfop.setCellValueFactory((Callback)new PropertyValueFactory("cfop"));
        this.colNcm.setCellValueFactory((Callback)new PropertyValueFactory("ncm"));
        this.colCst.setCellValueFactory((Callback)new PropertyValueFactory("cst"));
    }

    private void registraAcoes() {
        this.btnFechar.setOnAction(evt -> {
            this.itemSelecionado = null;
            this.fechaForm();
        });
        this.btnPesquisa.setOnAction(event -> this.loadTabela());
        this.tfPesquisa.setOnKeyPressed(event -> {
            if (event.getCode() == KeyCode.ENTER) {
                this.loadTabela();
            }
            if (event.getCode() == KeyCode.DOWN) {
                this.tabela.requestFocus();
            }
        });
        this.btnSelecionar.setOnAction(event -> this.seleciona());
        this.tabela.setOnMouseClicked(event -> {
            if (event.getClickCount() == 2) {
                this.seleciona();
            }
        });
        this.tabela.setOnKeyPressed(event -> {
            if (event.getCode() == KeyCode.ENTER && this.tabela.getSelectionModel().getSelectedItem() != null) {
                this.seleciona();
            }
        });
    }

    private void fechaForm() {
        Stage stage = (Stage)this.btnPesquisa.getScene().getWindow();
        stage.close();
    }
}

