/*
 * Decompiled with CFR 0.152.
 */
package br.com.maximasolutions.fiscal.controller;

import br.com.maximasolutions.config.StageManager;
import br.com.maximasolutions.core.MaximaAlert;
import br.com.maximasolutions.core.MaximaController;
import br.com.maximasolutions.core.MaximaDialogFX;
import br.com.maximasolutions.core.MaximaIcone;
import br.com.maximasolutions.fiscal.modelo.ConfiguracaoFiscalEntradaSaida;
import br.com.maximasolutions.fiscal.modelo.Sped;
import java.io.IOException;
import java.net.URL;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.stage.Stage;
import javafx.util.Callback;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Controller;

@Controller
public class SpedController
extends MaximaController
implements Initializable {
    @Lazy
    @Autowired
    private StageManager stageManager;
    @FXML
    private Button btnNovo;
    @FXML
    private TableView<Sped> tabela;
    @FXML
    private TableColumn<Sped, String> colDataInicio;
    @FXML
    private TableColumn<Sped, String> colDataFinal;
    @FXML
    private TableColumn<Sped, String> colDataArquivo;
    private ObservableList<Sped> spedList;

    public void initialize(URL url, ResourceBundle rb) {
        this.carregaIcones();
        this.spedList = FXCollections.observableArrayList();
        this.setColumnProperties();
        this.loadTabela();
        this.registraAcoes();
    }

    private void abreForm(ConfiguracaoFiscalEntradaSaida configuracaoFiscalEntradaSaida) {
        try {
            Stage stage = new MaximaDialogFX().createWindowForm(this.stageManager, "/fxml/fiscal/sped/SpedForm.fxml", "Gerar Arquivo SPED");
            stage.showAndWait();
        }
        catch (IOException ex) {
            Logger.getLogger(SpedController.class.getName()).log(Level.SEVERE, null, ex);
            MaximaAlert.aviso((StageManager)this.stageManager, (String)("Ocorreu um erro ao abrir form tipo de SPED.\n" + ex.getMessage()));
        }
    }

    private void novoConfiguracaoFiscalEntradaSaida() {
        this.abreForm(null);
        this.loadTabela();
    }

    private void loadTabela() {
        this.spedList.clear();
        this.spedList.addAll((Object[])new Sped[0]);
        this.tabela.setItems(this.spedList);
    }

    private void carregaIcones() {
        this.btnNovo.setGraphic((Node)new MaximaIcone().getIconeNovo());
    }

    private void setColumnProperties() {
        this.colDataInicio.setCellValueFactory((Callback)new PropertyValueFactory("dataInicio"));
        this.colDataFinal.setCellValueFactory((Callback)new PropertyValueFactory("dataFinal"));
        this.colDataArquivo.setCellValueFactory((Callback)new PropertyValueFactory("dataArquivo"));
    }

    private void registraAcoes() {
        this.btnNovo.setOnAction(event -> this.novoConfiguracaoFiscalEntradaSaida());
    }
}

