/*
 * Decompiled with CFR 0.152.
 */
package br.com.maximasolutions.fiscal.service;

import br.com.maximasolutions.core.MaximaException;
import br.com.maximasolutions.fiscal.modelo.EntradaCTe;
import br.com.maximasolutions.fiscal.repository.EntradaCTeRepository;
import br.com.maximasolutions.fiscal.service.EntradaCTeService;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(rollbackFor={MaximaException.class})
public class EntradaCTeServiceImpl
implements EntradaCTeService {
    @Autowired
    private EntradaCTeRepository entradaCTeRepository;

    public EntradaCTe salva(EntradaCTe entradaCTe) {
        return (EntradaCTe)this.entradaCTeRepository.save((Object)entradaCTe);
    }

    public void delete(EntradaCTe entradaCTe) {
        entradaCTe = (EntradaCTe)this.entradaCTeRepository.findById((Object)entradaCTe.getId()).get();
        entradaCTe.setExcluida(Boolean.TRUE);
        this.entradaCTeRepository.save((Object)entradaCTe);
    }

    public EntradaCTe getByChaveAcesso(String chaveAcesso) {
        return this.entradaCTeRepository.getByChaveAcesso(chaveAcesso);
    }

    @Transactional(readOnly=true)
    public EntradaCTe getById(Long id) {
        Optional entradaCTe = this.entradaCTeRepository.findById((Object)id);
        if (!entradaCTe.isPresent()) {
            return null;
        }
        return (EntradaCTe)entradaCTe.get();
    }

    @Transactional(readOnly=true)
    public List<EntradaCTe> lista(LocalDate inicio, LocalDate fim, Boolean excluida, String filtro) {
        return this.entradaCTeRepository.pesquisa(inicio, fim, excluida, filtro);
    }

    public BigDecimal totalLista(LocalDate inicio, LocalDate fim, Boolean excluida, String filtro) {
        BigDecimal total = this.entradaCTeRepository.totalPesquisa(inicio, fim, excluida, filtro);
        if (total == null) {
            total = BigDecimal.ZERO;
        }
        return total;
    }

    public List<EntradaCTe> listaEmitenteSped(LocalDate inicio, LocalDate fim) {
        return this.entradaCTeRepository.listaSpedFornecedores(inicio, fim);
    }

    public List<EntradaCTe> listaSped(LocalDate inicio, LocalDate fim) {
        return this.entradaCTeRepository.listaSped(inicio, fim);
    }
}

