/*
 * Decompiled with CFR 0.152.
 */
package br.com.maximasolutions.fiscal.service;

import br.com.maximasolutions.fiscal.modelo.Ncm;
import br.com.maximasolutions.fiscal.repository.NcmRepository;
import br.com.maximasolutions.fiscal.service.NcmService;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class NcmServiceImpl
implements NcmService {
    @Autowired
    private NcmRepository ncmRepository;

    @Transactional(readOnly=true)
    public Ncm loadByNCM(long ncm) {
        return this.ncmRepository.getByNCM(ncm);
    }

    @Transactional(readOnly=true)
    public List<Ncm> lista(String filtro) {
        if (filtro == null || filtro.isEmpty()) {
            return this.ncmRepository.lista();
        }
        try {
            Long ncm = Long.parseLong(filtro);
            return this.ncmRepository.lista(ncm);
        }
        catch (NumberFormatException numberFormatException) {
            return this.ncmRepository.lista("%" + filtro + "%");
        }
    }

    public Ncm salva(Ncm ncm) {
        return (Ncm)this.ncmRepository.save((Object)ncm);
    }

    public void deleteChaveDiferenteDe(String chave) {
        this.ncmRepository.deleteChaveDiferenteDe(chave);
    }
}

