/*
 * Decompiled with CFR 0.152.
 */
package br.com.maximasolutions.food.controller;

import br.com.maximasolutions.config.StageManager;
import br.com.maximasolutions.core.MaximaAlert;
import br.com.maximasolutions.core.MaximaController;
import br.com.maximasolutions.core.MaximaIcone;
import br.com.maximasolutions.food.modelo.DepartamentoImpressora;
import br.com.maximasolutions.food.service.DepartamentoImpressoraService;
import java.net.URL;
import java.util.ResourceBundle;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.TextField;
import javafx.stage.Stage;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Controller;

@Controller
public class DepartamentoImpressoraFormController
extends MaximaController
implements Initializable {
    @FXML
    private TextField tfNome;
    @FXML
    private TextField tfImpressora;
    @FXML
    private CheckBox cbbImprimeEntrega;
    @FXML
    private Button btnSalva;
    private DepartamentoImpressora departamentoImpressora;
    @Autowired
    private DepartamentoImpressoraService departamentoImpressoraService;
    @Lazy
    @Autowired
    private StageManager stageManager;

    public void initialize(URL url, ResourceBundle rb) {
        this.carregaIcones();
    }

    @FXML
    private void onSalva(ActionEvent event) {
        String mensagem;
        this.departamentoImpressora = this.getDepartamentoImpressora();
        if (this.departamentoImpressora.getId() == null) {
            this.departamentoImpressoraService.save((Object)this.departamentoImpressora);
            mensagem = "Departamento adicionado com sucesso.";
        } else {
            this.departamentoImpressoraService.update((Object)this.departamentoImpressora);
            mensagem = "Departamento alterado com sucesso.";
        }
        MaximaAlert.informe((StageManager)this.stageManager, (String)mensagem);
        Stage stage = (Stage)this.tfNome.getScene().getWindow();
        stage.close();
    }

    private DepartamentoImpressora getDepartamentoImpressora() {
        if (this.departamentoImpressora == null) {
            this.departamentoImpressora = new DepartamentoImpressora();
        }
        this.departamentoImpressora.setNome(this.tfNome.getText().trim());
        this.departamentoImpressora.setImpressora(this.tfImpressora.getText().trim());
        this.departamentoImpressora.setImprimeEntrega(Boolean.valueOf(this.cbbImprimeEntrega.isSelected()));
        return this.departamentoImpressora;
    }

    public void setDepartamentoImpressora(DepartamentoImpressora departamentoImpressora1) {
        this.departamentoImpressora = departamentoImpressora1;
        if (this.departamentoImpressora != null) {
            this.tfNome.setText(this.departamentoImpressora.getNome());
            this.tfImpressora.setText(this.departamentoImpressora.getImpressora());
            this.cbbImprimeEntrega.setSelected(this.departamentoImpressora.getImprimeEntrega().booleanValue());
        }
    }

    private void carregaIcones() {
        this.btnSalva.setGraphic((Node)new MaximaIcone().getIconeConfirma());
    }
}

