/*
 * Decompiled with CFR 0.152.
 */
package br.com.maximasolutions.food.controller;

import br.com.maximasolutions.config.StageManager;
import br.com.maximasolutions.core.MaximaAlert;
import br.com.maximasolutions.core.MaximaController;
import br.com.maximasolutions.core.MaximaDialogFX;
import br.com.maximasolutions.core.MaximaIcone;
import br.com.maximasolutions.delivery.modelo.Entregador;
import br.com.maximasolutions.food.controller.ComandaController;
import br.com.maximasolutions.food.controller.EntregadorFormController;
import br.com.maximasolutions.food.service.EntregadorService;
import java.io.IOException;
import java.net.URL;
import java.util.Collection;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.stage.Stage;
import javafx.util.Callback;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Controller;

@Controller
public class EntregadorController
extends MaximaController
implements Initializable {
    @Lazy
    @Autowired
    private StageManager stageManager;
    @Autowired
    EntregadorService entregadorService;
    @FXML
    TableView<Entregador> tabela;
    @FXML
    TableColumn<Entregador, String> colNome;
    @FXML
    TableColumn<Entregador, String> colTelefone;
    @FXML
    Button btNovo;
    @FXML
    Button btEdita;
    @FXML
    Button btDelete;
    @FXML
    Button btAtualiza;
    @FXML
    Button btnPesquisa;
    @FXML
    TextField tfPesquisa;
    @FXML
    CheckBox ccbAtivo;
    ObservableList<Entregador> entregadorList;

    public void initialize(URL url, ResourceBundle rb) {
        this.carregaIcone();
        this.registraAcoes();
        this.entregadorList = FXCollections.observableArrayList();
        this.setColumnProperties();
    }

    public void inicializa() {
        this.loadTabela();
    }

    public void carregaIcone() {
        this.btNovo.setGraphic((Node)new MaximaIcone().getIconeNovo());
        this.btDelete.setGraphic((Node)new MaximaIcone().getIconeDelete());
        this.btAtualiza.setGraphic((Node)new MaximaIcone().getIconeAtualiza());
        this.btEdita.setGraphic((Node)new MaximaIcone().edita());
    }

    private void novo() {
        try {
            Stage stage = new MaximaDialogFX().createWindowForm(this.stageManager, "/fxml/food/entregador/EntregadorForm.fxml", "Edi\u00e7\u00e3o de Entregador");
            EntregadorFormController controller = (EntregadorFormController)stage.getUserData();
            stage.setTitle("Cadastro de Entregador");
            stage.showAndWait();
            this.loadTabela();
        }
        catch (IOException ex) {
            Logger.getLogger(ComandaController.class.getName()).log(Level.SEVERE, null, ex);
            MaximaAlert.aviso((StageManager)this.stageManager, (String)"ERRO: N\u00e3o foi poss\u00edvel abrir m\u00f3dulo para cadastrar novo Entregador.");
        }
    }

    private void setColumnProperties() {
        this.colNome.setCellValueFactory((Callback)new PropertyValueFactory("nome"));
        this.colTelefone.setCellValueFactory((Callback)new PropertyValueFactory("telefone"));
    }

    private void loadTabela() {
        String valorPesquisa = this.tfPesquisa.getText().trim();
        this.entregadorList.clear();
        this.entregadorList.addAll((Collection)this.entregadorService.listaPorNome(valorPesquisa, this.ccbAtivo.isSelected()));
        this.tabela.setItems(this.entregadorList);
    }

    private void editaEntregador() {
        Entregador entregador = (Entregador)this.tabela.getSelectionModel().getSelectedItem();
        if (entregador != null) {
            try {
                Stage stage = new MaximaDialogFX().createWindowForm(this.stageManager, "/fxml/food/entregador/EntregadorForm.fxml", "Edi\u00e7\u00e3o de Entregador");
                EntregadorFormController controller = (EntregadorFormController)stage.getUserData();
                controller.inicializa(entregador);
                stage.setTitle("Cadastro de Entregador");
                stage.showAndWait();
                this.loadTabela();
            }
            catch (IOException ex) {
                Logger.getLogger(ComandaController.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    private void deleteEntregador() {
        Entregador entregador = (Entregador)this.tabela.getSelectionModel().getSelectedItem();
        if (entregador != null && MaximaAlert.confirmacao((String)("Deseja remover o entregador: '" + entregador.getNome() + "'?"))) {
            entregador.setAtivo(Boolean.FALSE);
            this.entregadorService.save((Object)entregador);
        }
        this.loadTabela();
    }

    private void registraAcoes() {
        this.btNovo.setOnAction(event -> this.novo());
        this.tabela.setOnMouseClicked(event -> {
            if (event.getClickCount() == 2) {
                this.editaEntregador();
            }
        });
        this.btAtualiza.setOnAction(evt -> this.loadTabela());
        this.btEdita.setOnAction(evt -> this.editaEntregador());
        this.btDelete.setOnAction(evt -> this.deleteEntregador());
        this.btnPesquisa.setOnAction(evt -> this.loadTabela());
    }
}

